# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.16.0
    Generated by: https://openapi-generator.tech
"""


import pprint
import re  # noqa: F401

import six

from generic_camunda_client.configuration import Configuration


class ActivityInstanceDto(object):
    """NOTE: This class is auto generated by OpenAPI Generator.
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    """
    Attributes:
      openapi_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    openapi_types = {
        'id': 'str',
        'parent_activity_instance_id': 'str',
        'activity_id': 'str',
        'activity_name': 'str',
        'activity_type': 'str',
        'process_instance_id': 'str',
        'process_definition_id': 'str',
        'child_activity_instances': 'list[ActivityInstanceDto]',
        'child_transition_instances': 'list[TransitionInstanceDto]',
        'execution_ids': 'list[str]',
        'incident_ids': 'list[str]',
        'incidents': 'list[ActivityInstanceIncidentDto]'
    }

    attribute_map = {
        'id': 'id',
        'parent_activity_instance_id': 'parentActivityInstanceId',
        'activity_id': 'activityId',
        'activity_name': 'activityName',
        'activity_type': 'activityType',
        'process_instance_id': 'processInstanceId',
        'process_definition_id': 'processDefinitionId',
        'child_activity_instances': 'childActivityInstances',
        'child_transition_instances': 'childTransitionInstances',
        'execution_ids': 'executionIds',
        'incident_ids': 'incidentIds',
        'incidents': 'incidents'
    }

    def __init__(self, id=None, parent_activity_instance_id=None, activity_id=None, activity_name=None, activity_type=None, process_instance_id=None, process_definition_id=None, child_activity_instances=None, child_transition_instances=None, execution_ids=None, incident_ids=None, incidents=None, local_vars_configuration=None):  # noqa: E501
        """ActivityInstanceDto - a model defined in OpenAPI"""  # noqa: E501
        if local_vars_configuration is None:
            local_vars_configuration = Configuration()
        self.local_vars_configuration = local_vars_configuration

        self._id = None
        self._parent_activity_instance_id = None
        self._activity_id = None
        self._activity_name = None
        self._activity_type = None
        self._process_instance_id = None
        self._process_definition_id = None
        self._child_activity_instances = None
        self._child_transition_instances = None
        self._execution_ids = None
        self._incident_ids = None
        self._incidents = None
        self.discriminator = None

        self.id = id
        self.parent_activity_instance_id = parent_activity_instance_id
        self.activity_id = activity_id
        self.activity_name = activity_name
        self.activity_type = activity_type
        self.process_instance_id = process_instance_id
        self.process_definition_id = process_definition_id
        self.child_activity_instances = child_activity_instances
        self.child_transition_instances = child_transition_instances
        self.execution_ids = execution_ids
        self.incident_ids = incident_ids
        self.incidents = incidents

    @property
    def id(self):
        """Gets the id of this ActivityInstanceDto.  # noqa: E501

        The id of the activity instance.  # noqa: E501

        :return: The id of this ActivityInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this ActivityInstanceDto.

        The id of the activity instance.  # noqa: E501

        :param id: The id of this ActivityInstanceDto.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def parent_activity_instance_id(self):
        """Gets the parent_activity_instance_id of this ActivityInstanceDto.  # noqa: E501

        The id of the parent activity instance, for example a sub process instance.  # noqa: E501

        :return: The parent_activity_instance_id of this ActivityInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._parent_activity_instance_id

    @parent_activity_instance_id.setter
    def parent_activity_instance_id(self, parent_activity_instance_id):
        """Sets the parent_activity_instance_id of this ActivityInstanceDto.

        The id of the parent activity instance, for example a sub process instance.  # noqa: E501

        :param parent_activity_instance_id: The parent_activity_instance_id of this ActivityInstanceDto.  # noqa: E501
        :type: str
        """

        self._parent_activity_instance_id = parent_activity_instance_id

    @property
    def activity_id(self):
        """Gets the activity_id of this ActivityInstanceDto.  # noqa: E501

        The id of the activity.  # noqa: E501

        :return: The activity_id of this ActivityInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._activity_id

    @activity_id.setter
    def activity_id(self, activity_id):
        """Sets the activity_id of this ActivityInstanceDto.

        The id of the activity.  # noqa: E501

        :param activity_id: The activity_id of this ActivityInstanceDto.  # noqa: E501
        :type: str
        """

        self._activity_id = activity_id

    @property
    def activity_name(self):
        """Gets the activity_name of this ActivityInstanceDto.  # noqa: E501

        The name of the activity  # noqa: E501

        :return: The activity_name of this ActivityInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._activity_name

    @activity_name.setter
    def activity_name(self, activity_name):
        """Sets the activity_name of this ActivityInstanceDto.

        The name of the activity  # noqa: E501

        :param activity_name: The activity_name of this ActivityInstanceDto.  # noqa: E501
        :type: str
        """

        self._activity_name = activity_name

    @property
    def activity_type(self):
        """Gets the activity_type of this ActivityInstanceDto.  # noqa: E501

        The type of activity (corresponds to the XML element name in the BPMN 2.0, e.g., 'userTask')  # noqa: E501

        :return: The activity_type of this ActivityInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._activity_type

    @activity_type.setter
    def activity_type(self, activity_type):
        """Sets the activity_type of this ActivityInstanceDto.

        The type of activity (corresponds to the XML element name in the BPMN 2.0, e.g., 'userTask')  # noqa: E501

        :param activity_type: The activity_type of this ActivityInstanceDto.  # noqa: E501
        :type: str
        """

        self._activity_type = activity_type

    @property
    def process_instance_id(self):
        """Gets the process_instance_id of this ActivityInstanceDto.  # noqa: E501

        The id of the process instance this activity instance is part of.  # noqa: E501

        :return: The process_instance_id of this ActivityInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._process_instance_id

    @process_instance_id.setter
    def process_instance_id(self, process_instance_id):
        """Sets the process_instance_id of this ActivityInstanceDto.

        The id of the process instance this activity instance is part of.  # noqa: E501

        :param process_instance_id: The process_instance_id of this ActivityInstanceDto.  # noqa: E501
        :type: str
        """

        self._process_instance_id = process_instance_id

    @property
    def process_definition_id(self):
        """Gets the process_definition_id of this ActivityInstanceDto.  # noqa: E501

        The id of the process definition.  # noqa: E501

        :return: The process_definition_id of this ActivityInstanceDto.  # noqa: E501
        :rtype: str
        """
        return self._process_definition_id

    @process_definition_id.setter
    def process_definition_id(self, process_definition_id):
        """Sets the process_definition_id of this ActivityInstanceDto.

        The id of the process definition.  # noqa: E501

        :param process_definition_id: The process_definition_id of this ActivityInstanceDto.  # noqa: E501
        :type: str
        """

        self._process_definition_id = process_definition_id

    @property
    def child_activity_instances(self):
        """Gets the child_activity_instances of this ActivityInstanceDto.  # noqa: E501

        A list of child activity instances.  # noqa: E501

        :return: The child_activity_instances of this ActivityInstanceDto.  # noqa: E501
        :rtype: list[ActivityInstanceDto]
        """
        return self._child_activity_instances

    @child_activity_instances.setter
    def child_activity_instances(self, child_activity_instances):
        """Sets the child_activity_instances of this ActivityInstanceDto.

        A list of child activity instances.  # noqa: E501

        :param child_activity_instances: The child_activity_instances of this ActivityInstanceDto.  # noqa: E501
        :type: list[ActivityInstanceDto]
        """

        self._child_activity_instances = child_activity_instances

    @property
    def child_transition_instances(self):
        """Gets the child_transition_instances of this ActivityInstanceDto.  # noqa: E501

        A list of child transition instances. A transition instance represents an execution waiting in an asynchronous continuation.  # noqa: E501

        :return: The child_transition_instances of this ActivityInstanceDto.  # noqa: E501
        :rtype: list[TransitionInstanceDto]
        """
        return self._child_transition_instances

    @child_transition_instances.setter
    def child_transition_instances(self, child_transition_instances):
        """Sets the child_transition_instances of this ActivityInstanceDto.

        A list of child transition instances. A transition instance represents an execution waiting in an asynchronous continuation.  # noqa: E501

        :param child_transition_instances: The child_transition_instances of this ActivityInstanceDto.  # noqa: E501
        :type: list[TransitionInstanceDto]
        """

        self._child_transition_instances = child_transition_instances

    @property
    def execution_ids(self):
        """Gets the execution_ids of this ActivityInstanceDto.  # noqa: E501

        A list of execution ids.  # noqa: E501

        :return: The execution_ids of this ActivityInstanceDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._execution_ids

    @execution_ids.setter
    def execution_ids(self, execution_ids):
        """Sets the execution_ids of this ActivityInstanceDto.

        A list of execution ids.  # noqa: E501

        :param execution_ids: The execution_ids of this ActivityInstanceDto.  # noqa: E501
        :type: list[str]
        """

        self._execution_ids = execution_ids

    @property
    def incident_ids(self):
        """Gets the incident_ids of this ActivityInstanceDto.  # noqa: E501

        A list of incident ids.  # noqa: E501

        :return: The incident_ids of this ActivityInstanceDto.  # noqa: E501
        :rtype: list[str]
        """
        return self._incident_ids

    @incident_ids.setter
    def incident_ids(self, incident_ids):
        """Sets the incident_ids of this ActivityInstanceDto.

        A list of incident ids.  # noqa: E501

        :param incident_ids: The incident_ids of this ActivityInstanceDto.  # noqa: E501
        :type: list[str]
        """

        self._incident_ids = incident_ids

    @property
    def incidents(self):
        """Gets the incidents of this ActivityInstanceDto.  # noqa: E501

        A list of JSON objects containing incident specific properties: * `id`: the id of the incident * `activityId`: the activity id in which the incident occurred  # noqa: E501

        :return: The incidents of this ActivityInstanceDto.  # noqa: E501
        :rtype: list[ActivityInstanceIncidentDto]
        """
        return self._incidents

    @incidents.setter
    def incidents(self, incidents):
        """Sets the incidents of this ActivityInstanceDto.

        A list of JSON objects containing incident specific properties: * `id`: the id of the incident * `activityId`: the activity id in which the incident occurred  # noqa: E501

        :param incidents: The incidents of this ActivityInstanceDto.  # noqa: E501
        :type: list[ActivityInstanceIncidentDto]
        """

        self._incidents = incidents

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.openapi_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, ActivityInstanceDto):
            return False

        return self.to_dict() == other.to_dict()

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        if not isinstance(other, ActivityInstanceDto):
            return True

        return self.to_dict() != other.to_dict()
