# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.16.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from generic_camunda_client.api_client import ApiClient
from generic_camunda_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class HistoricVariableInstanceApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_historic_variable_instance(self, id, **kwargs):  # noqa: E501
        """Delete Variable Instance  # noqa: E501

        Deletes a historic variable instance by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_historic_variable_instance(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the variable instance. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_historic_variable_instance_with_http_info(id, **kwargs)  # noqa: E501

    def delete_historic_variable_instance_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delete Variable Instance  # noqa: E501

        Deletes a historic variable instance by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_historic_variable_instance_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the variable instance. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_historic_variable_instance" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_historic_variable_instance`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/variable-instance/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_historic_variable_instance(self, id, **kwargs):  # noqa: E501
        """Get Variable Instance  # noqa: E501

        Retrieves a historic variable by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_variable_instance(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the variable instance. (required)
        :param bool deserialize_values: Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default `true`).  If set to `true`, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson's](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API's classpath.  If set to `false`, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While `true` is the default value for reasons of backward compatibility, we recommend setting this parameter to `false` when developing web applications that are independent of the Java process applications deployed to the engine.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: HistoricVariableInstanceDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_historic_variable_instance_with_http_info(id, **kwargs)  # noqa: E501

    def get_historic_variable_instance_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get Variable Instance  # noqa: E501

        Retrieves a historic variable by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_variable_instance_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the variable instance. (required)
        :param bool deserialize_values: Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default `true`).  If set to `true`, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson's](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API's classpath.  If set to `false`, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While `true` is the default value for reasons of backward compatibility, we recommend setting this parameter to `false` when developing web applications that are independent of the Java process applications deployed to the engine.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(HistoricVariableInstanceDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'deserialize_values'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_historic_variable_instance" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_historic_variable_instance`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'deserialize_values' in local_var_params and local_var_params['deserialize_values'] is not None:  # noqa: E501
            query_params.append(('deserializeValues', local_var_params['deserialize_values']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/variable-instance/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HistoricVariableInstanceDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_historic_variable_instance_binary(self, id, **kwargs):  # noqa: E501
        """Get Variable Instance (Binary)  # noqa: E501

        Retrieves the content of a historic variable by id. Applicable for variables that are serialized as binary data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_variable_instance_binary(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the variable instance. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_historic_variable_instance_binary_with_http_info(id, **kwargs)  # noqa: E501

    def get_historic_variable_instance_binary_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get Variable Instance (Binary)  # noqa: E501

        Retrieves the content of a historic variable by id. Applicable for variables that are serialized as binary data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_variable_instance_binary_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the variable instance. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_historic_variable_instance_binary" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_historic_variable_instance_binary`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream', '*/*', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/variable-instance/{id}/data', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_historic_variable_instances(self, **kwargs):  # noqa: E501
        """Get Variable Instances  # noqa: E501

        Queries for historic variable instances that fulfill the given parameters. The size of the result set can be retrieved by using the [Get Variable Instance Count](https://docs.camunda.org/manual/7.16/reference/rest/history/variable-instance/get-variable-instance-query-count/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_variable_instances(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str variable_name: Filter by variable name.
        :param str variable_name_like: Restrict to variables with a name like the parameter.
        :param object variable_value: Filter by variable value. Is treated as a `String` object on server side.
        :param bool variable_names_ignore_case: Match the variable name provided in `variableName` and `variableNameLike` case- insensitively. If set to `true` **variableName** and **variablename** are treated as equal.
        :param bool variable_values_ignore_case: Match the variable value provided in `variableValue` case-insensitively. If set to `true` **variableValue** and **variablevalue** are treated as equal.
        :param str variable_type_in: Only include historic variable instances which belong to one of the passed and comma- separated variable types. A list of all supported variable types can be found [here](https://docs.camunda.org/manual/7.16/user-guide/process-engine/variables/#supported-variable-values). **Note:** All non-primitive variables are associated with the type 'serializable'.
        :param bool include_deleted: Include variables that has already been deleted during the execution.
        :param str process_instance_id: Filter by the process instance the variable belongs to.
        :param str process_instance_id_in: Only include historic variable instances which belong to one of the passed and comma-separated process instance ids.
        :param str process_definition_id: Filter by the process definition the variable belongs to.
        :param str process_definition_key: Filter by a key of the process definition the variable belongs to.
        :param str execution_id_in: Only include historic variable instances which belong to one of the passed and and comma-separated execution ids.
        :param str case_instance_id: Filter by the case instance the variable belongs to.
        :param str case_execution_id_in: Only include historic variable instances which belong to one of the passed and and comma-separated case execution ids.
        :param str case_activity_id_in: Only include historic variable instances which belong to one of the passed and and comma-separated case activity ids.
        :param str task_id_in: Only include historic variable instances which belong to one of the passed and and comma-separated task ids.
        :param str activity_instance_id_in: Only include historic variable instances which belong to one of the passed and and comma-separated activity instance ids.
        :param str tenant_id_in: Only include historic variable instances which belong to one of the passed and comma- separated tenant ids.
        :param bool without_tenant_id: Only include historic variable instances that belong to no tenant. Value may only be `true`, as `false` is the default behavior.
        :param str sort_by: Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter.
        :param str sort_order: Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter.
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param bool deserialize_values: Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default `true`).  If set to `true`, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson's](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API's classpath.  If set to `false`, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While `true` is the default value for reasons of backward compatibility, we recommend setting this parameter to `false` when developing web applications that are independent of the Java process applications deployed to the engine.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[HistoricVariableInstanceDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_historic_variable_instances_with_http_info(**kwargs)  # noqa: E501

    def get_historic_variable_instances_with_http_info(self, **kwargs):  # noqa: E501
        """Get Variable Instances  # noqa: E501

        Queries for historic variable instances that fulfill the given parameters. The size of the result set can be retrieved by using the [Get Variable Instance Count](https://docs.camunda.org/manual/7.16/reference/rest/history/variable-instance/get-variable-instance-query-count/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_variable_instances_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str variable_name: Filter by variable name.
        :param str variable_name_like: Restrict to variables with a name like the parameter.
        :param object variable_value: Filter by variable value. Is treated as a `String` object on server side.
        :param bool variable_names_ignore_case: Match the variable name provided in `variableName` and `variableNameLike` case- insensitively. If set to `true` **variableName** and **variablename** are treated as equal.
        :param bool variable_values_ignore_case: Match the variable value provided in `variableValue` case-insensitively. If set to `true` **variableValue** and **variablevalue** are treated as equal.
        :param str variable_type_in: Only include historic variable instances which belong to one of the passed and comma- separated variable types. A list of all supported variable types can be found [here](https://docs.camunda.org/manual/7.16/user-guide/process-engine/variables/#supported-variable-values). **Note:** All non-primitive variables are associated with the type 'serializable'.
        :param bool include_deleted: Include variables that has already been deleted during the execution.
        :param str process_instance_id: Filter by the process instance the variable belongs to.
        :param str process_instance_id_in: Only include historic variable instances which belong to one of the passed and comma-separated process instance ids.
        :param str process_definition_id: Filter by the process definition the variable belongs to.
        :param str process_definition_key: Filter by a key of the process definition the variable belongs to.
        :param str execution_id_in: Only include historic variable instances which belong to one of the passed and and comma-separated execution ids.
        :param str case_instance_id: Filter by the case instance the variable belongs to.
        :param str case_execution_id_in: Only include historic variable instances which belong to one of the passed and and comma-separated case execution ids.
        :param str case_activity_id_in: Only include historic variable instances which belong to one of the passed and and comma-separated case activity ids.
        :param str task_id_in: Only include historic variable instances which belong to one of the passed and and comma-separated task ids.
        :param str activity_instance_id_in: Only include historic variable instances which belong to one of the passed and and comma-separated activity instance ids.
        :param str tenant_id_in: Only include historic variable instances which belong to one of the passed and comma- separated tenant ids.
        :param bool without_tenant_id: Only include historic variable instances that belong to no tenant. Value may only be `true`, as `false` is the default behavior.
        :param str sort_by: Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter.
        :param str sort_order: Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter.
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param bool deserialize_values: Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default `true`).  If set to `true`, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson's](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API's classpath.  If set to `false`, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While `true` is the default value for reasons of backward compatibility, we recommend setting this parameter to `false` when developing web applications that are independent of the Java process applications deployed to the engine.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[HistoricVariableInstanceDto], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'variable_name',
            'variable_name_like',
            'variable_value',
            'variable_names_ignore_case',
            'variable_values_ignore_case',
            'variable_type_in',
            'include_deleted',
            'process_instance_id',
            'process_instance_id_in',
            'process_definition_id',
            'process_definition_key',
            'execution_id_in',
            'case_instance_id',
            'case_execution_id_in',
            'case_activity_id_in',
            'task_id_in',
            'activity_instance_id_in',
            'tenant_id_in',
            'without_tenant_id',
            'sort_by',
            'sort_order',
            'first_result',
            'max_results',
            'deserialize_values'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_historic_variable_instances" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'variable_name' in local_var_params and local_var_params['variable_name'] is not None:  # noqa: E501
            query_params.append(('variableName', local_var_params['variable_name']))  # noqa: E501
        if 'variable_name_like' in local_var_params and local_var_params['variable_name_like'] is not None:  # noqa: E501
            query_params.append(('variableNameLike', local_var_params['variable_name_like']))  # noqa: E501
        if 'variable_value' in local_var_params and local_var_params['variable_value'] is not None:  # noqa: E501
            query_params.append(('variableValue', local_var_params['variable_value']))  # noqa: E501
        if 'variable_names_ignore_case' in local_var_params and local_var_params['variable_names_ignore_case'] is not None:  # noqa: E501
            query_params.append(('variableNamesIgnoreCase', local_var_params['variable_names_ignore_case']))  # noqa: E501
        if 'variable_values_ignore_case' in local_var_params and local_var_params['variable_values_ignore_case'] is not None:  # noqa: E501
            query_params.append(('variableValuesIgnoreCase', local_var_params['variable_values_ignore_case']))  # noqa: E501
        if 'variable_type_in' in local_var_params and local_var_params['variable_type_in'] is not None:  # noqa: E501
            query_params.append(('variableTypeIn', local_var_params['variable_type_in']))  # noqa: E501
        if 'include_deleted' in local_var_params and local_var_params['include_deleted'] is not None:  # noqa: E501
            query_params.append(('includeDeleted', local_var_params['include_deleted']))  # noqa: E501
        if 'process_instance_id' in local_var_params and local_var_params['process_instance_id'] is not None:  # noqa: E501
            query_params.append(('processInstanceId', local_var_params['process_instance_id']))  # noqa: E501
        if 'process_instance_id_in' in local_var_params and local_var_params['process_instance_id_in'] is not None:  # noqa: E501
            query_params.append(('processInstanceIdIn', local_var_params['process_instance_id_in']))  # noqa: E501
        if 'process_definition_id' in local_var_params and local_var_params['process_definition_id'] is not None:  # noqa: E501
            query_params.append(('processDefinitionId', local_var_params['process_definition_id']))  # noqa: E501
        if 'process_definition_key' in local_var_params and local_var_params['process_definition_key'] is not None:  # noqa: E501
            query_params.append(('processDefinitionKey', local_var_params['process_definition_key']))  # noqa: E501
        if 'execution_id_in' in local_var_params and local_var_params['execution_id_in'] is not None:  # noqa: E501
            query_params.append(('executionIdIn', local_var_params['execution_id_in']))  # noqa: E501
        if 'case_instance_id' in local_var_params and local_var_params['case_instance_id'] is not None:  # noqa: E501
            query_params.append(('caseInstanceId', local_var_params['case_instance_id']))  # noqa: E501
        if 'case_execution_id_in' in local_var_params and local_var_params['case_execution_id_in'] is not None:  # noqa: E501
            query_params.append(('caseExecutionIdIn', local_var_params['case_execution_id_in']))  # noqa: E501
        if 'case_activity_id_in' in local_var_params and local_var_params['case_activity_id_in'] is not None:  # noqa: E501
            query_params.append(('caseActivityIdIn', local_var_params['case_activity_id_in']))  # noqa: E501
        if 'task_id_in' in local_var_params and local_var_params['task_id_in'] is not None:  # noqa: E501
            query_params.append(('taskIdIn', local_var_params['task_id_in']))  # noqa: E501
        if 'activity_instance_id_in' in local_var_params and local_var_params['activity_instance_id_in'] is not None:  # noqa: E501
            query_params.append(('activityInstanceIdIn', local_var_params['activity_instance_id_in']))  # noqa: E501
        if 'tenant_id_in' in local_var_params and local_var_params['tenant_id_in'] is not None:  # noqa: E501
            query_params.append(('tenantIdIn', local_var_params['tenant_id_in']))  # noqa: E501
        if 'without_tenant_id' in local_var_params and local_var_params['without_tenant_id'] is not None:  # noqa: E501
            query_params.append(('withoutTenantId', local_var_params['without_tenant_id']))  # noqa: E501
        if 'sort_by' in local_var_params and local_var_params['sort_by'] is not None:  # noqa: E501
            query_params.append(('sortBy', local_var_params['sort_by']))  # noqa: E501
        if 'sort_order' in local_var_params and local_var_params['sort_order'] is not None:  # noqa: E501
            query_params.append(('sortOrder', local_var_params['sort_order']))  # noqa: E501
        if 'first_result' in local_var_params and local_var_params['first_result'] is not None:  # noqa: E501
            query_params.append(('firstResult', local_var_params['first_result']))  # noqa: E501
        if 'max_results' in local_var_params and local_var_params['max_results'] is not None:  # noqa: E501
            query_params.append(('maxResults', local_var_params['max_results']))  # noqa: E501
        if 'deserialize_values' in local_var_params and local_var_params['deserialize_values'] is not None:  # noqa: E501
            query_params.append(('deserializeValues', local_var_params['deserialize_values']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/variable-instance', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[HistoricVariableInstanceDto]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_historic_variable_instances_count(self, **kwargs):  # noqa: E501
        """Get Variable Instance Count  # noqa: E501

        Queries for the number of historic variable instances that fulfill the given parameters. Takes the same parameters as the [Get Variable Instances](https://docs.camunda.org/manual/7.16/reference/rest/history/variable-instance/get-variable-instance-query/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_variable_instances_count(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str variable_name: Filter by variable name.
        :param str variable_name_like: Restrict to variables with a name like the parameter.
        :param object variable_value: Filter by variable value. Is treated as a `String` object on server side.
        :param bool variable_names_ignore_case: Match the variable name provided in `variableName` and `variableNameLike` case- insensitively. If set to `true` **variableName** and **variablename** are treated as equal.
        :param bool variable_values_ignore_case: Match the variable value provided in `variableValue` case-insensitively. If set to `true` **variableValue** and **variablevalue** are treated as equal.
        :param str variable_type_in: Only include historic variable instances which belong to one of the passed and comma- separated variable types. A list of all supported variable types can be found [here](https://docs.camunda.org/manual/7.16/user-guide/process-engine/variables/#supported-variable-values). **Note:** All non-primitive variables are associated with the type 'serializable'.
        :param bool include_deleted: Include variables that has already been deleted during the execution.
        :param str process_instance_id: Filter by the process instance the variable belongs to.
        :param str process_instance_id_in: Only include historic variable instances which belong to one of the passed and comma-separated process instance ids.
        :param str process_definition_id: Filter by the process definition the variable belongs to.
        :param str process_definition_key: Filter by a key of the process definition the variable belongs to.
        :param str execution_id_in: Only include historic variable instances which belong to one of the passed and and comma-separated execution ids.
        :param str case_instance_id: Filter by the case instance the variable belongs to.
        :param str case_execution_id_in: Only include historic variable instances which belong to one of the passed and and comma-separated case execution ids.
        :param str case_activity_id_in: Only include historic variable instances which belong to one of the passed and and comma-separated case activity ids.
        :param str task_id_in: Only include historic variable instances which belong to one of the passed and and comma-separated task ids.
        :param str activity_instance_id_in: Only include historic variable instances which belong to one of the passed and and comma-separated activity instance ids.
        :param str tenant_id_in: Only include historic variable instances which belong to one of the passed and comma- separated tenant ids.
        :param bool without_tenant_id: Only include historic variable instances that belong to no tenant. Value may only be `true`, as `false` is the default behavior.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CountResultDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_historic_variable_instances_count_with_http_info(**kwargs)  # noqa: E501

    def get_historic_variable_instances_count_with_http_info(self, **kwargs):  # noqa: E501
        """Get Variable Instance Count  # noqa: E501

        Queries for the number of historic variable instances that fulfill the given parameters. Takes the same parameters as the [Get Variable Instances](https://docs.camunda.org/manual/7.16/reference/rest/history/variable-instance/get-variable-instance-query/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_variable_instances_count_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str variable_name: Filter by variable name.
        :param str variable_name_like: Restrict to variables with a name like the parameter.
        :param object variable_value: Filter by variable value. Is treated as a `String` object on server side.
        :param bool variable_names_ignore_case: Match the variable name provided in `variableName` and `variableNameLike` case- insensitively. If set to `true` **variableName** and **variablename** are treated as equal.
        :param bool variable_values_ignore_case: Match the variable value provided in `variableValue` case-insensitively. If set to `true` **variableValue** and **variablevalue** are treated as equal.
        :param str variable_type_in: Only include historic variable instances which belong to one of the passed and comma- separated variable types. A list of all supported variable types can be found [here](https://docs.camunda.org/manual/7.16/user-guide/process-engine/variables/#supported-variable-values). **Note:** All non-primitive variables are associated with the type 'serializable'.
        :param bool include_deleted: Include variables that has already been deleted during the execution.
        :param str process_instance_id: Filter by the process instance the variable belongs to.
        :param str process_instance_id_in: Only include historic variable instances which belong to one of the passed and comma-separated process instance ids.
        :param str process_definition_id: Filter by the process definition the variable belongs to.
        :param str process_definition_key: Filter by a key of the process definition the variable belongs to.
        :param str execution_id_in: Only include historic variable instances which belong to one of the passed and and comma-separated execution ids.
        :param str case_instance_id: Filter by the case instance the variable belongs to.
        :param str case_execution_id_in: Only include historic variable instances which belong to one of the passed and and comma-separated case execution ids.
        :param str case_activity_id_in: Only include historic variable instances which belong to one of the passed and and comma-separated case activity ids.
        :param str task_id_in: Only include historic variable instances which belong to one of the passed and and comma-separated task ids.
        :param str activity_instance_id_in: Only include historic variable instances which belong to one of the passed and and comma-separated activity instance ids.
        :param str tenant_id_in: Only include historic variable instances which belong to one of the passed and comma- separated tenant ids.
        :param bool without_tenant_id: Only include historic variable instances that belong to no tenant. Value may only be `true`, as `false` is the default behavior.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CountResultDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'variable_name',
            'variable_name_like',
            'variable_value',
            'variable_names_ignore_case',
            'variable_values_ignore_case',
            'variable_type_in',
            'include_deleted',
            'process_instance_id',
            'process_instance_id_in',
            'process_definition_id',
            'process_definition_key',
            'execution_id_in',
            'case_instance_id',
            'case_execution_id_in',
            'case_activity_id_in',
            'task_id_in',
            'activity_instance_id_in',
            'tenant_id_in',
            'without_tenant_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_historic_variable_instances_count" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'variable_name' in local_var_params and local_var_params['variable_name'] is not None:  # noqa: E501
            query_params.append(('variableName', local_var_params['variable_name']))  # noqa: E501
        if 'variable_name_like' in local_var_params and local_var_params['variable_name_like'] is not None:  # noqa: E501
            query_params.append(('variableNameLike', local_var_params['variable_name_like']))  # noqa: E501
        if 'variable_value' in local_var_params and local_var_params['variable_value'] is not None:  # noqa: E501
            query_params.append(('variableValue', local_var_params['variable_value']))  # noqa: E501
        if 'variable_names_ignore_case' in local_var_params and local_var_params['variable_names_ignore_case'] is not None:  # noqa: E501
            query_params.append(('variableNamesIgnoreCase', local_var_params['variable_names_ignore_case']))  # noqa: E501
        if 'variable_values_ignore_case' in local_var_params and local_var_params['variable_values_ignore_case'] is not None:  # noqa: E501
            query_params.append(('variableValuesIgnoreCase', local_var_params['variable_values_ignore_case']))  # noqa: E501
        if 'variable_type_in' in local_var_params and local_var_params['variable_type_in'] is not None:  # noqa: E501
            query_params.append(('variableTypeIn', local_var_params['variable_type_in']))  # noqa: E501
        if 'include_deleted' in local_var_params and local_var_params['include_deleted'] is not None:  # noqa: E501
            query_params.append(('includeDeleted', local_var_params['include_deleted']))  # noqa: E501
        if 'process_instance_id' in local_var_params and local_var_params['process_instance_id'] is not None:  # noqa: E501
            query_params.append(('processInstanceId', local_var_params['process_instance_id']))  # noqa: E501
        if 'process_instance_id_in' in local_var_params and local_var_params['process_instance_id_in'] is not None:  # noqa: E501
            query_params.append(('processInstanceIdIn', local_var_params['process_instance_id_in']))  # noqa: E501
        if 'process_definition_id' in local_var_params and local_var_params['process_definition_id'] is not None:  # noqa: E501
            query_params.append(('processDefinitionId', local_var_params['process_definition_id']))  # noqa: E501
        if 'process_definition_key' in local_var_params and local_var_params['process_definition_key'] is not None:  # noqa: E501
            query_params.append(('processDefinitionKey', local_var_params['process_definition_key']))  # noqa: E501
        if 'execution_id_in' in local_var_params and local_var_params['execution_id_in'] is not None:  # noqa: E501
            query_params.append(('executionIdIn', local_var_params['execution_id_in']))  # noqa: E501
        if 'case_instance_id' in local_var_params and local_var_params['case_instance_id'] is not None:  # noqa: E501
            query_params.append(('caseInstanceId', local_var_params['case_instance_id']))  # noqa: E501
        if 'case_execution_id_in' in local_var_params and local_var_params['case_execution_id_in'] is not None:  # noqa: E501
            query_params.append(('caseExecutionIdIn', local_var_params['case_execution_id_in']))  # noqa: E501
        if 'case_activity_id_in' in local_var_params and local_var_params['case_activity_id_in'] is not None:  # noqa: E501
            query_params.append(('caseActivityIdIn', local_var_params['case_activity_id_in']))  # noqa: E501
        if 'task_id_in' in local_var_params and local_var_params['task_id_in'] is not None:  # noqa: E501
            query_params.append(('taskIdIn', local_var_params['task_id_in']))  # noqa: E501
        if 'activity_instance_id_in' in local_var_params and local_var_params['activity_instance_id_in'] is not None:  # noqa: E501
            query_params.append(('activityInstanceIdIn', local_var_params['activity_instance_id_in']))  # noqa: E501
        if 'tenant_id_in' in local_var_params and local_var_params['tenant_id_in'] is not None:  # noqa: E501
            query_params.append(('tenantIdIn', local_var_params['tenant_id_in']))  # noqa: E501
        if 'without_tenant_id' in local_var_params and local_var_params['without_tenant_id'] is not None:  # noqa: E501
            query_params.append(('withoutTenantId', local_var_params['without_tenant_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/variable-instance/count', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CountResultDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def query_historic_variable_instances(self, **kwargs):  # noqa: E501
        """Get Variable Instances (POST)  # noqa: E501

        Queries for historic variable instances that fulfill the given parameters. This method is slightly more powerful than the [Get Variable Instances](https://docs.camunda.org/manual/7.16/reference/rest/history/variable-instance/get-variable-instance-query/) method because it allows filtering by variable values of the different types `String`, `Number` or `Boolean`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_historic_variable_instances(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param bool deserialize_values: Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default `true`).  If set to `true`, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson's](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API's classpath.  If set to `false`, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While `true` is the default value for reasons of backward compatibility, we recommend setting this parameter to `false` when developing web applications that are independent of the Java process applications deployed to the engine.
        :param HistoricVariableInstanceQueryDto historic_variable_instance_query_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[HistoricVariableInstanceDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.query_historic_variable_instances_with_http_info(**kwargs)  # noqa: E501

    def query_historic_variable_instances_with_http_info(self, **kwargs):  # noqa: E501
        """Get Variable Instances (POST)  # noqa: E501

        Queries for historic variable instances that fulfill the given parameters. This method is slightly more powerful than the [Get Variable Instances](https://docs.camunda.org/manual/7.16/reference/rest/history/variable-instance/get-variable-instance-query/) method because it allows filtering by variable values of the different types `String`, `Number` or `Boolean`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_historic_variable_instances_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param bool deserialize_values: Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default `true`).  If set to `true`, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson's](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API's classpath.  If set to `false`, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While `true` is the default value for reasons of backward compatibility, we recommend setting this parameter to `false` when developing web applications that are independent of the Java process applications deployed to the engine.
        :param HistoricVariableInstanceQueryDto historic_variable_instance_query_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[HistoricVariableInstanceDto], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'first_result',
            'max_results',
            'deserialize_values',
            'historic_variable_instance_query_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_historic_variable_instances" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'first_result' in local_var_params and local_var_params['first_result'] is not None:  # noqa: E501
            query_params.append(('firstResult', local_var_params['first_result']))  # noqa: E501
        if 'max_results' in local_var_params and local_var_params['max_results'] is not None:  # noqa: E501
            query_params.append(('maxResults', local_var_params['max_results']))  # noqa: E501
        if 'deserialize_values' in local_var_params and local_var_params['deserialize_values'] is not None:  # noqa: E501
            query_params.append(('deserializeValues', local_var_params['deserialize_values']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'historic_variable_instance_query_dto' in local_var_params:
            body_params = local_var_params['historic_variable_instance_query_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/variable-instance', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[HistoricVariableInstanceDto]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def query_historic_variable_instances_count(self, **kwargs):  # noqa: E501
        """Get Variable Instance Count (POST)  # noqa: E501

        Queries for historic variable instances that fulfill the given parameters. This method takes the same message body as the [Get Variable Instances (POST)](https://docs.camunda.org/manual/7.16/reference/rest/history/variable-instance/post-variable-instance-query/) method and therefore it is more powerful regarding variable values than the [Get Variable Instance Count](https://docs.camunda.org/manual/7.16/reference/rest/history/variable-instance/get-variable-instance-query-count/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_historic_variable_instances_count(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param HistoricVariableInstanceQueryDto historic_variable_instance_query_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CountResultDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.query_historic_variable_instances_count_with_http_info(**kwargs)  # noqa: E501

    def query_historic_variable_instances_count_with_http_info(self, **kwargs):  # noqa: E501
        """Get Variable Instance Count (POST)  # noqa: E501

        Queries for historic variable instances that fulfill the given parameters. This method takes the same message body as the [Get Variable Instances (POST)](https://docs.camunda.org/manual/7.16/reference/rest/history/variable-instance/post-variable-instance-query/) method and therefore it is more powerful regarding variable values than the [Get Variable Instance Count](https://docs.camunda.org/manual/7.16/reference/rest/history/variable-instance/get-variable-instance-query-count/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_historic_variable_instances_count_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param HistoricVariableInstanceQueryDto historic_variable_instance_query_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CountResultDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'historic_variable_instance_query_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_historic_variable_instances_count" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'historic_variable_instance_query_dto' in local_var_params:
            body_params = local_var_params['historic_variable_instance_query_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/variable-instance/count', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CountResultDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
