# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.16.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from generic_camunda_client.api_client import ApiClient
from generic_camunda_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class HistoricUserOperationLogApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def clear_annotation_user_operation_log(self, operation_id, **kwargs):  # noqa: E501
        """Clear Annotation of an User Operation Log (Historic)  # noqa: E501

        Clear the annotation which was previously set for auditing reasons.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.clear_annotation_user_operation_log(operation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str operation_id: The operation id of the operation log to be updated. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.clear_annotation_user_operation_log_with_http_info(operation_id, **kwargs)  # noqa: E501

    def clear_annotation_user_operation_log_with_http_info(self, operation_id, **kwargs):  # noqa: E501
        """Clear Annotation of an User Operation Log (Historic)  # noqa: E501

        Clear the annotation which was previously set for auditing reasons.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.clear_annotation_user_operation_log_with_http_info(operation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str operation_id: The operation id of the operation log to be updated. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'operation_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method clear_annotation_user_operation_log" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'operation_id' is set
        if self.api_client.client_side_validation and ('operation_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['operation_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `operation_id` when calling `clear_annotation_user_operation_log`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'operation_id' in local_var_params:
            path_params['operationId'] = local_var_params['operation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/user-operation/{operationId}/clear-annotation', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def query_user_operation_count(self, **kwargs):  # noqa: E501
        """Get User Operation Log Count  # noqa: E501

        Queries for the number of user operation log entries that fulfill the given parameters. Takes the same parameters as the [Get User Operation Log (Historic)](https://docs.camunda.org/manual/7.16/reference/rest/history/user-operation-log/get-user-operation-log-query/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_user_operation_count(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str deployment_id: Filter by deployment id.
        :param str process_definition_id: Filter by process definition id.
        :param str process_definition_key: Filter by process definition key.
        :param str process_instance_id: Filter by process instance id.
        :param str execution_id: Filter by execution id.
        :param str case_definition_id: Filter by case definition id.
        :param str case_instance_id: Filter by case instance id.
        :param str case_execution_id: Filter by case execution id.
        :param str task_id: Only include operations on this task.
        :param str external_task_id: Only include operations on this external task.
        :param str batch_id: Only include operations on this batch.
        :param str job_id: Filter by job id.
        :param str job_definition_id: Filter by job definition id.
        :param str user_id: Only include operations of this user.
        :param str operation_id: Filter by the id of the operation. This allows fetching of multiple entries which are part of a composite operation.
        :param str operation_type: Filter by the type of the operation like `Claim` or `Delegate`. See the [Javadoc](https://docs.camunda.org/manual/7.16/reference/javadoc/?org/camunda/bpm/engine/history/UserOperationLogEntry.html) for a list of available operation types.
        :param str entity_type: Filter by the type of the entity that was affected by this operation, possible values are `Task`, `Attachment` or `IdentityLink`.
        :param str entity_type_in: Filter by a comma-separated list of types of the entities that was affected by this operation, possible values are `Task`, `Attachment` or `IdentityLink`.
        :param str category: Filter by the category that this operation is associated with, possible values are `TaskWorker`, `Admin` or `Operator`.
        :param str category_in: Filter by a comma-separated list of categories that this operation is associated with, possible values are `TaskWorker`, `Admin` or `Operator`.
        :param str _property: Only include operations that changed this property, e.g., `owner` or `assignee`.
        :param datetime after_timestamp: Restrict to entries that were created after the given timestamp. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the timestamp must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., 2013-01-23T14:42:45.000+0200.
        :param datetime before_timestamp: Restrict to entries that were created before the given timestamp. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the timestamp must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., 2013-01-23T14:42:45.000+0200.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CountResultDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.query_user_operation_count_with_http_info(**kwargs)  # noqa: E501

    def query_user_operation_count_with_http_info(self, **kwargs):  # noqa: E501
        """Get User Operation Log Count  # noqa: E501

        Queries for the number of user operation log entries that fulfill the given parameters. Takes the same parameters as the [Get User Operation Log (Historic)](https://docs.camunda.org/manual/7.16/reference/rest/history/user-operation-log/get-user-operation-log-query/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_user_operation_count_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str deployment_id: Filter by deployment id.
        :param str process_definition_id: Filter by process definition id.
        :param str process_definition_key: Filter by process definition key.
        :param str process_instance_id: Filter by process instance id.
        :param str execution_id: Filter by execution id.
        :param str case_definition_id: Filter by case definition id.
        :param str case_instance_id: Filter by case instance id.
        :param str case_execution_id: Filter by case execution id.
        :param str task_id: Only include operations on this task.
        :param str external_task_id: Only include operations on this external task.
        :param str batch_id: Only include operations on this batch.
        :param str job_id: Filter by job id.
        :param str job_definition_id: Filter by job definition id.
        :param str user_id: Only include operations of this user.
        :param str operation_id: Filter by the id of the operation. This allows fetching of multiple entries which are part of a composite operation.
        :param str operation_type: Filter by the type of the operation like `Claim` or `Delegate`. See the [Javadoc](https://docs.camunda.org/manual/7.16/reference/javadoc/?org/camunda/bpm/engine/history/UserOperationLogEntry.html) for a list of available operation types.
        :param str entity_type: Filter by the type of the entity that was affected by this operation, possible values are `Task`, `Attachment` or `IdentityLink`.
        :param str entity_type_in: Filter by a comma-separated list of types of the entities that was affected by this operation, possible values are `Task`, `Attachment` or `IdentityLink`.
        :param str category: Filter by the category that this operation is associated with, possible values are `TaskWorker`, `Admin` or `Operator`.
        :param str category_in: Filter by a comma-separated list of categories that this operation is associated with, possible values are `TaskWorker`, `Admin` or `Operator`.
        :param str _property: Only include operations that changed this property, e.g., `owner` or `assignee`.
        :param datetime after_timestamp: Restrict to entries that were created after the given timestamp. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the timestamp must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., 2013-01-23T14:42:45.000+0200.
        :param datetime before_timestamp: Restrict to entries that were created before the given timestamp. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the timestamp must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., 2013-01-23T14:42:45.000+0200.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CountResultDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'deployment_id',
            'process_definition_id',
            'process_definition_key',
            'process_instance_id',
            'execution_id',
            'case_definition_id',
            'case_instance_id',
            'case_execution_id',
            'task_id',
            'external_task_id',
            'batch_id',
            'job_id',
            'job_definition_id',
            'user_id',
            'operation_id',
            'operation_type',
            'entity_type',
            'entity_type_in',
            'category',
            'category_in',
            '_property',
            'after_timestamp',
            'before_timestamp'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_user_operation_count" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'deployment_id' in local_var_params and local_var_params['deployment_id'] is not None:  # noqa: E501
            query_params.append(('deploymentId', local_var_params['deployment_id']))  # noqa: E501
        if 'process_definition_id' in local_var_params and local_var_params['process_definition_id'] is not None:  # noqa: E501
            query_params.append(('processDefinitionId', local_var_params['process_definition_id']))  # noqa: E501
        if 'process_definition_key' in local_var_params and local_var_params['process_definition_key'] is not None:  # noqa: E501
            query_params.append(('processDefinitionKey', local_var_params['process_definition_key']))  # noqa: E501
        if 'process_instance_id' in local_var_params and local_var_params['process_instance_id'] is not None:  # noqa: E501
            query_params.append(('processInstanceId', local_var_params['process_instance_id']))  # noqa: E501
        if 'execution_id' in local_var_params and local_var_params['execution_id'] is not None:  # noqa: E501
            query_params.append(('executionId', local_var_params['execution_id']))  # noqa: E501
        if 'case_definition_id' in local_var_params and local_var_params['case_definition_id'] is not None:  # noqa: E501
            query_params.append(('caseDefinitionId', local_var_params['case_definition_id']))  # noqa: E501
        if 'case_instance_id' in local_var_params and local_var_params['case_instance_id'] is not None:  # noqa: E501
            query_params.append(('caseInstanceId', local_var_params['case_instance_id']))  # noqa: E501
        if 'case_execution_id' in local_var_params and local_var_params['case_execution_id'] is not None:  # noqa: E501
            query_params.append(('caseExecutionId', local_var_params['case_execution_id']))  # noqa: E501
        if 'task_id' in local_var_params and local_var_params['task_id'] is not None:  # noqa: E501
            query_params.append(('taskId', local_var_params['task_id']))  # noqa: E501
        if 'external_task_id' in local_var_params and local_var_params['external_task_id'] is not None:  # noqa: E501
            query_params.append(('externalTaskId', local_var_params['external_task_id']))  # noqa: E501
        if 'batch_id' in local_var_params and local_var_params['batch_id'] is not None:  # noqa: E501
            query_params.append(('batchId', local_var_params['batch_id']))  # noqa: E501
        if 'job_id' in local_var_params and local_var_params['job_id'] is not None:  # noqa: E501
            query_params.append(('jobId', local_var_params['job_id']))  # noqa: E501
        if 'job_definition_id' in local_var_params and local_var_params['job_definition_id'] is not None:  # noqa: E501
            query_params.append(('jobDefinitionId', local_var_params['job_definition_id']))  # noqa: E501
        if 'user_id' in local_var_params and local_var_params['user_id'] is not None:  # noqa: E501
            query_params.append(('userId', local_var_params['user_id']))  # noqa: E501
        if 'operation_id' in local_var_params and local_var_params['operation_id'] is not None:  # noqa: E501
            query_params.append(('operationId', local_var_params['operation_id']))  # noqa: E501
        if 'operation_type' in local_var_params and local_var_params['operation_type'] is not None:  # noqa: E501
            query_params.append(('operationType', local_var_params['operation_type']))  # noqa: E501
        if 'entity_type' in local_var_params and local_var_params['entity_type'] is not None:  # noqa: E501
            query_params.append(('entityType', local_var_params['entity_type']))  # noqa: E501
        if 'entity_type_in' in local_var_params and local_var_params['entity_type_in'] is not None:  # noqa: E501
            query_params.append(('entityTypeIn', local_var_params['entity_type_in']))  # noqa: E501
        if 'category' in local_var_params and local_var_params['category'] is not None:  # noqa: E501
            query_params.append(('category', local_var_params['category']))  # noqa: E501
        if 'category_in' in local_var_params and local_var_params['category_in'] is not None:  # noqa: E501
            query_params.append(('categoryIn', local_var_params['category_in']))  # noqa: E501
        if '_property' in local_var_params and local_var_params['_property'] is not None:  # noqa: E501
            query_params.append(('property', local_var_params['_property']))  # noqa: E501
        if 'after_timestamp' in local_var_params and local_var_params['after_timestamp'] is not None:  # noqa: E501
            query_params.append(('afterTimestamp', local_var_params['after_timestamp']))  # noqa: E501
        if 'before_timestamp' in local_var_params and local_var_params['before_timestamp'] is not None:  # noqa: E501
            query_params.append(('beforeTimestamp', local_var_params['before_timestamp']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/user-operation/count', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CountResultDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def query_user_operation_entries(self, **kwargs):  # noqa: E501
        """Get User Operation Log (Historic)  # noqa: E501

        Queries for user operation log entries that fulfill the given parameters. The size of the result set can be retrieved by using the [Get User Operation Log Count](https://docs.camunda.org/manual/7.16/reference/rest/history/user-operation-log/get-user-operation-log-query-count/) method.  Note that the properties of operation log entries are interpreted as restrictions on the entities they apply to. That means, if a single process instance is updated, the field `processInstanceId` is populated. If a single operation updates all process instances of the same process definition, the field `processInstanceId` is `null` (a `null` restriction is viewed as a wildcard, i.e., matches a process instance with any id) and the field `processDefinitionId` is populated. This way, which entities were changed by a user operation can easily be reconstructed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_user_operation_entries(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str deployment_id: Filter by deployment id.
        :param str process_definition_id: Filter by process definition id.
        :param str process_definition_key: Filter by process definition key.
        :param str process_instance_id: Filter by process instance id.
        :param str execution_id: Filter by execution id.
        :param str case_definition_id: Filter by case definition id.
        :param str case_instance_id: Filter by case instance id.
        :param str case_execution_id: Filter by case execution id.
        :param str task_id: Only include operations on this task.
        :param str external_task_id: Only include operations on this external task.
        :param str batch_id: Only include operations on this batch.
        :param str job_id: Filter by job id.
        :param str job_definition_id: Filter by job definition id.
        :param str user_id: Only include operations of this user.
        :param str operation_id: Filter by the id of the operation. This allows fetching of multiple entries which are part of a composite operation.
        :param str operation_type: Filter by the type of the operation like `Claim` or `Delegate`. See the [Javadoc](https://docs.camunda.org/manual/7.16/reference/javadoc/?org/camunda/bpm/engine/history/UserOperationLogEntry.html) for a list of available operation types.
        :param str entity_type: Filter by the type of the entity that was affected by this operation, possible values are `Task`, `Attachment` or `IdentityLink`.
        :param str entity_type_in: Filter by a comma-separated list of types of the entities that was affected by this operation, possible values are `Task`, `Attachment` or `IdentityLink`.
        :param str category: Filter by the category that this operation is associated with, possible values are `TaskWorker`, `Admin` or `Operator`.
        :param str category_in: Filter by a comma-separated list of categories that this operation is associated with, possible values are `TaskWorker`, `Admin` or `Operator`.
        :param str _property: Only include operations that changed this property, e.g., `owner` or `assignee`.
        :param datetime after_timestamp: Restrict to entries that were created after the given timestamp. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the timestamp must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., 2013-01-23T14:42:45.000+0200.
        :param datetime before_timestamp: Restrict to entries that were created before the given timestamp. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the timestamp must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., 2013-01-23T14:42:45.000+0200.
        :param str sort_by: Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter.
        :param str sort_order: Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter.
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[UserOperationLogEntryDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.query_user_operation_entries_with_http_info(**kwargs)  # noqa: E501

    def query_user_operation_entries_with_http_info(self, **kwargs):  # noqa: E501
        """Get User Operation Log (Historic)  # noqa: E501

        Queries for user operation log entries that fulfill the given parameters. The size of the result set can be retrieved by using the [Get User Operation Log Count](https://docs.camunda.org/manual/7.16/reference/rest/history/user-operation-log/get-user-operation-log-query-count/) method.  Note that the properties of operation log entries are interpreted as restrictions on the entities they apply to. That means, if a single process instance is updated, the field `processInstanceId` is populated. If a single operation updates all process instances of the same process definition, the field `processInstanceId` is `null` (a `null` restriction is viewed as a wildcard, i.e., matches a process instance with any id) and the field `processDefinitionId` is populated. This way, which entities were changed by a user operation can easily be reconstructed.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_user_operation_entries_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str deployment_id: Filter by deployment id.
        :param str process_definition_id: Filter by process definition id.
        :param str process_definition_key: Filter by process definition key.
        :param str process_instance_id: Filter by process instance id.
        :param str execution_id: Filter by execution id.
        :param str case_definition_id: Filter by case definition id.
        :param str case_instance_id: Filter by case instance id.
        :param str case_execution_id: Filter by case execution id.
        :param str task_id: Only include operations on this task.
        :param str external_task_id: Only include operations on this external task.
        :param str batch_id: Only include operations on this batch.
        :param str job_id: Filter by job id.
        :param str job_definition_id: Filter by job definition id.
        :param str user_id: Only include operations of this user.
        :param str operation_id: Filter by the id of the operation. This allows fetching of multiple entries which are part of a composite operation.
        :param str operation_type: Filter by the type of the operation like `Claim` or `Delegate`. See the [Javadoc](https://docs.camunda.org/manual/7.16/reference/javadoc/?org/camunda/bpm/engine/history/UserOperationLogEntry.html) for a list of available operation types.
        :param str entity_type: Filter by the type of the entity that was affected by this operation, possible values are `Task`, `Attachment` or `IdentityLink`.
        :param str entity_type_in: Filter by a comma-separated list of types of the entities that was affected by this operation, possible values are `Task`, `Attachment` or `IdentityLink`.
        :param str category: Filter by the category that this operation is associated with, possible values are `TaskWorker`, `Admin` or `Operator`.
        :param str category_in: Filter by a comma-separated list of categories that this operation is associated with, possible values are `TaskWorker`, `Admin` or `Operator`.
        :param str _property: Only include operations that changed this property, e.g., `owner` or `assignee`.
        :param datetime after_timestamp: Restrict to entries that were created after the given timestamp. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the timestamp must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., 2013-01-23T14:42:45.000+0200.
        :param datetime before_timestamp: Restrict to entries that were created before the given timestamp. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the timestamp must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., 2013-01-23T14:42:45.000+0200.
        :param str sort_by: Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter.
        :param str sort_order: Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter.
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[UserOperationLogEntryDto], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'deployment_id',
            'process_definition_id',
            'process_definition_key',
            'process_instance_id',
            'execution_id',
            'case_definition_id',
            'case_instance_id',
            'case_execution_id',
            'task_id',
            'external_task_id',
            'batch_id',
            'job_id',
            'job_definition_id',
            'user_id',
            'operation_id',
            'operation_type',
            'entity_type',
            'entity_type_in',
            'category',
            'category_in',
            '_property',
            'after_timestamp',
            'before_timestamp',
            'sort_by',
            'sort_order',
            'first_result',
            'max_results'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_user_operation_entries" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'deployment_id' in local_var_params and local_var_params['deployment_id'] is not None:  # noqa: E501
            query_params.append(('deploymentId', local_var_params['deployment_id']))  # noqa: E501
        if 'process_definition_id' in local_var_params and local_var_params['process_definition_id'] is not None:  # noqa: E501
            query_params.append(('processDefinitionId', local_var_params['process_definition_id']))  # noqa: E501
        if 'process_definition_key' in local_var_params and local_var_params['process_definition_key'] is not None:  # noqa: E501
            query_params.append(('processDefinitionKey', local_var_params['process_definition_key']))  # noqa: E501
        if 'process_instance_id' in local_var_params and local_var_params['process_instance_id'] is not None:  # noqa: E501
            query_params.append(('processInstanceId', local_var_params['process_instance_id']))  # noqa: E501
        if 'execution_id' in local_var_params and local_var_params['execution_id'] is not None:  # noqa: E501
            query_params.append(('executionId', local_var_params['execution_id']))  # noqa: E501
        if 'case_definition_id' in local_var_params and local_var_params['case_definition_id'] is not None:  # noqa: E501
            query_params.append(('caseDefinitionId', local_var_params['case_definition_id']))  # noqa: E501
        if 'case_instance_id' in local_var_params and local_var_params['case_instance_id'] is not None:  # noqa: E501
            query_params.append(('caseInstanceId', local_var_params['case_instance_id']))  # noqa: E501
        if 'case_execution_id' in local_var_params and local_var_params['case_execution_id'] is not None:  # noqa: E501
            query_params.append(('caseExecutionId', local_var_params['case_execution_id']))  # noqa: E501
        if 'task_id' in local_var_params and local_var_params['task_id'] is not None:  # noqa: E501
            query_params.append(('taskId', local_var_params['task_id']))  # noqa: E501
        if 'external_task_id' in local_var_params and local_var_params['external_task_id'] is not None:  # noqa: E501
            query_params.append(('externalTaskId', local_var_params['external_task_id']))  # noqa: E501
        if 'batch_id' in local_var_params and local_var_params['batch_id'] is not None:  # noqa: E501
            query_params.append(('batchId', local_var_params['batch_id']))  # noqa: E501
        if 'job_id' in local_var_params and local_var_params['job_id'] is not None:  # noqa: E501
            query_params.append(('jobId', local_var_params['job_id']))  # noqa: E501
        if 'job_definition_id' in local_var_params and local_var_params['job_definition_id'] is not None:  # noqa: E501
            query_params.append(('jobDefinitionId', local_var_params['job_definition_id']))  # noqa: E501
        if 'user_id' in local_var_params and local_var_params['user_id'] is not None:  # noqa: E501
            query_params.append(('userId', local_var_params['user_id']))  # noqa: E501
        if 'operation_id' in local_var_params and local_var_params['operation_id'] is not None:  # noqa: E501
            query_params.append(('operationId', local_var_params['operation_id']))  # noqa: E501
        if 'operation_type' in local_var_params and local_var_params['operation_type'] is not None:  # noqa: E501
            query_params.append(('operationType', local_var_params['operation_type']))  # noqa: E501
        if 'entity_type' in local_var_params and local_var_params['entity_type'] is not None:  # noqa: E501
            query_params.append(('entityType', local_var_params['entity_type']))  # noqa: E501
        if 'entity_type_in' in local_var_params and local_var_params['entity_type_in'] is not None:  # noqa: E501
            query_params.append(('entityTypeIn', local_var_params['entity_type_in']))  # noqa: E501
        if 'category' in local_var_params and local_var_params['category'] is not None:  # noqa: E501
            query_params.append(('category', local_var_params['category']))  # noqa: E501
        if 'category_in' in local_var_params and local_var_params['category_in'] is not None:  # noqa: E501
            query_params.append(('categoryIn', local_var_params['category_in']))  # noqa: E501
        if '_property' in local_var_params and local_var_params['_property'] is not None:  # noqa: E501
            query_params.append(('property', local_var_params['_property']))  # noqa: E501
        if 'after_timestamp' in local_var_params and local_var_params['after_timestamp'] is not None:  # noqa: E501
            query_params.append(('afterTimestamp', local_var_params['after_timestamp']))  # noqa: E501
        if 'before_timestamp' in local_var_params and local_var_params['before_timestamp'] is not None:  # noqa: E501
            query_params.append(('beforeTimestamp', local_var_params['before_timestamp']))  # noqa: E501
        if 'sort_by' in local_var_params and local_var_params['sort_by'] is not None:  # noqa: E501
            query_params.append(('sortBy', local_var_params['sort_by']))  # noqa: E501
        if 'sort_order' in local_var_params and local_var_params['sort_order'] is not None:  # noqa: E501
            query_params.append(('sortOrder', local_var_params['sort_order']))  # noqa: E501
        if 'first_result' in local_var_params and local_var_params['first_result'] is not None:  # noqa: E501
            query_params.append(('firstResult', local_var_params['first_result']))  # noqa: E501
        if 'max_results' in local_var_params and local_var_params['max_results'] is not None:  # noqa: E501
            query_params.append(('maxResults', local_var_params['max_results']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/user-operation', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[UserOperationLogEntryDto]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_annotation_user_operation_log(self, operation_id, **kwargs):  # noqa: E501
        """Set Annotation to an User Operation Log (Historic)  # noqa: E501

        Set an annotation for auditing reasons.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_annotation_user_operation_log(operation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str operation_id: The operation id of the operation log to be updated. (required)
        :param AnnotationDto annotation_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.set_annotation_user_operation_log_with_http_info(operation_id, **kwargs)  # noqa: E501

    def set_annotation_user_operation_log_with_http_info(self, operation_id, **kwargs):  # noqa: E501
        """Set Annotation to an User Operation Log (Historic)  # noqa: E501

        Set an annotation for auditing reasons.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_annotation_user_operation_log_with_http_info(operation_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str operation_id: The operation id of the operation log to be updated. (required)
        :param AnnotationDto annotation_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'operation_id',
            'annotation_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_annotation_user_operation_log" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'operation_id' is set
        if self.api_client.client_side_validation and ('operation_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['operation_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `operation_id` when calling `set_annotation_user_operation_log`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'operation_id' in local_var_params:
            path_params['operationId'] = local_var_params['operation_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'annotation_dto' in local_var_params:
            body_params = local_var_params['annotation_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/user-operation/{operationId}/set-annotation', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
