# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.16.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from generic_camunda_client.api_client import ApiClient
from generic_camunda_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class HistoricTaskInstanceApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_historic_task_instance_report(self, **kwargs):  # noqa: E501
        """Get Task Report (Historic)  # noqa: E501

        Retrieves a report of completed tasks. When the report type is set to `count`, the report contains a list of completed task counts where an entry contains the task name, the definition key of the task, the process definition id, the process definition key, the process definition name and the count of how many tasks were completed for the specified key in a given period. When the report type is set to `duration`, the report contains a minimum, maximum and average duration value of all completed task instances in a given period.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_task_instance_report(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str report_type: **Mandatory.** Specifies the kind of the report to execute. To retrieve a report about the duration of process instances the value must be set to `duration`. For a report of the completed tasks in a specific timespan the value must be set to `count`.
        :param str period_unit: When the report type is set to `duration`, this parameter is **mandatory**. Specifies the granularity of the report. Valid values are `month` and `quarter`.
        :param datetime completed_before: Restrict to tasks that were completed before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime completed_after: Restrict to tasks that were completed after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param str group_by: When the report type is set to `count`, this parameter is **mandatory**. Groups the tasks report by a given criterion. Valid values are `taskName` and `processDefinition`.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[HistoricTaskInstanceReportResultDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_historic_task_instance_report_with_http_info(**kwargs)  # noqa: E501

    def get_historic_task_instance_report_with_http_info(self, **kwargs):  # noqa: E501
        """Get Task Report (Historic)  # noqa: E501

        Retrieves a report of completed tasks. When the report type is set to `count`, the report contains a list of completed task counts where an entry contains the task name, the definition key of the task, the process definition id, the process definition key, the process definition name and the count of how many tasks were completed for the specified key in a given period. When the report type is set to `duration`, the report contains a minimum, maximum and average duration value of all completed task instances in a given period.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_task_instance_report_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str report_type: **Mandatory.** Specifies the kind of the report to execute. To retrieve a report about the duration of process instances the value must be set to `duration`. For a report of the completed tasks in a specific timespan the value must be set to `count`.
        :param str period_unit: When the report type is set to `duration`, this parameter is **mandatory**. Specifies the granularity of the report. Valid values are `month` and `quarter`.
        :param datetime completed_before: Restrict to tasks that were completed before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime completed_after: Restrict to tasks that were completed after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param str group_by: When the report type is set to `count`, this parameter is **mandatory**. Groups the tasks report by a given criterion. Valid values are `taskName` and `processDefinition`.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[HistoricTaskInstanceReportResultDto], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'report_type',
            'period_unit',
            'completed_before',
            'completed_after',
            'group_by'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_historic_task_instance_report" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'report_type' in local_var_params and local_var_params['report_type'] is not None:  # noqa: E501
            query_params.append(('reportType', local_var_params['report_type']))  # noqa: E501
        if 'period_unit' in local_var_params and local_var_params['period_unit'] is not None:  # noqa: E501
            query_params.append(('periodUnit', local_var_params['period_unit']))  # noqa: E501
        if 'completed_before' in local_var_params and local_var_params['completed_before'] is not None:  # noqa: E501
            query_params.append(('completedBefore', local_var_params['completed_before']))  # noqa: E501
        if 'completed_after' in local_var_params and local_var_params['completed_after'] is not None:  # noqa: E501
            query_params.append(('completedAfter', local_var_params['completed_after']))  # noqa: E501
        if 'group_by' in local_var_params and local_var_params['group_by'] is not None:  # noqa: E501
            query_params.append(('groupBy', local_var_params['group_by']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/task/report', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[HistoricTaskInstanceReportResultDto]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_historic_task_instances(self, **kwargs):  # noqa: E501
        """Get Tasks (Historic)  # noqa: E501

        Queries for historic tasks that fulfill the given parameters. The size of the result set can be retrieved by using the [Get Task Count](https://docs.camunda.org/manual/7.16/reference/rest/history/task/get-task-query-count/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_task_instances(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_id: Filter by task id.
        :param str task_parent_task_id: Filter by parent task id.
        :param str process_instance_id: Filter by process instance id.
        :param str process_instance_business_key: Filter by process instance business key.
        :param str process_instance_business_key_in: Filter by process instances with one of the give business keys. The keys need to be in a comma-separated list.
        :param str process_instance_business_key_like: Filter by  process instance business key that has the parameter value as a substring.
        :param str execution_id: Filter by the id of the execution that executed the task.
        :param str process_definition_id: Filter by process definition id.
        :param str process_definition_key: Restrict to tasks that belong to a process definition with the given key.
        :param str process_definition_name: Restrict to tasks that belong to a process definition with the given name.
        :param str case_instance_id: Filter by case instance id.
        :param str case_execution_id: Filter by the id of the case execution that executed the task.
        :param str case_definition_id: Filter by case definition id.
        :param str case_definition_key: Restrict to tasks that belong to a case definition with the given key.
        :param str case_definition_name: Restrict to tasks that belong to a case definition with the given name.
        :param str activity_instance_id_in: Only include tasks which belong to one of the passed comma-separated activity instance ids.
        :param str task_name: Restrict to tasks that have the given name.
        :param str task_name_like: Restrict to tasks that have a name with the given parameter value as substring.
        :param str task_description: Restrict to tasks that have the given description.
        :param str task_description_like: Restrict to tasks that have a description that has the parameter value as a substring.
        :param str task_definition_key: Restrict to tasks that have the given key.
        :param str task_definition_key_in: Restrict to tasks that have one of the passed comma-separated task definition keys.
        :param str task_delete_reason: Restrict to tasks that have the given delete reason.
        :param str task_delete_reason_like: Restrict to tasks that have a delete reason that has the parameter value as a substring.
        :param str task_assignee: Restrict to tasks that the given user is assigned to.
        :param str task_assignee_like: Restrict to tasks that are assigned to users with the parameter value as a substring.
        :param str task_owner: Restrict to tasks that the given user owns.
        :param str task_owner_like: Restrict to tasks that are owned by users with the parameter value as a substring.
        :param int task_priority: Restrict to tasks that have the given priority.
        :param bool assigned: If set to `true`, restricts the query to all tasks that are assigned.
        :param bool unassigned: If set to `true`, restricts the query to all tasks that are unassigned.
        :param bool finished: Only include finished tasks. Value may only be `true`, as `false` is the default behavior.
        :param bool unfinished: Only include unfinished tasks. Value may only be `true`, as `false` is the default behavior.
        :param bool process_finished: Only include tasks of finished processes. Value may only be `true`, as `false` is the default behavior.
        :param bool process_unfinished: Only include tasks of unfinished processes. Value may only be `true`, as `false` is the default behavior.
        :param datetime task_due_date: Restrict to tasks that are due on the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime task_due_date_before: Restrict to tasks that are due before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime task_due_date_after: Restrict to tasks that are due after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param bool without_task_due_date: Only include tasks which have no due date. Value may only be `true`, as `false` is the default behavior.
        :param datetime task_follow_up_date: Restrict to tasks that have a followUp date on the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime task_follow_up_date_before: Restrict to tasks that have a followUp date before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime task_follow_up_date_after: Restrict to tasks that have a followUp date after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime started_before: Restrict to tasks that were started before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime started_after: Restrict to tasks that were started after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime finished_before: Restrict to tasks that were finished before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime finished_after: Restrict to tasks that were finished after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param str tenant_id_in: Filter by a comma-separated list of tenant ids. A task instance must have one of the given tenant ids.
        :param bool without_tenant_id: Only include historic task instances that belong to no tenant. Value may only be `true`, as `false` is the default behavior.
        :param str task_variables: Only include tasks that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form `key_operator_value`. `key` is the variable name, `operator` is the comparison operator to be used and `value` the variable value. **Note:** Values are always treated as `String` objects on server side.   Valid operator values are: * `eq` - equal to; * `neq` - not equal to; * `gt` - greater than; * `gteq` - greater than or equal to; * `lt` - lower than; * `lteq` - lower than or equal to; * `like`.  `key` and `value` may not contain underscore or comma characters.
        :param str process_variables: Only include tasks that belong to process instances that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form `key_operator_value`. `key` is the variable name, `operator` is the comparison operator to be used and `value` the variable value. **Note:** Values are always treated as `String` objects on server side.   Valid operator values are: * `eq` - equal to; * `neq` - not equal to; * `gt` - greater than; * `gteq` - greater than or equal to; * `lt` - lower than; * `lteq` - lower than or equal to; * `like`; * `notLike`.  `key` and `value` may not contain underscore or comma characters.
        :param bool variable_names_ignore_case: Match the variable name provided in `taskVariables` and `processVariables` case- insensitively. If set to `true` **variableName** and **variablename** are treated as equal.
        :param bool variable_values_ignore_case: Match the variable value provided in `taskVariables` and `processVariables` case- insensitively. If set to `true` **variableValue** and **variablevalue** are treated as equal.
        :param str task_involved_user: Restrict to tasks with a historic identity link to the given user.
        :param str task_involved_group: Restrict to tasks with a historic identity link to the given group.
        :param str task_had_candidate_user: Restrict to tasks with a historic identity link to the given candidate user.
        :param str task_had_candidate_group: Restrict to tasks with a historic identity link to the given candidate group.
        :param bool with_candidate_groups: Only include tasks which have a candidate group. Value may only be `true`, as `false` is the default behavior.
        :param bool without_candidate_groups: Only include tasks which have no candidate group. Value may only be `true`, as `false` is the default behavior.
        :param str sort_by: Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter.
        :param str sort_order: Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter.
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[HistoricTaskInstanceDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_historic_task_instances_with_http_info(**kwargs)  # noqa: E501

    def get_historic_task_instances_with_http_info(self, **kwargs):  # noqa: E501
        """Get Tasks (Historic)  # noqa: E501

        Queries for historic tasks that fulfill the given parameters. The size of the result set can be retrieved by using the [Get Task Count](https://docs.camunda.org/manual/7.16/reference/rest/history/task/get-task-query-count/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_task_instances_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_id: Filter by task id.
        :param str task_parent_task_id: Filter by parent task id.
        :param str process_instance_id: Filter by process instance id.
        :param str process_instance_business_key: Filter by process instance business key.
        :param str process_instance_business_key_in: Filter by process instances with one of the give business keys. The keys need to be in a comma-separated list.
        :param str process_instance_business_key_like: Filter by  process instance business key that has the parameter value as a substring.
        :param str execution_id: Filter by the id of the execution that executed the task.
        :param str process_definition_id: Filter by process definition id.
        :param str process_definition_key: Restrict to tasks that belong to a process definition with the given key.
        :param str process_definition_name: Restrict to tasks that belong to a process definition with the given name.
        :param str case_instance_id: Filter by case instance id.
        :param str case_execution_id: Filter by the id of the case execution that executed the task.
        :param str case_definition_id: Filter by case definition id.
        :param str case_definition_key: Restrict to tasks that belong to a case definition with the given key.
        :param str case_definition_name: Restrict to tasks that belong to a case definition with the given name.
        :param str activity_instance_id_in: Only include tasks which belong to one of the passed comma-separated activity instance ids.
        :param str task_name: Restrict to tasks that have the given name.
        :param str task_name_like: Restrict to tasks that have a name with the given parameter value as substring.
        :param str task_description: Restrict to tasks that have the given description.
        :param str task_description_like: Restrict to tasks that have a description that has the parameter value as a substring.
        :param str task_definition_key: Restrict to tasks that have the given key.
        :param str task_definition_key_in: Restrict to tasks that have one of the passed comma-separated task definition keys.
        :param str task_delete_reason: Restrict to tasks that have the given delete reason.
        :param str task_delete_reason_like: Restrict to tasks that have a delete reason that has the parameter value as a substring.
        :param str task_assignee: Restrict to tasks that the given user is assigned to.
        :param str task_assignee_like: Restrict to tasks that are assigned to users with the parameter value as a substring.
        :param str task_owner: Restrict to tasks that the given user owns.
        :param str task_owner_like: Restrict to tasks that are owned by users with the parameter value as a substring.
        :param int task_priority: Restrict to tasks that have the given priority.
        :param bool assigned: If set to `true`, restricts the query to all tasks that are assigned.
        :param bool unassigned: If set to `true`, restricts the query to all tasks that are unassigned.
        :param bool finished: Only include finished tasks. Value may only be `true`, as `false` is the default behavior.
        :param bool unfinished: Only include unfinished tasks. Value may only be `true`, as `false` is the default behavior.
        :param bool process_finished: Only include tasks of finished processes. Value may only be `true`, as `false` is the default behavior.
        :param bool process_unfinished: Only include tasks of unfinished processes. Value may only be `true`, as `false` is the default behavior.
        :param datetime task_due_date: Restrict to tasks that are due on the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime task_due_date_before: Restrict to tasks that are due before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime task_due_date_after: Restrict to tasks that are due after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param bool without_task_due_date: Only include tasks which have no due date. Value may only be `true`, as `false` is the default behavior.
        :param datetime task_follow_up_date: Restrict to tasks that have a followUp date on the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime task_follow_up_date_before: Restrict to tasks that have a followUp date before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime task_follow_up_date_after: Restrict to tasks that have a followUp date after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime started_before: Restrict to tasks that were started before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime started_after: Restrict to tasks that were started after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime finished_before: Restrict to tasks that were finished before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime finished_after: Restrict to tasks that were finished after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param str tenant_id_in: Filter by a comma-separated list of tenant ids. A task instance must have one of the given tenant ids.
        :param bool without_tenant_id: Only include historic task instances that belong to no tenant. Value may only be `true`, as `false` is the default behavior.
        :param str task_variables: Only include tasks that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form `key_operator_value`. `key` is the variable name, `operator` is the comparison operator to be used and `value` the variable value. **Note:** Values are always treated as `String` objects on server side.   Valid operator values are: * `eq` - equal to; * `neq` - not equal to; * `gt` - greater than; * `gteq` - greater than or equal to; * `lt` - lower than; * `lteq` - lower than or equal to; * `like`.  `key` and `value` may not contain underscore or comma characters.
        :param str process_variables: Only include tasks that belong to process instances that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form `key_operator_value`. `key` is the variable name, `operator` is the comparison operator to be used and `value` the variable value. **Note:** Values are always treated as `String` objects on server side.   Valid operator values are: * `eq` - equal to; * `neq` - not equal to; * `gt` - greater than; * `gteq` - greater than or equal to; * `lt` - lower than; * `lteq` - lower than or equal to; * `like`; * `notLike`.  `key` and `value` may not contain underscore or comma characters.
        :param bool variable_names_ignore_case: Match the variable name provided in `taskVariables` and `processVariables` case- insensitively. If set to `true` **variableName** and **variablename** are treated as equal.
        :param bool variable_values_ignore_case: Match the variable value provided in `taskVariables` and `processVariables` case- insensitively. If set to `true` **variableValue** and **variablevalue** are treated as equal.
        :param str task_involved_user: Restrict to tasks with a historic identity link to the given user.
        :param str task_involved_group: Restrict to tasks with a historic identity link to the given group.
        :param str task_had_candidate_user: Restrict to tasks with a historic identity link to the given candidate user.
        :param str task_had_candidate_group: Restrict to tasks with a historic identity link to the given candidate group.
        :param bool with_candidate_groups: Only include tasks which have a candidate group. Value may only be `true`, as `false` is the default behavior.
        :param bool without_candidate_groups: Only include tasks which have no candidate group. Value may only be `true`, as `false` is the default behavior.
        :param str sort_by: Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter.
        :param str sort_order: Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter.
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[HistoricTaskInstanceDto], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'task_id',
            'task_parent_task_id',
            'process_instance_id',
            'process_instance_business_key',
            'process_instance_business_key_in',
            'process_instance_business_key_like',
            'execution_id',
            'process_definition_id',
            'process_definition_key',
            'process_definition_name',
            'case_instance_id',
            'case_execution_id',
            'case_definition_id',
            'case_definition_key',
            'case_definition_name',
            'activity_instance_id_in',
            'task_name',
            'task_name_like',
            'task_description',
            'task_description_like',
            'task_definition_key',
            'task_definition_key_in',
            'task_delete_reason',
            'task_delete_reason_like',
            'task_assignee',
            'task_assignee_like',
            'task_owner',
            'task_owner_like',
            'task_priority',
            'assigned',
            'unassigned',
            'finished',
            'unfinished',
            'process_finished',
            'process_unfinished',
            'task_due_date',
            'task_due_date_before',
            'task_due_date_after',
            'without_task_due_date',
            'task_follow_up_date',
            'task_follow_up_date_before',
            'task_follow_up_date_after',
            'started_before',
            'started_after',
            'finished_before',
            'finished_after',
            'tenant_id_in',
            'without_tenant_id',
            'task_variables',
            'process_variables',
            'variable_names_ignore_case',
            'variable_values_ignore_case',
            'task_involved_user',
            'task_involved_group',
            'task_had_candidate_user',
            'task_had_candidate_group',
            'with_candidate_groups',
            'without_candidate_groups',
            'sort_by',
            'sort_order',
            'first_result',
            'max_results'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_historic_task_instances" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'task_id' in local_var_params and local_var_params['task_id'] is not None:  # noqa: E501
            query_params.append(('taskId', local_var_params['task_id']))  # noqa: E501
        if 'task_parent_task_id' in local_var_params and local_var_params['task_parent_task_id'] is not None:  # noqa: E501
            query_params.append(('taskParentTaskId', local_var_params['task_parent_task_id']))  # noqa: E501
        if 'process_instance_id' in local_var_params and local_var_params['process_instance_id'] is not None:  # noqa: E501
            query_params.append(('processInstanceId', local_var_params['process_instance_id']))  # noqa: E501
        if 'process_instance_business_key' in local_var_params and local_var_params['process_instance_business_key'] is not None:  # noqa: E501
            query_params.append(('processInstanceBusinessKey', local_var_params['process_instance_business_key']))  # noqa: E501
        if 'process_instance_business_key_in' in local_var_params and local_var_params['process_instance_business_key_in'] is not None:  # noqa: E501
            query_params.append(('processInstanceBusinessKeyIn', local_var_params['process_instance_business_key_in']))  # noqa: E501
        if 'process_instance_business_key_like' in local_var_params and local_var_params['process_instance_business_key_like'] is not None:  # noqa: E501
            query_params.append(('processInstanceBusinessKeyLike', local_var_params['process_instance_business_key_like']))  # noqa: E501
        if 'execution_id' in local_var_params and local_var_params['execution_id'] is not None:  # noqa: E501
            query_params.append(('executionId', local_var_params['execution_id']))  # noqa: E501
        if 'process_definition_id' in local_var_params and local_var_params['process_definition_id'] is not None:  # noqa: E501
            query_params.append(('processDefinitionId', local_var_params['process_definition_id']))  # noqa: E501
        if 'process_definition_key' in local_var_params and local_var_params['process_definition_key'] is not None:  # noqa: E501
            query_params.append(('processDefinitionKey', local_var_params['process_definition_key']))  # noqa: E501
        if 'process_definition_name' in local_var_params and local_var_params['process_definition_name'] is not None:  # noqa: E501
            query_params.append(('processDefinitionName', local_var_params['process_definition_name']))  # noqa: E501
        if 'case_instance_id' in local_var_params and local_var_params['case_instance_id'] is not None:  # noqa: E501
            query_params.append(('caseInstanceId', local_var_params['case_instance_id']))  # noqa: E501
        if 'case_execution_id' in local_var_params and local_var_params['case_execution_id'] is not None:  # noqa: E501
            query_params.append(('caseExecutionId', local_var_params['case_execution_id']))  # noqa: E501
        if 'case_definition_id' in local_var_params and local_var_params['case_definition_id'] is not None:  # noqa: E501
            query_params.append(('caseDefinitionId', local_var_params['case_definition_id']))  # noqa: E501
        if 'case_definition_key' in local_var_params and local_var_params['case_definition_key'] is not None:  # noqa: E501
            query_params.append(('caseDefinitionKey', local_var_params['case_definition_key']))  # noqa: E501
        if 'case_definition_name' in local_var_params and local_var_params['case_definition_name'] is not None:  # noqa: E501
            query_params.append(('caseDefinitionName', local_var_params['case_definition_name']))  # noqa: E501
        if 'activity_instance_id_in' in local_var_params and local_var_params['activity_instance_id_in'] is not None:  # noqa: E501
            query_params.append(('activityInstanceIdIn', local_var_params['activity_instance_id_in']))  # noqa: E501
        if 'task_name' in local_var_params and local_var_params['task_name'] is not None:  # noqa: E501
            query_params.append(('taskName', local_var_params['task_name']))  # noqa: E501
        if 'task_name_like' in local_var_params and local_var_params['task_name_like'] is not None:  # noqa: E501
            query_params.append(('taskNameLike', local_var_params['task_name_like']))  # noqa: E501
        if 'task_description' in local_var_params and local_var_params['task_description'] is not None:  # noqa: E501
            query_params.append(('taskDescription', local_var_params['task_description']))  # noqa: E501
        if 'task_description_like' in local_var_params and local_var_params['task_description_like'] is not None:  # noqa: E501
            query_params.append(('taskDescriptionLike', local_var_params['task_description_like']))  # noqa: E501
        if 'task_definition_key' in local_var_params and local_var_params['task_definition_key'] is not None:  # noqa: E501
            query_params.append(('taskDefinitionKey', local_var_params['task_definition_key']))  # noqa: E501
        if 'task_definition_key_in' in local_var_params and local_var_params['task_definition_key_in'] is not None:  # noqa: E501
            query_params.append(('taskDefinitionKeyIn', local_var_params['task_definition_key_in']))  # noqa: E501
        if 'task_delete_reason' in local_var_params and local_var_params['task_delete_reason'] is not None:  # noqa: E501
            query_params.append(('taskDeleteReason', local_var_params['task_delete_reason']))  # noqa: E501
        if 'task_delete_reason_like' in local_var_params and local_var_params['task_delete_reason_like'] is not None:  # noqa: E501
            query_params.append(('taskDeleteReasonLike', local_var_params['task_delete_reason_like']))  # noqa: E501
        if 'task_assignee' in local_var_params and local_var_params['task_assignee'] is not None:  # noqa: E501
            query_params.append(('taskAssignee', local_var_params['task_assignee']))  # noqa: E501
        if 'task_assignee_like' in local_var_params and local_var_params['task_assignee_like'] is not None:  # noqa: E501
            query_params.append(('taskAssigneeLike', local_var_params['task_assignee_like']))  # noqa: E501
        if 'task_owner' in local_var_params and local_var_params['task_owner'] is not None:  # noqa: E501
            query_params.append(('taskOwner', local_var_params['task_owner']))  # noqa: E501
        if 'task_owner_like' in local_var_params and local_var_params['task_owner_like'] is not None:  # noqa: E501
            query_params.append(('taskOwnerLike', local_var_params['task_owner_like']))  # noqa: E501
        if 'task_priority' in local_var_params and local_var_params['task_priority'] is not None:  # noqa: E501
            query_params.append(('taskPriority', local_var_params['task_priority']))  # noqa: E501
        if 'assigned' in local_var_params and local_var_params['assigned'] is not None:  # noqa: E501
            query_params.append(('assigned', local_var_params['assigned']))  # noqa: E501
        if 'unassigned' in local_var_params and local_var_params['unassigned'] is not None:  # noqa: E501
            query_params.append(('unassigned', local_var_params['unassigned']))  # noqa: E501
        if 'finished' in local_var_params and local_var_params['finished'] is not None:  # noqa: E501
            query_params.append(('finished', local_var_params['finished']))  # noqa: E501
        if 'unfinished' in local_var_params and local_var_params['unfinished'] is not None:  # noqa: E501
            query_params.append(('unfinished', local_var_params['unfinished']))  # noqa: E501
        if 'process_finished' in local_var_params and local_var_params['process_finished'] is not None:  # noqa: E501
            query_params.append(('processFinished', local_var_params['process_finished']))  # noqa: E501
        if 'process_unfinished' in local_var_params and local_var_params['process_unfinished'] is not None:  # noqa: E501
            query_params.append(('processUnfinished', local_var_params['process_unfinished']))  # noqa: E501
        if 'task_due_date' in local_var_params and local_var_params['task_due_date'] is not None:  # noqa: E501
            query_params.append(('taskDueDate', local_var_params['task_due_date']))  # noqa: E501
        if 'task_due_date_before' in local_var_params and local_var_params['task_due_date_before'] is not None:  # noqa: E501
            query_params.append(('taskDueDateBefore', local_var_params['task_due_date_before']))  # noqa: E501
        if 'task_due_date_after' in local_var_params and local_var_params['task_due_date_after'] is not None:  # noqa: E501
            query_params.append(('taskDueDateAfter', local_var_params['task_due_date_after']))  # noqa: E501
        if 'without_task_due_date' in local_var_params and local_var_params['without_task_due_date'] is not None:  # noqa: E501
            query_params.append(('withoutTaskDueDate', local_var_params['without_task_due_date']))  # noqa: E501
        if 'task_follow_up_date' in local_var_params and local_var_params['task_follow_up_date'] is not None:  # noqa: E501
            query_params.append(('taskFollowUpDate', local_var_params['task_follow_up_date']))  # noqa: E501
        if 'task_follow_up_date_before' in local_var_params and local_var_params['task_follow_up_date_before'] is not None:  # noqa: E501
            query_params.append(('taskFollowUpDateBefore', local_var_params['task_follow_up_date_before']))  # noqa: E501
        if 'task_follow_up_date_after' in local_var_params and local_var_params['task_follow_up_date_after'] is not None:  # noqa: E501
            query_params.append(('taskFollowUpDateAfter', local_var_params['task_follow_up_date_after']))  # noqa: E501
        if 'started_before' in local_var_params and local_var_params['started_before'] is not None:  # noqa: E501
            query_params.append(('startedBefore', local_var_params['started_before']))  # noqa: E501
        if 'started_after' in local_var_params and local_var_params['started_after'] is not None:  # noqa: E501
            query_params.append(('startedAfter', local_var_params['started_after']))  # noqa: E501
        if 'finished_before' in local_var_params and local_var_params['finished_before'] is not None:  # noqa: E501
            query_params.append(('finishedBefore', local_var_params['finished_before']))  # noqa: E501
        if 'finished_after' in local_var_params and local_var_params['finished_after'] is not None:  # noqa: E501
            query_params.append(('finishedAfter', local_var_params['finished_after']))  # noqa: E501
        if 'tenant_id_in' in local_var_params and local_var_params['tenant_id_in'] is not None:  # noqa: E501
            query_params.append(('tenantIdIn', local_var_params['tenant_id_in']))  # noqa: E501
        if 'without_tenant_id' in local_var_params and local_var_params['without_tenant_id'] is not None:  # noqa: E501
            query_params.append(('withoutTenantId', local_var_params['without_tenant_id']))  # noqa: E501
        if 'task_variables' in local_var_params and local_var_params['task_variables'] is not None:  # noqa: E501
            query_params.append(('taskVariables', local_var_params['task_variables']))  # noqa: E501
        if 'process_variables' in local_var_params and local_var_params['process_variables'] is not None:  # noqa: E501
            query_params.append(('processVariables', local_var_params['process_variables']))  # noqa: E501
        if 'variable_names_ignore_case' in local_var_params and local_var_params['variable_names_ignore_case'] is not None:  # noqa: E501
            query_params.append(('variableNamesIgnoreCase', local_var_params['variable_names_ignore_case']))  # noqa: E501
        if 'variable_values_ignore_case' in local_var_params and local_var_params['variable_values_ignore_case'] is not None:  # noqa: E501
            query_params.append(('variableValuesIgnoreCase', local_var_params['variable_values_ignore_case']))  # noqa: E501
        if 'task_involved_user' in local_var_params and local_var_params['task_involved_user'] is not None:  # noqa: E501
            query_params.append(('taskInvolvedUser', local_var_params['task_involved_user']))  # noqa: E501
        if 'task_involved_group' in local_var_params and local_var_params['task_involved_group'] is not None:  # noqa: E501
            query_params.append(('taskInvolvedGroup', local_var_params['task_involved_group']))  # noqa: E501
        if 'task_had_candidate_user' in local_var_params and local_var_params['task_had_candidate_user'] is not None:  # noqa: E501
            query_params.append(('taskHadCandidateUser', local_var_params['task_had_candidate_user']))  # noqa: E501
        if 'task_had_candidate_group' in local_var_params and local_var_params['task_had_candidate_group'] is not None:  # noqa: E501
            query_params.append(('taskHadCandidateGroup', local_var_params['task_had_candidate_group']))  # noqa: E501
        if 'with_candidate_groups' in local_var_params and local_var_params['with_candidate_groups'] is not None:  # noqa: E501
            query_params.append(('withCandidateGroups', local_var_params['with_candidate_groups']))  # noqa: E501
        if 'without_candidate_groups' in local_var_params and local_var_params['without_candidate_groups'] is not None:  # noqa: E501
            query_params.append(('withoutCandidateGroups', local_var_params['without_candidate_groups']))  # noqa: E501
        if 'sort_by' in local_var_params and local_var_params['sort_by'] is not None:  # noqa: E501
            query_params.append(('sortBy', local_var_params['sort_by']))  # noqa: E501
        if 'sort_order' in local_var_params and local_var_params['sort_order'] is not None:  # noqa: E501
            query_params.append(('sortOrder', local_var_params['sort_order']))  # noqa: E501
        if 'first_result' in local_var_params and local_var_params['first_result'] is not None:  # noqa: E501
            query_params.append(('firstResult', local_var_params['first_result']))  # noqa: E501
        if 'max_results' in local_var_params and local_var_params['max_results'] is not None:  # noqa: E501
            query_params.append(('maxResults', local_var_params['max_results']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/task', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[HistoricTaskInstanceDto]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_historic_task_instances_count(self, **kwargs):  # noqa: E501
        """Get Task Count  # noqa: E501

        Queries for the number of historic tasks that fulfill the given parameters. Takes the same parameters as the [Get Tasks (Historic)](https://docs.camunda.org/manual/7.16/reference/rest/history/task/get-task-query/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_task_instances_count(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_id: Filter by task id.
        :param str task_parent_task_id: Filter by parent task id.
        :param str process_instance_id: Filter by process instance id.
        :param str process_instance_business_key: Filter by process instance business key.
        :param str process_instance_business_key_in: Filter by process instances with one of the give business keys. The keys need to be in a comma-separated list.
        :param str process_instance_business_key_like: Filter by  process instance business key that has the parameter value as a substring.
        :param str execution_id: Filter by the id of the execution that executed the task.
        :param str process_definition_id: Filter by process definition id.
        :param str process_definition_key: Restrict to tasks that belong to a process definition with the given key.
        :param str process_definition_name: Restrict to tasks that belong to a process definition with the given name.
        :param str case_instance_id: Filter by case instance id.
        :param str case_execution_id: Filter by the id of the case execution that executed the task.
        :param str case_definition_id: Filter by case definition id.
        :param str case_definition_key: Restrict to tasks that belong to a case definition with the given key.
        :param str case_definition_name: Restrict to tasks that belong to a case definition with the given name.
        :param str activity_instance_id_in: Only include tasks which belong to one of the passed comma-separated activity instance ids.
        :param str task_name: Restrict to tasks that have the given name.
        :param str task_name_like: Restrict to tasks that have a name with the given parameter value as substring.
        :param str task_description: Restrict to tasks that have the given description.
        :param str task_description_like: Restrict to tasks that have a description that has the parameter value as a substring.
        :param str task_definition_key: Restrict to tasks that have the given key.
        :param str task_definition_key_in: Restrict to tasks that have one of the passed comma-separated task definition keys.
        :param str task_delete_reason: Restrict to tasks that have the given delete reason.
        :param str task_delete_reason_like: Restrict to tasks that have a delete reason that has the parameter value as a substring.
        :param str task_assignee: Restrict to tasks that the given user is assigned to.
        :param str task_assignee_like: Restrict to tasks that are assigned to users with the parameter value as a substring.
        :param str task_owner: Restrict to tasks that the given user owns.
        :param str task_owner_like: Restrict to tasks that are owned by users with the parameter value as a substring.
        :param int task_priority: Restrict to tasks that have the given priority.
        :param bool assigned: If set to `true`, restricts the query to all tasks that are assigned.
        :param bool unassigned: If set to `true`, restricts the query to all tasks that are unassigned.
        :param bool finished: Only include finished tasks. Value may only be `true`, as `false` is the default behavior.
        :param bool unfinished: Only include unfinished tasks. Value may only be `true`, as `false` is the default behavior.
        :param bool process_finished: Only include tasks of finished processes. Value may only be `true`, as `false` is the default behavior.
        :param bool process_unfinished: Only include tasks of unfinished processes. Value may only be `true`, as `false` is the default behavior.
        :param datetime task_due_date: Restrict to tasks that are due on the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime task_due_date_before: Restrict to tasks that are due before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime task_due_date_after: Restrict to tasks that are due after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param bool without_task_due_date: Only include tasks which have no due date. Value may only be `true`, as `false` is the default behavior.
        :param datetime task_follow_up_date: Restrict to tasks that have a followUp date on the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime task_follow_up_date_before: Restrict to tasks that have a followUp date before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime task_follow_up_date_after: Restrict to tasks that have a followUp date after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime started_before: Restrict to tasks that were started before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime started_after: Restrict to tasks that were started after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime finished_before: Restrict to tasks that were finished before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime finished_after: Restrict to tasks that were finished after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param str tenant_id_in: Filter by a comma-separated list of tenant ids. A task instance must have one of the given tenant ids.
        :param bool without_tenant_id: Only include historic task instances that belong to no tenant. Value may only be `true`, as `false` is the default behavior.
        :param str task_variables: Only include tasks that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form `key_operator_value`. `key` is the variable name, `operator` is the comparison operator to be used and `value` the variable value. **Note:** Values are always treated as `String` objects on server side.   Valid operator values are: * `eq` - equal to; * `neq` - not equal to; * `gt` - greater than; * `gteq` - greater than or equal to; * `lt` - lower than; * `lteq` - lower than or equal to; * `like`.  `key` and `value` may not contain underscore or comma characters.
        :param str process_variables: Only include tasks that belong to process instances that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form `key_operator_value`. `key` is the variable name, `operator` is the comparison operator to be used and `value` the variable value. **Note:** Values are always treated as `String` objects on server side.   Valid operator values are: * `eq` - equal to; * `neq` - not equal to; * `gt` - greater than; * `gteq` - greater than or equal to; * `lt` - lower than; * `lteq` - lower than or equal to; * `like`; * `notLike`.  `key` and `value` may not contain underscore or comma characters.
        :param bool variable_names_ignore_case: Match the variable name provided in `taskVariables` and `processVariables` case- insensitively. If set to `true` **variableName** and **variablename** are treated as equal.
        :param bool variable_values_ignore_case: Match the variable value provided in `taskVariables` and `processVariables` case- insensitively. If set to `true` **variableValue** and **variablevalue** are treated as equal.
        :param str task_involved_user: Restrict to tasks with a historic identity link to the given user.
        :param str task_involved_group: Restrict to tasks with a historic identity link to the given group.
        :param str task_had_candidate_user: Restrict to tasks with a historic identity link to the given candidate user.
        :param str task_had_candidate_group: Restrict to tasks with a historic identity link to the given candidate group.
        :param bool with_candidate_groups: Only include tasks which have a candidate group. Value may only be `true`, as `false` is the default behavior.
        :param bool without_candidate_groups: Only include tasks which have no candidate group. Value may only be `true`, as `false` is the default behavior.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CountResultDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_historic_task_instances_count_with_http_info(**kwargs)  # noqa: E501

    def get_historic_task_instances_count_with_http_info(self, **kwargs):  # noqa: E501
        """Get Task Count  # noqa: E501

        Queries for the number of historic tasks that fulfill the given parameters. Takes the same parameters as the [Get Tasks (Historic)](https://docs.camunda.org/manual/7.16/reference/rest/history/task/get-task-query/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_task_instances_count_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str task_id: Filter by task id.
        :param str task_parent_task_id: Filter by parent task id.
        :param str process_instance_id: Filter by process instance id.
        :param str process_instance_business_key: Filter by process instance business key.
        :param str process_instance_business_key_in: Filter by process instances with one of the give business keys. The keys need to be in a comma-separated list.
        :param str process_instance_business_key_like: Filter by  process instance business key that has the parameter value as a substring.
        :param str execution_id: Filter by the id of the execution that executed the task.
        :param str process_definition_id: Filter by process definition id.
        :param str process_definition_key: Restrict to tasks that belong to a process definition with the given key.
        :param str process_definition_name: Restrict to tasks that belong to a process definition with the given name.
        :param str case_instance_id: Filter by case instance id.
        :param str case_execution_id: Filter by the id of the case execution that executed the task.
        :param str case_definition_id: Filter by case definition id.
        :param str case_definition_key: Restrict to tasks that belong to a case definition with the given key.
        :param str case_definition_name: Restrict to tasks that belong to a case definition with the given name.
        :param str activity_instance_id_in: Only include tasks which belong to one of the passed comma-separated activity instance ids.
        :param str task_name: Restrict to tasks that have the given name.
        :param str task_name_like: Restrict to tasks that have a name with the given parameter value as substring.
        :param str task_description: Restrict to tasks that have the given description.
        :param str task_description_like: Restrict to tasks that have a description that has the parameter value as a substring.
        :param str task_definition_key: Restrict to tasks that have the given key.
        :param str task_definition_key_in: Restrict to tasks that have one of the passed comma-separated task definition keys.
        :param str task_delete_reason: Restrict to tasks that have the given delete reason.
        :param str task_delete_reason_like: Restrict to tasks that have a delete reason that has the parameter value as a substring.
        :param str task_assignee: Restrict to tasks that the given user is assigned to.
        :param str task_assignee_like: Restrict to tasks that are assigned to users with the parameter value as a substring.
        :param str task_owner: Restrict to tasks that the given user owns.
        :param str task_owner_like: Restrict to tasks that are owned by users with the parameter value as a substring.
        :param int task_priority: Restrict to tasks that have the given priority.
        :param bool assigned: If set to `true`, restricts the query to all tasks that are assigned.
        :param bool unassigned: If set to `true`, restricts the query to all tasks that are unassigned.
        :param bool finished: Only include finished tasks. Value may only be `true`, as `false` is the default behavior.
        :param bool unfinished: Only include unfinished tasks. Value may only be `true`, as `false` is the default behavior.
        :param bool process_finished: Only include tasks of finished processes. Value may only be `true`, as `false` is the default behavior.
        :param bool process_unfinished: Only include tasks of unfinished processes. Value may only be `true`, as `false` is the default behavior.
        :param datetime task_due_date: Restrict to tasks that are due on the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime task_due_date_before: Restrict to tasks that are due before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime task_due_date_after: Restrict to tasks that are due after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param bool without_task_due_date: Only include tasks which have no due date. Value may only be `true`, as `false` is the default behavior.
        :param datetime task_follow_up_date: Restrict to tasks that have a followUp date on the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime task_follow_up_date_before: Restrict to tasks that have a followUp date before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime task_follow_up_date_after: Restrict to tasks that have a followUp date after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime started_before: Restrict to tasks that were started before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime started_after: Restrict to tasks that were started after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime finished_before: Restrict to tasks that were finished before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime finished_after: Restrict to tasks that were finished after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param str tenant_id_in: Filter by a comma-separated list of tenant ids. A task instance must have one of the given tenant ids.
        :param bool without_tenant_id: Only include historic task instances that belong to no tenant. Value may only be `true`, as `false` is the default behavior.
        :param str task_variables: Only include tasks that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form `key_operator_value`. `key` is the variable name, `operator` is the comparison operator to be used and `value` the variable value. **Note:** Values are always treated as `String` objects on server side.   Valid operator values are: * `eq` - equal to; * `neq` - not equal to; * `gt` - greater than; * `gteq` - greater than or equal to; * `lt` - lower than; * `lteq` - lower than or equal to; * `like`.  `key` and `value` may not contain underscore or comma characters.
        :param str process_variables: Only include tasks that belong to process instances that have variables with certain values. Variable filtering expressions are comma-separated and are structured as follows:  A valid parameter value has the form `key_operator_value`. `key` is the variable name, `operator` is the comparison operator to be used and `value` the variable value. **Note:** Values are always treated as `String` objects on server side.   Valid operator values are: * `eq` - equal to; * `neq` - not equal to; * `gt` - greater than; * `gteq` - greater than or equal to; * `lt` - lower than; * `lteq` - lower than or equal to; * `like`; * `notLike`.  `key` and `value` may not contain underscore or comma characters.
        :param bool variable_names_ignore_case: Match the variable name provided in `taskVariables` and `processVariables` case- insensitively. If set to `true` **variableName** and **variablename** are treated as equal.
        :param bool variable_values_ignore_case: Match the variable value provided in `taskVariables` and `processVariables` case- insensitively. If set to `true` **variableValue** and **variablevalue** are treated as equal.
        :param str task_involved_user: Restrict to tasks with a historic identity link to the given user.
        :param str task_involved_group: Restrict to tasks with a historic identity link to the given group.
        :param str task_had_candidate_user: Restrict to tasks with a historic identity link to the given candidate user.
        :param str task_had_candidate_group: Restrict to tasks with a historic identity link to the given candidate group.
        :param bool with_candidate_groups: Only include tasks which have a candidate group. Value may only be `true`, as `false` is the default behavior.
        :param bool without_candidate_groups: Only include tasks which have no candidate group. Value may only be `true`, as `false` is the default behavior.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CountResultDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'task_id',
            'task_parent_task_id',
            'process_instance_id',
            'process_instance_business_key',
            'process_instance_business_key_in',
            'process_instance_business_key_like',
            'execution_id',
            'process_definition_id',
            'process_definition_key',
            'process_definition_name',
            'case_instance_id',
            'case_execution_id',
            'case_definition_id',
            'case_definition_key',
            'case_definition_name',
            'activity_instance_id_in',
            'task_name',
            'task_name_like',
            'task_description',
            'task_description_like',
            'task_definition_key',
            'task_definition_key_in',
            'task_delete_reason',
            'task_delete_reason_like',
            'task_assignee',
            'task_assignee_like',
            'task_owner',
            'task_owner_like',
            'task_priority',
            'assigned',
            'unassigned',
            'finished',
            'unfinished',
            'process_finished',
            'process_unfinished',
            'task_due_date',
            'task_due_date_before',
            'task_due_date_after',
            'without_task_due_date',
            'task_follow_up_date',
            'task_follow_up_date_before',
            'task_follow_up_date_after',
            'started_before',
            'started_after',
            'finished_before',
            'finished_after',
            'tenant_id_in',
            'without_tenant_id',
            'task_variables',
            'process_variables',
            'variable_names_ignore_case',
            'variable_values_ignore_case',
            'task_involved_user',
            'task_involved_group',
            'task_had_candidate_user',
            'task_had_candidate_group',
            'with_candidate_groups',
            'without_candidate_groups'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_historic_task_instances_count" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'task_id' in local_var_params and local_var_params['task_id'] is not None:  # noqa: E501
            query_params.append(('taskId', local_var_params['task_id']))  # noqa: E501
        if 'task_parent_task_id' in local_var_params and local_var_params['task_parent_task_id'] is not None:  # noqa: E501
            query_params.append(('taskParentTaskId', local_var_params['task_parent_task_id']))  # noqa: E501
        if 'process_instance_id' in local_var_params and local_var_params['process_instance_id'] is not None:  # noqa: E501
            query_params.append(('processInstanceId', local_var_params['process_instance_id']))  # noqa: E501
        if 'process_instance_business_key' in local_var_params and local_var_params['process_instance_business_key'] is not None:  # noqa: E501
            query_params.append(('processInstanceBusinessKey', local_var_params['process_instance_business_key']))  # noqa: E501
        if 'process_instance_business_key_in' in local_var_params and local_var_params['process_instance_business_key_in'] is not None:  # noqa: E501
            query_params.append(('processInstanceBusinessKeyIn', local_var_params['process_instance_business_key_in']))  # noqa: E501
        if 'process_instance_business_key_like' in local_var_params and local_var_params['process_instance_business_key_like'] is not None:  # noqa: E501
            query_params.append(('processInstanceBusinessKeyLike', local_var_params['process_instance_business_key_like']))  # noqa: E501
        if 'execution_id' in local_var_params and local_var_params['execution_id'] is not None:  # noqa: E501
            query_params.append(('executionId', local_var_params['execution_id']))  # noqa: E501
        if 'process_definition_id' in local_var_params and local_var_params['process_definition_id'] is not None:  # noqa: E501
            query_params.append(('processDefinitionId', local_var_params['process_definition_id']))  # noqa: E501
        if 'process_definition_key' in local_var_params and local_var_params['process_definition_key'] is not None:  # noqa: E501
            query_params.append(('processDefinitionKey', local_var_params['process_definition_key']))  # noqa: E501
        if 'process_definition_name' in local_var_params and local_var_params['process_definition_name'] is not None:  # noqa: E501
            query_params.append(('processDefinitionName', local_var_params['process_definition_name']))  # noqa: E501
        if 'case_instance_id' in local_var_params and local_var_params['case_instance_id'] is not None:  # noqa: E501
            query_params.append(('caseInstanceId', local_var_params['case_instance_id']))  # noqa: E501
        if 'case_execution_id' in local_var_params and local_var_params['case_execution_id'] is not None:  # noqa: E501
            query_params.append(('caseExecutionId', local_var_params['case_execution_id']))  # noqa: E501
        if 'case_definition_id' in local_var_params and local_var_params['case_definition_id'] is not None:  # noqa: E501
            query_params.append(('caseDefinitionId', local_var_params['case_definition_id']))  # noqa: E501
        if 'case_definition_key' in local_var_params and local_var_params['case_definition_key'] is not None:  # noqa: E501
            query_params.append(('caseDefinitionKey', local_var_params['case_definition_key']))  # noqa: E501
        if 'case_definition_name' in local_var_params and local_var_params['case_definition_name'] is not None:  # noqa: E501
            query_params.append(('caseDefinitionName', local_var_params['case_definition_name']))  # noqa: E501
        if 'activity_instance_id_in' in local_var_params and local_var_params['activity_instance_id_in'] is not None:  # noqa: E501
            query_params.append(('activityInstanceIdIn', local_var_params['activity_instance_id_in']))  # noqa: E501
        if 'task_name' in local_var_params and local_var_params['task_name'] is not None:  # noqa: E501
            query_params.append(('taskName', local_var_params['task_name']))  # noqa: E501
        if 'task_name_like' in local_var_params and local_var_params['task_name_like'] is not None:  # noqa: E501
            query_params.append(('taskNameLike', local_var_params['task_name_like']))  # noqa: E501
        if 'task_description' in local_var_params and local_var_params['task_description'] is not None:  # noqa: E501
            query_params.append(('taskDescription', local_var_params['task_description']))  # noqa: E501
        if 'task_description_like' in local_var_params and local_var_params['task_description_like'] is not None:  # noqa: E501
            query_params.append(('taskDescriptionLike', local_var_params['task_description_like']))  # noqa: E501
        if 'task_definition_key' in local_var_params and local_var_params['task_definition_key'] is not None:  # noqa: E501
            query_params.append(('taskDefinitionKey', local_var_params['task_definition_key']))  # noqa: E501
        if 'task_definition_key_in' in local_var_params and local_var_params['task_definition_key_in'] is not None:  # noqa: E501
            query_params.append(('taskDefinitionKeyIn', local_var_params['task_definition_key_in']))  # noqa: E501
        if 'task_delete_reason' in local_var_params and local_var_params['task_delete_reason'] is not None:  # noqa: E501
            query_params.append(('taskDeleteReason', local_var_params['task_delete_reason']))  # noqa: E501
        if 'task_delete_reason_like' in local_var_params and local_var_params['task_delete_reason_like'] is not None:  # noqa: E501
            query_params.append(('taskDeleteReasonLike', local_var_params['task_delete_reason_like']))  # noqa: E501
        if 'task_assignee' in local_var_params and local_var_params['task_assignee'] is not None:  # noqa: E501
            query_params.append(('taskAssignee', local_var_params['task_assignee']))  # noqa: E501
        if 'task_assignee_like' in local_var_params and local_var_params['task_assignee_like'] is not None:  # noqa: E501
            query_params.append(('taskAssigneeLike', local_var_params['task_assignee_like']))  # noqa: E501
        if 'task_owner' in local_var_params and local_var_params['task_owner'] is not None:  # noqa: E501
            query_params.append(('taskOwner', local_var_params['task_owner']))  # noqa: E501
        if 'task_owner_like' in local_var_params and local_var_params['task_owner_like'] is not None:  # noqa: E501
            query_params.append(('taskOwnerLike', local_var_params['task_owner_like']))  # noqa: E501
        if 'task_priority' in local_var_params and local_var_params['task_priority'] is not None:  # noqa: E501
            query_params.append(('taskPriority', local_var_params['task_priority']))  # noqa: E501
        if 'assigned' in local_var_params and local_var_params['assigned'] is not None:  # noqa: E501
            query_params.append(('assigned', local_var_params['assigned']))  # noqa: E501
        if 'unassigned' in local_var_params and local_var_params['unassigned'] is not None:  # noqa: E501
            query_params.append(('unassigned', local_var_params['unassigned']))  # noqa: E501
        if 'finished' in local_var_params and local_var_params['finished'] is not None:  # noqa: E501
            query_params.append(('finished', local_var_params['finished']))  # noqa: E501
        if 'unfinished' in local_var_params and local_var_params['unfinished'] is not None:  # noqa: E501
            query_params.append(('unfinished', local_var_params['unfinished']))  # noqa: E501
        if 'process_finished' in local_var_params and local_var_params['process_finished'] is not None:  # noqa: E501
            query_params.append(('processFinished', local_var_params['process_finished']))  # noqa: E501
        if 'process_unfinished' in local_var_params and local_var_params['process_unfinished'] is not None:  # noqa: E501
            query_params.append(('processUnfinished', local_var_params['process_unfinished']))  # noqa: E501
        if 'task_due_date' in local_var_params and local_var_params['task_due_date'] is not None:  # noqa: E501
            query_params.append(('taskDueDate', local_var_params['task_due_date']))  # noqa: E501
        if 'task_due_date_before' in local_var_params and local_var_params['task_due_date_before'] is not None:  # noqa: E501
            query_params.append(('taskDueDateBefore', local_var_params['task_due_date_before']))  # noqa: E501
        if 'task_due_date_after' in local_var_params and local_var_params['task_due_date_after'] is not None:  # noqa: E501
            query_params.append(('taskDueDateAfter', local_var_params['task_due_date_after']))  # noqa: E501
        if 'without_task_due_date' in local_var_params and local_var_params['without_task_due_date'] is not None:  # noqa: E501
            query_params.append(('withoutTaskDueDate', local_var_params['without_task_due_date']))  # noqa: E501
        if 'task_follow_up_date' in local_var_params and local_var_params['task_follow_up_date'] is not None:  # noqa: E501
            query_params.append(('taskFollowUpDate', local_var_params['task_follow_up_date']))  # noqa: E501
        if 'task_follow_up_date_before' in local_var_params and local_var_params['task_follow_up_date_before'] is not None:  # noqa: E501
            query_params.append(('taskFollowUpDateBefore', local_var_params['task_follow_up_date_before']))  # noqa: E501
        if 'task_follow_up_date_after' in local_var_params and local_var_params['task_follow_up_date_after'] is not None:  # noqa: E501
            query_params.append(('taskFollowUpDateAfter', local_var_params['task_follow_up_date_after']))  # noqa: E501
        if 'started_before' in local_var_params and local_var_params['started_before'] is not None:  # noqa: E501
            query_params.append(('startedBefore', local_var_params['started_before']))  # noqa: E501
        if 'started_after' in local_var_params and local_var_params['started_after'] is not None:  # noqa: E501
            query_params.append(('startedAfter', local_var_params['started_after']))  # noqa: E501
        if 'finished_before' in local_var_params and local_var_params['finished_before'] is not None:  # noqa: E501
            query_params.append(('finishedBefore', local_var_params['finished_before']))  # noqa: E501
        if 'finished_after' in local_var_params and local_var_params['finished_after'] is not None:  # noqa: E501
            query_params.append(('finishedAfter', local_var_params['finished_after']))  # noqa: E501
        if 'tenant_id_in' in local_var_params and local_var_params['tenant_id_in'] is not None:  # noqa: E501
            query_params.append(('tenantIdIn', local_var_params['tenant_id_in']))  # noqa: E501
        if 'without_tenant_id' in local_var_params and local_var_params['without_tenant_id'] is not None:  # noqa: E501
            query_params.append(('withoutTenantId', local_var_params['without_tenant_id']))  # noqa: E501
        if 'task_variables' in local_var_params and local_var_params['task_variables'] is not None:  # noqa: E501
            query_params.append(('taskVariables', local_var_params['task_variables']))  # noqa: E501
        if 'process_variables' in local_var_params and local_var_params['process_variables'] is not None:  # noqa: E501
            query_params.append(('processVariables', local_var_params['process_variables']))  # noqa: E501
        if 'variable_names_ignore_case' in local_var_params and local_var_params['variable_names_ignore_case'] is not None:  # noqa: E501
            query_params.append(('variableNamesIgnoreCase', local_var_params['variable_names_ignore_case']))  # noqa: E501
        if 'variable_values_ignore_case' in local_var_params and local_var_params['variable_values_ignore_case'] is not None:  # noqa: E501
            query_params.append(('variableValuesIgnoreCase', local_var_params['variable_values_ignore_case']))  # noqa: E501
        if 'task_involved_user' in local_var_params and local_var_params['task_involved_user'] is not None:  # noqa: E501
            query_params.append(('taskInvolvedUser', local_var_params['task_involved_user']))  # noqa: E501
        if 'task_involved_group' in local_var_params and local_var_params['task_involved_group'] is not None:  # noqa: E501
            query_params.append(('taskInvolvedGroup', local_var_params['task_involved_group']))  # noqa: E501
        if 'task_had_candidate_user' in local_var_params and local_var_params['task_had_candidate_user'] is not None:  # noqa: E501
            query_params.append(('taskHadCandidateUser', local_var_params['task_had_candidate_user']))  # noqa: E501
        if 'task_had_candidate_group' in local_var_params and local_var_params['task_had_candidate_group'] is not None:  # noqa: E501
            query_params.append(('taskHadCandidateGroup', local_var_params['task_had_candidate_group']))  # noqa: E501
        if 'with_candidate_groups' in local_var_params and local_var_params['with_candidate_groups'] is not None:  # noqa: E501
            query_params.append(('withCandidateGroups', local_var_params['with_candidate_groups']))  # noqa: E501
        if 'without_candidate_groups' in local_var_params and local_var_params['without_candidate_groups'] is not None:  # noqa: E501
            query_params.append(('withoutCandidateGroups', local_var_params['without_candidate_groups']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/task/count', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CountResultDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def query_historic_task_instances(self, **kwargs):  # noqa: E501
        """Get Tasks (Historic) (POST)  # noqa: E501

        Queries for historic tasks that fulfill the given parameters. This method is slightly more powerful than the [Get Tasks (Historic)](https://docs.camunda.org/manual/7.16/reference/rest/history/task/get-task-query/) method because it allows filtering by multiple process or task variables of types `String`, `Number` or `Boolean`. The size of the result set can be retrieved by using the [Get Task Count (POST)](https://docs.camunda.org/manual/7.16/reference/rest/history/task/post-task-query-count/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_historic_task_instances(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param HistoricTaskInstanceQueryDto historic_task_instance_query_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[HistoricTaskInstanceDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.query_historic_task_instances_with_http_info(**kwargs)  # noqa: E501

    def query_historic_task_instances_with_http_info(self, **kwargs):  # noqa: E501
        """Get Tasks (Historic) (POST)  # noqa: E501

        Queries for historic tasks that fulfill the given parameters. This method is slightly more powerful than the [Get Tasks (Historic)](https://docs.camunda.org/manual/7.16/reference/rest/history/task/get-task-query/) method because it allows filtering by multiple process or task variables of types `String`, `Number` or `Boolean`. The size of the result set can be retrieved by using the [Get Task Count (POST)](https://docs.camunda.org/manual/7.16/reference/rest/history/task/post-task-query-count/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_historic_task_instances_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param HistoricTaskInstanceQueryDto historic_task_instance_query_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[HistoricTaskInstanceDto], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'first_result',
            'max_results',
            'historic_task_instance_query_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_historic_task_instances" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'first_result' in local_var_params and local_var_params['first_result'] is not None:  # noqa: E501
            query_params.append(('firstResult', local_var_params['first_result']))  # noqa: E501
        if 'max_results' in local_var_params and local_var_params['max_results'] is not None:  # noqa: E501
            query_params.append(('maxResults', local_var_params['max_results']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'historic_task_instance_query_dto' in local_var_params:
            body_params = local_var_params['historic_task_instance_query_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/task', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[HistoricTaskInstanceDto]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def query_historic_task_instances_count(self, **kwargs):  # noqa: E501
        """Get Task Count (POST)  # noqa: E501

        Queries for the number of historic tasks that fulfill the given parameters. Takes the same parameters as the [Get Tasks (Historic)](https://docs.camunda.org/manual/7.16/reference/rest/history/task/get-task-query/) method. Corresponds to the size of the result set of the [Get Tasks (Historic) (POST)](https://docs.camunda.org/manual/7.16/reference/rest/history/task/post-task-query/) method and takes the same parameters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_historic_task_instances_count(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param HistoricTaskInstanceQueryDto historic_task_instance_query_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CountResultDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.query_historic_task_instances_count_with_http_info(**kwargs)  # noqa: E501

    def query_historic_task_instances_count_with_http_info(self, **kwargs):  # noqa: E501
        """Get Task Count (POST)  # noqa: E501

        Queries for the number of historic tasks that fulfill the given parameters. Takes the same parameters as the [Get Tasks (Historic)](https://docs.camunda.org/manual/7.16/reference/rest/history/task/get-task-query/) method. Corresponds to the size of the result set of the [Get Tasks (Historic) (POST)](https://docs.camunda.org/manual/7.16/reference/rest/history/task/post-task-query/) method and takes the same parameters.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_historic_task_instances_count_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param HistoricTaskInstanceQueryDto historic_task_instance_query_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CountResultDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'historic_task_instance_query_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_historic_task_instances_count" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'historic_task_instance_query_dto' in local_var_params:
            body_params = local_var_params['historic_task_instance_query_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/task/count', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CountResultDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
