# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.16.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from generic_camunda_client.api_client import ApiClient
from generic_camunda_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class HistoricProcessInstanceApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_historic_process_instance(self, id, **kwargs):  # noqa: E501
        """Delete  # noqa: E501

        Deletes a process instance from the history by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_historic_process_instance(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the historic process instance to be deleted. (required)
        :param bool fail_if_not_exists: If set to `false`, the request will still be successful if the process id is not found.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_historic_process_instance_with_http_info(id, **kwargs)  # noqa: E501

    def delete_historic_process_instance_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delete  # noqa: E501

        Deletes a process instance from the history by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_historic_process_instance_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the historic process instance to be deleted. (required)
        :param bool fail_if_not_exists: If set to `false`, the request will still be successful if the process id is not found.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'fail_if_not_exists'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_historic_process_instance" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_historic_process_instance`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'fail_if_not_exists' in local_var_params and local_var_params['fail_if_not_exists'] is not None:  # noqa: E501
            query_params.append(('failIfNotExists', local_var_params['fail_if_not_exists']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/process-instance/{id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_historic_process_instances_async(self, **kwargs):  # noqa: E501
        """Delete Async (POST)  # noqa: E501

        Delete multiple historic process instances asynchronously (batch). At least `historicProcessInstanceIds` or `historicProcessInstanceQuery` has to be provided. If both are provided then all instances matching query criterion and instances from the list will be deleted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_historic_process_instances_async(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param DeleteHistoricProcessInstancesDto delete_historic_process_instances_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BatchDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_historic_process_instances_async_with_http_info(**kwargs)  # noqa: E501

    def delete_historic_process_instances_async_with_http_info(self, **kwargs):  # noqa: E501
        """Delete Async (POST)  # noqa: E501

        Delete multiple historic process instances asynchronously (batch). At least `historicProcessInstanceIds` or `historicProcessInstanceQuery` has to be provided. If both are provided then all instances matching query criterion and instances from the list will be deleted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_historic_process_instances_async_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param DeleteHistoricProcessInstancesDto delete_historic_process_instances_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BatchDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'delete_historic_process_instances_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_historic_process_instances_async" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'delete_historic_process_instances_dto' in local_var_params:
            body_params = local_var_params['delete_historic_process_instances_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/process-instance/delete', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BatchDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_historic_variable_instances_of_historic_process_instance(self, id, **kwargs):  # noqa: E501
        """Delete Variable Instances  # noqa: E501

        Deletes all variables of a process instance from the history by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_historic_variable_instances_of_historic_process_instance(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the process instance for which all historic variables are to be deleted. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_historic_variable_instances_of_historic_process_instance_with_http_info(id, **kwargs)  # noqa: E501

    def delete_historic_variable_instances_of_historic_process_instance_with_http_info(self, id, **kwargs):  # noqa: E501
        """Delete Variable Instances  # noqa: E501

        Deletes all variables of a process instance from the history by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_historic_variable_instances_of_historic_process_instance_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the process instance for which all historic variables are to be deleted. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_historic_variable_instances_of_historic_process_instance" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `delete_historic_variable_instances_of_historic_process_instance`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/process-instance/{id}/variable-instances', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_historic_process_instance(self, id, **kwargs):  # noqa: E501
        """Get  # noqa: E501

        Retrieves a historic process instance by id, according to the `HistoricProcessInstance` interface in the engine.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_process_instance(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the historic process instance to be retrieved. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: HistoricProcessInstanceDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_historic_process_instance_with_http_info(id, **kwargs)  # noqa: E501

    def get_historic_process_instance_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get  # noqa: E501

        Retrieves a historic process instance by id, according to the `HistoricProcessInstance` interface in the engine.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_process_instance_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the historic process instance to be retrieved. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(HistoricProcessInstanceDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_historic_process_instance" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_historic_process_instance`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/process-instance/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HistoricProcessInstanceDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_historic_process_instance_duration_report(self, report_type, period_unit, **kwargs):  # noqa: E501
        """Get Duration Report  # noqa: E501

        Retrieves a report about the duration of completed process instances, grouped by a period. These reports include the maximum, minimum and average duration of all completed process instances which were started in a given period.  **Note:** This only includes historic data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_process_instance_duration_report(report_type, period_unit, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str report_type: **Mandatory.** Specifies the type of the report to retrieve. To retrieve a report about the duration of process instances, the value must be set to `duration`. (required)
        :param str period_unit: **Mandatory.** Specifies the granularity of the report. Valid values are `month` and `quarter`. (required)
        :param str process_definition_id_in: Filter by process definition ids. Must be a comma-separated list of process definition ids.
        :param str process_definition_key_in: Filter by process definition keys. Must be a comma-separated list of process definition keys.
        :param datetime started_before: Restrict to instances that were started before the given date. By [default](), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2016-01-23T14:42:45.000+0200`.
        :param datetime started_after: Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2016-01-23T14:42:45.000+0200`.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[DurationReportResultDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_historic_process_instance_duration_report_with_http_info(report_type, period_unit, **kwargs)  # noqa: E501

    def get_historic_process_instance_duration_report_with_http_info(self, report_type, period_unit, **kwargs):  # noqa: E501
        """Get Duration Report  # noqa: E501

        Retrieves a report about the duration of completed process instances, grouped by a period. These reports include the maximum, minimum and average duration of all completed process instances which were started in a given period.  **Note:** This only includes historic data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_process_instance_duration_report_with_http_info(report_type, period_unit, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str report_type: **Mandatory.** Specifies the type of the report to retrieve. To retrieve a report about the duration of process instances, the value must be set to `duration`. (required)
        :param str period_unit: **Mandatory.** Specifies the granularity of the report. Valid values are `month` and `quarter`. (required)
        :param str process_definition_id_in: Filter by process definition ids. Must be a comma-separated list of process definition ids.
        :param str process_definition_key_in: Filter by process definition keys. Must be a comma-separated list of process definition keys.
        :param datetime started_before: Restrict to instances that were started before the given date. By [default](), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2016-01-23T14:42:45.000+0200`.
        :param datetime started_after: Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2016-01-23T14:42:45.000+0200`.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[DurationReportResultDto], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'report_type',
            'period_unit',
            'process_definition_id_in',
            'process_definition_key_in',
            'started_before',
            'started_after'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_historic_process_instance_duration_report" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'report_type' is set
        if self.api_client.client_side_validation and ('report_type' not in local_var_params or  # noqa: E501
                                                        local_var_params['report_type'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `report_type` when calling `get_historic_process_instance_duration_report`")  # noqa: E501
        # verify the required parameter 'period_unit' is set
        if self.api_client.client_side_validation and ('period_unit' not in local_var_params or  # noqa: E501
                                                        local_var_params['period_unit'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `period_unit` when calling `get_historic_process_instance_duration_report`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'report_type' in local_var_params and local_var_params['report_type'] is not None:  # noqa: E501
            query_params.append(('reportType', local_var_params['report_type']))  # noqa: E501
        if 'period_unit' in local_var_params and local_var_params['period_unit'] is not None:  # noqa: E501
            query_params.append(('periodUnit', local_var_params['period_unit']))  # noqa: E501
        if 'process_definition_id_in' in local_var_params and local_var_params['process_definition_id_in'] is not None:  # noqa: E501
            query_params.append(('processDefinitionIdIn', local_var_params['process_definition_id_in']))  # noqa: E501
        if 'process_definition_key_in' in local_var_params and local_var_params['process_definition_key_in'] is not None:  # noqa: E501
            query_params.append(('processDefinitionKeyIn', local_var_params['process_definition_key_in']))  # noqa: E501
        if 'started_before' in local_var_params and local_var_params['started_before'] is not None:  # noqa: E501
            query_params.append(('startedBefore', local_var_params['started_before']))  # noqa: E501
        if 'started_after' in local_var_params and local_var_params['started_after'] is not None:  # noqa: E501
            query_params.append(('startedAfter', local_var_params['started_after']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json', 'application/csv', 'text/csv'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/process-instance/report', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DurationReportResultDto]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_historic_process_instances(self, **kwargs):  # noqa: E501
        """Get List  # noqa: E501

        Queries for historic process instances that fulfill the given parameters. The size of the result set can be retrieved by using the [Get Process Instance Count](https://docs.camunda.org/manual/7.16/reference/rest/history/process-instance/get-process-instance-query-count/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_process_instances(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str sort_by: Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter.
        :param str sort_order: Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter.
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param str process_instance_id: Filter by process instance id.
        :param str process_instance_ids: Filter by process instance ids. Filter by a comma-separated list of `Strings`.
        :param str process_definition_id: Filter by the process definition the instances run on.
        :param str process_definition_key: Filter by the key of the process definition the instances run on.
        :param str process_definition_key_in: Filter by a list of process definition keys. A process instance must have one of the given process definition keys. Filter by a comma-separated list of `Strings`.
        :param str process_definition_name: Filter by the name of the process definition the instances run on.
        :param str process_definition_name_like: Filter by process definition names that the parameter is a substring of.
        :param str process_definition_key_not_in: Exclude instances that belong to a set of process definitions. Filter by a comma-separated list of `Strings`.
        :param str process_instance_business_key: Filter by process instance business key.
        :param str process_instance_business_key_like: Filter by process instance business key that the parameter is a substring of.
        :param bool root_process_instances: Restrict the query to all process instances that are top level process instances.
        :param bool finished: Only include finished process instances. This flag includes all process instances that are completed or terminated. Value may only be `true`, as `false` is the default behavior.
        :param bool unfinished: Only include unfinished process instances. Value may only be `true`, as `false` is the default behavior.
        :param bool with_incidents: Only include process instances which have an incident. Value may only be `true`, as `false` is the default behavior.
        :param bool with_root_incidents: Only include process instances which have a root incident. Value may only be `true`, as `false` is the default behavior.
        :param str incident_type: Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.16/user-guide/process-engine/incidents/#incident-types) for a list of incident types.
        :param str incident_status: Only include process instances which have an incident in status either open or resolved. To get all process instances, use the query parameter withIncidents.
        :param str incident_message: Filter by the incident message. Exact match.
        :param str incident_message_like: Filter by the incident message that the parameter is a substring of.
        :param datetime started_before: Restrict to instances that were started before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime started_after: Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime finished_before: Restrict to instances that were finished before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime finished_after: Restrict to instances that were finished after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime executed_activity_after: Restrict to instances that executed an activity after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime executed_activity_before: Restrict to instances that executed an activity before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime executed_job_after: Restrict to instances that executed an job after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime executed_job_before: Restrict to instances that executed an job before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param str started_by: Only include process instances that were started by the given user.
        :param str super_process_instance_id: Restrict query to all process instances that are sub process instances of the given process instance. Takes a process instance id.
        :param str sub_process_instance_id: Restrict query to one process instance that has a sub process instance with the given id.
        :param str super_case_instance_id: Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id.
        :param str sub_case_instance_id: Restrict query to one process instance that has a sub case instance with the given id.
        :param str case_instance_id: Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id.
        :param str tenant_id_in: Filter by a list of tenant ids. A process instance must have one of the given tenant ids. Filter by a comma-separated list of `Strings`
        :param bool without_tenant_id: Only include historic process instances which belong to no tenant. Value may only be `true`, as `false` is the default behavior.
        :param str executed_activity_id_in: Restrict to instances that executed an activity with one of given ids. Filter by a comma-separated list of `Strings`
        :param str active_activity_id_in: Restrict to instances that have an active activity with one of given ids. Filter by a comma-separated list of `Strings`
        :param bool active: Restrict to instances that are active.
        :param bool suspended: Restrict to instances that are suspended.
        :param bool completed: Restrict to instances that are completed.
        :param bool externally_terminated: Restrict to instances that are externallyTerminated.
        :param bool internally_terminated: Restrict to instances that are internallyTerminated.
        :param str variables: Only include process instances that have/had variables with certain values. Variable filtering expressions are comma-separated and are structured as follows: A valid parameter value has the form `key_operator_value`. `key` is the variable name, `operator` is the comparison operator to be used and `value` the variable value.  **Note:** Values are always treated as String objects on server side.  Valid operator values are: `eq` - equal to; `neq` - not equal to; `gt` - greater than; `gteq` - greater than or equal to; `lt` - lower than; `lteq` - lower than or equal to; `like`.  Key and value may not contain underscore or comma characters. 
        :param bool variable_names_ignore_case: Match all variable names provided in variables case-insensitively. If set to `true` variableName and variablename are treated as equal.
        :param bool variable_values_ignore_case: Match all variable values provided in variables case-insensitively. If set to `true` variableValue and variablevalue are treated as equal.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[HistoricProcessInstanceDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_historic_process_instances_with_http_info(**kwargs)  # noqa: E501

    def get_historic_process_instances_with_http_info(self, **kwargs):  # noqa: E501
        """Get List  # noqa: E501

        Queries for historic process instances that fulfill the given parameters. The size of the result set can be retrieved by using the [Get Process Instance Count](https://docs.camunda.org/manual/7.16/reference/rest/history/process-instance/get-process-instance-query-count/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_process_instances_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str sort_by: Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter.
        :param str sort_order: Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter.
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param str process_instance_id: Filter by process instance id.
        :param str process_instance_ids: Filter by process instance ids. Filter by a comma-separated list of `Strings`.
        :param str process_definition_id: Filter by the process definition the instances run on.
        :param str process_definition_key: Filter by the key of the process definition the instances run on.
        :param str process_definition_key_in: Filter by a list of process definition keys. A process instance must have one of the given process definition keys. Filter by a comma-separated list of `Strings`.
        :param str process_definition_name: Filter by the name of the process definition the instances run on.
        :param str process_definition_name_like: Filter by process definition names that the parameter is a substring of.
        :param str process_definition_key_not_in: Exclude instances that belong to a set of process definitions. Filter by a comma-separated list of `Strings`.
        :param str process_instance_business_key: Filter by process instance business key.
        :param str process_instance_business_key_like: Filter by process instance business key that the parameter is a substring of.
        :param bool root_process_instances: Restrict the query to all process instances that are top level process instances.
        :param bool finished: Only include finished process instances. This flag includes all process instances that are completed or terminated. Value may only be `true`, as `false` is the default behavior.
        :param bool unfinished: Only include unfinished process instances. Value may only be `true`, as `false` is the default behavior.
        :param bool with_incidents: Only include process instances which have an incident. Value may only be `true`, as `false` is the default behavior.
        :param bool with_root_incidents: Only include process instances which have a root incident. Value may only be `true`, as `false` is the default behavior.
        :param str incident_type: Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.16/user-guide/process-engine/incidents/#incident-types) for a list of incident types.
        :param str incident_status: Only include process instances which have an incident in status either open or resolved. To get all process instances, use the query parameter withIncidents.
        :param str incident_message: Filter by the incident message. Exact match.
        :param str incident_message_like: Filter by the incident message that the parameter is a substring of.
        :param datetime started_before: Restrict to instances that were started before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime started_after: Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime finished_before: Restrict to instances that were finished before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime finished_after: Restrict to instances that were finished after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime executed_activity_after: Restrict to instances that executed an activity after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime executed_activity_before: Restrict to instances that executed an activity before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime executed_job_after: Restrict to instances that executed an job after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime executed_job_before: Restrict to instances that executed an job before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param str started_by: Only include process instances that were started by the given user.
        :param str super_process_instance_id: Restrict query to all process instances that are sub process instances of the given process instance. Takes a process instance id.
        :param str sub_process_instance_id: Restrict query to one process instance that has a sub process instance with the given id.
        :param str super_case_instance_id: Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id.
        :param str sub_case_instance_id: Restrict query to one process instance that has a sub case instance with the given id.
        :param str case_instance_id: Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id.
        :param str tenant_id_in: Filter by a list of tenant ids. A process instance must have one of the given tenant ids. Filter by a comma-separated list of `Strings`
        :param bool without_tenant_id: Only include historic process instances which belong to no tenant. Value may only be `true`, as `false` is the default behavior.
        :param str executed_activity_id_in: Restrict to instances that executed an activity with one of given ids. Filter by a comma-separated list of `Strings`
        :param str active_activity_id_in: Restrict to instances that have an active activity with one of given ids. Filter by a comma-separated list of `Strings`
        :param bool active: Restrict to instances that are active.
        :param bool suspended: Restrict to instances that are suspended.
        :param bool completed: Restrict to instances that are completed.
        :param bool externally_terminated: Restrict to instances that are externallyTerminated.
        :param bool internally_terminated: Restrict to instances that are internallyTerminated.
        :param str variables: Only include process instances that have/had variables with certain values. Variable filtering expressions are comma-separated and are structured as follows: A valid parameter value has the form `key_operator_value`. `key` is the variable name, `operator` is the comparison operator to be used and `value` the variable value.  **Note:** Values are always treated as String objects on server side.  Valid operator values are: `eq` - equal to; `neq` - not equal to; `gt` - greater than; `gteq` - greater than or equal to; `lt` - lower than; `lteq` - lower than or equal to; `like`.  Key and value may not contain underscore or comma characters. 
        :param bool variable_names_ignore_case: Match all variable names provided in variables case-insensitively. If set to `true` variableName and variablename are treated as equal.
        :param bool variable_values_ignore_case: Match all variable values provided in variables case-insensitively. If set to `true` variableValue and variablevalue are treated as equal.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[HistoricProcessInstanceDto], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'sort_by',
            'sort_order',
            'first_result',
            'max_results',
            'process_instance_id',
            'process_instance_ids',
            'process_definition_id',
            'process_definition_key',
            'process_definition_key_in',
            'process_definition_name',
            'process_definition_name_like',
            'process_definition_key_not_in',
            'process_instance_business_key',
            'process_instance_business_key_like',
            'root_process_instances',
            'finished',
            'unfinished',
            'with_incidents',
            'with_root_incidents',
            'incident_type',
            'incident_status',
            'incident_message',
            'incident_message_like',
            'started_before',
            'started_after',
            'finished_before',
            'finished_after',
            'executed_activity_after',
            'executed_activity_before',
            'executed_job_after',
            'executed_job_before',
            'started_by',
            'super_process_instance_id',
            'sub_process_instance_id',
            'super_case_instance_id',
            'sub_case_instance_id',
            'case_instance_id',
            'tenant_id_in',
            'without_tenant_id',
            'executed_activity_id_in',
            'active_activity_id_in',
            'active',
            'suspended',
            'completed',
            'externally_terminated',
            'internally_terminated',
            'variables',
            'variable_names_ignore_case',
            'variable_values_ignore_case'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_historic_process_instances" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'sort_by' in local_var_params and local_var_params['sort_by'] is not None:  # noqa: E501
            query_params.append(('sortBy', local_var_params['sort_by']))  # noqa: E501
        if 'sort_order' in local_var_params and local_var_params['sort_order'] is not None:  # noqa: E501
            query_params.append(('sortOrder', local_var_params['sort_order']))  # noqa: E501
        if 'first_result' in local_var_params and local_var_params['first_result'] is not None:  # noqa: E501
            query_params.append(('firstResult', local_var_params['first_result']))  # noqa: E501
        if 'max_results' in local_var_params and local_var_params['max_results'] is not None:  # noqa: E501
            query_params.append(('maxResults', local_var_params['max_results']))  # noqa: E501
        if 'process_instance_id' in local_var_params and local_var_params['process_instance_id'] is not None:  # noqa: E501
            query_params.append(('processInstanceId', local_var_params['process_instance_id']))  # noqa: E501
        if 'process_instance_ids' in local_var_params and local_var_params['process_instance_ids'] is not None:  # noqa: E501
            query_params.append(('processInstanceIds', local_var_params['process_instance_ids']))  # noqa: E501
        if 'process_definition_id' in local_var_params and local_var_params['process_definition_id'] is not None:  # noqa: E501
            query_params.append(('processDefinitionId', local_var_params['process_definition_id']))  # noqa: E501
        if 'process_definition_key' in local_var_params and local_var_params['process_definition_key'] is not None:  # noqa: E501
            query_params.append(('processDefinitionKey', local_var_params['process_definition_key']))  # noqa: E501
        if 'process_definition_key_in' in local_var_params and local_var_params['process_definition_key_in'] is not None:  # noqa: E501
            query_params.append(('processDefinitionKeyIn', local_var_params['process_definition_key_in']))  # noqa: E501
        if 'process_definition_name' in local_var_params and local_var_params['process_definition_name'] is not None:  # noqa: E501
            query_params.append(('processDefinitionName', local_var_params['process_definition_name']))  # noqa: E501
        if 'process_definition_name_like' in local_var_params and local_var_params['process_definition_name_like'] is not None:  # noqa: E501
            query_params.append(('processDefinitionNameLike', local_var_params['process_definition_name_like']))  # noqa: E501
        if 'process_definition_key_not_in' in local_var_params and local_var_params['process_definition_key_not_in'] is not None:  # noqa: E501
            query_params.append(('processDefinitionKeyNotIn', local_var_params['process_definition_key_not_in']))  # noqa: E501
        if 'process_instance_business_key' in local_var_params and local_var_params['process_instance_business_key'] is not None:  # noqa: E501
            query_params.append(('processInstanceBusinessKey', local_var_params['process_instance_business_key']))  # noqa: E501
        if 'process_instance_business_key_like' in local_var_params and local_var_params['process_instance_business_key_like'] is not None:  # noqa: E501
            query_params.append(('processInstanceBusinessKeyLike', local_var_params['process_instance_business_key_like']))  # noqa: E501
        if 'root_process_instances' in local_var_params and local_var_params['root_process_instances'] is not None:  # noqa: E501
            query_params.append(('rootProcessInstances', local_var_params['root_process_instances']))  # noqa: E501
        if 'finished' in local_var_params and local_var_params['finished'] is not None:  # noqa: E501
            query_params.append(('finished', local_var_params['finished']))  # noqa: E501
        if 'unfinished' in local_var_params and local_var_params['unfinished'] is not None:  # noqa: E501
            query_params.append(('unfinished', local_var_params['unfinished']))  # noqa: E501
        if 'with_incidents' in local_var_params and local_var_params['with_incidents'] is not None:  # noqa: E501
            query_params.append(('withIncidents', local_var_params['with_incidents']))  # noqa: E501
        if 'with_root_incidents' in local_var_params and local_var_params['with_root_incidents'] is not None:  # noqa: E501
            query_params.append(('withRootIncidents', local_var_params['with_root_incidents']))  # noqa: E501
        if 'incident_type' in local_var_params and local_var_params['incident_type'] is not None:  # noqa: E501
            query_params.append(('incidentType', local_var_params['incident_type']))  # noqa: E501
        if 'incident_status' in local_var_params and local_var_params['incident_status'] is not None:  # noqa: E501
            query_params.append(('incidentStatus', local_var_params['incident_status']))  # noqa: E501
        if 'incident_message' in local_var_params and local_var_params['incident_message'] is not None:  # noqa: E501
            query_params.append(('incidentMessage', local_var_params['incident_message']))  # noqa: E501
        if 'incident_message_like' in local_var_params and local_var_params['incident_message_like'] is not None:  # noqa: E501
            query_params.append(('incidentMessageLike', local_var_params['incident_message_like']))  # noqa: E501
        if 'started_before' in local_var_params and local_var_params['started_before'] is not None:  # noqa: E501
            query_params.append(('startedBefore', local_var_params['started_before']))  # noqa: E501
        if 'started_after' in local_var_params and local_var_params['started_after'] is not None:  # noqa: E501
            query_params.append(('startedAfter', local_var_params['started_after']))  # noqa: E501
        if 'finished_before' in local_var_params and local_var_params['finished_before'] is not None:  # noqa: E501
            query_params.append(('finishedBefore', local_var_params['finished_before']))  # noqa: E501
        if 'finished_after' in local_var_params and local_var_params['finished_after'] is not None:  # noqa: E501
            query_params.append(('finishedAfter', local_var_params['finished_after']))  # noqa: E501
        if 'executed_activity_after' in local_var_params and local_var_params['executed_activity_after'] is not None:  # noqa: E501
            query_params.append(('executedActivityAfter', local_var_params['executed_activity_after']))  # noqa: E501
        if 'executed_activity_before' in local_var_params and local_var_params['executed_activity_before'] is not None:  # noqa: E501
            query_params.append(('executedActivityBefore', local_var_params['executed_activity_before']))  # noqa: E501
        if 'executed_job_after' in local_var_params and local_var_params['executed_job_after'] is not None:  # noqa: E501
            query_params.append(('executedJobAfter', local_var_params['executed_job_after']))  # noqa: E501
        if 'executed_job_before' in local_var_params and local_var_params['executed_job_before'] is not None:  # noqa: E501
            query_params.append(('executedJobBefore', local_var_params['executed_job_before']))  # noqa: E501
        if 'started_by' in local_var_params and local_var_params['started_by'] is not None:  # noqa: E501
            query_params.append(('startedBy', local_var_params['started_by']))  # noqa: E501
        if 'super_process_instance_id' in local_var_params and local_var_params['super_process_instance_id'] is not None:  # noqa: E501
            query_params.append(('superProcessInstanceId', local_var_params['super_process_instance_id']))  # noqa: E501
        if 'sub_process_instance_id' in local_var_params and local_var_params['sub_process_instance_id'] is not None:  # noqa: E501
            query_params.append(('subProcessInstanceId', local_var_params['sub_process_instance_id']))  # noqa: E501
        if 'super_case_instance_id' in local_var_params and local_var_params['super_case_instance_id'] is not None:  # noqa: E501
            query_params.append(('superCaseInstanceId', local_var_params['super_case_instance_id']))  # noqa: E501
        if 'sub_case_instance_id' in local_var_params and local_var_params['sub_case_instance_id'] is not None:  # noqa: E501
            query_params.append(('subCaseInstanceId', local_var_params['sub_case_instance_id']))  # noqa: E501
        if 'case_instance_id' in local_var_params and local_var_params['case_instance_id'] is not None:  # noqa: E501
            query_params.append(('caseInstanceId', local_var_params['case_instance_id']))  # noqa: E501
        if 'tenant_id_in' in local_var_params and local_var_params['tenant_id_in'] is not None:  # noqa: E501
            query_params.append(('tenantIdIn', local_var_params['tenant_id_in']))  # noqa: E501
        if 'without_tenant_id' in local_var_params and local_var_params['without_tenant_id'] is not None:  # noqa: E501
            query_params.append(('withoutTenantId', local_var_params['without_tenant_id']))  # noqa: E501
        if 'executed_activity_id_in' in local_var_params and local_var_params['executed_activity_id_in'] is not None:  # noqa: E501
            query_params.append(('executedActivityIdIn', local_var_params['executed_activity_id_in']))  # noqa: E501
        if 'active_activity_id_in' in local_var_params and local_var_params['active_activity_id_in'] is not None:  # noqa: E501
            query_params.append(('activeActivityIdIn', local_var_params['active_activity_id_in']))  # noqa: E501
        if 'active' in local_var_params and local_var_params['active'] is not None:  # noqa: E501
            query_params.append(('active', local_var_params['active']))  # noqa: E501
        if 'suspended' in local_var_params and local_var_params['suspended'] is not None:  # noqa: E501
            query_params.append(('suspended', local_var_params['suspended']))  # noqa: E501
        if 'completed' in local_var_params and local_var_params['completed'] is not None:  # noqa: E501
            query_params.append(('completed', local_var_params['completed']))  # noqa: E501
        if 'externally_terminated' in local_var_params and local_var_params['externally_terminated'] is not None:  # noqa: E501
            query_params.append(('externallyTerminated', local_var_params['externally_terminated']))  # noqa: E501
        if 'internally_terminated' in local_var_params and local_var_params['internally_terminated'] is not None:  # noqa: E501
            query_params.append(('internallyTerminated', local_var_params['internally_terminated']))  # noqa: E501
        if 'variables' in local_var_params and local_var_params['variables'] is not None:  # noqa: E501
            query_params.append(('variables', local_var_params['variables']))  # noqa: E501
        if 'variable_names_ignore_case' in local_var_params and local_var_params['variable_names_ignore_case'] is not None:  # noqa: E501
            query_params.append(('variableNamesIgnoreCase', local_var_params['variable_names_ignore_case']))  # noqa: E501
        if 'variable_values_ignore_case' in local_var_params and local_var_params['variable_values_ignore_case'] is not None:  # noqa: E501
            query_params.append(('variableValuesIgnoreCase', local_var_params['variable_values_ignore_case']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/process-instance', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[HistoricProcessInstanceDto]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_historic_process_instances_count(self, **kwargs):  # noqa: E501
        """Get List Count  # noqa: E501

        Queries for the number of historic process instances that fulfill the given parameters. Takes the same parameters as the [Get Process Instances](https://docs.camunda.org/manual/7.16/reference/rest/history/process-instance/get-process-instance-query/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_process_instances_count(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str process_instance_id: Filter by process instance id.
        :param str process_instance_ids: Filter by process instance ids. Filter by a comma-separated list of `Strings`.
        :param str process_definition_id: Filter by the process definition the instances run on.
        :param str process_definition_key: Filter by the key of the process definition the instances run on.
        :param str process_definition_key_in: Filter by a list of process definition keys. A process instance must have one of the given process definition keys. Filter by a comma-separated list of `Strings`.
        :param str process_definition_name: Filter by the name of the process definition the instances run on.
        :param str process_definition_name_like: Filter by process definition names that the parameter is a substring of.
        :param str process_definition_key_not_in: Exclude instances that belong to a set of process definitions. Filter by a comma-separated list of `Strings`.
        :param str process_instance_business_key: Filter by process instance business key.
        :param str process_instance_business_key_like: Filter by process instance business key that the parameter is a substring of.
        :param bool root_process_instances: Restrict the query to all process instances that are top level process instances.
        :param bool finished: Only include finished process instances. This flag includes all process instances that are completed or terminated. Value may only be `true`, as `false` is the default behavior.
        :param bool unfinished: Only include unfinished process instances. Value may only be `true`, as `false` is the default behavior.
        :param bool with_incidents: Only include process instances which have an incident. Value may only be `true`, as `false` is the default behavior.
        :param bool with_root_incidents: Only include process instances which have a root incident. Value may only be `true`, as `false` is the default behavior.
        :param str incident_type: Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.16/user-guide/process-engine/incidents/#incident-types) for a list of incident types.
        :param str incident_status: Only include process instances which have an incident in status either open or resolved. To get all process instances, use the query parameter withIncidents.
        :param str incident_message: Filter by the incident message. Exact match.
        :param str incident_message_like: Filter by the incident message that the parameter is a substring of.
        :param datetime started_before: Restrict to instances that were started before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime started_after: Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime finished_before: Restrict to instances that were finished before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime finished_after: Restrict to instances that were finished after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime executed_activity_after: Restrict to instances that executed an activity after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime executed_activity_before: Restrict to instances that executed an activity before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime executed_job_after: Restrict to instances that executed an job after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime executed_job_before: Restrict to instances that executed an job before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param str started_by: Only include process instances that were started by the given user.
        :param str super_process_instance_id: Restrict query to all process instances that are sub process instances of the given process instance. Takes a process instance id.
        :param str sub_process_instance_id: Restrict query to one process instance that has a sub process instance with the given id.
        :param str super_case_instance_id: Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id.
        :param str sub_case_instance_id: Restrict query to one process instance that has a sub case instance with the given id.
        :param str case_instance_id: Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id.
        :param str tenant_id_in: Filter by a list of tenant ids. A process instance must have one of the given tenant ids. Filter by a comma-separated list of `Strings`
        :param bool without_tenant_id: Only include historic process instances which belong to no tenant. Value may only be `true`, as `false` is the default behavior.
        :param str executed_activity_id_in: Restrict to instances that executed an activity with one of given ids. Filter by a comma-separated list of `Strings`
        :param str active_activity_id_in: Restrict to instances that have an active activity with one of given ids. Filter by a comma-separated list of `Strings`
        :param bool active: Restrict to instances that are active.
        :param bool suspended: Restrict to instances that are suspended.
        :param bool completed: Restrict to instances that are completed.
        :param bool externally_terminated: Restrict to instances that are externallyTerminated.
        :param bool internally_terminated: Restrict to instances that are internallyTerminated.
        :param str variables: Only include process instances that have/had variables with certain values. Variable filtering expressions are comma-separated and are structured as follows: A valid parameter value has the form `key_operator_value`. `key` is the variable name, `operator` is the comparison operator to be used and `value` the variable value.  **Note:** Values are always treated as String objects on server side.  Valid operator values are: `eq` - equal to; `neq` - not equal to; `gt` - greater than; `gteq` - greater than or equal to; `lt` - lower than; `lteq` - lower than or equal to; `like`.  Key and value may not contain underscore or comma characters. 
        :param bool variable_names_ignore_case: Match all variable names provided in variables case-insensitively. If set to `true` variableName and variablename are treated as equal.
        :param bool variable_values_ignore_case: Match all variable values provided in variables case-insensitively. If set to `true` variableValue and variablevalue are treated as equal.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CountResultDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_historic_process_instances_count_with_http_info(**kwargs)  # noqa: E501

    def get_historic_process_instances_count_with_http_info(self, **kwargs):  # noqa: E501
        """Get List Count  # noqa: E501

        Queries for the number of historic process instances that fulfill the given parameters. Takes the same parameters as the [Get Process Instances](https://docs.camunda.org/manual/7.16/reference/rest/history/process-instance/get-process-instance-query/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_process_instances_count_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str process_instance_id: Filter by process instance id.
        :param str process_instance_ids: Filter by process instance ids. Filter by a comma-separated list of `Strings`.
        :param str process_definition_id: Filter by the process definition the instances run on.
        :param str process_definition_key: Filter by the key of the process definition the instances run on.
        :param str process_definition_key_in: Filter by a list of process definition keys. A process instance must have one of the given process definition keys. Filter by a comma-separated list of `Strings`.
        :param str process_definition_name: Filter by the name of the process definition the instances run on.
        :param str process_definition_name_like: Filter by process definition names that the parameter is a substring of.
        :param str process_definition_key_not_in: Exclude instances that belong to a set of process definitions. Filter by a comma-separated list of `Strings`.
        :param str process_instance_business_key: Filter by process instance business key.
        :param str process_instance_business_key_like: Filter by process instance business key that the parameter is a substring of.
        :param bool root_process_instances: Restrict the query to all process instances that are top level process instances.
        :param bool finished: Only include finished process instances. This flag includes all process instances that are completed or terminated. Value may only be `true`, as `false` is the default behavior.
        :param bool unfinished: Only include unfinished process instances. Value may only be `true`, as `false` is the default behavior.
        :param bool with_incidents: Only include process instances which have an incident. Value may only be `true`, as `false` is the default behavior.
        :param bool with_root_incidents: Only include process instances which have a root incident. Value may only be `true`, as `false` is the default behavior.
        :param str incident_type: Filter by the incident type. See the [User Guide](https://docs.camunda.org/manual/7.16/user-guide/process-engine/incidents/#incident-types) for a list of incident types.
        :param str incident_status: Only include process instances which have an incident in status either open or resolved. To get all process instances, use the query parameter withIncidents.
        :param str incident_message: Filter by the incident message. Exact match.
        :param str incident_message_like: Filter by the incident message that the parameter is a substring of.
        :param datetime started_before: Restrict to instances that were started before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime started_after: Restrict to instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime finished_before: Restrict to instances that were finished before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime finished_after: Restrict to instances that were finished after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime executed_activity_after: Restrict to instances that executed an activity after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime executed_activity_before: Restrict to instances that executed an activity before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime executed_job_after: Restrict to instances that executed an job after the given date (inclusive). By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime executed_job_before: Restrict to instances that executed an job before the given date (inclusive). By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param str started_by: Only include process instances that were started by the given user.
        :param str super_process_instance_id: Restrict query to all process instances that are sub process instances of the given process instance. Takes a process instance id.
        :param str sub_process_instance_id: Restrict query to one process instance that has a sub process instance with the given id.
        :param str super_case_instance_id: Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id.
        :param str sub_case_instance_id: Restrict query to one process instance that has a sub case instance with the given id.
        :param str case_instance_id: Restrict query to all process instances that are sub process instances of the given case instance. Takes a case instance id.
        :param str tenant_id_in: Filter by a list of tenant ids. A process instance must have one of the given tenant ids. Filter by a comma-separated list of `Strings`
        :param bool without_tenant_id: Only include historic process instances which belong to no tenant. Value may only be `true`, as `false` is the default behavior.
        :param str executed_activity_id_in: Restrict to instances that executed an activity with one of given ids. Filter by a comma-separated list of `Strings`
        :param str active_activity_id_in: Restrict to instances that have an active activity with one of given ids. Filter by a comma-separated list of `Strings`
        :param bool active: Restrict to instances that are active.
        :param bool suspended: Restrict to instances that are suspended.
        :param bool completed: Restrict to instances that are completed.
        :param bool externally_terminated: Restrict to instances that are externallyTerminated.
        :param bool internally_terminated: Restrict to instances that are internallyTerminated.
        :param str variables: Only include process instances that have/had variables with certain values. Variable filtering expressions are comma-separated and are structured as follows: A valid parameter value has the form `key_operator_value`. `key` is the variable name, `operator` is the comparison operator to be used and `value` the variable value.  **Note:** Values are always treated as String objects on server side.  Valid operator values are: `eq` - equal to; `neq` - not equal to; `gt` - greater than; `gteq` - greater than or equal to; `lt` - lower than; `lteq` - lower than or equal to; `like`.  Key and value may not contain underscore or comma characters. 
        :param bool variable_names_ignore_case: Match all variable names provided in variables case-insensitively. If set to `true` variableName and variablename are treated as equal.
        :param bool variable_values_ignore_case: Match all variable values provided in variables case-insensitively. If set to `true` variableValue and variablevalue are treated as equal.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CountResultDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'process_instance_id',
            'process_instance_ids',
            'process_definition_id',
            'process_definition_key',
            'process_definition_key_in',
            'process_definition_name',
            'process_definition_name_like',
            'process_definition_key_not_in',
            'process_instance_business_key',
            'process_instance_business_key_like',
            'root_process_instances',
            'finished',
            'unfinished',
            'with_incidents',
            'with_root_incidents',
            'incident_type',
            'incident_status',
            'incident_message',
            'incident_message_like',
            'started_before',
            'started_after',
            'finished_before',
            'finished_after',
            'executed_activity_after',
            'executed_activity_before',
            'executed_job_after',
            'executed_job_before',
            'started_by',
            'super_process_instance_id',
            'sub_process_instance_id',
            'super_case_instance_id',
            'sub_case_instance_id',
            'case_instance_id',
            'tenant_id_in',
            'without_tenant_id',
            'executed_activity_id_in',
            'active_activity_id_in',
            'active',
            'suspended',
            'completed',
            'externally_terminated',
            'internally_terminated',
            'variables',
            'variable_names_ignore_case',
            'variable_values_ignore_case'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_historic_process_instances_count" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'process_instance_id' in local_var_params and local_var_params['process_instance_id'] is not None:  # noqa: E501
            query_params.append(('processInstanceId', local_var_params['process_instance_id']))  # noqa: E501
        if 'process_instance_ids' in local_var_params and local_var_params['process_instance_ids'] is not None:  # noqa: E501
            query_params.append(('processInstanceIds', local_var_params['process_instance_ids']))  # noqa: E501
        if 'process_definition_id' in local_var_params and local_var_params['process_definition_id'] is not None:  # noqa: E501
            query_params.append(('processDefinitionId', local_var_params['process_definition_id']))  # noqa: E501
        if 'process_definition_key' in local_var_params and local_var_params['process_definition_key'] is not None:  # noqa: E501
            query_params.append(('processDefinitionKey', local_var_params['process_definition_key']))  # noqa: E501
        if 'process_definition_key_in' in local_var_params and local_var_params['process_definition_key_in'] is not None:  # noqa: E501
            query_params.append(('processDefinitionKeyIn', local_var_params['process_definition_key_in']))  # noqa: E501
        if 'process_definition_name' in local_var_params and local_var_params['process_definition_name'] is not None:  # noqa: E501
            query_params.append(('processDefinitionName', local_var_params['process_definition_name']))  # noqa: E501
        if 'process_definition_name_like' in local_var_params and local_var_params['process_definition_name_like'] is not None:  # noqa: E501
            query_params.append(('processDefinitionNameLike', local_var_params['process_definition_name_like']))  # noqa: E501
        if 'process_definition_key_not_in' in local_var_params and local_var_params['process_definition_key_not_in'] is not None:  # noqa: E501
            query_params.append(('processDefinitionKeyNotIn', local_var_params['process_definition_key_not_in']))  # noqa: E501
        if 'process_instance_business_key' in local_var_params and local_var_params['process_instance_business_key'] is not None:  # noqa: E501
            query_params.append(('processInstanceBusinessKey', local_var_params['process_instance_business_key']))  # noqa: E501
        if 'process_instance_business_key_like' in local_var_params and local_var_params['process_instance_business_key_like'] is not None:  # noqa: E501
            query_params.append(('processInstanceBusinessKeyLike', local_var_params['process_instance_business_key_like']))  # noqa: E501
        if 'root_process_instances' in local_var_params and local_var_params['root_process_instances'] is not None:  # noqa: E501
            query_params.append(('rootProcessInstances', local_var_params['root_process_instances']))  # noqa: E501
        if 'finished' in local_var_params and local_var_params['finished'] is not None:  # noqa: E501
            query_params.append(('finished', local_var_params['finished']))  # noqa: E501
        if 'unfinished' in local_var_params and local_var_params['unfinished'] is not None:  # noqa: E501
            query_params.append(('unfinished', local_var_params['unfinished']))  # noqa: E501
        if 'with_incidents' in local_var_params and local_var_params['with_incidents'] is not None:  # noqa: E501
            query_params.append(('withIncidents', local_var_params['with_incidents']))  # noqa: E501
        if 'with_root_incidents' in local_var_params and local_var_params['with_root_incidents'] is not None:  # noqa: E501
            query_params.append(('withRootIncidents', local_var_params['with_root_incidents']))  # noqa: E501
        if 'incident_type' in local_var_params and local_var_params['incident_type'] is not None:  # noqa: E501
            query_params.append(('incidentType', local_var_params['incident_type']))  # noqa: E501
        if 'incident_status' in local_var_params and local_var_params['incident_status'] is not None:  # noqa: E501
            query_params.append(('incidentStatus', local_var_params['incident_status']))  # noqa: E501
        if 'incident_message' in local_var_params and local_var_params['incident_message'] is not None:  # noqa: E501
            query_params.append(('incidentMessage', local_var_params['incident_message']))  # noqa: E501
        if 'incident_message_like' in local_var_params and local_var_params['incident_message_like'] is not None:  # noqa: E501
            query_params.append(('incidentMessageLike', local_var_params['incident_message_like']))  # noqa: E501
        if 'started_before' in local_var_params and local_var_params['started_before'] is not None:  # noqa: E501
            query_params.append(('startedBefore', local_var_params['started_before']))  # noqa: E501
        if 'started_after' in local_var_params and local_var_params['started_after'] is not None:  # noqa: E501
            query_params.append(('startedAfter', local_var_params['started_after']))  # noqa: E501
        if 'finished_before' in local_var_params and local_var_params['finished_before'] is not None:  # noqa: E501
            query_params.append(('finishedBefore', local_var_params['finished_before']))  # noqa: E501
        if 'finished_after' in local_var_params and local_var_params['finished_after'] is not None:  # noqa: E501
            query_params.append(('finishedAfter', local_var_params['finished_after']))  # noqa: E501
        if 'executed_activity_after' in local_var_params and local_var_params['executed_activity_after'] is not None:  # noqa: E501
            query_params.append(('executedActivityAfter', local_var_params['executed_activity_after']))  # noqa: E501
        if 'executed_activity_before' in local_var_params and local_var_params['executed_activity_before'] is not None:  # noqa: E501
            query_params.append(('executedActivityBefore', local_var_params['executed_activity_before']))  # noqa: E501
        if 'executed_job_after' in local_var_params and local_var_params['executed_job_after'] is not None:  # noqa: E501
            query_params.append(('executedJobAfter', local_var_params['executed_job_after']))  # noqa: E501
        if 'executed_job_before' in local_var_params and local_var_params['executed_job_before'] is not None:  # noqa: E501
            query_params.append(('executedJobBefore', local_var_params['executed_job_before']))  # noqa: E501
        if 'started_by' in local_var_params and local_var_params['started_by'] is not None:  # noqa: E501
            query_params.append(('startedBy', local_var_params['started_by']))  # noqa: E501
        if 'super_process_instance_id' in local_var_params and local_var_params['super_process_instance_id'] is not None:  # noqa: E501
            query_params.append(('superProcessInstanceId', local_var_params['super_process_instance_id']))  # noqa: E501
        if 'sub_process_instance_id' in local_var_params and local_var_params['sub_process_instance_id'] is not None:  # noqa: E501
            query_params.append(('subProcessInstanceId', local_var_params['sub_process_instance_id']))  # noqa: E501
        if 'super_case_instance_id' in local_var_params and local_var_params['super_case_instance_id'] is not None:  # noqa: E501
            query_params.append(('superCaseInstanceId', local_var_params['super_case_instance_id']))  # noqa: E501
        if 'sub_case_instance_id' in local_var_params and local_var_params['sub_case_instance_id'] is not None:  # noqa: E501
            query_params.append(('subCaseInstanceId', local_var_params['sub_case_instance_id']))  # noqa: E501
        if 'case_instance_id' in local_var_params and local_var_params['case_instance_id'] is not None:  # noqa: E501
            query_params.append(('caseInstanceId', local_var_params['case_instance_id']))  # noqa: E501
        if 'tenant_id_in' in local_var_params and local_var_params['tenant_id_in'] is not None:  # noqa: E501
            query_params.append(('tenantIdIn', local_var_params['tenant_id_in']))  # noqa: E501
        if 'without_tenant_id' in local_var_params and local_var_params['without_tenant_id'] is not None:  # noqa: E501
            query_params.append(('withoutTenantId', local_var_params['without_tenant_id']))  # noqa: E501
        if 'executed_activity_id_in' in local_var_params and local_var_params['executed_activity_id_in'] is not None:  # noqa: E501
            query_params.append(('executedActivityIdIn', local_var_params['executed_activity_id_in']))  # noqa: E501
        if 'active_activity_id_in' in local_var_params and local_var_params['active_activity_id_in'] is not None:  # noqa: E501
            query_params.append(('activeActivityIdIn', local_var_params['active_activity_id_in']))  # noqa: E501
        if 'active' in local_var_params and local_var_params['active'] is not None:  # noqa: E501
            query_params.append(('active', local_var_params['active']))  # noqa: E501
        if 'suspended' in local_var_params and local_var_params['suspended'] is not None:  # noqa: E501
            query_params.append(('suspended', local_var_params['suspended']))  # noqa: E501
        if 'completed' in local_var_params and local_var_params['completed'] is not None:  # noqa: E501
            query_params.append(('completed', local_var_params['completed']))  # noqa: E501
        if 'externally_terminated' in local_var_params and local_var_params['externally_terminated'] is not None:  # noqa: E501
            query_params.append(('externallyTerminated', local_var_params['externally_terminated']))  # noqa: E501
        if 'internally_terminated' in local_var_params and local_var_params['internally_terminated'] is not None:  # noqa: E501
            query_params.append(('internallyTerminated', local_var_params['internally_terminated']))  # noqa: E501
        if 'variables' in local_var_params and local_var_params['variables'] is not None:  # noqa: E501
            query_params.append(('variables', local_var_params['variables']))  # noqa: E501
        if 'variable_names_ignore_case' in local_var_params and local_var_params['variable_names_ignore_case'] is not None:  # noqa: E501
            query_params.append(('variableNamesIgnoreCase', local_var_params['variable_names_ignore_case']))  # noqa: E501
        if 'variable_values_ignore_case' in local_var_params and local_var_params['variable_values_ignore_case'] is not None:  # noqa: E501
            query_params.append(('variableValuesIgnoreCase', local_var_params['variable_values_ignore_case']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/process-instance/count', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CountResultDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def query_historic_process_instances(self, **kwargs):  # noqa: E501
        """Get List (POST)  # noqa: E501

        Queries for historic process instances that fulfill the given parameters. This method is slightly more powerful than the [Get Process Instance](https://docs.camunda.org/manual/7.16/reference/rest/history/process-instance/get-process-instance-query/) because it allows filtering by multiple process variables of types `String`, `Number` or `Boolean`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_historic_process_instances(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param HistoricProcessInstanceQueryDto historic_process_instance_query_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[HistoricProcessInstanceDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.query_historic_process_instances_with_http_info(**kwargs)  # noqa: E501

    def query_historic_process_instances_with_http_info(self, **kwargs):  # noqa: E501
        """Get List (POST)  # noqa: E501

        Queries for historic process instances that fulfill the given parameters. This method is slightly more powerful than the [Get Process Instance](https://docs.camunda.org/manual/7.16/reference/rest/history/process-instance/get-process-instance-query/) because it allows filtering by multiple process variables of types `String`, `Number` or `Boolean`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_historic_process_instances_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param HistoricProcessInstanceQueryDto historic_process_instance_query_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[HistoricProcessInstanceDto], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'first_result',
            'max_results',
            'historic_process_instance_query_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_historic_process_instances" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'first_result' in local_var_params and local_var_params['first_result'] is not None:  # noqa: E501
            query_params.append(('firstResult', local_var_params['first_result']))  # noqa: E501
        if 'max_results' in local_var_params and local_var_params['max_results'] is not None:  # noqa: E501
            query_params.append(('maxResults', local_var_params['max_results']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'historic_process_instance_query_dto' in local_var_params:
            body_params = local_var_params['historic_process_instance_query_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/process-instance', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[HistoricProcessInstanceDto]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def query_historic_process_instances_count(self, **kwargs):  # noqa: E501
        """Get List Count (POST)  # noqa: E501

        Queries for the number of historic process instances that fulfill the given parameters. This method takes the same message body as the [Get Process Instances (POST)](https://docs.camunda.org/manual/7.16/reference/rest/history/process-instance/get-process-instance-query/) method and therefore it is slightly more powerful than the [Get Process Instance Count](https://docs.camunda.org/manual/7.16/reference/rest/history/process-instance/post-process-instance-query-count/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_historic_process_instances_count(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param HistoricProcessInstanceQueryDto historic_process_instance_query_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CountResultDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.query_historic_process_instances_count_with_http_info(**kwargs)  # noqa: E501

    def query_historic_process_instances_count_with_http_info(self, **kwargs):  # noqa: E501
        """Get List Count (POST)  # noqa: E501

        Queries for the number of historic process instances that fulfill the given parameters. This method takes the same message body as the [Get Process Instances (POST)](https://docs.camunda.org/manual/7.16/reference/rest/history/process-instance/get-process-instance-query/) method and therefore it is slightly more powerful than the [Get Process Instance Count](https://docs.camunda.org/manual/7.16/reference/rest/history/process-instance/post-process-instance-query-count/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_historic_process_instances_count_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param HistoricProcessInstanceQueryDto historic_process_instance_query_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CountResultDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'historic_process_instance_query_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_historic_process_instances_count" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'historic_process_instance_query_dto' in local_var_params:
            body_params = local_var_params['historic_process_instance_query_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/process-instance/count', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CountResultDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_removal_time_async(self, **kwargs):  # noqa: E501
        """Set Removal Time Async (POST)  # noqa: E501

        Sets the removal time to multiple historic process instances asynchronously (batch).  At least `historicProcessInstanceIds` or `historicProcessInstanceQuery` has to be provided. If both are provided, all instances matching query criterion and instances from the list will be updated with a removal time.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_removal_time_async(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param SetRemovalTimeToHistoricProcessInstancesDto set_removal_time_to_historic_process_instances_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BatchDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.set_removal_time_async_with_http_info(**kwargs)  # noqa: E501

    def set_removal_time_async_with_http_info(self, **kwargs):  # noqa: E501
        """Set Removal Time Async (POST)  # noqa: E501

        Sets the removal time to multiple historic process instances asynchronously (batch).  At least `historicProcessInstanceIds` or `historicProcessInstanceQuery` has to be provided. If both are provided, all instances matching query criterion and instances from the list will be updated with a removal time.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_removal_time_async_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param SetRemovalTimeToHistoricProcessInstancesDto set_removal_time_to_historic_process_instances_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BatchDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'set_removal_time_to_historic_process_instances_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_removal_time_async" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'set_removal_time_to_historic_process_instances_dto' in local_var_params:
            body_params = local_var_params['set_removal_time_to_historic_process_instances_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/process-instance/set-removal-time', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BatchDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
