# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.16.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from generic_camunda_client.api_client import ApiClient
from generic_camunda_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class HistoricProcessDefinitionApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_cleanable_historic_process_instance_report(self, **kwargs):  # noqa: E501
        """Get Cleanable Process Instance Report  # noqa: E501

        Retrieves a report about a process definition and finished process instances relevant to history cleanup (see [History cleanup](https://docs.camunda.org/manual/7.16/user-guide/process-engine/history/#history-cleanup))  so that you can tune the history time to live. These reports include the count of the finished historic process instances, cleanable process instances and basic process definition data - id, key, name and version. The size of the result set can be retrieved by using the [Get Cleanable Process Instance Report Count](https://docs.camunda.org/manual/7.16/reference/rest/history/process-definition/get-cleanable-process-instance-report-count/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cleanable_historic_process_instance_report(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str process_definition_id_in: Filter by process definition ids. Must be a comma-separated list of process definition ids.
        :param str process_definition_key_in: Filter by process definition keys. Must be a comma-separated list of process definition keys.
        :param str tenant_id_in: Filter by a comma-separated list of tenant ids. A process definition must have one of the given  tenant ids.
        :param bool without_tenant_id: Only include process definitions which belong to no tenant. Value may only be `true`, as `false` is the default behavior.
        :param bool compact: Only include process instances which have more than zero finished instances. Value may only be `true`, as `false` is the default behavior.
        :param str sort_by: Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter.
        :param str sort_order: Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter.
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[CleanableHistoricProcessInstanceReportResultDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_cleanable_historic_process_instance_report_with_http_info(**kwargs)  # noqa: E501

    def get_cleanable_historic_process_instance_report_with_http_info(self, **kwargs):  # noqa: E501
        """Get Cleanable Process Instance Report  # noqa: E501

        Retrieves a report about a process definition and finished process instances relevant to history cleanup (see [History cleanup](https://docs.camunda.org/manual/7.16/user-guide/process-engine/history/#history-cleanup))  so that you can tune the history time to live. These reports include the count of the finished historic process instances, cleanable process instances and basic process definition data - id, key, name and version. The size of the result set can be retrieved by using the [Get Cleanable Process Instance Report Count](https://docs.camunda.org/manual/7.16/reference/rest/history/process-definition/get-cleanable-process-instance-report-count/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cleanable_historic_process_instance_report_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str process_definition_id_in: Filter by process definition ids. Must be a comma-separated list of process definition ids.
        :param str process_definition_key_in: Filter by process definition keys. Must be a comma-separated list of process definition keys.
        :param str tenant_id_in: Filter by a comma-separated list of tenant ids. A process definition must have one of the given  tenant ids.
        :param bool without_tenant_id: Only include process definitions which belong to no tenant. Value may only be `true`, as `false` is the default behavior.
        :param bool compact: Only include process instances which have more than zero finished instances. Value may only be `true`, as `false` is the default behavior.
        :param str sort_by: Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter.
        :param str sort_order: Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter.
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[CleanableHistoricProcessInstanceReportResultDto], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'process_definition_id_in',
            'process_definition_key_in',
            'tenant_id_in',
            'without_tenant_id',
            'compact',
            'sort_by',
            'sort_order',
            'first_result',
            'max_results'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cleanable_historic_process_instance_report" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'process_definition_id_in' in local_var_params and local_var_params['process_definition_id_in'] is not None:  # noqa: E501
            query_params.append(('processDefinitionIdIn', local_var_params['process_definition_id_in']))  # noqa: E501
        if 'process_definition_key_in' in local_var_params and local_var_params['process_definition_key_in'] is not None:  # noqa: E501
            query_params.append(('processDefinitionKeyIn', local_var_params['process_definition_key_in']))  # noqa: E501
        if 'tenant_id_in' in local_var_params and local_var_params['tenant_id_in'] is not None:  # noqa: E501
            query_params.append(('tenantIdIn', local_var_params['tenant_id_in']))  # noqa: E501
        if 'without_tenant_id' in local_var_params and local_var_params['without_tenant_id'] is not None:  # noqa: E501
            query_params.append(('withoutTenantId', local_var_params['without_tenant_id']))  # noqa: E501
        if 'compact' in local_var_params and local_var_params['compact'] is not None:  # noqa: E501
            query_params.append(('compact', local_var_params['compact']))  # noqa: E501
        if 'sort_by' in local_var_params and local_var_params['sort_by'] is not None:  # noqa: E501
            query_params.append(('sortBy', local_var_params['sort_by']))  # noqa: E501
        if 'sort_order' in local_var_params and local_var_params['sort_order'] is not None:  # noqa: E501
            query_params.append(('sortOrder', local_var_params['sort_order']))  # noqa: E501
        if 'first_result' in local_var_params and local_var_params['first_result'] is not None:  # noqa: E501
            query_params.append(('firstResult', local_var_params['first_result']))  # noqa: E501
        if 'max_results' in local_var_params and local_var_params['max_results'] is not None:  # noqa: E501
            query_params.append(('maxResults', local_var_params['max_results']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/process-definition/cleanable-process-instance-report', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CleanableHistoricProcessInstanceReportResultDto]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cleanable_historic_process_instance_report_count(self, **kwargs):  # noqa: E501
        """Get Cleanable Process Instance Report Count  # noqa: E501

        Queries for the number of report results about a process definition and finished process instances relevant to history cleanup (see [History cleanup](https://docs.camunda.org/manual/7.16/user-guide/process-engine/history/#history-cleanup)). Takes the same parameters as the [Get Cleanable Process Instance Report](https://docs.camunda.org/manual/7.16/reference/rest/history/process-definition/get-cleanable-process-instance-report/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cleanable_historic_process_instance_report_count(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str process_definition_id_in: Filter by process definition ids. Must be a comma-separated list of process definition ids.
        :param str process_definition_key_in: Filter by process definition keys. Must be a comma-separated list of process definition keys.
        :param str tenant_id_in: Filter by a comma-separated list of tenant ids. A process definition must have one of the given  tenant ids.
        :param bool without_tenant_id: Only include process definitions which belong to no tenant. Value may only be `true`, as `false` is the default behavior.
        :param bool compact: Only include process instances which have more than zero finished instances. Value may only be `true`, as `false` is the default behavior.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CountResultDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_cleanable_historic_process_instance_report_count_with_http_info(**kwargs)  # noqa: E501

    def get_cleanable_historic_process_instance_report_count_with_http_info(self, **kwargs):  # noqa: E501
        """Get Cleanable Process Instance Report Count  # noqa: E501

        Queries for the number of report results about a process definition and finished process instances relevant to history cleanup (see [History cleanup](https://docs.camunda.org/manual/7.16/user-guide/process-engine/history/#history-cleanup)). Takes the same parameters as the [Get Cleanable Process Instance Report](https://docs.camunda.org/manual/7.16/reference/rest/history/process-definition/get-cleanable-process-instance-report/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cleanable_historic_process_instance_report_count_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str process_definition_id_in: Filter by process definition ids. Must be a comma-separated list of process definition ids.
        :param str process_definition_key_in: Filter by process definition keys. Must be a comma-separated list of process definition keys.
        :param str tenant_id_in: Filter by a comma-separated list of tenant ids. A process definition must have one of the given  tenant ids.
        :param bool without_tenant_id: Only include process definitions which belong to no tenant. Value may only be `true`, as `false` is the default behavior.
        :param bool compact: Only include process instances which have more than zero finished instances. Value may only be `true`, as `false` is the default behavior.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CountResultDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'process_definition_id_in',
            'process_definition_key_in',
            'tenant_id_in',
            'without_tenant_id',
            'compact'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cleanable_historic_process_instance_report_count" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'process_definition_id_in' in local_var_params and local_var_params['process_definition_id_in'] is not None:  # noqa: E501
            query_params.append(('processDefinitionIdIn', local_var_params['process_definition_id_in']))  # noqa: E501
        if 'process_definition_key_in' in local_var_params and local_var_params['process_definition_key_in'] is not None:  # noqa: E501
            query_params.append(('processDefinitionKeyIn', local_var_params['process_definition_key_in']))  # noqa: E501
        if 'tenant_id_in' in local_var_params and local_var_params['tenant_id_in'] is not None:  # noqa: E501
            query_params.append(('tenantIdIn', local_var_params['tenant_id_in']))  # noqa: E501
        if 'without_tenant_id' in local_var_params and local_var_params['without_tenant_id'] is not None:  # noqa: E501
            query_params.append(('withoutTenantId', local_var_params['without_tenant_id']))  # noqa: E501
        if 'compact' in local_var_params and local_var_params['compact'] is not None:  # noqa: E501
            query_params.append(('compact', local_var_params['compact']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/process-definition/cleanable-process-instance-report/count', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CountResultDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_historic_activity_statistics(self, id, **kwargs):  # noqa: E501
        """Get Historic Activity Statistics  # noqa: E501

        Retrieves historic statistics of a given process definition, grouped by activities. These statistics include the number of running activity instances and, optionally, the number of canceled activity instances, finished activity instances and activity instances which completed a scope (i.e., in BPMN 2.0 manner: a scope is completed by an activity instance when the activity instance consumed a token but did not emit a new token). **Note:** This only includes historic data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_activity_statistics(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the process definition. (required)
        :param bool canceled: Whether to include the number of canceled activity instances in the result or not. Valid values are `true` or `false`. Default: `false`.
        :param bool finished: Whether to include the number of finished activity instances in the result or not. Valid values are `true` or `false`. Default: `false`.
        :param bool complete_scope: Whether to include the number of activity instances which completed a scope in the result or not. Valid values are `true` or `false`. Default: `false`.
        :param bool incidents: Whether to include the number of incidents. Valid values are `true` or `false`. Default: `false`.
        :param datetime started_before: Restrict to process instances that were started before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/),  the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`,  e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime started_after: Restrict to process instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/),  the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`,  e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime finished_before: Restrict to process instances that were finished before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/),  the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`,  e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime finished_after: Restrict to process instances that were finished after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/),  the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`,  e.g., `2013-01-23T14:42:45.000+0200`.
        :param str process_instance_id_in: Restrict to process instances with the given IDs. The IDs must be provided as a comma- separated list.
        :param str sort_by: Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter.
        :param str sort_order: Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[HistoricActivityStatisticsDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_historic_activity_statistics_with_http_info(id, **kwargs)  # noqa: E501

    def get_historic_activity_statistics_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get Historic Activity Statistics  # noqa: E501

        Retrieves historic statistics of a given process definition, grouped by activities. These statistics include the number of running activity instances and, optionally, the number of canceled activity instances, finished activity instances and activity instances which completed a scope (i.e., in BPMN 2.0 manner: a scope is completed by an activity instance when the activity instance consumed a token but did not emit a new token). **Note:** This only includes historic data.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_activity_statistics_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the process definition. (required)
        :param bool canceled: Whether to include the number of canceled activity instances in the result or not. Valid values are `true` or `false`. Default: `false`.
        :param bool finished: Whether to include the number of finished activity instances in the result or not. Valid values are `true` or `false`. Default: `false`.
        :param bool complete_scope: Whether to include the number of activity instances which completed a scope in the result or not. Valid values are `true` or `false`. Default: `false`.
        :param bool incidents: Whether to include the number of incidents. Valid values are `true` or `false`. Default: `false`.
        :param datetime started_before: Restrict to process instances that were started before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/),  the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`,  e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime started_after: Restrict to process instances that were started after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/),  the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`,  e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime finished_before: Restrict to process instances that were finished before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/),  the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`,  e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime finished_after: Restrict to process instances that were finished after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/),  the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`,  e.g., `2013-01-23T14:42:45.000+0200`.
        :param str process_instance_id_in: Restrict to process instances with the given IDs. The IDs must be provided as a comma- separated list.
        :param str sort_by: Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter.
        :param str sort_order: Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[HistoricActivityStatisticsDto], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'canceled',
            'finished',
            'complete_scope',
            'incidents',
            'started_before',
            'started_after',
            'finished_before',
            'finished_after',
            'process_instance_id_in',
            'sort_by',
            'sort_order'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_historic_activity_statistics" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_historic_activity_statistics`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'canceled' in local_var_params and local_var_params['canceled'] is not None:  # noqa: E501
            query_params.append(('canceled', local_var_params['canceled']))  # noqa: E501
        if 'finished' in local_var_params and local_var_params['finished'] is not None:  # noqa: E501
            query_params.append(('finished', local_var_params['finished']))  # noqa: E501
        if 'complete_scope' in local_var_params and local_var_params['complete_scope'] is not None:  # noqa: E501
            query_params.append(('completeScope', local_var_params['complete_scope']))  # noqa: E501
        if 'incidents' in local_var_params and local_var_params['incidents'] is not None:  # noqa: E501
            query_params.append(('incidents', local_var_params['incidents']))  # noqa: E501
        if 'started_before' in local_var_params and local_var_params['started_before'] is not None:  # noqa: E501
            query_params.append(('startedBefore', local_var_params['started_before']))  # noqa: E501
        if 'started_after' in local_var_params and local_var_params['started_after'] is not None:  # noqa: E501
            query_params.append(('startedAfter', local_var_params['started_after']))  # noqa: E501
        if 'finished_before' in local_var_params and local_var_params['finished_before'] is not None:  # noqa: E501
            query_params.append(('finishedBefore', local_var_params['finished_before']))  # noqa: E501
        if 'finished_after' in local_var_params and local_var_params['finished_after'] is not None:  # noqa: E501
            query_params.append(('finishedAfter', local_var_params['finished_after']))  # noqa: E501
        if 'process_instance_id_in' in local_var_params and local_var_params['process_instance_id_in'] is not None:  # noqa: E501
            query_params.append(('processInstanceIdIn', local_var_params['process_instance_id_in']))  # noqa: E501
        if 'sort_by' in local_var_params and local_var_params['sort_by'] is not None:  # noqa: E501
            query_params.append(('sortBy', local_var_params['sort_by']))  # noqa: E501
        if 'sort_order' in local_var_params and local_var_params['sort_order'] is not None:  # noqa: E501
            query_params.append(('sortOrder', local_var_params['sort_order']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/process-definition/{id}/statistics', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[HistoricActivityStatisticsDto]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
