# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.16.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from generic_camunda_client.api_client import ApiClient
from generic_camunda_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class HistoricJobLogApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_historic_job_log(self, id, **kwargs):  # noqa: E501
        """Get Job Log  # noqa: E501

        Retrieves a historic job log by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_job_log(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the log entry. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: HistoricJobLogDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_historic_job_log_with_http_info(id, **kwargs)  # noqa: E501

    def get_historic_job_log_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get Job Log  # noqa: E501

        Retrieves a historic job log by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_job_log_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the log entry. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(HistoricJobLogDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_historic_job_log" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_historic_job_log`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/job-log/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HistoricJobLogDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_historic_job_logs(self, **kwargs):  # noqa: E501
        """Get Job Logs  # noqa: E501

        Queries for historic job logs that fulfill the given parameters. The size of the result set can be retrieved by using the [Get Job Log Count](https://docs.camunda.org/manual/7.16/reference/rest/history/job-log/get-job-log-query-count/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_job_logs(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str log_id: Filter by historic job log id.
        :param str job_id: Filter by job id.
        :param str job_exception_message: Filter by job exception message.
        :param str job_definition_id: Filter by job definition id.
        :param str job_definition_type: Filter by job definition type. See the [User Guide](https://docs.camunda.org/manual/7.16/user-guide/process-engine/the-job-executor/#job-creation) for more information about job definition types.
        :param str job_definition_configuration: Filter by job definition configuration.
        :param str activity_id_in: Only include historic job logs which belong to one of the passed activity ids.
        :param str failed_activity_id_in: Only include historic job logs which belong to failures of one of the passed activity ids.
        :param str execution_id_in: Only include historic job logs which belong to one of the passed execution ids.
        :param str process_instance_id: Filter by process instance id.
        :param str process_definition_id: Filter by process definition id.
        :param str process_definition_key: Filter by process definition key.
        :param str deployment_id: Filter by deployment id.
        :param str tenant_id_in: Only include historic job log entries which belong to one of the passed and comma- separated tenant ids.
        :param bool without_tenant_id: Only include historic job log entries that belong to no tenant. Value may only be `true`, as `false` is the default behavior.
        :param str hostname: Filter by hostname.
        :param int job_priority_lower_than_or_equals: Only include logs for which the associated job had a priority lower than or equal to the given value. Value must be a valid `long` value.
        :param int job_priority_higher_than_or_equals: Only include logs for which the associated job had a priority higher than or equal to the given value. Value must be a valid `long` value.
        :param bool creation_log: Only include creation logs. Value may only be `true`, as `false` is the default behavior.
        :param bool failure_log: Only include failure logs. Value may only be `true`, as `false` is the default behavior.
        :param bool success_log: Only include success logs. Value may only be `true`, as `false` is the default behavior.
        :param bool deletion_log: Only include deletion logs. Value may only be `true`, as `false` is the default behavior.
        :param str sort_by: Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter.
        :param str sort_order: Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter.
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[HistoricJobLogDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_historic_job_logs_with_http_info(**kwargs)  # noqa: E501

    def get_historic_job_logs_with_http_info(self, **kwargs):  # noqa: E501
        """Get Job Logs  # noqa: E501

        Queries for historic job logs that fulfill the given parameters. The size of the result set can be retrieved by using the [Get Job Log Count](https://docs.camunda.org/manual/7.16/reference/rest/history/job-log/get-job-log-query-count/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_job_logs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str log_id: Filter by historic job log id.
        :param str job_id: Filter by job id.
        :param str job_exception_message: Filter by job exception message.
        :param str job_definition_id: Filter by job definition id.
        :param str job_definition_type: Filter by job definition type. See the [User Guide](https://docs.camunda.org/manual/7.16/user-guide/process-engine/the-job-executor/#job-creation) for more information about job definition types.
        :param str job_definition_configuration: Filter by job definition configuration.
        :param str activity_id_in: Only include historic job logs which belong to one of the passed activity ids.
        :param str failed_activity_id_in: Only include historic job logs which belong to failures of one of the passed activity ids.
        :param str execution_id_in: Only include historic job logs which belong to one of the passed execution ids.
        :param str process_instance_id: Filter by process instance id.
        :param str process_definition_id: Filter by process definition id.
        :param str process_definition_key: Filter by process definition key.
        :param str deployment_id: Filter by deployment id.
        :param str tenant_id_in: Only include historic job log entries which belong to one of the passed and comma- separated tenant ids.
        :param bool without_tenant_id: Only include historic job log entries that belong to no tenant. Value may only be `true`, as `false` is the default behavior.
        :param str hostname: Filter by hostname.
        :param int job_priority_lower_than_or_equals: Only include logs for which the associated job had a priority lower than or equal to the given value. Value must be a valid `long` value.
        :param int job_priority_higher_than_or_equals: Only include logs for which the associated job had a priority higher than or equal to the given value. Value must be a valid `long` value.
        :param bool creation_log: Only include creation logs. Value may only be `true`, as `false` is the default behavior.
        :param bool failure_log: Only include failure logs. Value may only be `true`, as `false` is the default behavior.
        :param bool success_log: Only include success logs. Value may only be `true`, as `false` is the default behavior.
        :param bool deletion_log: Only include deletion logs. Value may only be `true`, as `false` is the default behavior.
        :param str sort_by: Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter.
        :param str sort_order: Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter.
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[HistoricJobLogDto], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'log_id',
            'job_id',
            'job_exception_message',
            'job_definition_id',
            'job_definition_type',
            'job_definition_configuration',
            'activity_id_in',
            'failed_activity_id_in',
            'execution_id_in',
            'process_instance_id',
            'process_definition_id',
            'process_definition_key',
            'deployment_id',
            'tenant_id_in',
            'without_tenant_id',
            'hostname',
            'job_priority_lower_than_or_equals',
            'job_priority_higher_than_or_equals',
            'creation_log',
            'failure_log',
            'success_log',
            'deletion_log',
            'sort_by',
            'sort_order',
            'first_result',
            'max_results'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_historic_job_logs" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'log_id' in local_var_params and local_var_params['log_id'] is not None:  # noqa: E501
            query_params.append(('logId', local_var_params['log_id']))  # noqa: E501
        if 'job_id' in local_var_params and local_var_params['job_id'] is not None:  # noqa: E501
            query_params.append(('jobId', local_var_params['job_id']))  # noqa: E501
        if 'job_exception_message' in local_var_params and local_var_params['job_exception_message'] is not None:  # noqa: E501
            query_params.append(('jobExceptionMessage', local_var_params['job_exception_message']))  # noqa: E501
        if 'job_definition_id' in local_var_params and local_var_params['job_definition_id'] is not None:  # noqa: E501
            query_params.append(('jobDefinitionId', local_var_params['job_definition_id']))  # noqa: E501
        if 'job_definition_type' in local_var_params and local_var_params['job_definition_type'] is not None:  # noqa: E501
            query_params.append(('jobDefinitionType', local_var_params['job_definition_type']))  # noqa: E501
        if 'job_definition_configuration' in local_var_params and local_var_params['job_definition_configuration'] is not None:  # noqa: E501
            query_params.append(('jobDefinitionConfiguration', local_var_params['job_definition_configuration']))  # noqa: E501
        if 'activity_id_in' in local_var_params and local_var_params['activity_id_in'] is not None:  # noqa: E501
            query_params.append(('activityIdIn', local_var_params['activity_id_in']))  # noqa: E501
        if 'failed_activity_id_in' in local_var_params and local_var_params['failed_activity_id_in'] is not None:  # noqa: E501
            query_params.append(('failedActivityIdIn', local_var_params['failed_activity_id_in']))  # noqa: E501
        if 'execution_id_in' in local_var_params and local_var_params['execution_id_in'] is not None:  # noqa: E501
            query_params.append(('executionIdIn', local_var_params['execution_id_in']))  # noqa: E501
        if 'process_instance_id' in local_var_params and local_var_params['process_instance_id'] is not None:  # noqa: E501
            query_params.append(('processInstanceId', local_var_params['process_instance_id']))  # noqa: E501
        if 'process_definition_id' in local_var_params and local_var_params['process_definition_id'] is not None:  # noqa: E501
            query_params.append(('processDefinitionId', local_var_params['process_definition_id']))  # noqa: E501
        if 'process_definition_key' in local_var_params and local_var_params['process_definition_key'] is not None:  # noqa: E501
            query_params.append(('processDefinitionKey', local_var_params['process_definition_key']))  # noqa: E501
        if 'deployment_id' in local_var_params and local_var_params['deployment_id'] is not None:  # noqa: E501
            query_params.append(('deploymentId', local_var_params['deployment_id']))  # noqa: E501
        if 'tenant_id_in' in local_var_params and local_var_params['tenant_id_in'] is not None:  # noqa: E501
            query_params.append(('tenantIdIn', local_var_params['tenant_id_in']))  # noqa: E501
        if 'without_tenant_id' in local_var_params and local_var_params['without_tenant_id'] is not None:  # noqa: E501
            query_params.append(('withoutTenantId', local_var_params['without_tenant_id']))  # noqa: E501
        if 'hostname' in local_var_params and local_var_params['hostname'] is not None:  # noqa: E501
            query_params.append(('hostname', local_var_params['hostname']))  # noqa: E501
        if 'job_priority_lower_than_or_equals' in local_var_params and local_var_params['job_priority_lower_than_or_equals'] is not None:  # noqa: E501
            query_params.append(('jobPriorityLowerThanOrEquals', local_var_params['job_priority_lower_than_or_equals']))  # noqa: E501
        if 'job_priority_higher_than_or_equals' in local_var_params and local_var_params['job_priority_higher_than_or_equals'] is not None:  # noqa: E501
            query_params.append(('jobPriorityHigherThanOrEquals', local_var_params['job_priority_higher_than_or_equals']))  # noqa: E501
        if 'creation_log' in local_var_params and local_var_params['creation_log'] is not None:  # noqa: E501
            query_params.append(('creationLog', local_var_params['creation_log']))  # noqa: E501
        if 'failure_log' in local_var_params and local_var_params['failure_log'] is not None:  # noqa: E501
            query_params.append(('failureLog', local_var_params['failure_log']))  # noqa: E501
        if 'success_log' in local_var_params and local_var_params['success_log'] is not None:  # noqa: E501
            query_params.append(('successLog', local_var_params['success_log']))  # noqa: E501
        if 'deletion_log' in local_var_params and local_var_params['deletion_log'] is not None:  # noqa: E501
            query_params.append(('deletionLog', local_var_params['deletion_log']))  # noqa: E501
        if 'sort_by' in local_var_params and local_var_params['sort_by'] is not None:  # noqa: E501
            query_params.append(('sortBy', local_var_params['sort_by']))  # noqa: E501
        if 'sort_order' in local_var_params and local_var_params['sort_order'] is not None:  # noqa: E501
            query_params.append(('sortOrder', local_var_params['sort_order']))  # noqa: E501
        if 'first_result' in local_var_params and local_var_params['first_result'] is not None:  # noqa: E501
            query_params.append(('firstResult', local_var_params['first_result']))  # noqa: E501
        if 'max_results' in local_var_params and local_var_params['max_results'] is not None:  # noqa: E501
            query_params.append(('maxResults', local_var_params['max_results']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/job-log', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[HistoricJobLogDto]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_historic_job_logs_count(self, **kwargs):  # noqa: E501
        """Get Job Log Count  # noqa: E501

        Queries for the number of historic job logs that fulfill the given parameters. Takes the same parameters as the [Get Job Logs](https://docs.camunda.org/manual/7.16/reference/rest/history/job-log/get-job-log-query/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_job_logs_count(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str log_id: Filter by historic job log id.
        :param str job_id: Filter by job id.
        :param str job_exception_message: Filter by job exception message.
        :param str job_definition_id: Filter by job definition id.
        :param str job_definition_type: Filter by job definition type. See the [User Guide](https://docs.camunda.org/manual/7.16/user-guide/process-engine/the-job-executor/#job-creation) for more information about job definition types.
        :param str job_definition_configuration: Filter by job definition configuration.
        :param str activity_id_in: Only include historic job logs which belong to one of the passed activity ids.
        :param str failed_activity_id_in: Only include historic job logs which belong to failures of one of the passed activity ids.
        :param str execution_id_in: Only include historic job logs which belong to one of the passed execution ids.
        :param str process_instance_id: Filter by process instance id.
        :param str process_definition_id: Filter by process definition id.
        :param str process_definition_key: Filter by process definition key.
        :param str deployment_id: Filter by deployment id.
        :param str tenant_id_in: Only include historic job log entries which belong to one of the passed and comma- separated tenant ids.
        :param bool without_tenant_id: Only include historic job log entries that belong to no tenant. Value may only be `true`, as `false` is the default behavior.
        :param str hostname: Filter by hostname.
        :param int job_priority_lower_than_or_equals: Only include logs for which the associated job had a priority lower than or equal to the given value. Value must be a valid `long` value.
        :param int job_priority_higher_than_or_equals: Only include logs for which the associated job had a priority higher than or equal to the given value. Value must be a valid `long` value.
        :param bool creation_log: Only include creation logs. Value may only be `true`, as `false` is the default behavior.
        :param bool failure_log: Only include failure logs. Value may only be `true`, as `false` is the default behavior.
        :param bool success_log: Only include success logs. Value may only be `true`, as `false` is the default behavior.
        :param bool deletion_log: Only include deletion logs. Value may only be `true`, as `false` is the default behavior.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CountResultDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_historic_job_logs_count_with_http_info(**kwargs)  # noqa: E501

    def get_historic_job_logs_count_with_http_info(self, **kwargs):  # noqa: E501
        """Get Job Log Count  # noqa: E501

        Queries for the number of historic job logs that fulfill the given parameters. Takes the same parameters as the [Get Job Logs](https://docs.camunda.org/manual/7.16/reference/rest/history/job-log/get-job-log-query/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_job_logs_count_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str log_id: Filter by historic job log id.
        :param str job_id: Filter by job id.
        :param str job_exception_message: Filter by job exception message.
        :param str job_definition_id: Filter by job definition id.
        :param str job_definition_type: Filter by job definition type. See the [User Guide](https://docs.camunda.org/manual/7.16/user-guide/process-engine/the-job-executor/#job-creation) for more information about job definition types.
        :param str job_definition_configuration: Filter by job definition configuration.
        :param str activity_id_in: Only include historic job logs which belong to one of the passed activity ids.
        :param str failed_activity_id_in: Only include historic job logs which belong to failures of one of the passed activity ids.
        :param str execution_id_in: Only include historic job logs which belong to one of the passed execution ids.
        :param str process_instance_id: Filter by process instance id.
        :param str process_definition_id: Filter by process definition id.
        :param str process_definition_key: Filter by process definition key.
        :param str deployment_id: Filter by deployment id.
        :param str tenant_id_in: Only include historic job log entries which belong to one of the passed and comma- separated tenant ids.
        :param bool without_tenant_id: Only include historic job log entries that belong to no tenant. Value may only be `true`, as `false` is the default behavior.
        :param str hostname: Filter by hostname.
        :param int job_priority_lower_than_or_equals: Only include logs for which the associated job had a priority lower than or equal to the given value. Value must be a valid `long` value.
        :param int job_priority_higher_than_or_equals: Only include logs for which the associated job had a priority higher than or equal to the given value. Value must be a valid `long` value.
        :param bool creation_log: Only include creation logs. Value may only be `true`, as `false` is the default behavior.
        :param bool failure_log: Only include failure logs. Value may only be `true`, as `false` is the default behavior.
        :param bool success_log: Only include success logs. Value may only be `true`, as `false` is the default behavior.
        :param bool deletion_log: Only include deletion logs. Value may only be `true`, as `false` is the default behavior.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CountResultDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'log_id',
            'job_id',
            'job_exception_message',
            'job_definition_id',
            'job_definition_type',
            'job_definition_configuration',
            'activity_id_in',
            'failed_activity_id_in',
            'execution_id_in',
            'process_instance_id',
            'process_definition_id',
            'process_definition_key',
            'deployment_id',
            'tenant_id_in',
            'without_tenant_id',
            'hostname',
            'job_priority_lower_than_or_equals',
            'job_priority_higher_than_or_equals',
            'creation_log',
            'failure_log',
            'success_log',
            'deletion_log'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_historic_job_logs_count" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'log_id' in local_var_params and local_var_params['log_id'] is not None:  # noqa: E501
            query_params.append(('logId', local_var_params['log_id']))  # noqa: E501
        if 'job_id' in local_var_params and local_var_params['job_id'] is not None:  # noqa: E501
            query_params.append(('jobId', local_var_params['job_id']))  # noqa: E501
        if 'job_exception_message' in local_var_params and local_var_params['job_exception_message'] is not None:  # noqa: E501
            query_params.append(('jobExceptionMessage', local_var_params['job_exception_message']))  # noqa: E501
        if 'job_definition_id' in local_var_params and local_var_params['job_definition_id'] is not None:  # noqa: E501
            query_params.append(('jobDefinitionId', local_var_params['job_definition_id']))  # noqa: E501
        if 'job_definition_type' in local_var_params and local_var_params['job_definition_type'] is not None:  # noqa: E501
            query_params.append(('jobDefinitionType', local_var_params['job_definition_type']))  # noqa: E501
        if 'job_definition_configuration' in local_var_params and local_var_params['job_definition_configuration'] is not None:  # noqa: E501
            query_params.append(('jobDefinitionConfiguration', local_var_params['job_definition_configuration']))  # noqa: E501
        if 'activity_id_in' in local_var_params and local_var_params['activity_id_in'] is not None:  # noqa: E501
            query_params.append(('activityIdIn', local_var_params['activity_id_in']))  # noqa: E501
        if 'failed_activity_id_in' in local_var_params and local_var_params['failed_activity_id_in'] is not None:  # noqa: E501
            query_params.append(('failedActivityIdIn', local_var_params['failed_activity_id_in']))  # noqa: E501
        if 'execution_id_in' in local_var_params and local_var_params['execution_id_in'] is not None:  # noqa: E501
            query_params.append(('executionIdIn', local_var_params['execution_id_in']))  # noqa: E501
        if 'process_instance_id' in local_var_params and local_var_params['process_instance_id'] is not None:  # noqa: E501
            query_params.append(('processInstanceId', local_var_params['process_instance_id']))  # noqa: E501
        if 'process_definition_id' in local_var_params and local_var_params['process_definition_id'] is not None:  # noqa: E501
            query_params.append(('processDefinitionId', local_var_params['process_definition_id']))  # noqa: E501
        if 'process_definition_key' in local_var_params and local_var_params['process_definition_key'] is not None:  # noqa: E501
            query_params.append(('processDefinitionKey', local_var_params['process_definition_key']))  # noqa: E501
        if 'deployment_id' in local_var_params and local_var_params['deployment_id'] is not None:  # noqa: E501
            query_params.append(('deploymentId', local_var_params['deployment_id']))  # noqa: E501
        if 'tenant_id_in' in local_var_params and local_var_params['tenant_id_in'] is not None:  # noqa: E501
            query_params.append(('tenantIdIn', local_var_params['tenant_id_in']))  # noqa: E501
        if 'without_tenant_id' in local_var_params and local_var_params['without_tenant_id'] is not None:  # noqa: E501
            query_params.append(('withoutTenantId', local_var_params['without_tenant_id']))  # noqa: E501
        if 'hostname' in local_var_params and local_var_params['hostname'] is not None:  # noqa: E501
            query_params.append(('hostname', local_var_params['hostname']))  # noqa: E501
        if 'job_priority_lower_than_or_equals' in local_var_params and local_var_params['job_priority_lower_than_or_equals'] is not None:  # noqa: E501
            query_params.append(('jobPriorityLowerThanOrEquals', local_var_params['job_priority_lower_than_or_equals']))  # noqa: E501
        if 'job_priority_higher_than_or_equals' in local_var_params and local_var_params['job_priority_higher_than_or_equals'] is not None:  # noqa: E501
            query_params.append(('jobPriorityHigherThanOrEquals', local_var_params['job_priority_higher_than_or_equals']))  # noqa: E501
        if 'creation_log' in local_var_params and local_var_params['creation_log'] is not None:  # noqa: E501
            query_params.append(('creationLog', local_var_params['creation_log']))  # noqa: E501
        if 'failure_log' in local_var_params and local_var_params['failure_log'] is not None:  # noqa: E501
            query_params.append(('failureLog', local_var_params['failure_log']))  # noqa: E501
        if 'success_log' in local_var_params and local_var_params['success_log'] is not None:  # noqa: E501
            query_params.append(('successLog', local_var_params['success_log']))  # noqa: E501
        if 'deletion_log' in local_var_params and local_var_params['deletion_log'] is not None:  # noqa: E501
            query_params.append(('deletionLog', local_var_params['deletion_log']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/job-log/count', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CountResultDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_stacktrace_historic_job_log(self, id, **kwargs):  # noqa: E501
        """Get Job Log Exception Stacktrace  # noqa: E501

        Retrieves the corresponding exception stacktrace to the passed historic job log by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_stacktrace_historic_job_log(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the historic job log to get the exception stacktrace for. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_stacktrace_historic_job_log_with_http_info(id, **kwargs)  # noqa: E501

    def get_stacktrace_historic_job_log_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get Job Log Exception Stacktrace  # noqa: E501

        Retrieves the corresponding exception stacktrace to the passed historic job log by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_stacktrace_historic_job_log_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the historic job log to get the exception stacktrace for. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(object, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_stacktrace_historic_job_log" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_stacktrace_historic_job_log`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/job-log/{id}/stacktrace', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def query_historic_job_logs(self, **kwargs):  # noqa: E501
        """Get Job Logs (POST)  # noqa: E501

        Queries for historic job logs that fulfill the given parameters. This method is slightly more powerful than the [Get Job Logs](https://docs.camunda.org/manual/7.16/reference/rest/history/job-log/get-job-log-query/) method because it allows filtering by historic job logs values of the different types `String`, `Number` or `Boolean`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_historic_job_logs(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param HistoricJobLogQueryDto historic_job_log_query_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[HistoricJobLogDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.query_historic_job_logs_with_http_info(**kwargs)  # noqa: E501

    def query_historic_job_logs_with_http_info(self, **kwargs):  # noqa: E501
        """Get Job Logs (POST)  # noqa: E501

        Queries for historic job logs that fulfill the given parameters. This method is slightly more powerful than the [Get Job Logs](https://docs.camunda.org/manual/7.16/reference/rest/history/job-log/get-job-log-query/) method because it allows filtering by historic job logs values of the different types `String`, `Number` or `Boolean`.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_historic_job_logs_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param HistoricJobLogQueryDto historic_job_log_query_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[HistoricJobLogDto], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'first_result',
            'max_results',
            'historic_job_log_query_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_historic_job_logs" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'first_result' in local_var_params and local_var_params['first_result'] is not None:  # noqa: E501
            query_params.append(('firstResult', local_var_params['first_result']))  # noqa: E501
        if 'max_results' in local_var_params and local_var_params['max_results'] is not None:  # noqa: E501
            query_params.append(('maxResults', local_var_params['max_results']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'historic_job_log_query_dto' in local_var_params:
            body_params = local_var_params['historic_job_log_query_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/job-log', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[HistoricJobLogDto]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def query_historic_job_logs_count(self, **kwargs):  # noqa: E501
        """Get Job Log Count (POST)  # noqa: E501

        Queries for the number of historic job logs that fulfill the given parameters. This method takes the same message body as the [Get Job Logs (POST)](https://docs.camunda.org/manual/7.16/reference/rest/history/job-log/post-job-log-query/) method and therefore it is slightly more powerful than the [Get Job Log Count](https://docs.camunda.org/manual/7.16/reference/rest/history/job-log/get-job-log-query-count/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_historic_job_logs_count(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param HistoricJobLogQueryDto historic_job_log_query_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CountResultDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.query_historic_job_logs_count_with_http_info(**kwargs)  # noqa: E501

    def query_historic_job_logs_count_with_http_info(self, **kwargs):  # noqa: E501
        """Get Job Log Count (POST)  # noqa: E501

        Queries for the number of historic job logs that fulfill the given parameters. This method takes the same message body as the [Get Job Logs (POST)](https://docs.camunda.org/manual/7.16/reference/rest/history/job-log/post-job-log-query/) method and therefore it is slightly more powerful than the [Get Job Log Count](https://docs.camunda.org/manual/7.16/reference/rest/history/job-log/get-job-log-query-count/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_historic_job_logs_count_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param HistoricJobLogQueryDto historic_job_log_query_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CountResultDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'historic_job_log_query_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_historic_job_logs_count" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'historic_job_log_query_dto' in local_var_params:
            body_params = local_var_params['historic_job_log_query_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/job-log/count', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CountResultDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
