# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.16.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from generic_camunda_client.api_client import ApiClient
from generic_camunda_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class HistoricIncidentApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_historic_incidents(self, **kwargs):  # noqa: E501
        """Get Incidents  # noqa: E501

        Queries for historic incidents that fulfill given parameters. The size of the result set can be retrieved by using the [Get Incident Count](https://docs.camunda.org/manual/7.16/reference/rest/history/incident/get-incident-query-count/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_incidents(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str incident_id: Restricts to incidents that have the given id.
        :param str incident_type: Restricts to incidents that belong to the given incident type. See the [User Guide](/manual/develop/user-guide/process-engine/incidents/#incident-types) for a list of incident types.
        :param str incident_message: Restricts to incidents that have the given incident message.
        :param str incident_message_like: Restricts to incidents that incidents message is a substring of the given value. The string can include the wildcard character '%' to express like-strategy: starts with (string%), ends with (%string) or contains (%string%). 
        :param str process_definition_id: Restricts to incidents that belong to a process definition with the given id.
        :param str process_definition_key: Restricts to incidents that have the given processDefinitionKey.
        :param str process_definition_key_in: Restricts to incidents that have one of the given process definition keys.
        :param str process_instance_id: Restricts to incidents that belong to a process instance with the given id.
        :param str execution_id: Restricts to incidents that belong to an execution with the given id.
        :param datetime create_time_before: Restricts to incidents that have a createTime date before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime create_time_after: Restricts to incidents that have a createTime date after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime end_time_before: Restricts to incidents that have an endTimeBefore date before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime end_time_after: Restricts to incidents that have an endTimeAfter date after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param str activity_id: Restricts to incidents that belong to an activity with the given id.
        :param str failed_activity_id: Restricts to incidents that were created due to the failure of an activity with the given id.
        :param str cause_incident_id: Restricts to incidents that have the given incident id as cause incident.
        :param str root_cause_incident_id: Restricts to incidents that have the given incident id as root cause incident.
        :param str configuration: Restricts to incidents that have the given parameter set as configuration.
        :param str history_configuration: Restricts to incidents that have the given parameter set as history configuration.
        :param bool open: Restricts to incidents that are open.
        :param bool resolved: Restricts to incidents that are resolved.
        :param bool deleted: Restricts to incidents that are deleted.
        :param str tenant_id_in: Restricts to incidents that have one of the given comma-separated tenant ids.
        :param bool without_tenant_id: Only include historic incidents that belong to no tenant. Value may only be `true`, as `false` is the default behavior.
        :param str job_definition_id_in: Restricts to incidents that have one of the given comma-separated job definition ids.
        :param str sort_by: Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter.
        :param str sort_order: Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[HistoricIncidentDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_historic_incidents_with_http_info(**kwargs)  # noqa: E501

    def get_historic_incidents_with_http_info(self, **kwargs):  # noqa: E501
        """Get Incidents  # noqa: E501

        Queries for historic incidents that fulfill given parameters. The size of the result set can be retrieved by using the [Get Incident Count](https://docs.camunda.org/manual/7.16/reference/rest/history/incident/get-incident-query-count/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_incidents_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str incident_id: Restricts to incidents that have the given id.
        :param str incident_type: Restricts to incidents that belong to the given incident type. See the [User Guide](/manual/develop/user-guide/process-engine/incidents/#incident-types) for a list of incident types.
        :param str incident_message: Restricts to incidents that have the given incident message.
        :param str incident_message_like: Restricts to incidents that incidents message is a substring of the given value. The string can include the wildcard character '%' to express like-strategy: starts with (string%), ends with (%string) or contains (%string%). 
        :param str process_definition_id: Restricts to incidents that belong to a process definition with the given id.
        :param str process_definition_key: Restricts to incidents that have the given processDefinitionKey.
        :param str process_definition_key_in: Restricts to incidents that have one of the given process definition keys.
        :param str process_instance_id: Restricts to incidents that belong to a process instance with the given id.
        :param str execution_id: Restricts to incidents that belong to an execution with the given id.
        :param datetime create_time_before: Restricts to incidents that have a createTime date before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime create_time_after: Restricts to incidents that have a createTime date after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime end_time_before: Restricts to incidents that have an endTimeBefore date before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime end_time_after: Restricts to incidents that have an endTimeAfter date after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param str activity_id: Restricts to incidents that belong to an activity with the given id.
        :param str failed_activity_id: Restricts to incidents that were created due to the failure of an activity with the given id.
        :param str cause_incident_id: Restricts to incidents that have the given incident id as cause incident.
        :param str root_cause_incident_id: Restricts to incidents that have the given incident id as root cause incident.
        :param str configuration: Restricts to incidents that have the given parameter set as configuration.
        :param str history_configuration: Restricts to incidents that have the given parameter set as history configuration.
        :param bool open: Restricts to incidents that are open.
        :param bool resolved: Restricts to incidents that are resolved.
        :param bool deleted: Restricts to incidents that are deleted.
        :param str tenant_id_in: Restricts to incidents that have one of the given comma-separated tenant ids.
        :param bool without_tenant_id: Only include historic incidents that belong to no tenant. Value may only be `true`, as `false` is the default behavior.
        :param str job_definition_id_in: Restricts to incidents that have one of the given comma-separated job definition ids.
        :param str sort_by: Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter.
        :param str sort_order: Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[HistoricIncidentDto], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'incident_id',
            'incident_type',
            'incident_message',
            'incident_message_like',
            'process_definition_id',
            'process_definition_key',
            'process_definition_key_in',
            'process_instance_id',
            'execution_id',
            'create_time_before',
            'create_time_after',
            'end_time_before',
            'end_time_after',
            'activity_id',
            'failed_activity_id',
            'cause_incident_id',
            'root_cause_incident_id',
            'configuration',
            'history_configuration',
            'open',
            'resolved',
            'deleted',
            'tenant_id_in',
            'without_tenant_id',
            'job_definition_id_in',
            'sort_by',
            'sort_order'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_historic_incidents" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'incident_id' in local_var_params and local_var_params['incident_id'] is not None:  # noqa: E501
            query_params.append(('incidentId', local_var_params['incident_id']))  # noqa: E501
        if 'incident_type' in local_var_params and local_var_params['incident_type'] is not None:  # noqa: E501
            query_params.append(('incidentType', local_var_params['incident_type']))  # noqa: E501
        if 'incident_message' in local_var_params and local_var_params['incident_message'] is not None:  # noqa: E501
            query_params.append(('incidentMessage', local_var_params['incident_message']))  # noqa: E501
        if 'incident_message_like' in local_var_params and local_var_params['incident_message_like'] is not None:  # noqa: E501
            query_params.append(('incidentMessageLike', local_var_params['incident_message_like']))  # noqa: E501
        if 'process_definition_id' in local_var_params and local_var_params['process_definition_id'] is not None:  # noqa: E501
            query_params.append(('processDefinitionId', local_var_params['process_definition_id']))  # noqa: E501
        if 'process_definition_key' in local_var_params and local_var_params['process_definition_key'] is not None:  # noqa: E501
            query_params.append(('processDefinitionKey', local_var_params['process_definition_key']))  # noqa: E501
        if 'process_definition_key_in' in local_var_params and local_var_params['process_definition_key_in'] is not None:  # noqa: E501
            query_params.append(('processDefinitionKeyIn', local_var_params['process_definition_key_in']))  # noqa: E501
        if 'process_instance_id' in local_var_params and local_var_params['process_instance_id'] is not None:  # noqa: E501
            query_params.append(('processInstanceId', local_var_params['process_instance_id']))  # noqa: E501
        if 'execution_id' in local_var_params and local_var_params['execution_id'] is not None:  # noqa: E501
            query_params.append(('executionId', local_var_params['execution_id']))  # noqa: E501
        if 'create_time_before' in local_var_params and local_var_params['create_time_before'] is not None:  # noqa: E501
            query_params.append(('createTimeBefore', local_var_params['create_time_before']))  # noqa: E501
        if 'create_time_after' in local_var_params and local_var_params['create_time_after'] is not None:  # noqa: E501
            query_params.append(('createTimeAfter', local_var_params['create_time_after']))  # noqa: E501
        if 'end_time_before' in local_var_params and local_var_params['end_time_before'] is not None:  # noqa: E501
            query_params.append(('endTimeBefore', local_var_params['end_time_before']))  # noqa: E501
        if 'end_time_after' in local_var_params and local_var_params['end_time_after'] is not None:  # noqa: E501
            query_params.append(('endTimeAfter', local_var_params['end_time_after']))  # noqa: E501
        if 'activity_id' in local_var_params and local_var_params['activity_id'] is not None:  # noqa: E501
            query_params.append(('activityId', local_var_params['activity_id']))  # noqa: E501
        if 'failed_activity_id' in local_var_params and local_var_params['failed_activity_id'] is not None:  # noqa: E501
            query_params.append(('failedActivityId', local_var_params['failed_activity_id']))  # noqa: E501
        if 'cause_incident_id' in local_var_params and local_var_params['cause_incident_id'] is not None:  # noqa: E501
            query_params.append(('causeIncidentId', local_var_params['cause_incident_id']))  # noqa: E501
        if 'root_cause_incident_id' in local_var_params and local_var_params['root_cause_incident_id'] is not None:  # noqa: E501
            query_params.append(('rootCauseIncidentId', local_var_params['root_cause_incident_id']))  # noqa: E501
        if 'configuration' in local_var_params and local_var_params['configuration'] is not None:  # noqa: E501
            query_params.append(('configuration', local_var_params['configuration']))  # noqa: E501
        if 'history_configuration' in local_var_params and local_var_params['history_configuration'] is not None:  # noqa: E501
            query_params.append(('historyConfiguration', local_var_params['history_configuration']))  # noqa: E501
        if 'open' in local_var_params and local_var_params['open'] is not None:  # noqa: E501
            query_params.append(('open', local_var_params['open']))  # noqa: E501
        if 'resolved' in local_var_params and local_var_params['resolved'] is not None:  # noqa: E501
            query_params.append(('resolved', local_var_params['resolved']))  # noqa: E501
        if 'deleted' in local_var_params and local_var_params['deleted'] is not None:  # noqa: E501
            query_params.append(('deleted', local_var_params['deleted']))  # noqa: E501
        if 'tenant_id_in' in local_var_params and local_var_params['tenant_id_in'] is not None:  # noqa: E501
            query_params.append(('tenantIdIn', local_var_params['tenant_id_in']))  # noqa: E501
        if 'without_tenant_id' in local_var_params and local_var_params['without_tenant_id'] is not None:  # noqa: E501
            query_params.append(('withoutTenantId', local_var_params['without_tenant_id']))  # noqa: E501
        if 'job_definition_id_in' in local_var_params and local_var_params['job_definition_id_in'] is not None:  # noqa: E501
            query_params.append(('jobDefinitionIdIn', local_var_params['job_definition_id_in']))  # noqa: E501
        if 'sort_by' in local_var_params and local_var_params['sort_by'] is not None:  # noqa: E501
            query_params.append(('sortBy', local_var_params['sort_by']))  # noqa: E501
        if 'sort_order' in local_var_params and local_var_params['sort_order'] is not None:  # noqa: E501
            query_params.append(('sortOrder', local_var_params['sort_order']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/incident', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[HistoricIncidentDto]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_historic_incidents_count(self, **kwargs):  # noqa: E501
        """Get Incident Count  # noqa: E501

        Queries for the number of historic incidents that fulfill the given parameters. Takes the same parameters as the [Get Incidents](https://docs.camunda.org/manual/7.16/reference/rest/history/incident/get-incident-query/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_incidents_count(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str incident_id: Restricts to incidents that have the given id.
        :param str incident_type: Restricts to incidents that belong to the given incident type. See the [User Guide](/manual/develop/user-guide/process-engine/incidents/#incident-types) for a list of incident types.
        :param str incident_message: Restricts to incidents that have the given incident message.
        :param str incident_message_like: Restricts to incidents that incidents message is a substring of the given value. The string can include the wildcard character '%' to express like-strategy: starts with (string%), ends with (%string) or contains (%string%). 
        :param str process_definition_id: Restricts to incidents that belong to a process definition with the given id.
        :param str process_definition_key: Restricts to incidents that have the given processDefinitionKey.
        :param str process_definition_key_in: Restricts to incidents that have one of the given process definition keys.
        :param str process_instance_id: Restricts to incidents that belong to a process instance with the given id.
        :param str execution_id: Restricts to incidents that belong to an execution with the given id.
        :param datetime create_time_before: Restricts to incidents that have a createTime date before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime create_time_after: Restricts to incidents that have a createTime date after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime end_time_before: Restricts to incidents that have an endTimeBefore date before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime end_time_after: Restricts to incidents that have an endTimeAfter date after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param str activity_id: Restricts to incidents that belong to an activity with the given id.
        :param str failed_activity_id: Restricts to incidents that were created due to the failure of an activity with the given id.
        :param str cause_incident_id: Restricts to incidents that have the given incident id as cause incident.
        :param str root_cause_incident_id: Restricts to incidents that have the given incident id as root cause incident.
        :param str configuration: Restricts to incidents that have the given parameter set as configuration.
        :param str history_configuration: Restricts to incidents that have the given parameter set as history configuration.
        :param bool open: Restricts to incidents that are open.
        :param bool resolved: Restricts to incidents that are resolved.
        :param bool deleted: Restricts to incidents that are deleted.
        :param str tenant_id_in: Restricts to incidents that have one of the given comma-separated tenant ids.
        :param bool without_tenant_id: Only include historic incidents that belong to no tenant. Value may only be `true`, as `false` is the default behavior.
        :param str job_definition_id_in: Restricts to incidents that have one of the given comma-separated job definition ids.
        :param str sort_by: Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter.
        :param str sort_order: Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CountResultDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_historic_incidents_count_with_http_info(**kwargs)  # noqa: E501

    def get_historic_incidents_count_with_http_info(self, **kwargs):  # noqa: E501
        """Get Incident Count  # noqa: E501

        Queries for the number of historic incidents that fulfill the given parameters. Takes the same parameters as the [Get Incidents](https://docs.camunda.org/manual/7.16/reference/rest/history/incident/get-incident-query/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_incidents_count_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str incident_id: Restricts to incidents that have the given id.
        :param str incident_type: Restricts to incidents that belong to the given incident type. See the [User Guide](/manual/develop/user-guide/process-engine/incidents/#incident-types) for a list of incident types.
        :param str incident_message: Restricts to incidents that have the given incident message.
        :param str incident_message_like: Restricts to incidents that incidents message is a substring of the given value. The string can include the wildcard character '%' to express like-strategy: starts with (string%), ends with (%string) or contains (%string%). 
        :param str process_definition_id: Restricts to incidents that belong to a process definition with the given id.
        :param str process_definition_key: Restricts to incidents that have the given processDefinitionKey.
        :param str process_definition_key_in: Restricts to incidents that have one of the given process definition keys.
        :param str process_instance_id: Restricts to incidents that belong to a process instance with the given id.
        :param str execution_id: Restricts to incidents that belong to an execution with the given id.
        :param datetime create_time_before: Restricts to incidents that have a createTime date before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime create_time_after: Restricts to incidents that have a createTime date after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime end_time_before: Restricts to incidents that have an endTimeBefore date before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime end_time_after: Restricts to incidents that have an endTimeAfter date after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param str activity_id: Restricts to incidents that belong to an activity with the given id.
        :param str failed_activity_id: Restricts to incidents that were created due to the failure of an activity with the given id.
        :param str cause_incident_id: Restricts to incidents that have the given incident id as cause incident.
        :param str root_cause_incident_id: Restricts to incidents that have the given incident id as root cause incident.
        :param str configuration: Restricts to incidents that have the given parameter set as configuration.
        :param str history_configuration: Restricts to incidents that have the given parameter set as history configuration.
        :param bool open: Restricts to incidents that are open.
        :param bool resolved: Restricts to incidents that are resolved.
        :param bool deleted: Restricts to incidents that are deleted.
        :param str tenant_id_in: Restricts to incidents that have one of the given comma-separated tenant ids.
        :param bool without_tenant_id: Only include historic incidents that belong to no tenant. Value may only be `true`, as `false` is the default behavior.
        :param str job_definition_id_in: Restricts to incidents that have one of the given comma-separated job definition ids.
        :param str sort_by: Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter.
        :param str sort_order: Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CountResultDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'incident_id',
            'incident_type',
            'incident_message',
            'incident_message_like',
            'process_definition_id',
            'process_definition_key',
            'process_definition_key_in',
            'process_instance_id',
            'execution_id',
            'create_time_before',
            'create_time_after',
            'end_time_before',
            'end_time_after',
            'activity_id',
            'failed_activity_id',
            'cause_incident_id',
            'root_cause_incident_id',
            'configuration',
            'history_configuration',
            'open',
            'resolved',
            'deleted',
            'tenant_id_in',
            'without_tenant_id',
            'job_definition_id_in',
            'sort_by',
            'sort_order'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_historic_incidents_count" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'incident_id' in local_var_params and local_var_params['incident_id'] is not None:  # noqa: E501
            query_params.append(('incidentId', local_var_params['incident_id']))  # noqa: E501
        if 'incident_type' in local_var_params and local_var_params['incident_type'] is not None:  # noqa: E501
            query_params.append(('incidentType', local_var_params['incident_type']))  # noqa: E501
        if 'incident_message' in local_var_params and local_var_params['incident_message'] is not None:  # noqa: E501
            query_params.append(('incidentMessage', local_var_params['incident_message']))  # noqa: E501
        if 'incident_message_like' in local_var_params and local_var_params['incident_message_like'] is not None:  # noqa: E501
            query_params.append(('incidentMessageLike', local_var_params['incident_message_like']))  # noqa: E501
        if 'process_definition_id' in local_var_params and local_var_params['process_definition_id'] is not None:  # noqa: E501
            query_params.append(('processDefinitionId', local_var_params['process_definition_id']))  # noqa: E501
        if 'process_definition_key' in local_var_params and local_var_params['process_definition_key'] is not None:  # noqa: E501
            query_params.append(('processDefinitionKey', local_var_params['process_definition_key']))  # noqa: E501
        if 'process_definition_key_in' in local_var_params and local_var_params['process_definition_key_in'] is not None:  # noqa: E501
            query_params.append(('processDefinitionKeyIn', local_var_params['process_definition_key_in']))  # noqa: E501
        if 'process_instance_id' in local_var_params and local_var_params['process_instance_id'] is not None:  # noqa: E501
            query_params.append(('processInstanceId', local_var_params['process_instance_id']))  # noqa: E501
        if 'execution_id' in local_var_params and local_var_params['execution_id'] is not None:  # noqa: E501
            query_params.append(('executionId', local_var_params['execution_id']))  # noqa: E501
        if 'create_time_before' in local_var_params and local_var_params['create_time_before'] is not None:  # noqa: E501
            query_params.append(('createTimeBefore', local_var_params['create_time_before']))  # noqa: E501
        if 'create_time_after' in local_var_params and local_var_params['create_time_after'] is not None:  # noqa: E501
            query_params.append(('createTimeAfter', local_var_params['create_time_after']))  # noqa: E501
        if 'end_time_before' in local_var_params and local_var_params['end_time_before'] is not None:  # noqa: E501
            query_params.append(('endTimeBefore', local_var_params['end_time_before']))  # noqa: E501
        if 'end_time_after' in local_var_params and local_var_params['end_time_after'] is not None:  # noqa: E501
            query_params.append(('endTimeAfter', local_var_params['end_time_after']))  # noqa: E501
        if 'activity_id' in local_var_params and local_var_params['activity_id'] is not None:  # noqa: E501
            query_params.append(('activityId', local_var_params['activity_id']))  # noqa: E501
        if 'failed_activity_id' in local_var_params and local_var_params['failed_activity_id'] is not None:  # noqa: E501
            query_params.append(('failedActivityId', local_var_params['failed_activity_id']))  # noqa: E501
        if 'cause_incident_id' in local_var_params and local_var_params['cause_incident_id'] is not None:  # noqa: E501
            query_params.append(('causeIncidentId', local_var_params['cause_incident_id']))  # noqa: E501
        if 'root_cause_incident_id' in local_var_params and local_var_params['root_cause_incident_id'] is not None:  # noqa: E501
            query_params.append(('rootCauseIncidentId', local_var_params['root_cause_incident_id']))  # noqa: E501
        if 'configuration' in local_var_params and local_var_params['configuration'] is not None:  # noqa: E501
            query_params.append(('configuration', local_var_params['configuration']))  # noqa: E501
        if 'history_configuration' in local_var_params and local_var_params['history_configuration'] is not None:  # noqa: E501
            query_params.append(('historyConfiguration', local_var_params['history_configuration']))  # noqa: E501
        if 'open' in local_var_params and local_var_params['open'] is not None:  # noqa: E501
            query_params.append(('open', local_var_params['open']))  # noqa: E501
        if 'resolved' in local_var_params and local_var_params['resolved'] is not None:  # noqa: E501
            query_params.append(('resolved', local_var_params['resolved']))  # noqa: E501
        if 'deleted' in local_var_params and local_var_params['deleted'] is not None:  # noqa: E501
            query_params.append(('deleted', local_var_params['deleted']))  # noqa: E501
        if 'tenant_id_in' in local_var_params and local_var_params['tenant_id_in'] is not None:  # noqa: E501
            query_params.append(('tenantIdIn', local_var_params['tenant_id_in']))  # noqa: E501
        if 'without_tenant_id' in local_var_params and local_var_params['without_tenant_id'] is not None:  # noqa: E501
            query_params.append(('withoutTenantId', local_var_params['without_tenant_id']))  # noqa: E501
        if 'job_definition_id_in' in local_var_params and local_var_params['job_definition_id_in'] is not None:  # noqa: E501
            query_params.append(('jobDefinitionIdIn', local_var_params['job_definition_id_in']))  # noqa: E501
        if 'sort_by' in local_var_params and local_var_params['sort_by'] is not None:  # noqa: E501
            query_params.append(('sortBy', local_var_params['sort_by']))  # noqa: E501
        if 'sort_order' in local_var_params and local_var_params['sort_order'] is not None:  # noqa: E501
            query_params.append(('sortOrder', local_var_params['sort_order']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/incident/count', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CountResultDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
