# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.16.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from generic_camunda_client.api_client import ApiClient
from generic_camunda_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class HistoricIdentityLinkLogApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_historic_identity_links(self, **kwargs):  # noqa: E501
        """Get Identity Link Logs  # noqa: E501

        Queries for historic identity link logs that fulfill given parameters. The size of the result set can be retrieved by using the [Get Identity-Link-Log Count](https://docs.camunda.org/manual/7.16/reference/rest/history/identity-links/get-identity-link-query-count/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_identity_links(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str type: Restricts to identity links that have the given type (candidate/assignee/owner).
        :param str user_id: Restricts to identity links that have the given user id.
        :param str group_id: Restricts to identity links that have the given group id.
        :param datetime date_before: Restricts to identity links that have the time before the given time.
        :param datetime date_after: Restricts to identity links that have the time after the given time.
        :param str task_id: Restricts to identity links that have the given task id.
        :param str process_definition_id: Restricts to identity links that have the given process definition id.
        :param str process_definition_key: Restricts to identity links that have the given process definition key.
        :param str operation_type: Restricts to identity links that have the given operationType (add/delete).
        :param str assigner_id: Restricts to identity links that have the given assigner id.
        :param str tenant_id_in: Filter by a comma-separated list of tenant ids.
        :param bool without_tenant_id: Only include historic identity links that belong to no tenant. Value may only be `true`, as `false` is the default behavior.
        :param str sort_by: Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter.
        :param str sort_order: Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter.
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[HistoricIdentityLinkLogDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_historic_identity_links_with_http_info(**kwargs)  # noqa: E501

    def get_historic_identity_links_with_http_info(self, **kwargs):  # noqa: E501
        """Get Identity Link Logs  # noqa: E501

        Queries for historic identity link logs that fulfill given parameters. The size of the result set can be retrieved by using the [Get Identity-Link-Log Count](https://docs.camunda.org/manual/7.16/reference/rest/history/identity-links/get-identity-link-query-count/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_identity_links_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str type: Restricts to identity links that have the given type (candidate/assignee/owner).
        :param str user_id: Restricts to identity links that have the given user id.
        :param str group_id: Restricts to identity links that have the given group id.
        :param datetime date_before: Restricts to identity links that have the time before the given time.
        :param datetime date_after: Restricts to identity links that have the time after the given time.
        :param str task_id: Restricts to identity links that have the given task id.
        :param str process_definition_id: Restricts to identity links that have the given process definition id.
        :param str process_definition_key: Restricts to identity links that have the given process definition key.
        :param str operation_type: Restricts to identity links that have the given operationType (add/delete).
        :param str assigner_id: Restricts to identity links that have the given assigner id.
        :param str tenant_id_in: Filter by a comma-separated list of tenant ids.
        :param bool without_tenant_id: Only include historic identity links that belong to no tenant. Value may only be `true`, as `false` is the default behavior.
        :param str sort_by: Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter.
        :param str sort_order: Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter.
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[HistoricIdentityLinkLogDto], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'type',
            'user_id',
            'group_id',
            'date_before',
            'date_after',
            'task_id',
            'process_definition_id',
            'process_definition_key',
            'operation_type',
            'assigner_id',
            'tenant_id_in',
            'without_tenant_id',
            'sort_by',
            'sort_order',
            'first_result',
            'max_results'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_historic_identity_links" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'user_id' in local_var_params and local_var_params['user_id'] is not None:  # noqa: E501
            query_params.append(('userId', local_var_params['user_id']))  # noqa: E501
        if 'group_id' in local_var_params and local_var_params['group_id'] is not None:  # noqa: E501
            query_params.append(('groupId', local_var_params['group_id']))  # noqa: E501
        if 'date_before' in local_var_params and local_var_params['date_before'] is not None:  # noqa: E501
            query_params.append(('dateBefore', local_var_params['date_before']))  # noqa: E501
        if 'date_after' in local_var_params and local_var_params['date_after'] is not None:  # noqa: E501
            query_params.append(('dateAfter', local_var_params['date_after']))  # noqa: E501
        if 'task_id' in local_var_params and local_var_params['task_id'] is not None:  # noqa: E501
            query_params.append(('taskId', local_var_params['task_id']))  # noqa: E501
        if 'process_definition_id' in local_var_params and local_var_params['process_definition_id'] is not None:  # noqa: E501
            query_params.append(('processDefinitionId', local_var_params['process_definition_id']))  # noqa: E501
        if 'process_definition_key' in local_var_params and local_var_params['process_definition_key'] is not None:  # noqa: E501
            query_params.append(('processDefinitionKey', local_var_params['process_definition_key']))  # noqa: E501
        if 'operation_type' in local_var_params and local_var_params['operation_type'] is not None:  # noqa: E501
            query_params.append(('operationType', local_var_params['operation_type']))  # noqa: E501
        if 'assigner_id' in local_var_params and local_var_params['assigner_id'] is not None:  # noqa: E501
            query_params.append(('assignerId', local_var_params['assigner_id']))  # noqa: E501
        if 'tenant_id_in' in local_var_params and local_var_params['tenant_id_in'] is not None:  # noqa: E501
            query_params.append(('tenantIdIn', local_var_params['tenant_id_in']))  # noqa: E501
        if 'without_tenant_id' in local_var_params and local_var_params['without_tenant_id'] is not None:  # noqa: E501
            query_params.append(('withoutTenantId', local_var_params['without_tenant_id']))  # noqa: E501
        if 'sort_by' in local_var_params and local_var_params['sort_by'] is not None:  # noqa: E501
            query_params.append(('sortBy', local_var_params['sort_by']))  # noqa: E501
        if 'sort_order' in local_var_params and local_var_params['sort_order'] is not None:  # noqa: E501
            query_params.append(('sortOrder', local_var_params['sort_order']))  # noqa: E501
        if 'first_result' in local_var_params and local_var_params['first_result'] is not None:  # noqa: E501
            query_params.append(('firstResult', local_var_params['first_result']))  # noqa: E501
        if 'max_results' in local_var_params and local_var_params['max_results'] is not None:  # noqa: E501
            query_params.append(('maxResults', local_var_params['max_results']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/identity-link-log', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[HistoricIdentityLinkLogDto]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_historic_identity_links_count(self, **kwargs):  # noqa: E501
        """Get Identity Link Log Count  # noqa: E501

        Queries for the number of historic identity link logs that fulfill the given parameters. Takes the same parameters as the [Get Identity-Link-Logs](https://docs.camunda.org/manual/7.16/reference/rest/history/identity-links/get-identity-link-query/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_identity_links_count(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str type: Restricts to identity links that have the given type (candidate/assignee/owner).
        :param str user_id: Restricts to identity links that have the given user id.
        :param str group_id: Restricts to identity links that have the given group id.
        :param datetime date_before: Restricts to identity links that have the time before the given time.
        :param datetime date_after: Restricts to identity links that have the time after the given time.
        :param str task_id: Restricts to identity links that have the given task id.
        :param str process_definition_id: Restricts to identity links that have the given process definition id.
        :param str process_definition_key: Restricts to identity links that have the given process definition key.
        :param str operation_type: Restricts to identity links that have the given operationType (add/delete).
        :param str assigner_id: Restricts to identity links that have the given assigner id.
        :param str tenant_id_in: Filter by a comma-separated list of tenant ids.
        :param bool without_tenant_id: Only include historic identity links that belong to no tenant. Value may only be `true`, as `false` is the default behavior.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CountResultDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_historic_identity_links_count_with_http_info(**kwargs)  # noqa: E501

    def get_historic_identity_links_count_with_http_info(self, **kwargs):  # noqa: E501
        """Get Identity Link Log Count  # noqa: E501

        Queries for the number of historic identity link logs that fulfill the given parameters. Takes the same parameters as the [Get Identity-Link-Logs](https://docs.camunda.org/manual/7.16/reference/rest/history/identity-links/get-identity-link-query/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_identity_links_count_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str type: Restricts to identity links that have the given type (candidate/assignee/owner).
        :param str user_id: Restricts to identity links that have the given user id.
        :param str group_id: Restricts to identity links that have the given group id.
        :param datetime date_before: Restricts to identity links that have the time before the given time.
        :param datetime date_after: Restricts to identity links that have the time after the given time.
        :param str task_id: Restricts to identity links that have the given task id.
        :param str process_definition_id: Restricts to identity links that have the given process definition id.
        :param str process_definition_key: Restricts to identity links that have the given process definition key.
        :param str operation_type: Restricts to identity links that have the given operationType (add/delete).
        :param str assigner_id: Restricts to identity links that have the given assigner id.
        :param str tenant_id_in: Filter by a comma-separated list of tenant ids.
        :param bool without_tenant_id: Only include historic identity links that belong to no tenant. Value may only be `true`, as `false` is the default behavior.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CountResultDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'type',
            'user_id',
            'group_id',
            'date_before',
            'date_after',
            'task_id',
            'process_definition_id',
            'process_definition_key',
            'operation_type',
            'assigner_id',
            'tenant_id_in',
            'without_tenant_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_historic_identity_links_count" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'type' in local_var_params and local_var_params['type'] is not None:  # noqa: E501
            query_params.append(('type', local_var_params['type']))  # noqa: E501
        if 'user_id' in local_var_params and local_var_params['user_id'] is not None:  # noqa: E501
            query_params.append(('userId', local_var_params['user_id']))  # noqa: E501
        if 'group_id' in local_var_params and local_var_params['group_id'] is not None:  # noqa: E501
            query_params.append(('groupId', local_var_params['group_id']))  # noqa: E501
        if 'date_before' in local_var_params and local_var_params['date_before'] is not None:  # noqa: E501
            query_params.append(('dateBefore', local_var_params['date_before']))  # noqa: E501
        if 'date_after' in local_var_params and local_var_params['date_after'] is not None:  # noqa: E501
            query_params.append(('dateAfter', local_var_params['date_after']))  # noqa: E501
        if 'task_id' in local_var_params and local_var_params['task_id'] is not None:  # noqa: E501
            query_params.append(('taskId', local_var_params['task_id']))  # noqa: E501
        if 'process_definition_id' in local_var_params and local_var_params['process_definition_id'] is not None:  # noqa: E501
            query_params.append(('processDefinitionId', local_var_params['process_definition_id']))  # noqa: E501
        if 'process_definition_key' in local_var_params and local_var_params['process_definition_key'] is not None:  # noqa: E501
            query_params.append(('processDefinitionKey', local_var_params['process_definition_key']))  # noqa: E501
        if 'operation_type' in local_var_params and local_var_params['operation_type'] is not None:  # noqa: E501
            query_params.append(('operationType', local_var_params['operation_type']))  # noqa: E501
        if 'assigner_id' in local_var_params and local_var_params['assigner_id'] is not None:  # noqa: E501
            query_params.append(('assignerId', local_var_params['assigner_id']))  # noqa: E501
        if 'tenant_id_in' in local_var_params and local_var_params['tenant_id_in'] is not None:  # noqa: E501
            query_params.append(('tenantIdIn', local_var_params['tenant_id_in']))  # noqa: E501
        if 'without_tenant_id' in local_var_params and local_var_params['without_tenant_id'] is not None:  # noqa: E501
            query_params.append(('withoutTenantId', local_var_params['without_tenant_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/identity-link-log/count', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CountResultDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
