# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.16.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from generic_camunda_client.api_client import ApiClient
from generic_camunda_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class HistoricDetailApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_historic_details(self, **kwargs):  # noqa: E501
        """Get Historic Details  # noqa: E501

        Queries for historic details that fulfill the given parameters. The size of the result set can be retrieved by using the [Get Historic Detail Count](https://docs.camunda.org/manual/7.16/reference/rest/history/detail/get-detail-query-count/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_details(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str process_instance_id: Filter by process instance id.
        :param str process_instance_id_in: Only include historic details which belong to one of the passed comma-separated process instance ids.
        :param str execution_id: Filter by execution id.
        :param str task_id: Filter by task id.
        :param str activity_instance_id: Filter by activity instance id.
        :param str case_instance_id: Filter by case instance id.
        :param str case_execution_id: Filter by case execution id.
        :param str variable_instance_id: Filter by variable instance id.
        :param str variable_type_in: Only include historic details where the variable updates belong to one of the passed comma-separated list of variable types. A list of all supported variable types can be found [here](https://docs.camunda.org/manual/7.16/user-guide/process-engine/variables/#supported-variable-values). **Note:** All non-primitive variables are associated with the type `serializable`.
        :param str tenant_id_in: Filter by a comma-separated list of tenant ids.
        :param bool without_tenant_id: Only include historic details that belong to no tenant. Value may only be `true`, as `false` is the default behavior.
        :param str user_operation_id: Filter by a user operation id.
        :param bool form_fields: Only include `HistoricFormFields`. Value may only be `true`, as `false` is the default behavior.
        :param bool variable_updates: Only include `HistoricVariableUpdates`. Value may only be `true`, as `false` is the default behavior.
        :param bool exclude_task_details: Excludes all task-related `HistoricDetails`, so only items which have no task id set will be selected. When this parameter is used together with `taskId`, this call is ignored and task details are not excluded. Value may only be `true`, as `false` is the default behavior.
        :param bool initial: Restrict to historic variable updates that contain only initial variable values. Value may only be `true`, as `false` is the default behavior.
        :param datetime occurred_before: Restrict to historic details that occured before the given date (including the date). Default [format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., 2013-01-23T14:42:45.000+0200.
        :param datetime occurred_after: Restrict to historic details that occured after the given date (including the date). Default [format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., 2013-01-23T14:42:45.000+0200.
        :param str sort_by: Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter.
        :param str sort_order: Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter.
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param bool deserialize_values: Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default `true`).  If set to `true`, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson's](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API's classpath.  If set to `false`, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While `true` is the default value for reasons of backward compatibility, we recommend setting this parameter to `false` when developing web applications that are independent of the Java process applications deployed to the engine.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[HistoricDetailDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_historic_details_with_http_info(**kwargs)  # noqa: E501

    def get_historic_details_with_http_info(self, **kwargs):  # noqa: E501
        """Get Historic Details  # noqa: E501

        Queries for historic details that fulfill the given parameters. The size of the result set can be retrieved by using the [Get Historic Detail Count](https://docs.camunda.org/manual/7.16/reference/rest/history/detail/get-detail-query-count/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_details_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str process_instance_id: Filter by process instance id.
        :param str process_instance_id_in: Only include historic details which belong to one of the passed comma-separated process instance ids.
        :param str execution_id: Filter by execution id.
        :param str task_id: Filter by task id.
        :param str activity_instance_id: Filter by activity instance id.
        :param str case_instance_id: Filter by case instance id.
        :param str case_execution_id: Filter by case execution id.
        :param str variable_instance_id: Filter by variable instance id.
        :param str variable_type_in: Only include historic details where the variable updates belong to one of the passed comma-separated list of variable types. A list of all supported variable types can be found [here](https://docs.camunda.org/manual/7.16/user-guide/process-engine/variables/#supported-variable-values). **Note:** All non-primitive variables are associated with the type `serializable`.
        :param str tenant_id_in: Filter by a comma-separated list of tenant ids.
        :param bool without_tenant_id: Only include historic details that belong to no tenant. Value may only be `true`, as `false` is the default behavior.
        :param str user_operation_id: Filter by a user operation id.
        :param bool form_fields: Only include `HistoricFormFields`. Value may only be `true`, as `false` is the default behavior.
        :param bool variable_updates: Only include `HistoricVariableUpdates`. Value may only be `true`, as `false` is the default behavior.
        :param bool exclude_task_details: Excludes all task-related `HistoricDetails`, so only items which have no task id set will be selected. When this parameter is used together with `taskId`, this call is ignored and task details are not excluded. Value may only be `true`, as `false` is the default behavior.
        :param bool initial: Restrict to historic variable updates that contain only initial variable values. Value may only be `true`, as `false` is the default behavior.
        :param datetime occurred_before: Restrict to historic details that occured before the given date (including the date). Default [format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., 2013-01-23T14:42:45.000+0200.
        :param datetime occurred_after: Restrict to historic details that occured after the given date (including the date). Default [format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., 2013-01-23T14:42:45.000+0200.
        :param str sort_by: Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter.
        :param str sort_order: Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter.
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param bool deserialize_values: Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default `true`).  If set to `true`, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson's](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API's classpath.  If set to `false`, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While `true` is the default value for reasons of backward compatibility, we recommend setting this parameter to `false` when developing web applications that are independent of the Java process applications deployed to the engine.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[HistoricDetailDto], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'process_instance_id',
            'process_instance_id_in',
            'execution_id',
            'task_id',
            'activity_instance_id',
            'case_instance_id',
            'case_execution_id',
            'variable_instance_id',
            'variable_type_in',
            'tenant_id_in',
            'without_tenant_id',
            'user_operation_id',
            'form_fields',
            'variable_updates',
            'exclude_task_details',
            'initial',
            'occurred_before',
            'occurred_after',
            'sort_by',
            'sort_order',
            'first_result',
            'max_results',
            'deserialize_values'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_historic_details" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'process_instance_id' in local_var_params and local_var_params['process_instance_id'] is not None:  # noqa: E501
            query_params.append(('processInstanceId', local_var_params['process_instance_id']))  # noqa: E501
        if 'process_instance_id_in' in local_var_params and local_var_params['process_instance_id_in'] is not None:  # noqa: E501
            query_params.append(('processInstanceIdIn', local_var_params['process_instance_id_in']))  # noqa: E501
        if 'execution_id' in local_var_params and local_var_params['execution_id'] is not None:  # noqa: E501
            query_params.append(('executionId', local_var_params['execution_id']))  # noqa: E501
        if 'task_id' in local_var_params and local_var_params['task_id'] is not None:  # noqa: E501
            query_params.append(('taskId', local_var_params['task_id']))  # noqa: E501
        if 'activity_instance_id' in local_var_params and local_var_params['activity_instance_id'] is not None:  # noqa: E501
            query_params.append(('activityInstanceId', local_var_params['activity_instance_id']))  # noqa: E501
        if 'case_instance_id' in local_var_params and local_var_params['case_instance_id'] is not None:  # noqa: E501
            query_params.append(('caseInstanceId', local_var_params['case_instance_id']))  # noqa: E501
        if 'case_execution_id' in local_var_params and local_var_params['case_execution_id'] is not None:  # noqa: E501
            query_params.append(('caseExecutionId', local_var_params['case_execution_id']))  # noqa: E501
        if 'variable_instance_id' in local_var_params and local_var_params['variable_instance_id'] is not None:  # noqa: E501
            query_params.append(('variableInstanceId', local_var_params['variable_instance_id']))  # noqa: E501
        if 'variable_type_in' in local_var_params and local_var_params['variable_type_in'] is not None:  # noqa: E501
            query_params.append(('variableTypeIn', local_var_params['variable_type_in']))  # noqa: E501
        if 'tenant_id_in' in local_var_params and local_var_params['tenant_id_in'] is not None:  # noqa: E501
            query_params.append(('tenantIdIn', local_var_params['tenant_id_in']))  # noqa: E501
        if 'without_tenant_id' in local_var_params and local_var_params['without_tenant_id'] is not None:  # noqa: E501
            query_params.append(('withoutTenantId', local_var_params['without_tenant_id']))  # noqa: E501
        if 'user_operation_id' in local_var_params and local_var_params['user_operation_id'] is not None:  # noqa: E501
            query_params.append(('userOperationId', local_var_params['user_operation_id']))  # noqa: E501
        if 'form_fields' in local_var_params and local_var_params['form_fields'] is not None:  # noqa: E501
            query_params.append(('formFields', local_var_params['form_fields']))  # noqa: E501
        if 'variable_updates' in local_var_params and local_var_params['variable_updates'] is not None:  # noqa: E501
            query_params.append(('variableUpdates', local_var_params['variable_updates']))  # noqa: E501
        if 'exclude_task_details' in local_var_params and local_var_params['exclude_task_details'] is not None:  # noqa: E501
            query_params.append(('excludeTaskDetails', local_var_params['exclude_task_details']))  # noqa: E501
        if 'initial' in local_var_params and local_var_params['initial'] is not None:  # noqa: E501
            query_params.append(('initial', local_var_params['initial']))  # noqa: E501
        if 'occurred_before' in local_var_params and local_var_params['occurred_before'] is not None:  # noqa: E501
            query_params.append(('occurredBefore', local_var_params['occurred_before']))  # noqa: E501
        if 'occurred_after' in local_var_params and local_var_params['occurred_after'] is not None:  # noqa: E501
            query_params.append(('occurredAfter', local_var_params['occurred_after']))  # noqa: E501
        if 'sort_by' in local_var_params and local_var_params['sort_by'] is not None:  # noqa: E501
            query_params.append(('sortBy', local_var_params['sort_by']))  # noqa: E501
        if 'sort_order' in local_var_params and local_var_params['sort_order'] is not None:  # noqa: E501
            query_params.append(('sortOrder', local_var_params['sort_order']))  # noqa: E501
        if 'first_result' in local_var_params and local_var_params['first_result'] is not None:  # noqa: E501
            query_params.append(('firstResult', local_var_params['first_result']))  # noqa: E501
        if 'max_results' in local_var_params and local_var_params['max_results'] is not None:  # noqa: E501
            query_params.append(('maxResults', local_var_params['max_results']))  # noqa: E501
        if 'deserialize_values' in local_var_params and local_var_params['deserialize_values'] is not None:  # noqa: E501
            query_params.append(('deserializeValues', local_var_params['deserialize_values']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/detail', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[HistoricDetailDto]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_historic_details_count(self, **kwargs):  # noqa: E501
        """Get Historic Detail Count  # noqa: E501

        Queries for the number of historic details that fulfill the given parameters. Takes the same parameters as the [Get Historic Details](https://docs.camunda.org/manual/7.16/reference/rest/history/detail/get-detail-query/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_details_count(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str process_instance_id: Filter by process instance id.
        :param str process_instance_id_in: Only include historic details which belong to one of the passed comma-separated process instance ids.
        :param str execution_id: Filter by execution id.
        :param str task_id: Filter by task id.
        :param str activity_instance_id: Filter by activity instance id.
        :param str case_instance_id: Filter by case instance id.
        :param str case_execution_id: Filter by case execution id.
        :param str variable_instance_id: Filter by variable instance id.
        :param str variable_type_in: Only include historic details where the variable updates belong to one of the passed comma-separated list of variable types. A list of all supported variable types can be found [here](https://docs.camunda.org/manual/7.16/user-guide/process-engine/variables/#supported-variable-values). **Note:** All non-primitive variables are associated with the type `serializable`.
        :param str tenant_id_in: Filter by a comma-separated list of tenant ids.
        :param bool without_tenant_id: Only include historic details that belong to no tenant. Value may only be `true`, as `false` is the default behavior.
        :param str user_operation_id: Filter by a user operation id.
        :param bool form_fields: Only include `HistoricFormFields`. Value may only be `true`, as `false` is the default behavior.
        :param bool variable_updates: Only include `HistoricVariableUpdates`. Value may only be `true`, as `false` is the default behavior.
        :param bool exclude_task_details: Excludes all task-related `HistoricDetails`, so only items which have no task id set will be selected. When this parameter is used together with `taskId`, this call is ignored and task details are not excluded. Value may only be `true`, as `false` is the default behavior.
        :param bool initial: Restrict to historic variable updates that contain only initial variable values. Value may only be `true`, as `false` is the default behavior.
        :param datetime occurred_before: Restrict to historic details that occured before the given date (including the date). Default [format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., 2013-01-23T14:42:45.000+0200.
        :param datetime occurred_after: Restrict to historic details that occured after the given date (including the date). Default [format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., 2013-01-23T14:42:45.000+0200.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CountResultDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_historic_details_count_with_http_info(**kwargs)  # noqa: E501

    def get_historic_details_count_with_http_info(self, **kwargs):  # noqa: E501
        """Get Historic Detail Count  # noqa: E501

        Queries for the number of historic details that fulfill the given parameters. Takes the same parameters as the [Get Historic Details](https://docs.camunda.org/manual/7.16/reference/rest/history/detail/get-detail-query/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_details_count_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str process_instance_id: Filter by process instance id.
        :param str process_instance_id_in: Only include historic details which belong to one of the passed comma-separated process instance ids.
        :param str execution_id: Filter by execution id.
        :param str task_id: Filter by task id.
        :param str activity_instance_id: Filter by activity instance id.
        :param str case_instance_id: Filter by case instance id.
        :param str case_execution_id: Filter by case execution id.
        :param str variable_instance_id: Filter by variable instance id.
        :param str variable_type_in: Only include historic details where the variable updates belong to one of the passed comma-separated list of variable types. A list of all supported variable types can be found [here](https://docs.camunda.org/manual/7.16/user-guide/process-engine/variables/#supported-variable-values). **Note:** All non-primitive variables are associated with the type `serializable`.
        :param str tenant_id_in: Filter by a comma-separated list of tenant ids.
        :param bool without_tenant_id: Only include historic details that belong to no tenant. Value may only be `true`, as `false` is the default behavior.
        :param str user_operation_id: Filter by a user operation id.
        :param bool form_fields: Only include `HistoricFormFields`. Value may only be `true`, as `false` is the default behavior.
        :param bool variable_updates: Only include `HistoricVariableUpdates`. Value may only be `true`, as `false` is the default behavior.
        :param bool exclude_task_details: Excludes all task-related `HistoricDetails`, so only items which have no task id set will be selected. When this parameter is used together with `taskId`, this call is ignored and task details are not excluded. Value may only be `true`, as `false` is the default behavior.
        :param bool initial: Restrict to historic variable updates that contain only initial variable values. Value may only be `true`, as `false` is the default behavior.
        :param datetime occurred_before: Restrict to historic details that occured before the given date (including the date). Default [format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., 2013-01-23T14:42:45.000+0200.
        :param datetime occurred_after: Restrict to historic details that occured after the given date (including the date). Default [format](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/) `yyyy-MM-dd'T'HH:mm:ss.SSSZ`, e.g., 2013-01-23T14:42:45.000+0200.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CountResultDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'process_instance_id',
            'process_instance_id_in',
            'execution_id',
            'task_id',
            'activity_instance_id',
            'case_instance_id',
            'case_execution_id',
            'variable_instance_id',
            'variable_type_in',
            'tenant_id_in',
            'without_tenant_id',
            'user_operation_id',
            'form_fields',
            'variable_updates',
            'exclude_task_details',
            'initial',
            'occurred_before',
            'occurred_after'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_historic_details_count" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'process_instance_id' in local_var_params and local_var_params['process_instance_id'] is not None:  # noqa: E501
            query_params.append(('processInstanceId', local_var_params['process_instance_id']))  # noqa: E501
        if 'process_instance_id_in' in local_var_params and local_var_params['process_instance_id_in'] is not None:  # noqa: E501
            query_params.append(('processInstanceIdIn', local_var_params['process_instance_id_in']))  # noqa: E501
        if 'execution_id' in local_var_params and local_var_params['execution_id'] is not None:  # noqa: E501
            query_params.append(('executionId', local_var_params['execution_id']))  # noqa: E501
        if 'task_id' in local_var_params and local_var_params['task_id'] is not None:  # noqa: E501
            query_params.append(('taskId', local_var_params['task_id']))  # noqa: E501
        if 'activity_instance_id' in local_var_params and local_var_params['activity_instance_id'] is not None:  # noqa: E501
            query_params.append(('activityInstanceId', local_var_params['activity_instance_id']))  # noqa: E501
        if 'case_instance_id' in local_var_params and local_var_params['case_instance_id'] is not None:  # noqa: E501
            query_params.append(('caseInstanceId', local_var_params['case_instance_id']))  # noqa: E501
        if 'case_execution_id' in local_var_params and local_var_params['case_execution_id'] is not None:  # noqa: E501
            query_params.append(('caseExecutionId', local_var_params['case_execution_id']))  # noqa: E501
        if 'variable_instance_id' in local_var_params and local_var_params['variable_instance_id'] is not None:  # noqa: E501
            query_params.append(('variableInstanceId', local_var_params['variable_instance_id']))  # noqa: E501
        if 'variable_type_in' in local_var_params and local_var_params['variable_type_in'] is not None:  # noqa: E501
            query_params.append(('variableTypeIn', local_var_params['variable_type_in']))  # noqa: E501
        if 'tenant_id_in' in local_var_params and local_var_params['tenant_id_in'] is not None:  # noqa: E501
            query_params.append(('tenantIdIn', local_var_params['tenant_id_in']))  # noqa: E501
        if 'without_tenant_id' in local_var_params and local_var_params['without_tenant_id'] is not None:  # noqa: E501
            query_params.append(('withoutTenantId', local_var_params['without_tenant_id']))  # noqa: E501
        if 'user_operation_id' in local_var_params and local_var_params['user_operation_id'] is not None:  # noqa: E501
            query_params.append(('userOperationId', local_var_params['user_operation_id']))  # noqa: E501
        if 'form_fields' in local_var_params and local_var_params['form_fields'] is not None:  # noqa: E501
            query_params.append(('formFields', local_var_params['form_fields']))  # noqa: E501
        if 'variable_updates' in local_var_params and local_var_params['variable_updates'] is not None:  # noqa: E501
            query_params.append(('variableUpdates', local_var_params['variable_updates']))  # noqa: E501
        if 'exclude_task_details' in local_var_params and local_var_params['exclude_task_details'] is not None:  # noqa: E501
            query_params.append(('excludeTaskDetails', local_var_params['exclude_task_details']))  # noqa: E501
        if 'initial' in local_var_params and local_var_params['initial'] is not None:  # noqa: E501
            query_params.append(('initial', local_var_params['initial']))  # noqa: E501
        if 'occurred_before' in local_var_params and local_var_params['occurred_before'] is not None:  # noqa: E501
            query_params.append(('occurredBefore', local_var_params['occurred_before']))  # noqa: E501
        if 'occurred_after' in local_var_params and local_var_params['occurred_after'] is not None:  # noqa: E501
            query_params.append(('occurredAfter', local_var_params['occurred_after']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/detail/count', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CountResultDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def historic_detail(self, id, **kwargs):  # noqa: E501
        """Get Historic Detail  # noqa: E501

        Retrieves a historic detail by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.historic_detail(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the detail. (required)
        :param bool deserialize_value: Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default `true`).  If set to `true`, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson's](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API's classpath.  If set to `false`, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While `true` is the default value for reasons of backward compatibility, we recommend setting this parameter to `false` when developing web applications that are independent of the Java process applications deployed to the engine.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: HistoricDetailDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.historic_detail_with_http_info(id, **kwargs)  # noqa: E501

    def historic_detail_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get Historic Detail  # noqa: E501

        Retrieves a historic detail by id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.historic_detail_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the detail. (required)
        :param bool deserialize_value: Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default `true`).  If set to `true`, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson's](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API's classpath.  If set to `false`, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While `true` is the default value for reasons of backward compatibility, we recommend setting this parameter to `false` when developing web applications that are independent of the Java process applications deployed to the engine.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(HistoricDetailDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'deserialize_value'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method historic_detail" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `historic_detail`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'deserialize_value' in local_var_params and local_var_params['deserialize_value'] is not None:  # noqa: E501
            query_params.append(('deserializeValue', local_var_params['deserialize_value']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/detail/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HistoricDetailDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def historic_detail_binary(self, id, **kwargs):  # noqa: E501
        """Get Historic Detail (Binary)  # noqa: E501

        Retrieves the content of a historic variable update by id. Applicable for byte array and file variables.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.historic_detail_binary(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the historic variable update. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.historic_detail_binary_with_http_info(id, **kwargs)  # noqa: E501

    def historic_detail_binary_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get Historic Detail (Binary)  # noqa: E501

        Retrieves the content of a historic variable update by id. Applicable for byte array and file variables.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.historic_detail_binary_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the historic variable update. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method historic_detail_binary" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `historic_detail_binary`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/octet-stream', '*/*', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/detail/{id}/data', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def query_historic_details(self, **kwargs):  # noqa: E501
        """Get Historic Details (POST)  # noqa: E501

        Queries for historic details that fulfill the given parameters. This method is slightly more powerful than the [Get Historic Details](https://docs.camunda.org/manual/7.16/reference/rest/history/detail/get-detail-query/) method because it allows sorting by multiple parameters. The size of the result set can be retrieved by using the [Get Historic Detail Count](https://docs.camunda.org/manual/7.16/reference/rest/history/detail/get-detail-query-count/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_historic_details(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param bool deserialize_values: Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default `true`).  If set to `true`, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson's](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API's classpath.  If set to `false`, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While `true` is the default value for reasons of backward compatibility, we recommend setting this parameter to `false` when developing web applications that are independent of the Java process applications deployed to the engine.
        :param HistoricDetailQueryDto historic_detail_query_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[HistoricDetailDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.query_historic_details_with_http_info(**kwargs)  # noqa: E501

    def query_historic_details_with_http_info(self, **kwargs):  # noqa: E501
        """Get Historic Details (POST)  # noqa: E501

        Queries for historic details that fulfill the given parameters. This method is slightly more powerful than the [Get Historic Details](https://docs.camunda.org/manual/7.16/reference/rest/history/detail/get-detail-query/) method because it allows sorting by multiple parameters. The size of the result set can be retrieved by using the [Get Historic Detail Count](https://docs.camunda.org/manual/7.16/reference/rest/history/detail/get-detail-query-count/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.query_historic_details_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param bool deserialize_values: Determines whether serializable variable values (typically variables that store custom Java objects) should be deserialized on server side (default `true`).  If set to `true`, a serializable variable will be deserialized on server side and transformed to JSON using [Jackson's](https://github.com/FasterXML/jackson) POJO/bean property introspection feature. Note that this requires the Java classes of the variable value to be on the REST API's classpath.  If set to `false`, a serializable variable will be returned in its serialized format. For example, a variable that is serialized as XML will be returned as a JSON string containing XML.  **Note:** While `true` is the default value for reasons of backward compatibility, we recommend setting this parameter to `false` when developing web applications that are independent of the Java process applications deployed to the engine.
        :param HistoricDetailQueryDto historic_detail_query_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[HistoricDetailDto], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'first_result',
            'max_results',
            'deserialize_values',
            'historic_detail_query_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method query_historic_details" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'first_result' in local_var_params and local_var_params['first_result'] is not None:  # noqa: E501
            query_params.append(('firstResult', local_var_params['first_result']))  # noqa: E501
        if 'max_results' in local_var_params and local_var_params['max_results'] is not None:  # noqa: E501
            query_params.append(('maxResults', local_var_params['max_results']))  # noqa: E501
        if 'deserialize_values' in local_var_params and local_var_params['deserialize_values'] is not None:  # noqa: E501
            query_params.append(('deserializeValues', local_var_params['deserialize_values']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'historic_detail_query_dto' in local_var_params:
            body_params = local_var_params['historic_detail_query_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/detail', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[HistoricDetailDto]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
