# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.16.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from generic_camunda_client.api_client import ApiClient
from generic_camunda_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class HistoricDecisionInstanceApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_async(self, **kwargs):  # noqa: E501
        """Delete Async (POST)  # noqa: E501

        Delete multiple historic decision instances asynchronously (batch). At least `historicDecisionInstanceIds` or `historicDecisionInstanceQuery`  has to be provided. If both are provided then all instances matching query  criterion and instances from the list will be deleted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_async(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param DeleteHistoricDecisionInstancesDto delete_historic_decision_instances_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BatchDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.delete_async_with_http_info(**kwargs)  # noqa: E501

    def delete_async_with_http_info(self, **kwargs):  # noqa: E501
        """Delete Async (POST)  # noqa: E501

        Delete multiple historic decision instances asynchronously (batch). At least `historicDecisionInstanceIds` or `historicDecisionInstanceQuery`  has to be provided. If both are provided then all instances matching query  criterion and instances from the list will be deleted.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_async_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param DeleteHistoricDecisionInstancesDto delete_historic_decision_instances_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BatchDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'delete_historic_decision_instances_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_async" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'delete_historic_decision_instances_dto' in local_var_params:
            body_params = local_var_params['delete_historic_decision_instances_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/decision-instance/delete', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BatchDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_historic_decision_instance(self, id, **kwargs):  # noqa: E501
        """Get Historic Decision Instance  # noqa: E501

        Retrieves a historic decision instance by id, according to the  `HistoricDecisionInstance` interface in the engine.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_decision_instance(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the historic decision instance to be retrieved. (required)
        :param bool include_inputs: Include input values in the result. Value may only be `true`, as `false` is the default behavior.
        :param bool include_outputs: Include output values in the result. Value may only be `true`, as `false` is the default behavior.
        :param bool disable_binary_fetching: Disables fetching of byte array input and output values. Value may only be `true`, as `false` is the default behavior.
        :param bool disable_custom_object_deserialization: Disables deserialization of input and output values that are custom objects. Value may only be `true`, as `false` is the default behavior.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: HistoricDecisionInstanceDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_historic_decision_instance_with_http_info(id, **kwargs)  # noqa: E501

    def get_historic_decision_instance_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get Historic Decision Instance  # noqa: E501

        Retrieves a historic decision instance by id, according to the  `HistoricDecisionInstance` interface in the engine.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_decision_instance_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the historic decision instance to be retrieved. (required)
        :param bool include_inputs: Include input values in the result. Value may only be `true`, as `false` is the default behavior.
        :param bool include_outputs: Include output values in the result. Value may only be `true`, as `false` is the default behavior.
        :param bool disable_binary_fetching: Disables fetching of byte array input and output values. Value may only be `true`, as `false` is the default behavior.
        :param bool disable_custom_object_deserialization: Disables deserialization of input and output values that are custom objects. Value may only be `true`, as `false` is the default behavior.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(HistoricDecisionInstanceDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id',
            'include_inputs',
            'include_outputs',
            'disable_binary_fetching',
            'disable_custom_object_deserialization'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_historic_decision_instance" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_historic_decision_instance`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []
        if 'include_inputs' in local_var_params and local_var_params['include_inputs'] is not None:  # noqa: E501
            query_params.append(('includeInputs', local_var_params['include_inputs']))  # noqa: E501
        if 'include_outputs' in local_var_params and local_var_params['include_outputs'] is not None:  # noqa: E501
            query_params.append(('includeOutputs', local_var_params['include_outputs']))  # noqa: E501
        if 'disable_binary_fetching' in local_var_params and local_var_params['disable_binary_fetching'] is not None:  # noqa: E501
            query_params.append(('disableBinaryFetching', local_var_params['disable_binary_fetching']))  # noqa: E501
        if 'disable_custom_object_deserialization' in local_var_params and local_var_params['disable_custom_object_deserialization'] is not None:  # noqa: E501
            query_params.append(('disableCustomObjectDeserialization', local_var_params['disable_custom_object_deserialization']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/decision-instance/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='HistoricDecisionInstanceDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_historic_decision_instances(self, **kwargs):  # noqa: E501
        """Get Historic Decision Instances  # noqa: E501

        Queries for historic decision instances that fulfill the given parameters.  The size of the result set can be retrieved by using the  [Get Historic Decision Instance Count](https://docs.camunda.org/manual/7.16/reference/rest/history/decision-instance/get-decision-instance-query-count/)  method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_decision_instances(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str decision_instance_id: Filter by decision instance id.
        :param str decision_instance_id_in: Filter by decision instance ids. Must be a comma-separated list of decision instance ids.
        :param str decision_definition_id: Filter by the decision definition the instances belongs to.
        :param str decision_definition_id_in: Filter by the decision definitions the instances belongs to. Must be a comma-separated list of decision definition ids.
        :param str decision_definition_key: Filter by the key of the decision definition the instances belongs to.
        :param str decision_definition_key_in: Filter by the keys of the decision definition the instances belongs to. Must be a comma- separated list of decision definition keys.
        :param str decision_definition_name: Filter by the name of the decision definition the instances belongs to.
        :param str decision_definition_name_like: Filter by the name of the decision definition the instances belongs to, that the parameter is a substring of.
        :param str process_definition_id: Filter by the process definition the instances belongs to.
        :param str process_definition_key: Filter by the key of the process definition the instances belongs to.
        :param str process_instance_id: Filter by the process instance the instances belongs to.
        :param str case_definition_id: Filter by the case definition the instances belongs to.
        :param str case_definition_key: Filter by the key of the case definition the instances belongs to.
        :param str case_instance_id: Filter by the case instance the instances belongs to.
        :param str activity_id_in: Filter by the activity ids the instances belongs to. Must be a comma-separated list of acitvity ids.
        :param str activity_instance_id_in: Filter by the activity instance ids the instances belongs to. Must be a comma-separated list of acitvity instance ids.
        :param str tenant_id_in: Filter by a comma-separated list of tenant ids. A historic decision instance must have one of the given tenant ids.
        :param bool without_tenant_id: Only include historic decision instances that belong to no tenant. Value may only be `true`, as `false` is the default behavior.
        :param datetime evaluated_before: Restrict to instances that were evaluated before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM- dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime evaluated_after: Restrict to instances that were evaluated after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM- dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param str user_id: Restrict to instances that were evaluated by the given user.
        :param str root_decision_instance_id: Restrict to instances that have a given root decision instance id. This also includes the decision instance with the given id.
        :param bool root_decision_instances_only: Restrict to instances those are the root decision instance of an evaluation. Value may only be `true`, as `false` is the default behavior.
        :param str decision_requirements_definition_id: Filter by the decision requirements definition the instances belongs to.
        :param str decision_requirements_definition_key: Filter by the key of the decision requirements definition the instances belongs to.
        :param bool include_inputs: Include input values in the result. Value may only be `true`, as `false` is the default behavior.
        :param bool include_outputs: Include output values in the result. Value may only be `true`, as `false` is the default behavior.
        :param bool disable_binary_fetching: Disables fetching of byte array input and output values. Value may only be `true`, as `false` is the default behavior.
        :param bool disable_custom_object_deserialization: Disables deserialization of input and output values that are custom objects. Value may only be `true`, as `false` is the default behavior.
        :param str sort_by: Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter.
        :param str sort_order: Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter.
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[HistoricDecisionInstanceDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_historic_decision_instances_with_http_info(**kwargs)  # noqa: E501

    def get_historic_decision_instances_with_http_info(self, **kwargs):  # noqa: E501
        """Get Historic Decision Instances  # noqa: E501

        Queries for historic decision instances that fulfill the given parameters.  The size of the result set can be retrieved by using the  [Get Historic Decision Instance Count](https://docs.camunda.org/manual/7.16/reference/rest/history/decision-instance/get-decision-instance-query-count/)  method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_decision_instances_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str decision_instance_id: Filter by decision instance id.
        :param str decision_instance_id_in: Filter by decision instance ids. Must be a comma-separated list of decision instance ids.
        :param str decision_definition_id: Filter by the decision definition the instances belongs to.
        :param str decision_definition_id_in: Filter by the decision definitions the instances belongs to. Must be a comma-separated list of decision definition ids.
        :param str decision_definition_key: Filter by the key of the decision definition the instances belongs to.
        :param str decision_definition_key_in: Filter by the keys of the decision definition the instances belongs to. Must be a comma- separated list of decision definition keys.
        :param str decision_definition_name: Filter by the name of the decision definition the instances belongs to.
        :param str decision_definition_name_like: Filter by the name of the decision definition the instances belongs to, that the parameter is a substring of.
        :param str process_definition_id: Filter by the process definition the instances belongs to.
        :param str process_definition_key: Filter by the key of the process definition the instances belongs to.
        :param str process_instance_id: Filter by the process instance the instances belongs to.
        :param str case_definition_id: Filter by the case definition the instances belongs to.
        :param str case_definition_key: Filter by the key of the case definition the instances belongs to.
        :param str case_instance_id: Filter by the case instance the instances belongs to.
        :param str activity_id_in: Filter by the activity ids the instances belongs to. Must be a comma-separated list of acitvity ids.
        :param str activity_instance_id_in: Filter by the activity instance ids the instances belongs to. Must be a comma-separated list of acitvity instance ids.
        :param str tenant_id_in: Filter by a comma-separated list of tenant ids. A historic decision instance must have one of the given tenant ids.
        :param bool without_tenant_id: Only include historic decision instances that belong to no tenant. Value may only be `true`, as `false` is the default behavior.
        :param datetime evaluated_before: Restrict to instances that were evaluated before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM- dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime evaluated_after: Restrict to instances that were evaluated after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM- dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param str user_id: Restrict to instances that were evaluated by the given user.
        :param str root_decision_instance_id: Restrict to instances that have a given root decision instance id. This also includes the decision instance with the given id.
        :param bool root_decision_instances_only: Restrict to instances those are the root decision instance of an evaluation. Value may only be `true`, as `false` is the default behavior.
        :param str decision_requirements_definition_id: Filter by the decision requirements definition the instances belongs to.
        :param str decision_requirements_definition_key: Filter by the key of the decision requirements definition the instances belongs to.
        :param bool include_inputs: Include input values in the result. Value may only be `true`, as `false` is the default behavior.
        :param bool include_outputs: Include output values in the result. Value may only be `true`, as `false` is the default behavior.
        :param bool disable_binary_fetching: Disables fetching of byte array input and output values. Value may only be `true`, as `false` is the default behavior.
        :param bool disable_custom_object_deserialization: Disables deserialization of input and output values that are custom objects. Value may only be `true`, as `false` is the default behavior.
        :param str sort_by: Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter.
        :param str sort_order: Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter.
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[HistoricDecisionInstanceDto], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'decision_instance_id',
            'decision_instance_id_in',
            'decision_definition_id',
            'decision_definition_id_in',
            'decision_definition_key',
            'decision_definition_key_in',
            'decision_definition_name',
            'decision_definition_name_like',
            'process_definition_id',
            'process_definition_key',
            'process_instance_id',
            'case_definition_id',
            'case_definition_key',
            'case_instance_id',
            'activity_id_in',
            'activity_instance_id_in',
            'tenant_id_in',
            'without_tenant_id',
            'evaluated_before',
            'evaluated_after',
            'user_id',
            'root_decision_instance_id',
            'root_decision_instances_only',
            'decision_requirements_definition_id',
            'decision_requirements_definition_key',
            'include_inputs',
            'include_outputs',
            'disable_binary_fetching',
            'disable_custom_object_deserialization',
            'sort_by',
            'sort_order',
            'first_result',
            'max_results'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_historic_decision_instances" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'decision_instance_id' in local_var_params and local_var_params['decision_instance_id'] is not None:  # noqa: E501
            query_params.append(('decisionInstanceId', local_var_params['decision_instance_id']))  # noqa: E501
        if 'decision_instance_id_in' in local_var_params and local_var_params['decision_instance_id_in'] is not None:  # noqa: E501
            query_params.append(('decisionInstanceIdIn', local_var_params['decision_instance_id_in']))  # noqa: E501
        if 'decision_definition_id' in local_var_params and local_var_params['decision_definition_id'] is not None:  # noqa: E501
            query_params.append(('decisionDefinitionId', local_var_params['decision_definition_id']))  # noqa: E501
        if 'decision_definition_id_in' in local_var_params and local_var_params['decision_definition_id_in'] is not None:  # noqa: E501
            query_params.append(('decisionDefinitionIdIn', local_var_params['decision_definition_id_in']))  # noqa: E501
        if 'decision_definition_key' in local_var_params and local_var_params['decision_definition_key'] is not None:  # noqa: E501
            query_params.append(('decisionDefinitionKey', local_var_params['decision_definition_key']))  # noqa: E501
        if 'decision_definition_key_in' in local_var_params and local_var_params['decision_definition_key_in'] is not None:  # noqa: E501
            query_params.append(('decisionDefinitionKeyIn', local_var_params['decision_definition_key_in']))  # noqa: E501
        if 'decision_definition_name' in local_var_params and local_var_params['decision_definition_name'] is not None:  # noqa: E501
            query_params.append(('decisionDefinitionName', local_var_params['decision_definition_name']))  # noqa: E501
        if 'decision_definition_name_like' in local_var_params and local_var_params['decision_definition_name_like'] is not None:  # noqa: E501
            query_params.append(('decisionDefinitionNameLike', local_var_params['decision_definition_name_like']))  # noqa: E501
        if 'process_definition_id' in local_var_params and local_var_params['process_definition_id'] is not None:  # noqa: E501
            query_params.append(('processDefinitionId', local_var_params['process_definition_id']))  # noqa: E501
        if 'process_definition_key' in local_var_params and local_var_params['process_definition_key'] is not None:  # noqa: E501
            query_params.append(('processDefinitionKey', local_var_params['process_definition_key']))  # noqa: E501
        if 'process_instance_id' in local_var_params and local_var_params['process_instance_id'] is not None:  # noqa: E501
            query_params.append(('processInstanceId', local_var_params['process_instance_id']))  # noqa: E501
        if 'case_definition_id' in local_var_params and local_var_params['case_definition_id'] is not None:  # noqa: E501
            query_params.append(('caseDefinitionId', local_var_params['case_definition_id']))  # noqa: E501
        if 'case_definition_key' in local_var_params and local_var_params['case_definition_key'] is not None:  # noqa: E501
            query_params.append(('caseDefinitionKey', local_var_params['case_definition_key']))  # noqa: E501
        if 'case_instance_id' in local_var_params and local_var_params['case_instance_id'] is not None:  # noqa: E501
            query_params.append(('caseInstanceId', local_var_params['case_instance_id']))  # noqa: E501
        if 'activity_id_in' in local_var_params and local_var_params['activity_id_in'] is not None:  # noqa: E501
            query_params.append(('activityIdIn', local_var_params['activity_id_in']))  # noqa: E501
        if 'activity_instance_id_in' in local_var_params and local_var_params['activity_instance_id_in'] is not None:  # noqa: E501
            query_params.append(('activityInstanceIdIn', local_var_params['activity_instance_id_in']))  # noqa: E501
        if 'tenant_id_in' in local_var_params and local_var_params['tenant_id_in'] is not None:  # noqa: E501
            query_params.append(('tenantIdIn', local_var_params['tenant_id_in']))  # noqa: E501
        if 'without_tenant_id' in local_var_params and local_var_params['without_tenant_id'] is not None:  # noqa: E501
            query_params.append(('withoutTenantId', local_var_params['without_tenant_id']))  # noqa: E501
        if 'evaluated_before' in local_var_params and local_var_params['evaluated_before'] is not None:  # noqa: E501
            query_params.append(('evaluatedBefore', local_var_params['evaluated_before']))  # noqa: E501
        if 'evaluated_after' in local_var_params and local_var_params['evaluated_after'] is not None:  # noqa: E501
            query_params.append(('evaluatedAfter', local_var_params['evaluated_after']))  # noqa: E501
        if 'user_id' in local_var_params and local_var_params['user_id'] is not None:  # noqa: E501
            query_params.append(('userId', local_var_params['user_id']))  # noqa: E501
        if 'root_decision_instance_id' in local_var_params and local_var_params['root_decision_instance_id'] is not None:  # noqa: E501
            query_params.append(('rootDecisionInstanceId', local_var_params['root_decision_instance_id']))  # noqa: E501
        if 'root_decision_instances_only' in local_var_params and local_var_params['root_decision_instances_only'] is not None:  # noqa: E501
            query_params.append(('rootDecisionInstancesOnly', local_var_params['root_decision_instances_only']))  # noqa: E501
        if 'decision_requirements_definition_id' in local_var_params and local_var_params['decision_requirements_definition_id'] is not None:  # noqa: E501
            query_params.append(('decisionRequirementsDefinitionId', local_var_params['decision_requirements_definition_id']))  # noqa: E501
        if 'decision_requirements_definition_key' in local_var_params and local_var_params['decision_requirements_definition_key'] is not None:  # noqa: E501
            query_params.append(('decisionRequirementsDefinitionKey', local_var_params['decision_requirements_definition_key']))  # noqa: E501
        if 'include_inputs' in local_var_params and local_var_params['include_inputs'] is not None:  # noqa: E501
            query_params.append(('includeInputs', local_var_params['include_inputs']))  # noqa: E501
        if 'include_outputs' in local_var_params and local_var_params['include_outputs'] is not None:  # noqa: E501
            query_params.append(('includeOutputs', local_var_params['include_outputs']))  # noqa: E501
        if 'disable_binary_fetching' in local_var_params and local_var_params['disable_binary_fetching'] is not None:  # noqa: E501
            query_params.append(('disableBinaryFetching', local_var_params['disable_binary_fetching']))  # noqa: E501
        if 'disable_custom_object_deserialization' in local_var_params and local_var_params['disable_custom_object_deserialization'] is not None:  # noqa: E501
            query_params.append(('disableCustomObjectDeserialization', local_var_params['disable_custom_object_deserialization']))  # noqa: E501
        if 'sort_by' in local_var_params and local_var_params['sort_by'] is not None:  # noqa: E501
            query_params.append(('sortBy', local_var_params['sort_by']))  # noqa: E501
        if 'sort_order' in local_var_params and local_var_params['sort_order'] is not None:  # noqa: E501
            query_params.append(('sortOrder', local_var_params['sort_order']))  # noqa: E501
        if 'first_result' in local_var_params and local_var_params['first_result'] is not None:  # noqa: E501
            query_params.append(('firstResult', local_var_params['first_result']))  # noqa: E501
        if 'max_results' in local_var_params and local_var_params['max_results'] is not None:  # noqa: E501
            query_params.append(('maxResults', local_var_params['max_results']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/decision-instance', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[HistoricDecisionInstanceDto]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_historic_decision_instances_count(self, **kwargs):  # noqa: E501
        """Get Historic Decision Instance Count  # noqa: E501

        Queries for the number of historic decision instances that fulfill the given parameters.  Takes the same parameters as the  [Get Historic Decision Instances](https://docs.camunda.org/manual/7.16/reference/rest/history/decision-instance/get-decision-instance-query/)  method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_decision_instances_count(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str decision_instance_id: Filter by decision instance id.
        :param str decision_instance_id_in: Filter by decision instance ids. Must be a comma-separated list of decision instance ids.
        :param str decision_definition_id: Filter by the decision definition the instances belongs to.
        :param str decision_definition_id_in: Filter by the decision definitions the instances belongs to. Must be a comma-separated list of decision definition ids.
        :param str decision_definition_key: Filter by the key of the decision definition the instances belongs to.
        :param str decision_definition_key_in: Filter by the keys of the decision definition the instances belongs to. Must be a comma- separated list of decision definition keys.
        :param str decision_definition_name: Filter by the name of the decision definition the instances belongs to.
        :param str decision_definition_name_like: Filter by the name of the decision definition the instances belongs to, that the parameter is a substring of.
        :param str process_definition_id: Filter by the process definition the instances belongs to.
        :param str process_definition_key: Filter by the key of the process definition the instances belongs to.
        :param str process_instance_id: Filter by the process instance the instances belongs to.
        :param str case_definition_id: Filter by the case definition the instances belongs to.
        :param str case_definition_key: Filter by the key of the case definition the instances belongs to.
        :param str case_instance_id: Filter by the case instance the instances belongs to.
        :param str activity_id_in: Filter by the activity ids the instances belongs to. Must be a comma-separated list of acitvity ids.
        :param str activity_instance_id_in: Filter by the activity instance ids the instances belongs to. Must be a comma-separated list of acitvity instance ids.
        :param str tenant_id_in: Filter by a comma-separated list of tenant ids. A historic decision instance must have one of the given tenant ids.
        :param bool without_tenant_id: Only include historic decision instances that belong to no tenant. Value may only be `true`, as `false` is the default behavior.
        :param datetime evaluated_before: Restrict to instances that were evaluated before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM- dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime evaluated_after: Restrict to instances that were evaluated after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM- dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param str user_id: Restrict to instances that were evaluated by the given user.
        :param str root_decision_instance_id: Restrict to instances that have a given root decision instance id. This also includes the decision instance with the given id.
        :param bool root_decision_instances_only: Restrict to instances those are the root decision instance of an evaluation. Value may only be `true`, as `false` is the default behavior.
        :param str decision_requirements_definition_id: Filter by the decision requirements definition the instances belongs to.
        :param str decision_requirements_definition_key: Filter by the key of the decision requirements definition the instances belongs to.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CountResultDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_historic_decision_instances_count_with_http_info(**kwargs)  # noqa: E501

    def get_historic_decision_instances_count_with_http_info(self, **kwargs):  # noqa: E501
        """Get Historic Decision Instance Count  # noqa: E501

        Queries for the number of historic decision instances that fulfill the given parameters.  Takes the same parameters as the  [Get Historic Decision Instances](https://docs.camunda.org/manual/7.16/reference/rest/history/decision-instance/get-decision-instance-query/)  method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_historic_decision_instances_count_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str decision_instance_id: Filter by decision instance id.
        :param str decision_instance_id_in: Filter by decision instance ids. Must be a comma-separated list of decision instance ids.
        :param str decision_definition_id: Filter by the decision definition the instances belongs to.
        :param str decision_definition_id_in: Filter by the decision definitions the instances belongs to. Must be a comma-separated list of decision definition ids.
        :param str decision_definition_key: Filter by the key of the decision definition the instances belongs to.
        :param str decision_definition_key_in: Filter by the keys of the decision definition the instances belongs to. Must be a comma- separated list of decision definition keys.
        :param str decision_definition_name: Filter by the name of the decision definition the instances belongs to.
        :param str decision_definition_name_like: Filter by the name of the decision definition the instances belongs to, that the parameter is a substring of.
        :param str process_definition_id: Filter by the process definition the instances belongs to.
        :param str process_definition_key: Filter by the key of the process definition the instances belongs to.
        :param str process_instance_id: Filter by the process instance the instances belongs to.
        :param str case_definition_id: Filter by the case definition the instances belongs to.
        :param str case_definition_key: Filter by the key of the case definition the instances belongs to.
        :param str case_instance_id: Filter by the case instance the instances belongs to.
        :param str activity_id_in: Filter by the activity ids the instances belongs to. Must be a comma-separated list of acitvity ids.
        :param str activity_instance_id_in: Filter by the activity instance ids the instances belongs to. Must be a comma-separated list of acitvity instance ids.
        :param str tenant_id_in: Filter by a comma-separated list of tenant ids. A historic decision instance must have one of the given tenant ids.
        :param bool without_tenant_id: Only include historic decision instances that belong to no tenant. Value may only be `true`, as `false` is the default behavior.
        :param datetime evaluated_before: Restrict to instances that were evaluated before the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM- dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param datetime evaluated_after: Restrict to instances that were evaluated after the given date. By [default](https://docs.camunda.org/manual/7.16/reference/rest/overview/date-format/), the date must have the format `yyyy-MM- dd'T'HH:mm:ss.SSSZ`, e.g., `2013-01-23T14:42:45.000+0200`.
        :param str user_id: Restrict to instances that were evaluated by the given user.
        :param str root_decision_instance_id: Restrict to instances that have a given root decision instance id. This also includes the decision instance with the given id.
        :param bool root_decision_instances_only: Restrict to instances those are the root decision instance of an evaluation. Value may only be `true`, as `false` is the default behavior.
        :param str decision_requirements_definition_id: Filter by the decision requirements definition the instances belongs to.
        :param str decision_requirements_definition_key: Filter by the key of the decision requirements definition the instances belongs to.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CountResultDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'decision_instance_id',
            'decision_instance_id_in',
            'decision_definition_id',
            'decision_definition_id_in',
            'decision_definition_key',
            'decision_definition_key_in',
            'decision_definition_name',
            'decision_definition_name_like',
            'process_definition_id',
            'process_definition_key',
            'process_instance_id',
            'case_definition_id',
            'case_definition_key',
            'case_instance_id',
            'activity_id_in',
            'activity_instance_id_in',
            'tenant_id_in',
            'without_tenant_id',
            'evaluated_before',
            'evaluated_after',
            'user_id',
            'root_decision_instance_id',
            'root_decision_instances_only',
            'decision_requirements_definition_id',
            'decision_requirements_definition_key'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_historic_decision_instances_count" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'decision_instance_id' in local_var_params and local_var_params['decision_instance_id'] is not None:  # noqa: E501
            query_params.append(('decisionInstanceId', local_var_params['decision_instance_id']))  # noqa: E501
        if 'decision_instance_id_in' in local_var_params and local_var_params['decision_instance_id_in'] is not None:  # noqa: E501
            query_params.append(('decisionInstanceIdIn', local_var_params['decision_instance_id_in']))  # noqa: E501
        if 'decision_definition_id' in local_var_params and local_var_params['decision_definition_id'] is not None:  # noqa: E501
            query_params.append(('decisionDefinitionId', local_var_params['decision_definition_id']))  # noqa: E501
        if 'decision_definition_id_in' in local_var_params and local_var_params['decision_definition_id_in'] is not None:  # noqa: E501
            query_params.append(('decisionDefinitionIdIn', local_var_params['decision_definition_id_in']))  # noqa: E501
        if 'decision_definition_key' in local_var_params and local_var_params['decision_definition_key'] is not None:  # noqa: E501
            query_params.append(('decisionDefinitionKey', local_var_params['decision_definition_key']))  # noqa: E501
        if 'decision_definition_key_in' in local_var_params and local_var_params['decision_definition_key_in'] is not None:  # noqa: E501
            query_params.append(('decisionDefinitionKeyIn', local_var_params['decision_definition_key_in']))  # noqa: E501
        if 'decision_definition_name' in local_var_params and local_var_params['decision_definition_name'] is not None:  # noqa: E501
            query_params.append(('decisionDefinitionName', local_var_params['decision_definition_name']))  # noqa: E501
        if 'decision_definition_name_like' in local_var_params and local_var_params['decision_definition_name_like'] is not None:  # noqa: E501
            query_params.append(('decisionDefinitionNameLike', local_var_params['decision_definition_name_like']))  # noqa: E501
        if 'process_definition_id' in local_var_params and local_var_params['process_definition_id'] is not None:  # noqa: E501
            query_params.append(('processDefinitionId', local_var_params['process_definition_id']))  # noqa: E501
        if 'process_definition_key' in local_var_params and local_var_params['process_definition_key'] is not None:  # noqa: E501
            query_params.append(('processDefinitionKey', local_var_params['process_definition_key']))  # noqa: E501
        if 'process_instance_id' in local_var_params and local_var_params['process_instance_id'] is not None:  # noqa: E501
            query_params.append(('processInstanceId', local_var_params['process_instance_id']))  # noqa: E501
        if 'case_definition_id' in local_var_params and local_var_params['case_definition_id'] is not None:  # noqa: E501
            query_params.append(('caseDefinitionId', local_var_params['case_definition_id']))  # noqa: E501
        if 'case_definition_key' in local_var_params and local_var_params['case_definition_key'] is not None:  # noqa: E501
            query_params.append(('caseDefinitionKey', local_var_params['case_definition_key']))  # noqa: E501
        if 'case_instance_id' in local_var_params and local_var_params['case_instance_id'] is not None:  # noqa: E501
            query_params.append(('caseInstanceId', local_var_params['case_instance_id']))  # noqa: E501
        if 'activity_id_in' in local_var_params and local_var_params['activity_id_in'] is not None:  # noqa: E501
            query_params.append(('activityIdIn', local_var_params['activity_id_in']))  # noqa: E501
        if 'activity_instance_id_in' in local_var_params and local_var_params['activity_instance_id_in'] is not None:  # noqa: E501
            query_params.append(('activityInstanceIdIn', local_var_params['activity_instance_id_in']))  # noqa: E501
        if 'tenant_id_in' in local_var_params and local_var_params['tenant_id_in'] is not None:  # noqa: E501
            query_params.append(('tenantIdIn', local_var_params['tenant_id_in']))  # noqa: E501
        if 'without_tenant_id' in local_var_params and local_var_params['without_tenant_id'] is not None:  # noqa: E501
            query_params.append(('withoutTenantId', local_var_params['without_tenant_id']))  # noqa: E501
        if 'evaluated_before' in local_var_params and local_var_params['evaluated_before'] is not None:  # noqa: E501
            query_params.append(('evaluatedBefore', local_var_params['evaluated_before']))  # noqa: E501
        if 'evaluated_after' in local_var_params and local_var_params['evaluated_after'] is not None:  # noqa: E501
            query_params.append(('evaluatedAfter', local_var_params['evaluated_after']))  # noqa: E501
        if 'user_id' in local_var_params and local_var_params['user_id'] is not None:  # noqa: E501
            query_params.append(('userId', local_var_params['user_id']))  # noqa: E501
        if 'root_decision_instance_id' in local_var_params and local_var_params['root_decision_instance_id'] is not None:  # noqa: E501
            query_params.append(('rootDecisionInstanceId', local_var_params['root_decision_instance_id']))  # noqa: E501
        if 'root_decision_instances_only' in local_var_params and local_var_params['root_decision_instances_only'] is not None:  # noqa: E501
            query_params.append(('rootDecisionInstancesOnly', local_var_params['root_decision_instances_only']))  # noqa: E501
        if 'decision_requirements_definition_id' in local_var_params and local_var_params['decision_requirements_definition_id'] is not None:  # noqa: E501
            query_params.append(('decisionRequirementsDefinitionId', local_var_params['decision_requirements_definition_id']))  # noqa: E501
        if 'decision_requirements_definition_key' in local_var_params and local_var_params['decision_requirements_definition_key'] is not None:  # noqa: E501
            query_params.append(('decisionRequirementsDefinitionKey', local_var_params['decision_requirements_definition_key']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/decision-instance/count', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CountResultDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def set_removal_time_async_historic_decision_instance(self, **kwargs):  # noqa: E501
        """Set Removal Time Async (POST)  # noqa: E501

        Sets the removal time to multiple historic decision instances asynchronously (batch).  At least `historicDecisionInstanceIds` or `historicDecisionInstanceQuery` has to be provided. If both are provided, all instances matching query criterion and instances from the list will be updated with a removal time.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_removal_time_async_historic_decision_instance(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param SetRemovalTimeToHistoricDecisionInstancesDto set_removal_time_to_historic_decision_instances_dto:
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: BatchDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.set_removal_time_async_historic_decision_instance_with_http_info(**kwargs)  # noqa: E501

    def set_removal_time_async_historic_decision_instance_with_http_info(self, **kwargs):  # noqa: E501
        """Set Removal Time Async (POST)  # noqa: E501

        Sets the removal time to multiple historic decision instances asynchronously (batch).  At least `historicDecisionInstanceIds` or `historicDecisionInstanceQuery` has to be provided. If both are provided, all instances matching query criterion and instances from the list will be updated with a removal time.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.set_removal_time_async_historic_decision_instance_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param SetRemovalTimeToHistoricDecisionInstancesDto set_removal_time_to_historic_decision_instances_dto:
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(BatchDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'set_removal_time_to_historic_decision_instances_dto'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method set_removal_time_async_historic_decision_instance" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'set_removal_time_to_historic_decision_instances_dto' in local_var_params:
            body_params = local_var_params['set_removal_time_to_historic_decision_instances_dto']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/decision-instance/set-removal-time', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='BatchDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
