# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.16.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from generic_camunda_client.api_client import ApiClient
from generic_camunda_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class HistoricDecisionDefinitionApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_cleanable_historic_decision_instance_report(self, **kwargs):  # noqa: E501
        """Get Cleanable Decision Instance Report  # noqa: E501

        Retrieves a report about a decision definition and finished decision instances relevant to history cleanup (see [History cleanup](https://docs.camunda.org/manual/7.16/user-guide/process-engine/history/#history-cleanup)),  so that you can tune the history time to live. These reports include the count of the finished historic decision instances, cleanable decision instances and basic decision definition data - id, key, name and version. The size of the result set can be retrieved by using the  [Get Cleanable Decision Instance Report Count](https://docs.camunda.org/manual/7.16/reference/rest/history/decision-definition/get-cleanable-decision-instance-report-count/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cleanable_historic_decision_instance_report(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str decision_definition_id_in: Filter by decision definition ids. Must be a comma-separated list of decision definition ids.
        :param str decision_definition_key_in: Filter by decision definition keys. Must be a comma-separated list of decision definition keys.
        :param str tenant_id_in: Filter by a comma-separated list of tenant ids. A decision definition must have one of the given tenant  ids.
        :param bool without_tenant_id: Only include decision definitions which belong to no tenant. Value may only be `true`, as `false`  is the default behavior.
        :param bool compact: Only include decision instances which have more than zero finished instances. Value may only be `true`,  as `false` is the default behavior.
        :param str sort_by: Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter.
        :param str sort_order: Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter.
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[CleanableHistoricDecisionInstanceReportResultDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_cleanable_historic_decision_instance_report_with_http_info(**kwargs)  # noqa: E501

    def get_cleanable_historic_decision_instance_report_with_http_info(self, **kwargs):  # noqa: E501
        """Get Cleanable Decision Instance Report  # noqa: E501

        Retrieves a report about a decision definition and finished decision instances relevant to history cleanup (see [History cleanup](https://docs.camunda.org/manual/7.16/user-guide/process-engine/history/#history-cleanup)),  so that you can tune the history time to live. These reports include the count of the finished historic decision instances, cleanable decision instances and basic decision definition data - id, key, name and version. The size of the result set can be retrieved by using the  [Get Cleanable Decision Instance Report Count](https://docs.camunda.org/manual/7.16/reference/rest/history/decision-definition/get-cleanable-decision-instance-report-count/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cleanable_historic_decision_instance_report_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str decision_definition_id_in: Filter by decision definition ids. Must be a comma-separated list of decision definition ids.
        :param str decision_definition_key_in: Filter by decision definition keys. Must be a comma-separated list of decision definition keys.
        :param str tenant_id_in: Filter by a comma-separated list of tenant ids. A decision definition must have one of the given tenant  ids.
        :param bool without_tenant_id: Only include decision definitions which belong to no tenant. Value may only be `true`, as `false`  is the default behavior.
        :param bool compact: Only include decision instances which have more than zero finished instances. Value may only be `true`,  as `false` is the default behavior.
        :param str sort_by: Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter.
        :param str sort_order: Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter.
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[CleanableHistoricDecisionInstanceReportResultDto], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'decision_definition_id_in',
            'decision_definition_key_in',
            'tenant_id_in',
            'without_tenant_id',
            'compact',
            'sort_by',
            'sort_order',
            'first_result',
            'max_results'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cleanable_historic_decision_instance_report" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'decision_definition_id_in' in local_var_params and local_var_params['decision_definition_id_in'] is not None:  # noqa: E501
            query_params.append(('decisionDefinitionIdIn', local_var_params['decision_definition_id_in']))  # noqa: E501
        if 'decision_definition_key_in' in local_var_params and local_var_params['decision_definition_key_in'] is not None:  # noqa: E501
            query_params.append(('decisionDefinitionKeyIn', local_var_params['decision_definition_key_in']))  # noqa: E501
        if 'tenant_id_in' in local_var_params and local_var_params['tenant_id_in'] is not None:  # noqa: E501
            query_params.append(('tenantIdIn', local_var_params['tenant_id_in']))  # noqa: E501
        if 'without_tenant_id' in local_var_params and local_var_params['without_tenant_id'] is not None:  # noqa: E501
            query_params.append(('withoutTenantId', local_var_params['without_tenant_id']))  # noqa: E501
        if 'compact' in local_var_params and local_var_params['compact'] is not None:  # noqa: E501
            query_params.append(('compact', local_var_params['compact']))  # noqa: E501
        if 'sort_by' in local_var_params and local_var_params['sort_by'] is not None:  # noqa: E501
            query_params.append(('sortBy', local_var_params['sort_by']))  # noqa: E501
        if 'sort_order' in local_var_params and local_var_params['sort_order'] is not None:  # noqa: E501
            query_params.append(('sortOrder', local_var_params['sort_order']))  # noqa: E501
        if 'first_result' in local_var_params and local_var_params['first_result'] is not None:  # noqa: E501
            query_params.append(('firstResult', local_var_params['first_result']))  # noqa: E501
        if 'max_results' in local_var_params and local_var_params['max_results'] is not None:  # noqa: E501
            query_params.append(('maxResults', local_var_params['max_results']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/decision-definition/cleanable-decision-instance-report', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[CleanableHistoricDecisionInstanceReportResultDto]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_cleanable_historic_decision_instance_report_count(self, **kwargs):  # noqa: E501
        """Get Cleanable Decision Instance Report Count  # noqa: E501

        Queries for the number of report results about a decision definition and finished decision instances relevant to history cleanup (see [History cleanup](https://docs.camunda.org/manual/7.16/user-guide/process-engine/history/#history-cleanup)). Takes the same parameters as the [Get Cleanable Decision Instance Report](https://docs.camunda.org/manual/7.16/reference/rest/history/decision-definition/get-cleanable-decision-instance-report/)  method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cleanable_historic_decision_instance_report_count(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str decision_definition_id_in: Filter by decision definition ids. Must be a comma-separated list of decision definition ids.
        :param str decision_definition_key_in: Filter by decision definition keys. Must be a comma-separated list of decision definition keys.
        :param str tenant_id_in: Filter by a comma-separated list of tenant ids. A decision definition must have one of the given tenant  ids.
        :param bool without_tenant_id: Only include decision definitions which belong to no tenant. Value may only be `true`, as `false`  is the default behavior.
        :param bool compact: Only include decision instances which have more than zero finished instances. Value may only be `true`,  as `false` is the default behavior.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CountResultDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_cleanable_historic_decision_instance_report_count_with_http_info(**kwargs)  # noqa: E501

    def get_cleanable_historic_decision_instance_report_count_with_http_info(self, **kwargs):  # noqa: E501
        """Get Cleanable Decision Instance Report Count  # noqa: E501

        Queries for the number of report results about a decision definition and finished decision instances relevant to history cleanup (see [History cleanup](https://docs.camunda.org/manual/7.16/user-guide/process-engine/history/#history-cleanup)). Takes the same parameters as the [Get Cleanable Decision Instance Report](https://docs.camunda.org/manual/7.16/reference/rest/history/decision-definition/get-cleanable-decision-instance-report/)  method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_cleanable_historic_decision_instance_report_count_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str decision_definition_id_in: Filter by decision definition ids. Must be a comma-separated list of decision definition ids.
        :param str decision_definition_key_in: Filter by decision definition keys. Must be a comma-separated list of decision definition keys.
        :param str tenant_id_in: Filter by a comma-separated list of tenant ids. A decision definition must have one of the given tenant  ids.
        :param bool without_tenant_id: Only include decision definitions which belong to no tenant. Value may only be `true`, as `false`  is the default behavior.
        :param bool compact: Only include decision instances which have more than zero finished instances. Value may only be `true`,  as `false` is the default behavior.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CountResultDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'decision_definition_id_in',
            'decision_definition_key_in',
            'tenant_id_in',
            'without_tenant_id',
            'compact'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_cleanable_historic_decision_instance_report_count" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'decision_definition_id_in' in local_var_params and local_var_params['decision_definition_id_in'] is not None:  # noqa: E501
            query_params.append(('decisionDefinitionIdIn', local_var_params['decision_definition_id_in']))  # noqa: E501
        if 'decision_definition_key_in' in local_var_params and local_var_params['decision_definition_key_in'] is not None:  # noqa: E501
            query_params.append(('decisionDefinitionKeyIn', local_var_params['decision_definition_key_in']))  # noqa: E501
        if 'tenant_id_in' in local_var_params and local_var_params['tenant_id_in'] is not None:  # noqa: E501
            query_params.append(('tenantIdIn', local_var_params['tenant_id_in']))  # noqa: E501
        if 'without_tenant_id' in local_var_params and local_var_params['without_tenant_id'] is not None:  # noqa: E501
            query_params.append(('withoutTenantId', local_var_params['without_tenant_id']))  # noqa: E501
        if 'compact' in local_var_params and local_var_params['compact'] is not None:  # noqa: E501
            query_params.append(('compact', local_var_params['compact']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/history/decision-definition/cleanable-decision-instance-report/count', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CountResultDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
