# coding: utf-8

"""
    Camunda Platform REST API

    OpenApi Spec for Camunda Platform REST API.  # noqa: E501

    The version of the OpenAPI document: 7.16.0
    Generated by: https://openapi-generator.tech
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from generic_camunda_client.api_client import ApiClient
from generic_camunda_client.exceptions import (  # noqa: F401
    ApiTypeError,
    ApiValueError
)


class DecisionRequirementsDefinitionApi(object):
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_decision_requirements_definition_by_id(self, id, **kwargs):  # noqa: E501
        """Get Decision Requirements Definition by ID  # noqa: E501

        Retrieves a decision requirements definition according to the `DecisionRequirementsDefinition` interface in the engine.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_decision_requirements_definition_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the decision requirements definition to be retrieved. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DecisionRequirementsDefinitionDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_decision_requirements_definition_by_id_with_http_info(id, **kwargs)  # noqa: E501

    def get_decision_requirements_definition_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get Decision Requirements Definition by ID  # noqa: E501

        Retrieves a decision requirements definition according to the `DecisionRequirementsDefinition` interface in the engine.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_decision_requirements_definition_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the decision requirements definition to be retrieved. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DecisionRequirementsDefinitionDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_decision_requirements_definition_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_decision_requirements_definition_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/decision-requirements-definition/{id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DecisionRequirementsDefinitionDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_decision_requirements_definition_by_key(self, key, **kwargs):  # noqa: E501
        """Get Decision Requirements Definition by Key  # noqa: E501

        Retrieves a decision requirements definition according to the `DecisionRequirementsDefinition` interface in the engine.  Returns the latest version of the decision requirements definition  which belongs to no tenant.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_decision_requirements_definition_by_key(key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str key: The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DecisionRequirementsDefinitionDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_decision_requirements_definition_by_key_with_http_info(key, **kwargs)  # noqa: E501

    def get_decision_requirements_definition_by_key_with_http_info(self, key, **kwargs):  # noqa: E501
        """Get Decision Requirements Definition by Key  # noqa: E501

        Retrieves a decision requirements definition according to the `DecisionRequirementsDefinition` interface in the engine.  Returns the latest version of the decision requirements definition  which belongs to no tenant.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_decision_requirements_definition_by_key_with_http_info(key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str key: The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DecisionRequirementsDefinitionDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'key'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_decision_requirements_definition_by_key" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'key' is set
        if self.api_client.client_side_validation and ('key' not in local_var_params or  # noqa: E501
                                                        local_var_params['key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `key` when calling `get_decision_requirements_definition_by_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'key' in local_var_params:
            path_params['key'] = local_var_params['key']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/decision-requirements-definition/key/{key}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DecisionRequirementsDefinitionDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_decision_requirements_definition_by_key_and_tenant_id(self, key, tenant_id, **kwargs):  # noqa: E501
        """Get Decision Requirements Definition by Key and Tenant ID  # noqa: E501

        Retrieves a decision requirements definition according to the `DecisionRequirementsDefinition` interface in the engine. Returns the latest version of the decision requirements definition  for a tenant.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_decision_requirements_definition_by_key_and_tenant_id(key, tenant_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str key: The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
        :param str tenant_id: The id of the tenant to which the decision requirements definition belongs to. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DecisionRequirementsDefinitionDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_decision_requirements_definition_by_key_and_tenant_id_with_http_info(key, tenant_id, **kwargs)  # noqa: E501

    def get_decision_requirements_definition_by_key_and_tenant_id_with_http_info(self, key, tenant_id, **kwargs):  # noqa: E501
        """Get Decision Requirements Definition by Key and Tenant ID  # noqa: E501

        Retrieves a decision requirements definition according to the `DecisionRequirementsDefinition` interface in the engine. Returns the latest version of the decision requirements definition  for a tenant.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_decision_requirements_definition_by_key_and_tenant_id_with_http_info(key, tenant_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str key: The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
        :param str tenant_id: The id of the tenant to which the decision requirements definition belongs to. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DecisionRequirementsDefinitionDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'key',
            'tenant_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_decision_requirements_definition_by_key_and_tenant_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'key' is set
        if self.api_client.client_side_validation and ('key' not in local_var_params or  # noqa: E501
                                                        local_var_params['key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `key` when calling `get_decision_requirements_definition_by_key_and_tenant_id`")  # noqa: E501
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and ('tenant_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tenant_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `get_decision_requirements_definition_by_key_and_tenant_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'key' in local_var_params:
            path_params['key'] = local_var_params['key']  # noqa: E501
        if 'tenant_id' in local_var_params:
            path_params['tenant-id'] = local_var_params['tenant_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/decision-requirements-definition/key/{key}/tenant-id/{tenant-id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DecisionRequirementsDefinitionDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_decision_requirements_definition_diagram_by_id(self, id, **kwargs):  # noqa: E501
        """Get Decision Requirements Diagram by ID  # noqa: E501

        Retrieves the diagram of a decision requirements definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_decision_requirements_definition_diagram_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the decision requirements definition. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_decision_requirements_definition_diagram_by_id_with_http_info(id, **kwargs)  # noqa: E501

    def get_decision_requirements_definition_diagram_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get Decision Requirements Diagram by ID  # noqa: E501

        Retrieves the diagram of a decision requirements definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_decision_requirements_definition_diagram_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the decision requirements definition. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_decision_requirements_definition_diagram_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_decision_requirements_definition_diagram_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['image/*', 'application/octet-stream', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/decision-requirements-definition/{id}/diagram', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_decision_requirements_definition_diagram_by_key(self, key, **kwargs):  # noqa: E501
        """Get Decision Requirements Diagram by Key  # noqa: E501

        Retrieves the diagram of a decision requirements definition. Returns the diagram for the latest version of the decision requirements  definition which belongs to no tenant.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_decision_requirements_definition_diagram_by_key(key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str key: The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_decision_requirements_definition_diagram_by_key_with_http_info(key, **kwargs)  # noqa: E501

    def get_decision_requirements_definition_diagram_by_key_with_http_info(self, key, **kwargs):  # noqa: E501
        """Get Decision Requirements Diagram by Key  # noqa: E501

        Retrieves the diagram of a decision requirements definition. Returns the diagram for the latest version of the decision requirements  definition which belongs to no tenant.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_decision_requirements_definition_diagram_by_key_with_http_info(key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str key: The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'key'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_decision_requirements_definition_diagram_by_key" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'key' is set
        if self.api_client.client_side_validation and ('key' not in local_var_params or  # noqa: E501
                                                        local_var_params['key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `key` when calling `get_decision_requirements_definition_diagram_by_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'key' in local_var_params:
            path_params['key'] = local_var_params['key']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['image/*', 'application/octet-stream', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/decision-requirements-definition/key/{key}/diagram', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_decision_requirements_definition_diagram_by_key_and_tenant_id(self, key, tenant_id, **kwargs):  # noqa: E501
        """Get Decision Requirements Diagram by Key and Tenant ID  # noqa: E501

        Retrieves the diagram of a decision requirements definition. Returns the diagram of the latest version of the decision requirements  definition for a tenant.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_decision_requirements_definition_diagram_by_key_and_tenant_id(key, tenant_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str key: The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
        :param str tenant_id: The id of the tenant to which the decision requirements definition belongs to. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_decision_requirements_definition_diagram_by_key_and_tenant_id_with_http_info(key, tenant_id, **kwargs)  # noqa: E501

    def get_decision_requirements_definition_diagram_by_key_and_tenant_id_with_http_info(self, key, tenant_id, **kwargs):  # noqa: E501
        """Get Decision Requirements Diagram by Key and Tenant ID  # noqa: E501

        Retrieves the diagram of a decision requirements definition. Returns the diagram of the latest version of the decision requirements  definition for a tenant.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_decision_requirements_definition_diagram_by_key_and_tenant_id_with_http_info(key, tenant_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str key: The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
        :param str tenant_id: The id of the tenant to which the decision requirements definition belongs to. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(file, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'key',
            'tenant_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_decision_requirements_definition_diagram_by_key_and_tenant_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'key' is set
        if self.api_client.client_side_validation and ('key' not in local_var_params or  # noqa: E501
                                                        local_var_params['key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `key` when calling `get_decision_requirements_definition_diagram_by_key_and_tenant_id`")  # noqa: E501
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and ('tenant_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tenant_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `get_decision_requirements_definition_diagram_by_key_and_tenant_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'key' in local_var_params:
            path_params['key'] = local_var_params['key']  # noqa: E501
        if 'tenant_id' in local_var_params:
            path_params['tenant-id'] = local_var_params['tenant_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['image/*', 'application/octet-stream', 'application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/decision-requirements-definition/key/{key}/tenant-id/{tenant-id}/diagram', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_decision_requirements_definition_dmn_xml_by_id(self, id, **kwargs):  # noqa: E501
        """Get DMN XML by ID  # noqa: E501

        Retrieves the DMN XML of a decision requirements definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_decision_requirements_definition_dmn_xml_by_id(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the decision requirements definition. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DecisionRequirementsDefinitionXmlDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_decision_requirements_definition_dmn_xml_by_id_with_http_info(id, **kwargs)  # noqa: E501

    def get_decision_requirements_definition_dmn_xml_by_id_with_http_info(self, id, **kwargs):  # noqa: E501
        """Get DMN XML by ID  # noqa: E501

        Retrieves the DMN XML of a decision requirements definition.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_decision_requirements_definition_dmn_xml_by_id_with_http_info(id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str id: The id of the decision requirements definition. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DecisionRequirementsDefinitionXmlDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_decision_requirements_definition_dmn_xml_by_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'id' is set
        if self.api_client.client_side_validation and ('id' not in local_var_params or  # noqa: E501
                                                        local_var_params['id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `id` when calling `get_decision_requirements_definition_dmn_xml_by_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'id' in local_var_params:
            path_params['id'] = local_var_params['id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/decision-requirements-definition/{id}/xml', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DecisionRequirementsDefinitionXmlDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_decision_requirements_definition_dmn_xml_by_key(self, key, **kwargs):  # noqa: E501
        """Get DMN XML by Key  # noqa: E501

        Retrieves the DMN XML of a decision requirements definition. Returns the XML for the latest version of the decision requirements  definition which belongs to no tenant.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_decision_requirements_definition_dmn_xml_by_key(key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str key: The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DecisionRequirementsDefinitionXmlDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_decision_requirements_definition_dmn_xml_by_key_with_http_info(key, **kwargs)  # noqa: E501

    def get_decision_requirements_definition_dmn_xml_by_key_with_http_info(self, key, **kwargs):  # noqa: E501
        """Get DMN XML by Key  # noqa: E501

        Retrieves the DMN XML of a decision requirements definition. Returns the XML for the latest version of the decision requirements  definition which belongs to no tenant.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_decision_requirements_definition_dmn_xml_by_key_with_http_info(key, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str key: The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DecisionRequirementsDefinitionXmlDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'key'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_decision_requirements_definition_dmn_xml_by_key" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'key' is set
        if self.api_client.client_side_validation and ('key' not in local_var_params or  # noqa: E501
                                                        local_var_params['key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `key` when calling `get_decision_requirements_definition_dmn_xml_by_key`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'key' in local_var_params:
            path_params['key'] = local_var_params['key']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/decision-requirements-definition/key/{key}/xml', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DecisionRequirementsDefinitionXmlDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_decision_requirements_definition_dmn_xml_by_key_and_tenant_id(self, key, tenant_id, **kwargs):  # noqa: E501
        """Get DMN XML by Key and Tenant ID  # noqa: E501

        Retrieves the DMN XML of a decision requirements definition. Returns the XML of the latest version of the decision requirements  definition for a tenant.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_decision_requirements_definition_dmn_xml_by_key_and_tenant_id(key, tenant_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str key: The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
        :param str tenant_id: The id of the tenant to which the decision requirements definition belongs to. (required)
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: DecisionRequirementsDefinitionXmlDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_decision_requirements_definition_dmn_xml_by_key_and_tenant_id_with_http_info(key, tenant_id, **kwargs)  # noqa: E501

    def get_decision_requirements_definition_dmn_xml_by_key_and_tenant_id_with_http_info(self, key, tenant_id, **kwargs):  # noqa: E501
        """Get DMN XML by Key and Tenant ID  # noqa: E501

        Retrieves the DMN XML of a decision requirements definition. Returns the XML of the latest version of the decision requirements  definition for a tenant.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_decision_requirements_definition_dmn_xml_by_key_and_tenant_id_with_http_info(key, tenant_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str key: The key of the decision requirements definition (the latest version thereof) to be retrieved. (required)
        :param str tenant_id: The id of the tenant to which the decision requirements definition belongs to. (required)
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(DecisionRequirementsDefinitionXmlDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'key',
            'tenant_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_decision_requirements_definition_dmn_xml_by_key_and_tenant_id" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']
        # verify the required parameter 'key' is set
        if self.api_client.client_side_validation and ('key' not in local_var_params or  # noqa: E501
                                                        local_var_params['key'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `key` when calling `get_decision_requirements_definition_dmn_xml_by_key_and_tenant_id`")  # noqa: E501
        # verify the required parameter 'tenant_id' is set
        if self.api_client.client_side_validation and ('tenant_id' not in local_var_params or  # noqa: E501
                                                        local_var_params['tenant_id'] is None):  # noqa: E501
            raise ApiValueError("Missing the required parameter `tenant_id` when calling `get_decision_requirements_definition_dmn_xml_by_key_and_tenant_id`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'key' in local_var_params:
            path_params['key'] = local_var_params['key']  # noqa: E501
        if 'tenant_id' in local_var_params:
            path_params['tenant-id'] = local_var_params['tenant_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/decision-requirements-definition/key/{key}/tenant-id/{tenant-id}/xml', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='DecisionRequirementsDefinitionXmlDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_decision_requirements_definitions(self, **kwargs):  # noqa: E501
        """Get Decision Requirements Definitions  # noqa: E501

        Queries for decision requirements definitions that fulfill given parameters. Parameters may be the properties of decision requirements definitions, such as the name, key or version.  The size of the result set can be retrieved by using the [Get Decision Requirements Definition Count](https://docs.camunda.org/manual/7.16/reference/rest/decision-requirements-definition/get-query-count/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_decision_requirements_definitions(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str decision_requirements_definition_id: Filter by decision requirements definition id.
        :param str decision_requirements_definition_id_in: Filter by decision requirements definition ids.
        :param str name: Filter by decision requirements definition name.
        :param str name_like: Filter by decision requirements definition names that the parameter is a substring of.
        :param str deployment_id: Filter by the id of the deployment a decision requirement definition belongs to.
        :param str key: Filter by decision requirements definition key, i.e., the id in the DMN 1.3 XML. Exact match.
        :param str key_like: Filter by decision requirements definition keys that the parameter is a substring of.
        :param str category: Filter by decision requirements definition category. Exact match.
        :param str category_like: Filter by decision requirements definition categories that the parameter is a substring of.
        :param int version: Filter by decision requirements definition version.
        :param bool latest_version: Only include those decision requirements definitions that are latest versions. Value may only be `true`, as `false` is the default behavior.
        :param str resource_name: Filter by the name of the decision requirements definition resource. Exact match.
        :param str resource_name_like: Filter by names of those decision requirements definition resources that the parameter is a substring of.
        :param str tenant_id_in: Filter by a comma-separated list of tenant ids. A decision requirements definition must have one of the given tenant ids.
        :param bool without_tenant_id: Only include decision requirements definitions which belong to no tenant. Value may only be `true`, as `false` is the default behavior.
        :param bool include_decision_requirements_definitions_without_tenant_id: Include decision requirements definitions which belong to no tenant. Can be used in combination with `tenantIdIn`. Value may only be `true`, as `false` is the default behavior.
        :param str sort_by: Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter.
        :param str sort_order: Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter.
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: list[DecisionRequirementsDefinitionDto]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_decision_requirements_definitions_with_http_info(**kwargs)  # noqa: E501

    def get_decision_requirements_definitions_with_http_info(self, **kwargs):  # noqa: E501
        """Get Decision Requirements Definitions  # noqa: E501

        Queries for decision requirements definitions that fulfill given parameters. Parameters may be the properties of decision requirements definitions, such as the name, key or version.  The size of the result set can be retrieved by using the [Get Decision Requirements Definition Count](https://docs.camunda.org/manual/7.16/reference/rest/decision-requirements-definition/get-query-count/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_decision_requirements_definitions_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str decision_requirements_definition_id: Filter by decision requirements definition id.
        :param str decision_requirements_definition_id_in: Filter by decision requirements definition ids.
        :param str name: Filter by decision requirements definition name.
        :param str name_like: Filter by decision requirements definition names that the parameter is a substring of.
        :param str deployment_id: Filter by the id of the deployment a decision requirement definition belongs to.
        :param str key: Filter by decision requirements definition key, i.e., the id in the DMN 1.3 XML. Exact match.
        :param str key_like: Filter by decision requirements definition keys that the parameter is a substring of.
        :param str category: Filter by decision requirements definition category. Exact match.
        :param str category_like: Filter by decision requirements definition categories that the parameter is a substring of.
        :param int version: Filter by decision requirements definition version.
        :param bool latest_version: Only include those decision requirements definitions that are latest versions. Value may only be `true`, as `false` is the default behavior.
        :param str resource_name: Filter by the name of the decision requirements definition resource. Exact match.
        :param str resource_name_like: Filter by names of those decision requirements definition resources that the parameter is a substring of.
        :param str tenant_id_in: Filter by a comma-separated list of tenant ids. A decision requirements definition must have one of the given tenant ids.
        :param bool without_tenant_id: Only include decision requirements definitions which belong to no tenant. Value may only be `true`, as `false` is the default behavior.
        :param bool include_decision_requirements_definitions_without_tenant_id: Include decision requirements definitions which belong to no tenant. Can be used in combination with `tenantIdIn`. Value may only be `true`, as `false` is the default behavior.
        :param str sort_by: Sort the results lexicographically by a given criterion. Must be used in conjunction with the sortOrder parameter.
        :param str sort_order: Sort the results in a given order. Values may be asc for ascending order or desc for descending order. Must be used in conjunction with the sortBy parameter.
        :param int first_result: Pagination of results. Specifies the index of the first result to return.
        :param int max_results: Pagination of results. Specifies the maximum number of results to return. Will return less results if there are no more results left.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(list[DecisionRequirementsDefinitionDto], status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'decision_requirements_definition_id',
            'decision_requirements_definition_id_in',
            'name',
            'name_like',
            'deployment_id',
            'key',
            'key_like',
            'category',
            'category_like',
            'version',
            'latest_version',
            'resource_name',
            'resource_name_like',
            'tenant_id_in',
            'without_tenant_id',
            'include_decision_requirements_definitions_without_tenant_id',
            'sort_by',
            'sort_order',
            'first_result',
            'max_results'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_decision_requirements_definitions" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'decision_requirements_definition_id' in local_var_params and local_var_params['decision_requirements_definition_id'] is not None:  # noqa: E501
            query_params.append(('decisionRequirementsDefinitionId', local_var_params['decision_requirements_definition_id']))  # noqa: E501
        if 'decision_requirements_definition_id_in' in local_var_params and local_var_params['decision_requirements_definition_id_in'] is not None:  # noqa: E501
            query_params.append(('decisionRequirementsDefinitionIdIn', local_var_params['decision_requirements_definition_id_in']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'name_like' in local_var_params and local_var_params['name_like'] is not None:  # noqa: E501
            query_params.append(('nameLike', local_var_params['name_like']))  # noqa: E501
        if 'deployment_id' in local_var_params and local_var_params['deployment_id'] is not None:  # noqa: E501
            query_params.append(('deploymentId', local_var_params['deployment_id']))  # noqa: E501
        if 'key' in local_var_params and local_var_params['key'] is not None:  # noqa: E501
            query_params.append(('key', local_var_params['key']))  # noqa: E501
        if 'key_like' in local_var_params and local_var_params['key_like'] is not None:  # noqa: E501
            query_params.append(('keyLike', local_var_params['key_like']))  # noqa: E501
        if 'category' in local_var_params and local_var_params['category'] is not None:  # noqa: E501
            query_params.append(('category', local_var_params['category']))  # noqa: E501
        if 'category_like' in local_var_params and local_var_params['category_like'] is not None:  # noqa: E501
            query_params.append(('categoryLike', local_var_params['category_like']))  # noqa: E501
        if 'version' in local_var_params and local_var_params['version'] is not None:  # noqa: E501
            query_params.append(('version', local_var_params['version']))  # noqa: E501
        if 'latest_version' in local_var_params and local_var_params['latest_version'] is not None:  # noqa: E501
            query_params.append(('latestVersion', local_var_params['latest_version']))  # noqa: E501
        if 'resource_name' in local_var_params and local_var_params['resource_name'] is not None:  # noqa: E501
            query_params.append(('resourceName', local_var_params['resource_name']))  # noqa: E501
        if 'resource_name_like' in local_var_params and local_var_params['resource_name_like'] is not None:  # noqa: E501
            query_params.append(('resourceNameLike', local_var_params['resource_name_like']))  # noqa: E501
        if 'tenant_id_in' in local_var_params and local_var_params['tenant_id_in'] is not None:  # noqa: E501
            query_params.append(('tenantIdIn', local_var_params['tenant_id_in']))  # noqa: E501
        if 'without_tenant_id' in local_var_params and local_var_params['without_tenant_id'] is not None:  # noqa: E501
            query_params.append(('withoutTenantId', local_var_params['without_tenant_id']))  # noqa: E501
        if 'include_decision_requirements_definitions_without_tenant_id' in local_var_params and local_var_params['include_decision_requirements_definitions_without_tenant_id'] is not None:  # noqa: E501
            query_params.append(('includeDecisionRequirementsDefinitionsWithoutTenantId', local_var_params['include_decision_requirements_definitions_without_tenant_id']))  # noqa: E501
        if 'sort_by' in local_var_params and local_var_params['sort_by'] is not None:  # noqa: E501
            query_params.append(('sortBy', local_var_params['sort_by']))  # noqa: E501
        if 'sort_order' in local_var_params and local_var_params['sort_order'] is not None:  # noqa: E501
            query_params.append(('sortOrder', local_var_params['sort_order']))  # noqa: E501
        if 'first_result' in local_var_params and local_var_params['first_result'] is not None:  # noqa: E501
            query_params.append(('firstResult', local_var_params['first_result']))  # noqa: E501
        if 'max_results' in local_var_params and local_var_params['max_results'] is not None:  # noqa: E501
            query_params.append(('maxResults', local_var_params['max_results']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/decision-requirements-definition', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[DecisionRequirementsDefinitionDto]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_decision_requirements_definitions_count(self, **kwargs):  # noqa: E501
        """Get Decision Requirements Definition Count  # noqa: E501

        Requests the number of decision requirements definitions that fulfill the query criteria. Takes the same filtering parameters as the [Get Decision Requirements Definitions](https://docs.camunda.org/manual/7.16/reference/rest/decision-requirements-definition/get-query/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_decision_requirements_definitions_count(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str decision_requirements_definition_id: Filter by decision requirements definition id.
        :param str decision_requirements_definition_id_in: Filter by decision requirements definition ids.
        :param str name: Filter by decision requirements definition name.
        :param str name_like: Filter by decision requirements definition names that the parameter is a substring of.
        :param str deployment_id: Filter by the id of the deployment a decision requirement definition belongs to.
        :param str key: Filter by decision requirements definition key, i.e., the id in the DMN 1.3 XML. Exact match.
        :param str key_like: Filter by decision requirements definition keys that the parameter is a substring of.
        :param str category: Filter by decision requirements definition category. Exact match.
        :param str category_like: Filter by decision requirements definition categories that the parameter is a substring of.
        :param int version: Filter by decision requirements definition version.
        :param bool latest_version: Only include those decision requirements definitions that are latest versions. Value may only be `true`, as `false` is the default behavior.
        :param str resource_name: Filter by the name of the decision requirements definition resource. Exact match.
        :param str resource_name_like: Filter by names of those decision requirements definition resources that the parameter is a substring of.
        :param str tenant_id_in: Filter by a comma-separated list of tenant ids. A decision requirements definition must have one of the given tenant ids.
        :param bool without_tenant_id: Only include decision requirements definitions which belong to no tenant. Value may only be `true`, as `false` is the default behavior.
        :param bool include_decision_requirements_definitions_without_tenant_id: Include decision requirements definitions which belong to no tenant. Can be used in combination with `tenantIdIn`. Value may only be `true`, as `false` is the default behavior.
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: CountResultDto
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        return self.get_decision_requirements_definitions_count_with_http_info(**kwargs)  # noqa: E501

    def get_decision_requirements_definitions_count_with_http_info(self, **kwargs):  # noqa: E501
        """Get Decision Requirements Definition Count  # noqa: E501

        Requests the number of decision requirements definitions that fulfill the query criteria. Takes the same filtering parameters as the [Get Decision Requirements Definitions](https://docs.camunda.org/manual/7.16/reference/rest/decision-requirements-definition/get-query/) method.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_decision_requirements_definitions_count_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool: execute request asynchronously
        :param str decision_requirements_definition_id: Filter by decision requirements definition id.
        :param str decision_requirements_definition_id_in: Filter by decision requirements definition ids.
        :param str name: Filter by decision requirements definition name.
        :param str name_like: Filter by decision requirements definition names that the parameter is a substring of.
        :param str deployment_id: Filter by the id of the deployment a decision requirement definition belongs to.
        :param str key: Filter by decision requirements definition key, i.e., the id in the DMN 1.3 XML. Exact match.
        :param str key_like: Filter by decision requirements definition keys that the parameter is a substring of.
        :param str category: Filter by decision requirements definition category. Exact match.
        :param str category_like: Filter by decision requirements definition categories that the parameter is a substring of.
        :param int version: Filter by decision requirements definition version.
        :param bool latest_version: Only include those decision requirements definitions that are latest versions. Value may only be `true`, as `false` is the default behavior.
        :param str resource_name: Filter by the name of the decision requirements definition resource. Exact match.
        :param str resource_name_like: Filter by names of those decision requirements definition resources that the parameter is a substring of.
        :param str tenant_id_in: Filter by a comma-separated list of tenant ids. A decision requirements definition must have one of the given tenant ids.
        :param bool without_tenant_id: Only include decision requirements definitions which belong to no tenant. Value may only be `true`, as `false` is the default behavior.
        :param bool include_decision_requirements_definitions_without_tenant_id: Include decision requirements definitions which belong to no tenant. Can be used in combination with `tenantIdIn`. Value may only be `true`, as `false` is the default behavior.
        :param _return_http_data_only: response data without head status code
                                       and headers
        :param _preload_content: if False, the urllib3.HTTPResponse object will
                                 be returned without reading/decoding response
                                 data. Default is True.
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :return: tuple(CountResultDto, status_code(int), headers(HTTPHeaderDict))
                 If the method is called asynchronously,
                 returns the request thread.
        """

        local_var_params = locals()

        all_params = [
            'decision_requirements_definition_id',
            'decision_requirements_definition_id_in',
            'name',
            'name_like',
            'deployment_id',
            'key',
            'key_like',
            'category',
            'category_like',
            'version',
            'latest_version',
            'resource_name',
            'resource_name_like',
            'tenant_id_in',
            'without_tenant_id',
            'include_decision_requirements_definitions_without_tenant_id'
        ]
        all_params.extend(
            [
                'async_req',
                '_return_http_data_only',
                '_preload_content',
                '_request_timeout'
            ]
        )

        for key, val in six.iteritems(local_var_params['kwargs']):
            if key not in all_params:
                raise ApiTypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_decision_requirements_definitions_count" % key
                )
            local_var_params[key] = val
        del local_var_params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'decision_requirements_definition_id' in local_var_params and local_var_params['decision_requirements_definition_id'] is not None:  # noqa: E501
            query_params.append(('decisionRequirementsDefinitionId', local_var_params['decision_requirements_definition_id']))  # noqa: E501
        if 'decision_requirements_definition_id_in' in local_var_params and local_var_params['decision_requirements_definition_id_in'] is not None:  # noqa: E501
            query_params.append(('decisionRequirementsDefinitionIdIn', local_var_params['decision_requirements_definition_id_in']))  # noqa: E501
        if 'name' in local_var_params and local_var_params['name'] is not None:  # noqa: E501
            query_params.append(('name', local_var_params['name']))  # noqa: E501
        if 'name_like' in local_var_params and local_var_params['name_like'] is not None:  # noqa: E501
            query_params.append(('nameLike', local_var_params['name_like']))  # noqa: E501
        if 'deployment_id' in local_var_params and local_var_params['deployment_id'] is not None:  # noqa: E501
            query_params.append(('deploymentId', local_var_params['deployment_id']))  # noqa: E501
        if 'key' in local_var_params and local_var_params['key'] is not None:  # noqa: E501
            query_params.append(('key', local_var_params['key']))  # noqa: E501
        if 'key_like' in local_var_params and local_var_params['key_like'] is not None:  # noqa: E501
            query_params.append(('keyLike', local_var_params['key_like']))  # noqa: E501
        if 'category' in local_var_params and local_var_params['category'] is not None:  # noqa: E501
            query_params.append(('category', local_var_params['category']))  # noqa: E501
        if 'category_like' in local_var_params and local_var_params['category_like'] is not None:  # noqa: E501
            query_params.append(('categoryLike', local_var_params['category_like']))  # noqa: E501
        if 'version' in local_var_params and local_var_params['version'] is not None:  # noqa: E501
            query_params.append(('version', local_var_params['version']))  # noqa: E501
        if 'latest_version' in local_var_params and local_var_params['latest_version'] is not None:  # noqa: E501
            query_params.append(('latestVersion', local_var_params['latest_version']))  # noqa: E501
        if 'resource_name' in local_var_params and local_var_params['resource_name'] is not None:  # noqa: E501
            query_params.append(('resourceName', local_var_params['resource_name']))  # noqa: E501
        if 'resource_name_like' in local_var_params and local_var_params['resource_name_like'] is not None:  # noqa: E501
            query_params.append(('resourceNameLike', local_var_params['resource_name_like']))  # noqa: E501
        if 'tenant_id_in' in local_var_params and local_var_params['tenant_id_in'] is not None:  # noqa: E501
            query_params.append(('tenantIdIn', local_var_params['tenant_id_in']))  # noqa: E501
        if 'without_tenant_id' in local_var_params and local_var_params['without_tenant_id'] is not None:  # noqa: E501
            query_params.append(('withoutTenantId', local_var_params['without_tenant_id']))  # noqa: E501
        if 'include_decision_requirements_definitions_without_tenant_id' in local_var_params and local_var_params['include_decision_requirements_definitions_without_tenant_id'] is not None:  # noqa: E501
            query_params.append(('includeDecisionRequirementsDefinitionsWithoutTenantId', local_var_params['include_decision_requirements_definitions_without_tenant_id']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = []  # noqa: E501

        return self.api_client.call_api(
            '/decision-requirements-definition/count', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='CountResultDto',  # noqa: E501
            auth_settings=auth_settings,
            async_req=local_var_params.get('async_req'),
            _return_http_data_only=local_var_params.get('_return_http_data_only'),  # noqa: E501
            _preload_content=local_var_params.get('_preload_content', True),
            _request_timeout=local_var_params.get('_request_timeout'),
            collection_formats=collection_formats)
