# generic-camunda-client
OpenApi Spec for Camunda Platform REST API.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 7.16.0
- Package version: 7.16.0
- Build date: 2021-10-13T19:50:53.906279420Z[GMT]
- Build package: org.openapitools.codegen.languages.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import generic_camunda_client
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import generic_camunda_client
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function

import time
import generic_camunda_client
from generic_camunda_client.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to http://localhost:8080/engine-rest
# See configuration.py for a list of all supported configuration parameters.
configuration = generic_camunda_client.Configuration(
    host = "http://localhost:8080/engine-rest"
)



# Enter a context with an instance of the API client
with generic_camunda_client.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = generic_camunda_client.AuthorizationApi(api_client)
    
    try:
        # Authorization Resource Options
        api_response = api_instance.available_operations_authorization()
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AuthorizationApi->available_operations_authorization: %s\n" % e)
    
```

## Documentation for API Endpoints

All URIs are relative to *http://localhost:8080/engine-rest*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AuthorizationApi* | [**available_operations_authorization**](docs/AuthorizationApi.md#available_operations_authorization) | **OPTIONS** /authorization | Authorization Resource Options
*AuthorizationApi* | [**available_operations_authorization_instance**](docs/AuthorizationApi.md#available_operations_authorization_instance) | **OPTIONS** /authorization/{id} | Authorization Resource Options
*AuthorizationApi* | [**create_authorization**](docs/AuthorizationApi.md#create_authorization) | **POST** /authorization/create | Create a New Authorization
*AuthorizationApi* | [**delete_authorization**](docs/AuthorizationApi.md#delete_authorization) | **DELETE** /authorization/{id} | Delete Authorization
*AuthorizationApi* | [**get_authorization**](docs/AuthorizationApi.md#get_authorization) | **GET** /authorization/{id} | Get Authorization
*AuthorizationApi* | [**get_authorization_count**](docs/AuthorizationApi.md#get_authorization_count) | **GET** /authorization/count | Get Authorization Count
*AuthorizationApi* | [**is_user_authorized**](docs/AuthorizationApi.md#is_user_authorized) | **GET** /authorization/check | Perform an Authorization Check
*AuthorizationApi* | [**query_authorizations**](docs/AuthorizationApi.md#query_authorizations) | **GET** /authorization | Get Authorizations
*AuthorizationApi* | [**update_authorization**](docs/AuthorizationApi.md#update_authorization) | **PUT** /authorization/{id} | Update an Authorization
*BatchApi* | [**delete_batch**](docs/BatchApi.md#delete_batch) | **DELETE** /batch/{id} | Delete
*BatchApi* | [**get_batch**](docs/BatchApi.md#get_batch) | **GET** /batch/{id} | Get
*BatchApi* | [**get_batch_statistics**](docs/BatchApi.md#get_batch_statistics) | **GET** /batch/statistics | Get Statistics
*BatchApi* | [**get_batch_statistics_count**](docs/BatchApi.md#get_batch_statistics_count) | **GET** /batch/statistics/count | Get Statistics Count
*BatchApi* | [**get_batches**](docs/BatchApi.md#get_batches) | **GET** /batch | Get List
*BatchApi* | [**get_batches_count**](docs/BatchApi.md#get_batches_count) | **GET** /batch/count | Get List Count
*BatchApi* | [**update_batch_suspension_state**](docs/BatchApi.md#update_batch_suspension_state) | **PUT** /batch/{id}/suspended | Activate/Suspend
*ConditionApi* | [**evaluate_condition**](docs/ConditionApi.md#evaluate_condition) | **POST** /condition | Evaluate
*DecisionDefinitionApi* | [**evaluate_decision_by_id**](docs/DecisionDefinitionApi.md#evaluate_decision_by_id) | **POST** /decision-definition/{id}/evaluate | Evaluate By Id
*DecisionDefinitionApi* | [**evaluate_decision_by_key**](docs/DecisionDefinitionApi.md#evaluate_decision_by_key) | **POST** /decision-definition/key/{key}/evaluate | Evaluate By Key
*DecisionDefinitionApi* | [**evaluate_decision_by_key_and_tenant**](docs/DecisionDefinitionApi.md#evaluate_decision_by_key_and_tenant) | **POST** /decision-definition/key/{key}/tenant-id/{tenant-id}/evaluate | Evaluate By Key And Tenant
*DecisionDefinitionApi* | [**get_decision_definition_by_id**](docs/DecisionDefinitionApi.md#get_decision_definition_by_id) | **GET** /decision-definition/{id} | Get Decision Definition By Id
*DecisionDefinitionApi* | [**get_decision_definition_by_key**](docs/DecisionDefinitionApi.md#get_decision_definition_by_key) | **GET** /decision-definition/key/{key} | Get Decision Definition By Key
*DecisionDefinitionApi* | [**get_decision_definition_by_key_and_tenant_id**](docs/DecisionDefinitionApi.md#get_decision_definition_by_key_and_tenant_id) | **GET** /decision-definition/key/{key}/tenant-id/{tenant-id} | Get Decision Definition By Key And Tenant Id
*DecisionDefinitionApi* | [**get_decision_definition_diagram**](docs/DecisionDefinitionApi.md#get_decision_definition_diagram) | **GET** /decision-definition/{id}/diagram | Get Diagram
*DecisionDefinitionApi* | [**get_decision_definition_diagram_by_key**](docs/DecisionDefinitionApi.md#get_decision_definition_diagram_by_key) | **GET** /decision-definition/key/{key}/diagram | Get Diagram By Key
*DecisionDefinitionApi* | [**get_decision_definition_diagram_by_key_and_tenant**](docs/DecisionDefinitionApi.md#get_decision_definition_diagram_by_key_and_tenant) | **GET** /decision-definition/key/{key}/tenant-id/{tenant-id}/diagram | Get Diagram By Key And Tenant
*DecisionDefinitionApi* | [**get_decision_definition_dmn_xml_by_id**](docs/DecisionDefinitionApi.md#get_decision_definition_dmn_xml_by_id) | **GET** /decision-definition/{id}/xml | Get XML By Id
*DecisionDefinitionApi* | [**get_decision_definition_dmn_xml_by_key**](docs/DecisionDefinitionApi.md#get_decision_definition_dmn_xml_by_key) | **GET** /decision-definition/key/{key}/xml | Get XML By Key
*DecisionDefinitionApi* | [**get_decision_definition_dmn_xml_by_key_and_tenant**](docs/DecisionDefinitionApi.md#get_decision_definition_dmn_xml_by_key_and_tenant) | **GET** /decision-definition/key/{key}/tenant-id/{tenant-id}/xml | Get XML By Key and Tenant
*DecisionDefinitionApi* | [**get_decision_definitions**](docs/DecisionDefinitionApi.md#get_decision_definitions) | **GET** /decision-definition | Get List
*DecisionDefinitionApi* | [**get_decision_definitions_count**](docs/DecisionDefinitionApi.md#get_decision_definitions_count) | **GET** /decision-definition/count | Get List Count
*DecisionDefinitionApi* | [**update_history_time_to_live_by_decision_definition_id**](docs/DecisionDefinitionApi.md#update_history_time_to_live_by_decision_definition_id) | **PUT** /decision-definition/{id}/history-time-to-live | Update History Time to Live
*DecisionDefinitionApi* | [**update_history_time_to_live_by_decision_definition_key**](docs/DecisionDefinitionApi.md#update_history_time_to_live_by_decision_definition_key) | **PUT** /decision-definition/key/{key}/history-time-to-live | Update History Time to Live By Key
*DecisionDefinitionApi* | [**update_history_time_to_live_by_decision_definition_key_and_tenant**](docs/DecisionDefinitionApi.md#update_history_time_to_live_by_decision_definition_key_and_tenant) | **PUT** /decision-definition/key/{key}/tenant-id/{tenant-id}/history-time-to-live | Update History Time to Live By Key And Tenant
*DecisionRequirementsDefinitionApi* | [**get_decision_requirements_definition_by_id**](docs/DecisionRequirementsDefinitionApi.md#get_decision_requirements_definition_by_id) | **GET** /decision-requirements-definition/{id} | Get Decision Requirements Definition by ID
*DecisionRequirementsDefinitionApi* | [**get_decision_requirements_definition_by_key**](docs/DecisionRequirementsDefinitionApi.md#get_decision_requirements_definition_by_key) | **GET** /decision-requirements-definition/key/{key} | Get Decision Requirements Definition by Key
*DecisionRequirementsDefinitionApi* | [**get_decision_requirements_definition_by_key_and_tenant_id**](docs/DecisionRequirementsDefinitionApi.md#get_decision_requirements_definition_by_key_and_tenant_id) | **GET** /decision-requirements-definition/key/{key}/tenant-id/{tenant-id} | Get Decision Requirements Definition by Key and Tenant ID
*DecisionRequirementsDefinitionApi* | [**get_decision_requirements_definition_diagram_by_id**](docs/DecisionRequirementsDefinitionApi.md#get_decision_requirements_definition_diagram_by_id) | **GET** /decision-requirements-definition/{id}/diagram | Get Decision Requirements Diagram by ID
*DecisionRequirementsDefinitionApi* | [**get_decision_requirements_definition_diagram_by_key**](docs/DecisionRequirementsDefinitionApi.md#get_decision_requirements_definition_diagram_by_key) | **GET** /decision-requirements-definition/key/{key}/diagram | Get Decision Requirements Diagram by Key
*DecisionRequirementsDefinitionApi* | [**get_decision_requirements_definition_diagram_by_key_and_tenant_id**](docs/DecisionRequirementsDefinitionApi.md#get_decision_requirements_definition_diagram_by_key_and_tenant_id) | **GET** /decision-requirements-definition/key/{key}/tenant-id/{tenant-id}/diagram | Get Decision Requirements Diagram by Key and Tenant ID
*DecisionRequirementsDefinitionApi* | [**get_decision_requirements_definition_dmn_xml_by_id**](docs/DecisionRequirementsDefinitionApi.md#get_decision_requirements_definition_dmn_xml_by_id) | **GET** /decision-requirements-definition/{id}/xml | Get DMN XML by ID
*DecisionRequirementsDefinitionApi* | [**get_decision_requirements_definition_dmn_xml_by_key**](docs/DecisionRequirementsDefinitionApi.md#get_decision_requirements_definition_dmn_xml_by_key) | **GET** /decision-requirements-definition/key/{key}/xml | Get DMN XML by Key
*DecisionRequirementsDefinitionApi* | [**get_decision_requirements_definition_dmn_xml_by_key_and_tenant_id**](docs/DecisionRequirementsDefinitionApi.md#get_decision_requirements_definition_dmn_xml_by_key_and_tenant_id) | **GET** /decision-requirements-definition/key/{key}/tenant-id/{tenant-id}/xml | Get DMN XML by Key and Tenant ID
*DecisionRequirementsDefinitionApi* | [**get_decision_requirements_definitions**](docs/DecisionRequirementsDefinitionApi.md#get_decision_requirements_definitions) | **GET** /decision-requirements-definition | Get Decision Requirements Definitions
*DecisionRequirementsDefinitionApi* | [**get_decision_requirements_definitions_count**](docs/DecisionRequirementsDefinitionApi.md#get_decision_requirements_definitions_count) | **GET** /decision-requirements-definition/count | Get Decision Requirements Definition Count
*DeploymentApi* | [**create_deployment**](docs/DeploymentApi.md#create_deployment) | **POST** /deployment/create | Create
*DeploymentApi* | [**delete_deployment**](docs/DeploymentApi.md#delete_deployment) | **DELETE** /deployment/{id} | Delete
*DeploymentApi* | [**get_deployment**](docs/DeploymentApi.md#get_deployment) | **GET** /deployment/{id} | Get
*DeploymentApi* | [**get_deployment_resource**](docs/DeploymentApi.md#get_deployment_resource) | **GET** /deployment/{id}/resources/{resourceId} | Get Resource
*DeploymentApi* | [**get_deployment_resource_data**](docs/DeploymentApi.md#get_deployment_resource_data) | **GET** /deployment/{id}/resources/{resourceId}/data | Get Resource (Binary)
*DeploymentApi* | [**get_deployment_resources**](docs/DeploymentApi.md#get_deployment_resources) | **GET** /deployment/{id}/resources | Get Resources
*DeploymentApi* | [**get_deployments**](docs/DeploymentApi.md#get_deployments) | **GET** /deployment | Get List
*DeploymentApi* | [**get_deployments_count**](docs/DeploymentApi.md#get_deployments_count) | **GET** /deployment/count | Get List Count
*DeploymentApi* | [**redeploy**](docs/DeploymentApi.md#redeploy) | **POST** /deployment/{id}/redeploy | Redeploy
*EngineApi* | [**get_process_engine_names**](docs/EngineApi.md#get_process_engine_names) | **GET** /engine | Get List
*EventSubscriptionApi* | [**get_event_subscriptions**](docs/EventSubscriptionApi.md#get_event_subscriptions) | **GET** /event-subscription | Get List
*EventSubscriptionApi* | [**get_event_subscriptions_count**](docs/EventSubscriptionApi.md#get_event_subscriptions_count) | **GET** /event-subscription/count | Get List Count
*ExecutionApi* | [**create_incident**](docs/ExecutionApi.md#create_incident) | **POST** /execution/{id}/create-incident | Create Incident
*ExecutionApi* | [**delete_local_execution_variable**](docs/ExecutionApi.md#delete_local_execution_variable) | **DELETE** /execution/{id}/localVariables/{varName} | Delete Local Execution Variable
*ExecutionApi* | [**get_execution**](docs/ExecutionApi.md#get_execution) | **GET** /execution/{id} | Get Execution
*ExecutionApi* | [**get_executions**](docs/ExecutionApi.md#get_executions) | **GET** /execution | Get Executions
*ExecutionApi* | [**get_executions_count**](docs/ExecutionApi.md#get_executions_count) | **GET** /execution/count | Get Execution Count
*ExecutionApi* | [**get_local_execution_variable**](docs/ExecutionApi.md#get_local_execution_variable) | **GET** /execution/{id}/localVariables/{varName} | Get Local Execution Variable
*ExecutionApi* | [**get_local_execution_variable_binary**](docs/ExecutionApi.md#get_local_execution_variable_binary) | **GET** /execution/{id}/localVariables/{varName}/data | Get Local Execution Variable (Binary)
*ExecutionApi* | [**get_local_execution_variables**](docs/ExecutionApi.md#get_local_execution_variables) | **GET** /execution/{id}/localVariables | Get Local Execution Variables
*ExecutionApi* | [**get_message_event_subscription**](docs/ExecutionApi.md#get_message_event_subscription) | **GET** /execution/{id}/messageSubscriptions/{messageName} | Get Message Event Subscription
*ExecutionApi* | [**modify_local_execution_variables**](docs/ExecutionApi.md#modify_local_execution_variables) | **POST** /execution/{id}/localVariables | Update/Delete Local Execution Variables
*ExecutionApi* | [**put_local_execution_variable**](docs/ExecutionApi.md#put_local_execution_variable) | **PUT** /execution/{id}/localVariables/{varName} | Put Local Execution Variable
*ExecutionApi* | [**query_executions**](docs/ExecutionApi.md#query_executions) | **POST** /execution | Get Executions (POST)
*ExecutionApi* | [**query_executions_count**](docs/ExecutionApi.md#query_executions_count) | **POST** /execution/count | Get Execution Count (POST)
*ExecutionApi* | [**set_local_execution_variable_binary**](docs/ExecutionApi.md#set_local_execution_variable_binary) | **POST** /execution/{id}/localVariables/{varName}/data | Post Local Execution Variable (Binary)
*ExecutionApi* | [**signal_execution**](docs/ExecutionApi.md#signal_execution) | **POST** /execution/{id}/signal | Trigger Execution
*ExecutionApi* | [**trigger_event**](docs/ExecutionApi.md#trigger_event) | **POST** /execution/{id}/messageSubscriptions/{messageName}/trigger | Trigger Message Event Subscription
*ExternalTaskApi* | [**complete_external_task_resource**](docs/ExternalTaskApi.md#complete_external_task_resource) | **POST** /external-task/{id}/complete | Complete
*ExternalTaskApi* | [**extend_lock**](docs/ExternalTaskApi.md#extend_lock) | **POST** /external-task/{id}/extendLock | Extend Lock
*ExternalTaskApi* | [**fetch_and_lock**](docs/ExternalTaskApi.md#fetch_and_lock) | **POST** /external-task/fetchAndLock | Fetch and Lock
*ExternalTaskApi* | [**get_external_task**](docs/ExternalTaskApi.md#get_external_task) | **GET** /external-task/{id} | Get
*ExternalTaskApi* | [**get_external_task_error_details**](docs/ExternalTaskApi.md#get_external_task_error_details) | **GET** /external-task/{id}/errorDetails | Get Error Details
*ExternalTaskApi* | [**get_external_tasks**](docs/ExternalTaskApi.md#get_external_tasks) | **GET** /external-task | Get List
*ExternalTaskApi* | [**get_external_tasks_count**](docs/ExternalTaskApi.md#get_external_tasks_count) | **GET** /external-task/count | Get List Count
*ExternalTaskApi* | [**get_topic_names**](docs/ExternalTaskApi.md#get_topic_names) | **GET** /external-task/topic-names | Get External Task Topic Names
*ExternalTaskApi* | [**handle_external_task_bpmn_error**](docs/ExternalTaskApi.md#handle_external_task_bpmn_error) | **POST** /external-task/{id}/bpmnError | Handle BPMN Error
*ExternalTaskApi* | [**handle_failure**](docs/ExternalTaskApi.md#handle_failure) | **POST** /external-task/{id}/failure | Handle Failure
*ExternalTaskApi* | [**lock**](docs/ExternalTaskApi.md#lock) | **POST** /external-task/{id}/lock | 
*ExternalTaskApi* | [**query_external_tasks**](docs/ExternalTaskApi.md#query_external_tasks) | **POST** /external-task | Get List (POST)
*ExternalTaskApi* | [**query_external_tasks_count**](docs/ExternalTaskApi.md#query_external_tasks_count) | **POST** /external-task/count | Get List Count (POST)
*ExternalTaskApi* | [**set_external_task_resource_priority**](docs/ExternalTaskApi.md#set_external_task_resource_priority) | **PUT** /external-task/{id}/priority | Set Priority
*ExternalTaskApi* | [**set_external_task_resource_retries**](docs/ExternalTaskApi.md#set_external_task_resource_retries) | **PUT** /external-task/{id}/retries | Set Retries
*ExternalTaskApi* | [**set_external_task_retries**](docs/ExternalTaskApi.md#set_external_task_retries) | **PUT** /external-task/retries | Set Retries Sync
*ExternalTaskApi* | [**set_external_task_retries_async_operation**](docs/ExternalTaskApi.md#set_external_task_retries_async_operation) | **POST** /external-task/retries-async | Set Retries Async
*ExternalTaskApi* | [**unlock**](docs/ExternalTaskApi.md#unlock) | **POST** /external-task/{id}/unlock | Unlock
*FilterApi* | [**create_filter**](docs/FilterApi.md#create_filter) | **POST** /filter/create | Create Filter
*FilterApi* | [**delete_filter**](docs/FilterApi.md#delete_filter) | **DELETE** /filter/{id} | Delete Filter
*FilterApi* | [**execute_filter_count**](docs/FilterApi.md#execute_filter_count) | **GET** /filter/{id}/count | Execute Filter Count
*FilterApi* | [**execute_filter_list**](docs/FilterApi.md#execute_filter_list) | **GET** /filter/{id}/list | Execute Filter List
*FilterApi* | [**execute_filter_single_result**](docs/FilterApi.md#execute_filter_single_result) | **GET** /filter/{id}/singleResult | Execute Filter Single Result
*FilterApi* | [**filter_resource_options**](docs/FilterApi.md#filter_resource_options) | **OPTIONS** /filter | Filter Resource Options
*FilterApi* | [**filter_resource_options_single**](docs/FilterApi.md#filter_resource_options_single) | **OPTIONS** /filter/{id} | Filter Resource Options
*FilterApi* | [**get_filter_count**](docs/FilterApi.md#get_filter_count) | **GET** /filter/count | Get Filter Count
*FilterApi* | [**get_filter_list**](docs/FilterApi.md#get_filter_list) | **GET** /filter | Get Filters
*FilterApi* | [**get_single_filter**](docs/FilterApi.md#get_single_filter) | **GET** /filter/{id} | Get Single Filter
*FilterApi* | [**post_execute_filter_count**](docs/FilterApi.md#post_execute_filter_count) | **POST** /filter/{id}/count | Execute Filter Count (POST)
*FilterApi* | [**post_execute_filter_list**](docs/FilterApi.md#post_execute_filter_list) | **POST** /filter/{id}/list | Execute Filter List (POST)
*FilterApi* | [**post_execute_filter_single_result**](docs/FilterApi.md#post_execute_filter_single_result) | **POST** /filter/{id}/singleResult | Execute Filter Single Result (POST)
*FilterApi* | [**update_filter**](docs/FilterApi.md#update_filter) | **PUT** /filter/{id} | Update Filter
*GroupApi* | [**available_group_instance_operations**](docs/GroupApi.md#available_group_instance_operations) | **OPTIONS** /group/{id} | Group Resource Instance Options
*GroupApi* | [**available_group_members_operations**](docs/GroupApi.md#available_group_members_operations) | **OPTIONS** /group/{id}/members | Group Membership Resource Options
*GroupApi* | [**available_group_operations**](docs/GroupApi.md#available_group_operations) | **OPTIONS** /group | Group Resource Options
*GroupApi* | [**create_group**](docs/GroupApi.md#create_group) | **POST** /group/create | Create Group
*GroupApi* | [**create_group_member**](docs/GroupApi.md#create_group_member) | **PUT** /group/{id}/members/{userId} | Create Group Member
*GroupApi* | [**delete_group**](docs/GroupApi.md#delete_group) | **DELETE** /group/{id} | Delete Group
*GroupApi* | [**delete_group_member**](docs/GroupApi.md#delete_group_member) | **DELETE** /group/{id}/members/{userId} | Delete a Group Member
*GroupApi* | [**get_group**](docs/GroupApi.md#get_group) | **GET** /group/{id} | Get Group
*GroupApi* | [**get_group_count**](docs/GroupApi.md#get_group_count) | **GET** /group/count | Get List Count
*GroupApi* | [**get_query_groups**](docs/GroupApi.md#get_query_groups) | **GET** /group | Get List
*GroupApi* | [**post_query_groups**](docs/GroupApi.md#post_query_groups) | **POST** /group | Get List (POST)
*GroupApi* | [**query_group_count**](docs/GroupApi.md#query_group_count) | **POST** /group/count | Get List Count (POST)
*GroupApi* | [**update_group**](docs/GroupApi.md#update_group) | **PUT** /group/{id} | Update Group
*HistoricActivityInstanceApi* | [**get_historic_activity_instance**](docs/HistoricActivityInstanceApi.md#get_historic_activity_instance) | **GET** /history/activity-instance/{id} | Get
*HistoricActivityInstanceApi* | [**get_historic_activity_instances**](docs/HistoricActivityInstanceApi.md#get_historic_activity_instances) | **GET** /history/activity-instance | Get List
*HistoricActivityInstanceApi* | [**get_historic_activity_instances_count**](docs/HistoricActivityInstanceApi.md#get_historic_activity_instances_count) | **GET** /history/activity-instance/count | Get List Count
*HistoricActivityInstanceApi* | [**query_historic_activity_instances**](docs/HistoricActivityInstanceApi.md#query_historic_activity_instances) | **POST** /history/activity-instance | Get List (POST)
*HistoricActivityInstanceApi* | [**query_historic_activity_instances_count**](docs/HistoricActivityInstanceApi.md#query_historic_activity_instances_count) | **POST** /history/activity-instance/count | Get List Count (POST)
*HistoricBatchApi* | [**delete_historic_batch**](docs/HistoricBatchApi.md#delete_historic_batch) | **DELETE** /history/batch/{id} | Delete Historic Batch
*HistoricBatchApi* | [**get_cleanable_historic_batches_report**](docs/HistoricBatchApi.md#get_cleanable_historic_batches_report) | **GET** /history/batch/cleanable-batch-report | Get Cleanable Batch Report
*HistoricBatchApi* | [**get_cleanable_historic_batches_report_count**](docs/HistoricBatchApi.md#get_cleanable_historic_batches_report_count) | **GET** /history/batch/cleanable-batch-report/count | Get Cleanable Batch Report Count
*HistoricBatchApi* | [**get_historic_batch**](docs/HistoricBatchApi.md#get_historic_batch) | **GET** /history/batch/{id} | Get Historic Batch
*HistoricBatchApi* | [**get_historic_batches**](docs/HistoricBatchApi.md#get_historic_batches) | **GET** /history/batch | Get Historic Batches
*HistoricBatchApi* | [**get_historic_batches_count**](docs/HistoricBatchApi.md#get_historic_batches_count) | **GET** /history/batch/count | Get Historic Batch Count
*HistoricBatchApi* | [**set_removal_time_async_historic_batch**](docs/HistoricBatchApi.md#set_removal_time_async_historic_batch) | **POST** /history/batch/set-removal-time | Set Removal Time Async (POST)
*HistoricDecisionDefinitionApi* | [**get_cleanable_historic_decision_instance_report**](docs/HistoricDecisionDefinitionApi.md#get_cleanable_historic_decision_instance_report) | **GET** /history/decision-definition/cleanable-decision-instance-report | Get Cleanable Decision Instance Report
*HistoricDecisionDefinitionApi* | [**get_cleanable_historic_decision_instance_report_count**](docs/HistoricDecisionDefinitionApi.md#get_cleanable_historic_decision_instance_report_count) | **GET** /history/decision-definition/cleanable-decision-instance-report/count | Get Cleanable Decision Instance Report Count
*HistoricDecisionInstanceApi* | [**delete_async**](docs/HistoricDecisionInstanceApi.md#delete_async) | **POST** /history/decision-instance/delete | Delete Async (POST)
*HistoricDecisionInstanceApi* | [**get_historic_decision_instance**](docs/HistoricDecisionInstanceApi.md#get_historic_decision_instance) | **GET** /history/decision-instance/{id} | Get Historic Decision Instance
*HistoricDecisionInstanceApi* | [**get_historic_decision_instances**](docs/HistoricDecisionInstanceApi.md#get_historic_decision_instances) | **GET** /history/decision-instance | Get Historic Decision Instances
*HistoricDecisionInstanceApi* | [**get_historic_decision_instances_count**](docs/HistoricDecisionInstanceApi.md#get_historic_decision_instances_count) | **GET** /history/decision-instance/count | Get Historic Decision Instance Count
*HistoricDecisionInstanceApi* | [**set_removal_time_async_historic_decision_instance**](docs/HistoricDecisionInstanceApi.md#set_removal_time_async_historic_decision_instance) | **POST** /history/decision-instance/set-removal-time | Set Removal Time Async (POST)
*HistoricDecisionRequirementsDefinitionApi* | [**get_decision_statistics**](docs/HistoricDecisionRequirementsDefinitionApi.md#get_decision_statistics) | **GET** /history/decision-requirements-definition/{id}/statistics | Get DRD Statistics
*HistoricDetailApi* | [**get_historic_details**](docs/HistoricDetailApi.md#get_historic_details) | **GET** /history/detail | Get Historic Details
*HistoricDetailApi* | [**get_historic_details_count**](docs/HistoricDetailApi.md#get_historic_details_count) | **GET** /history/detail/count | Get Historic Detail Count
*HistoricDetailApi* | [**historic_detail**](docs/HistoricDetailApi.md#historic_detail) | **GET** /history/detail/{id} | Get Historic Detail
*HistoricDetailApi* | [**historic_detail_binary**](docs/HistoricDetailApi.md#historic_detail_binary) | **GET** /history/detail/{id}/data | Get Historic Detail (Binary)
*HistoricDetailApi* | [**query_historic_details**](docs/HistoricDetailApi.md#query_historic_details) | **POST** /history/detail | Get Historic Details (POST)
*HistoricExternalTaskLogApi* | [**get_error_details_historic_external_task_log**](docs/HistoricExternalTaskLogApi.md#get_error_details_historic_external_task_log) | **GET** /history/external-task-log/{id}/error-details | Get External Task Log Error Details
*HistoricExternalTaskLogApi* | [**get_historic_external_task_log**](docs/HistoricExternalTaskLogApi.md#get_historic_external_task_log) | **GET** /history/external-task-log/{id} | Get External Task Log
*HistoricExternalTaskLogApi* | [**get_historic_external_task_logs**](docs/HistoricExternalTaskLogApi.md#get_historic_external_task_logs) | **GET** /history/external-task-log | Get External Task Logs
*HistoricExternalTaskLogApi* | [**get_historic_external_task_logs_count**](docs/HistoricExternalTaskLogApi.md#get_historic_external_task_logs_count) | **GET** /history/external-task-log/count | Get External Task Log Count
*HistoricExternalTaskLogApi* | [**query_historic_external_task_logs**](docs/HistoricExternalTaskLogApi.md#query_historic_external_task_logs) | **POST** /history/external-task-log | Get External Task Logs (POST)
*HistoricExternalTaskLogApi* | [**query_historic_external_task_logs_count**](docs/HistoricExternalTaskLogApi.md#query_historic_external_task_logs_count) | **POST** /history/external-task-log/count | Get External Task Log Count (POST)
*HistoricIdentityLinkLogApi* | [**get_historic_identity_links**](docs/HistoricIdentityLinkLogApi.md#get_historic_identity_links) | **GET** /history/identity-link-log | Get Identity Link Logs
*HistoricIdentityLinkLogApi* | [**get_historic_identity_links_count**](docs/HistoricIdentityLinkLogApi.md#get_historic_identity_links_count) | **GET** /history/identity-link-log/count | Get Identity Link Log Count
*HistoricIncidentApi* | [**get_historic_incidents**](docs/HistoricIncidentApi.md#get_historic_incidents) | **GET** /history/incident | Get Incidents
*HistoricIncidentApi* | [**get_historic_incidents_count**](docs/HistoricIncidentApi.md#get_historic_incidents_count) | **GET** /history/incident/count | Get Incident Count
*HistoricJobLogApi* | [**get_historic_job_log**](docs/HistoricJobLogApi.md#get_historic_job_log) | **GET** /history/job-log/{id} | Get Job Log
*HistoricJobLogApi* | [**get_historic_job_logs**](docs/HistoricJobLogApi.md#get_historic_job_logs) | **GET** /history/job-log | Get Job Logs
*HistoricJobLogApi* | [**get_historic_job_logs_count**](docs/HistoricJobLogApi.md#get_historic_job_logs_count) | **GET** /history/job-log/count | Get Job Log Count
*HistoricJobLogApi* | [**get_stacktrace_historic_job_log**](docs/HistoricJobLogApi.md#get_stacktrace_historic_job_log) | **GET** /history/job-log/{id}/stacktrace | Get Job Log Exception Stacktrace
*HistoricJobLogApi* | [**query_historic_job_logs**](docs/HistoricJobLogApi.md#query_historic_job_logs) | **POST** /history/job-log | Get Job Logs (POST)
*HistoricJobLogApi* | [**query_historic_job_logs_count**](docs/HistoricJobLogApi.md#query_historic_job_logs_count) | **POST** /history/job-log/count | Get Job Log Count (POST)
*HistoricProcessDefinitionApi* | [**get_cleanable_historic_process_instance_report**](docs/HistoricProcessDefinitionApi.md#get_cleanable_historic_process_instance_report) | **GET** /history/process-definition/cleanable-process-instance-report | Get Cleanable Process Instance Report
*HistoricProcessDefinitionApi* | [**get_cleanable_historic_process_instance_report_count**](docs/HistoricProcessDefinitionApi.md#get_cleanable_historic_process_instance_report_count) | **GET** /history/process-definition/cleanable-process-instance-report/count | Get Cleanable Process Instance Report Count
*HistoricProcessDefinitionApi* | [**get_historic_activity_statistics**](docs/HistoricProcessDefinitionApi.md#get_historic_activity_statistics) | **GET** /history/process-definition/{id}/statistics | Get Historic Activity Statistics
*HistoricProcessInstanceApi* | [**delete_historic_process_instance**](docs/HistoricProcessInstanceApi.md#delete_historic_process_instance) | **DELETE** /history/process-instance/{id} | Delete
*HistoricProcessInstanceApi* | [**delete_historic_process_instances_async**](docs/HistoricProcessInstanceApi.md#delete_historic_process_instances_async) | **POST** /history/process-instance/delete | Delete Async (POST)
*HistoricProcessInstanceApi* | [**delete_historic_variable_instances_of_historic_process_instance**](docs/HistoricProcessInstanceApi.md#delete_historic_variable_instances_of_historic_process_instance) | **DELETE** /history/process-instance/{id}/variable-instances | Delete Variable Instances
*HistoricProcessInstanceApi* | [**get_historic_process_instance**](docs/HistoricProcessInstanceApi.md#get_historic_process_instance) | **GET** /history/process-instance/{id} | Get
*HistoricProcessInstanceApi* | [**get_historic_process_instance_duration_report**](docs/HistoricProcessInstanceApi.md#get_historic_process_instance_duration_report) | **GET** /history/process-instance/report | Get Duration Report
*HistoricProcessInstanceApi* | [**get_historic_process_instances**](docs/HistoricProcessInstanceApi.md#get_historic_process_instances) | **GET** /history/process-instance | Get List
*HistoricProcessInstanceApi* | [**get_historic_process_instances_count**](docs/HistoricProcessInstanceApi.md#get_historic_process_instances_count) | **GET** /history/process-instance/count | Get List Count
*HistoricProcessInstanceApi* | [**query_historic_process_instances**](docs/HistoricProcessInstanceApi.md#query_historic_process_instances) | **POST** /history/process-instance | Get List (POST)
*HistoricProcessInstanceApi* | [**query_historic_process_instances_count**](docs/HistoricProcessInstanceApi.md#query_historic_process_instances_count) | **POST** /history/process-instance/count | Get List Count (POST)
*HistoricProcessInstanceApi* | [**set_removal_time_async**](docs/HistoricProcessInstanceApi.md#set_removal_time_async) | **POST** /history/process-instance/set-removal-time | Set Removal Time Async (POST)
*HistoricTaskInstanceApi* | [**get_historic_task_instance_report**](docs/HistoricTaskInstanceApi.md#get_historic_task_instance_report) | **GET** /history/task/report | Get Task Report (Historic)
*HistoricTaskInstanceApi* | [**get_historic_task_instances**](docs/HistoricTaskInstanceApi.md#get_historic_task_instances) | **GET** /history/task | Get Tasks (Historic)
*HistoricTaskInstanceApi* | [**get_historic_task_instances_count**](docs/HistoricTaskInstanceApi.md#get_historic_task_instances_count) | **GET** /history/task/count | Get Task Count
*HistoricTaskInstanceApi* | [**query_historic_task_instances**](docs/HistoricTaskInstanceApi.md#query_historic_task_instances) | **POST** /history/task | Get Tasks (Historic) (POST)
*HistoricTaskInstanceApi* | [**query_historic_task_instances_count**](docs/HistoricTaskInstanceApi.md#query_historic_task_instances_count) | **POST** /history/task/count | Get Task Count (POST)
*HistoricUserOperationLogApi* | [**clear_annotation_user_operation_log**](docs/HistoricUserOperationLogApi.md#clear_annotation_user_operation_log) | **PUT** /history/user-operation/{operationId}/clear-annotation | Clear Annotation of an User Operation Log (Historic)
*HistoricUserOperationLogApi* | [**query_user_operation_count**](docs/HistoricUserOperationLogApi.md#query_user_operation_count) | **GET** /history/user-operation/count | Get User Operation Log Count
*HistoricUserOperationLogApi* | [**query_user_operation_entries**](docs/HistoricUserOperationLogApi.md#query_user_operation_entries) | **GET** /history/user-operation | Get User Operation Log (Historic)
*HistoricUserOperationLogApi* | [**set_annotation_user_operation_log**](docs/HistoricUserOperationLogApi.md#set_annotation_user_operation_log) | **PUT** /history/user-operation/{operationId}/set-annotation | Set Annotation to an User Operation Log (Historic)
*HistoricVariableInstanceApi* | [**delete_historic_variable_instance**](docs/HistoricVariableInstanceApi.md#delete_historic_variable_instance) | **DELETE** /history/variable-instance/{id} | Delete Variable Instance
*HistoricVariableInstanceApi* | [**get_historic_variable_instance**](docs/HistoricVariableInstanceApi.md#get_historic_variable_instance) | **GET** /history/variable-instance/{id} | Get Variable Instance
*HistoricVariableInstanceApi* | [**get_historic_variable_instance_binary**](docs/HistoricVariableInstanceApi.md#get_historic_variable_instance_binary) | **GET** /history/variable-instance/{id}/data | Get Variable Instance (Binary)
*HistoricVariableInstanceApi* | [**get_historic_variable_instances**](docs/HistoricVariableInstanceApi.md#get_historic_variable_instances) | **GET** /history/variable-instance | Get Variable Instances
*HistoricVariableInstanceApi* | [**get_historic_variable_instances_count**](docs/HistoricVariableInstanceApi.md#get_historic_variable_instances_count) | **GET** /history/variable-instance/count | Get Variable Instance Count
*HistoricVariableInstanceApi* | [**query_historic_variable_instances**](docs/HistoricVariableInstanceApi.md#query_historic_variable_instances) | **POST** /history/variable-instance | Get Variable Instances (POST)
*HistoricVariableInstanceApi* | [**query_historic_variable_instances_count**](docs/HistoricVariableInstanceApi.md#query_historic_variable_instances_count) | **POST** /history/variable-instance/count | Get Variable Instance Count (POST)
*HistoryCleanupApi* | [**cleanup_async**](docs/HistoryCleanupApi.md#cleanup_async) | **POST** /history/cleanup | Clean up history (POST)
*HistoryCleanupApi* | [**find_cleanup_job**](docs/HistoryCleanupApi.md#find_cleanup_job) | **GET** /history/cleanup/job | Find clean up history job (GET)
*HistoryCleanupApi* | [**find_cleanup_jobs**](docs/HistoryCleanupApi.md#find_cleanup_jobs) | **GET** /history/cleanup/jobs | Find clean up history jobs (GET)
*HistoryCleanupApi* | [**get_history_cleanup_configuration**](docs/HistoryCleanupApi.md#get_history_cleanup_configuration) | **GET** /history/cleanup/configuration | Get History Cleanup Configuration
*IdentityApi* | [**check_password**](docs/IdentityApi.md#check_password) | **POST** /identity/password-policy | Validate Password
*IdentityApi* | [**get_group_info**](docs/IdentityApi.md#get_group_info) | **GET** /identity/groups | Get a User&#39;s Groups
*IdentityApi* | [**get_password_policy**](docs/IdentityApi.md#get_password_policy) | **GET** /identity/password-policy | Get Password Policy
*IdentityApi* | [**verify_user**](docs/IdentityApi.md#verify_user) | **POST** /identity/verify | Verify User
*IncidentApi* | [**clear_incident_annotation**](docs/IncidentApi.md#clear_incident_annotation) | **DELETE** /incident/{id}/annotation | Clear Incident Annotation
*IncidentApi* | [**get_incident**](docs/IncidentApi.md#get_incident) | **GET** /incident/{id} | Get Incident
*IncidentApi* | [**get_incidents**](docs/IncidentApi.md#get_incidents) | **GET** /incident | Get List
*IncidentApi* | [**get_incidents_count**](docs/IncidentApi.md#get_incidents_count) | **GET** /incident/count | Get List Count
*IncidentApi* | [**resolve_incident**](docs/IncidentApi.md#resolve_incident) | **DELETE** /incident/{id} | Resolve Incident
*IncidentApi* | [**set_incident_annotation**](docs/IncidentApi.md#set_incident_annotation) | **PUT** /incident/{id}/annotation | Set Incident Annotation
*JobApi* | [**execute_job**](docs/JobApi.md#execute_job) | **POST** /job/{id}/execute | Execute Job
*JobApi* | [**get_job**](docs/JobApi.md#get_job) | **GET** /job/{id} | Get Job
*JobApi* | [**get_jobs**](docs/JobApi.md#get_jobs) | **GET** /job | Get Jobs
*JobApi* | [**get_jobs_count**](docs/JobApi.md#get_jobs_count) | **GET** /job/count | Get Job Count
*JobApi* | [**get_stacktrace**](docs/JobApi.md#get_stacktrace) | **GET** /job/{id}/stacktrace | Get Exception Stacktrace
*JobApi* | [**query_jobs**](docs/JobApi.md#query_jobs) | **POST** /job | Get Jobs (POST)
*JobApi* | [**query_jobs_count**](docs/JobApi.md#query_jobs_count) | **POST** /job/count | Get Job Count (POST)
*JobApi* | [**recalculate_duedate**](docs/JobApi.md#recalculate_duedate) | **POST** /job/{id}/duedate/recalculate | Recalculate Job Due Date
*JobApi* | [**set_job_duedate**](docs/JobApi.md#set_job_duedate) | **PUT** /job/{id}/duedate | Set Job Due Date
*JobApi* | [**set_job_priority**](docs/JobApi.md#set_job_priority) | **PUT** /job/{id}/priority | Set Job Priority
*JobApi* | [**set_job_retries**](docs/JobApi.md#set_job_retries) | **PUT** /job/{id}/retries | Set Job Retries
*JobApi* | [**set_job_retries_async_operation**](docs/JobApi.md#set_job_retries_async_operation) | **POST** /job/retries | Set Job Retries Async (POST)
*JobApi* | [**update_job_suspension_state**](docs/JobApi.md#update_job_suspension_state) | **PUT** /job/{id}/suspended | Activate/Suspend Job By Id
*JobApi* | [**update_suspension_state_by**](docs/JobApi.md#update_suspension_state_by) | **PUT** /job/suspended | Activate/Suspend Jobs
*JobDefinitionApi* | [**get_job_definition**](docs/JobDefinitionApi.md#get_job_definition) | **GET** /job-definition/{id} | Get Job Definition
*JobDefinitionApi* | [**get_job_definitions**](docs/JobDefinitionApi.md#get_job_definitions) | **GET** /job-definition | Get Job Definitions
*JobDefinitionApi* | [**get_job_definitions_count**](docs/JobDefinitionApi.md#get_job_definitions_count) | **GET** /job-definition/count | Get Job Definition Count
*JobDefinitionApi* | [**query_job_definitions**](docs/JobDefinitionApi.md#query_job_definitions) | **POST** /job-definition | Get Job Definitions (POST)
*JobDefinitionApi* | [**query_job_definitions_count**](docs/JobDefinitionApi.md#query_job_definitions_count) | **POST** /job-definition/count | Get Job Definition Count (POST)
*JobDefinitionApi* | [**set_job_priority_job_definition**](docs/JobDefinitionApi.md#set_job_priority_job_definition) | **PUT** /job-definition/{id}/jobPriority | Set Job Definition Priority by Id
*JobDefinitionApi* | [**set_job_retries_job_definition**](docs/JobDefinitionApi.md#set_job_retries_job_definition) | **PUT** /job-definition/{id}/retries | Set Job Retries By Job Definition Id
*JobDefinitionApi* | [**update_suspension_state_job_definition**](docs/JobDefinitionApi.md#update_suspension_state_job_definition) | **PUT** /job-definition/{id}/suspended | Activate/Suspend Job Definition By Id
*JobDefinitionApi* | [**update_suspension_state_job_definitions**](docs/JobDefinitionApi.md#update_suspension_state_job_definitions) | **PUT** /job-definition/suspended | Activate/Suspend Job Definitions
*MessageApi* | [**deliver_message**](docs/MessageApi.md#deliver_message) | **POST** /message | Correlate
*MetricsApi* | [**delete_task_metrics**](docs/MetricsApi.md#delete_task_metrics) | **DELETE** /metrics/task-worker | Delete Task Worker Metrics
*MetricsApi* | [**get_metrics**](docs/MetricsApi.md#get_metrics) | **GET** /metrics/{metrics-name}/sum | Get Sum
*MetricsApi* | [**interval**](docs/MetricsApi.md#interval) | **GET** /metrics | Get Metrics in Interval
*MigrationApi* | [**execute_migration_plan**](docs/MigrationApi.md#execute_migration_plan) | **POST** /migration/execute | Execute Migration Plan
*MigrationApi* | [**execute_migration_plan_async**](docs/MigrationApi.md#execute_migration_plan_async) | **POST** /migration/executeAsync | Execute Migration Plan Async (Batch)
*MigrationApi* | [**generate_migration_plan**](docs/MigrationApi.md#generate_migration_plan) | **POST** /migration/generate | Generate Migration Plan
*MigrationApi* | [**validate_migration_plan**](docs/MigrationApi.md#validate_migration_plan) | **POST** /migration/validate | Validate Migration Plan
*ModificationApi* | [**execute_modification**](docs/ModificationApi.md#execute_modification) | **POST** /modification/execute | Execute Modification
*ModificationApi* | [**execute_modification_async**](docs/ModificationApi.md#execute_modification_async) | **POST** /modification/executeAsync | Execute Modification Async (Batch)
*ProcessDefinitionApi* | [**delete_process_definition**](docs/ProcessDefinitionApi.md#delete_process_definition) | **DELETE** /process-definition/{id} | Delete
*ProcessDefinitionApi* | [**delete_process_definitions_by_key**](docs/ProcessDefinitionApi.md#delete_process_definitions_by_key) | **DELETE** /process-definition/key/{key} | Delete By Key
*ProcessDefinitionApi* | [**delete_process_definitions_by_key_and_tenant_id**](docs/ProcessDefinitionApi.md#delete_process_definitions_by_key_and_tenant_id) | **DELETE** /process-definition/key/{key}/tenant-id/{tenant-id} | Delete By Key
*ProcessDefinitionApi* | [**get_activity_statistics**](docs/ProcessDefinitionApi.md#get_activity_statistics) | **GET** /process-definition/{id}/statistics | Get Activity Instance Statistics
*ProcessDefinitionApi* | [**get_activity_statistics_by_process_definition_key**](docs/ProcessDefinitionApi.md#get_activity_statistics_by_process_definition_key) | **GET** /process-definition/key/{key}/statistics | Get Activity Instance Statistics
*ProcessDefinitionApi* | [**get_activity_statistics_by_process_definition_key_and_tenant_id**](docs/ProcessDefinitionApi.md#get_activity_statistics_by_process_definition_key_and_tenant_id) | **GET** /process-definition/key/{key}/tenant-id/{tenant-id}/statistics | Get Activity Instance Statistics
*ProcessDefinitionApi* | [**get_deployed_start_form**](docs/ProcessDefinitionApi.md#get_deployed_start_form) | **GET** /process-definition/{id}/deployed-start-form | Get Deployed Start Form
*ProcessDefinitionApi* | [**get_deployed_start_form_by_key**](docs/ProcessDefinitionApi.md#get_deployed_start_form_by_key) | **GET** /process-definition/key/{key}/deployed-start-form | Get Deployed Start Form
*ProcessDefinitionApi* | [**get_deployed_start_form_by_key_and_tenant_id**](docs/ProcessDefinitionApi.md#get_deployed_start_form_by_key_and_tenant_id) | **GET** /process-definition/key/{key}/tenant-id/{tenant-id}/deployed-start-form | Get Deployed Start Form
*ProcessDefinitionApi* | [**get_latest_process_definition_by_tenant_id**](docs/ProcessDefinitionApi.md#get_latest_process_definition_by_tenant_id) | **GET** /process-definition/key/{key}/tenant-id/{tenant-id} | Get
*ProcessDefinitionApi* | [**get_process_definition**](docs/ProcessDefinitionApi.md#get_process_definition) | **GET** /process-definition/{id} | Get
*ProcessDefinitionApi* | [**get_process_definition_bpmn20_xml**](docs/ProcessDefinitionApi.md#get_process_definition_bpmn20_xml) | **GET** /process-definition/{id}/xml | Get XML
*ProcessDefinitionApi* | [**get_process_definition_bpmn20_xml_by_key**](docs/ProcessDefinitionApi.md#get_process_definition_bpmn20_xml_by_key) | **GET** /process-definition/key/{key}/xml | Get XML
*ProcessDefinitionApi* | [**get_process_definition_bpmn20_xml_by_key_and_tenant_id**](docs/ProcessDefinitionApi.md#get_process_definition_bpmn20_xml_by_key_and_tenant_id) | **GET** /process-definition/key/{key}/tenant-id/{tenant-id}/xml | Get XML
*ProcessDefinitionApi* | [**get_process_definition_by_key**](docs/ProcessDefinitionApi.md#get_process_definition_by_key) | **GET** /process-definition/key/{key} | Get
*ProcessDefinitionApi* | [**get_process_definition_diagram**](docs/ProcessDefinitionApi.md#get_process_definition_diagram) | **GET** /process-definition/{id}/diagram | Get Diagram
*ProcessDefinitionApi* | [**get_process_definition_diagram_by_key**](docs/ProcessDefinitionApi.md#get_process_definition_diagram_by_key) | **GET** /process-definition/key/{key}/diagram | Get Diagram
*ProcessDefinitionApi* | [**get_process_definition_diagram_by_key_and_tenant_id**](docs/ProcessDefinitionApi.md#get_process_definition_diagram_by_key_and_tenant_id) | **GET** /process-definition/key/{key}/tenant-id/{tenant-id}/diagram | Get Diagram
*ProcessDefinitionApi* | [**get_process_definition_statistics**](docs/ProcessDefinitionApi.md#get_process_definition_statistics) | **GET** /process-definition/statistics | Get Process Instance Statistics
*ProcessDefinitionApi* | [**get_process_definitions**](docs/ProcessDefinitionApi.md#get_process_definitions) | **GET** /process-definition | Get List
*ProcessDefinitionApi* | [**get_process_definitions_count**](docs/ProcessDefinitionApi.md#get_process_definitions_count) | **GET** /process-definition/count | Get List Count
*ProcessDefinitionApi* | [**get_rendered_start_form**](docs/ProcessDefinitionApi.md#get_rendered_start_form) | **GET** /process-definition/{id}/rendered-form | Get Rendered Start Form
*ProcessDefinitionApi* | [**get_rendered_start_form_by_key**](docs/ProcessDefinitionApi.md#get_rendered_start_form_by_key) | **GET** /process-definition/key/{key}/rendered-form | Get Rendered Start Form
*ProcessDefinitionApi* | [**get_rendered_start_form_by_key_and_tenant_id**](docs/ProcessDefinitionApi.md#get_rendered_start_form_by_key_and_tenant_id) | **GET** /process-definition/key/{key}/tenant-id/{tenant-id}/rendered-form | Get Rendered Start Form
*ProcessDefinitionApi* | [**get_start_form**](docs/ProcessDefinitionApi.md#get_start_form) | **GET** /process-definition/{id}/startForm | Get Start Form Key
*ProcessDefinitionApi* | [**get_start_form_by_key**](docs/ProcessDefinitionApi.md#get_start_form_by_key) | **GET** /process-definition/key/{key}/startForm | Get Start Form Key
*ProcessDefinitionApi* | [**get_start_form_by_key_and_tenant_id**](docs/ProcessDefinitionApi.md#get_start_form_by_key_and_tenant_id) | **GET** /process-definition/key/{key}/tenant-id/{tenant-id}/startForm | Get Start Form Key
*ProcessDefinitionApi* | [**get_start_form_variables**](docs/ProcessDefinitionApi.md#get_start_form_variables) | **GET** /process-definition/{id}/form-variables | Get Start Form Variables
*ProcessDefinitionApi* | [**get_start_form_variables_by_key**](docs/ProcessDefinitionApi.md#get_start_form_variables_by_key) | **GET** /process-definition/key/{key}/form-variables | Get Start Form Variables
*ProcessDefinitionApi* | [**get_start_form_variables_by_key_and_tenant_id**](docs/ProcessDefinitionApi.md#get_start_form_variables_by_key_and_tenant_id) | **GET** /process-definition/key/{key}/tenant-id/{tenant-id}/form-variables | Get Start Form Variables
*ProcessDefinitionApi* | [**get_static_called_process_definitions**](docs/ProcessDefinitionApi.md#get_static_called_process_definitions) | **GET** /process-definition/{id}/static-called-process-definitions | Get Static Called Process Definitions
*ProcessDefinitionApi* | [**restart_process_instance**](docs/ProcessDefinitionApi.md#restart_process_instance) | **POST** /process-definition/{id}/restart | Restart Process Instance
*ProcessDefinitionApi* | [**restart_process_instance_async_operation**](docs/ProcessDefinitionApi.md#restart_process_instance_async_operation) | **POST** /process-definition/{id}/restart-async | Restart Process Instance Async
*ProcessDefinitionApi* | [**start_process_instance**](docs/ProcessDefinitionApi.md#start_process_instance) | **POST** /process-definition/{id}/start | Start Instance
*ProcessDefinitionApi* | [**start_process_instance_by_key**](docs/ProcessDefinitionApi.md#start_process_instance_by_key) | **POST** /process-definition/key/{key}/start | Start Instance
*ProcessDefinitionApi* | [**start_process_instance_by_key_and_tenant_id**](docs/ProcessDefinitionApi.md#start_process_instance_by_key_and_tenant_id) | **POST** /process-definition/key/{key}/tenant-id/{tenant-id}/start | Start Instance
*ProcessDefinitionApi* | [**submit_form**](docs/ProcessDefinitionApi.md#submit_form) | **POST** /process-definition/{id}/submit-form | Submit Start Form
*ProcessDefinitionApi* | [**submit_form_by_key**](docs/ProcessDefinitionApi.md#submit_form_by_key) | **POST** /process-definition/key/{key}/submit-form | Submit Start Form
*ProcessDefinitionApi* | [**submit_form_by_key_and_tenant_id**](docs/ProcessDefinitionApi.md#submit_form_by_key_and_tenant_id) | **POST** /process-definition/key/{key}/tenant-id/{tenant-id}/submit-form | Submit Start Form
*ProcessDefinitionApi* | [**update_history_time_to_live_by_process_definition_id**](docs/ProcessDefinitionApi.md#update_history_time_to_live_by_process_definition_id) | **PUT** /process-definition/{id}/history-time-to-live | Update History Time to Live
*ProcessDefinitionApi* | [**update_history_time_to_live_by_process_definition_key**](docs/ProcessDefinitionApi.md#update_history_time_to_live_by_process_definition_key) | **PUT** /process-definition/key/{key}/history-time-to-live | Update History Time to Live
*ProcessDefinitionApi* | [**update_history_time_to_live_by_process_definition_key_and_tenant_id**](docs/ProcessDefinitionApi.md#update_history_time_to_live_by_process_definition_key_and_tenant_id) | **PUT** /process-definition/key/{key}/tenant-id/{tenant-id}/history-time-to-live | Update History Time to Live
*ProcessDefinitionApi* | [**update_process_definition_suspension_state**](docs/ProcessDefinitionApi.md#update_process_definition_suspension_state) | **PUT** /process-definition/suspended | Activate/Suspend By Key
*ProcessDefinitionApi* | [**update_process_definition_suspension_state_by_id**](docs/ProcessDefinitionApi.md#update_process_definition_suspension_state_by_id) | **PUT** /process-definition/{id}/suspended | Activate/Suspend By Id
*ProcessDefinitionApi* | [**update_process_definition_suspension_state_by_key**](docs/ProcessDefinitionApi.md#update_process_definition_suspension_state_by_key) | **PUT** /process-definition/key/{key}/suspended | Activate/Suspend by Id
*ProcessDefinitionApi* | [**update_process_definition_suspension_state_by_key_and_tenant_id**](docs/ProcessDefinitionApi.md#update_process_definition_suspension_state_by_key_and_tenant_id) | **PUT** /process-definition/key/{key}/tenant-id/{tenant-id}/suspended | Activate/Suspend by Id
*ProcessInstanceApi* | [**correlate_message_async_operation**](docs/ProcessInstanceApi.md#correlate_message_async_operation) | **POST** /process-instance/message-async | Correlate Message Async (POST)
*ProcessInstanceApi* | [**delete_async_historic_query_based**](docs/ProcessInstanceApi.md#delete_async_historic_query_based) | **POST** /process-instance/delete-historic-query-based | Delete Async Historic Query Based (POST)
*ProcessInstanceApi* | [**delete_process_instance**](docs/ProcessInstanceApi.md#delete_process_instance) | **DELETE** /process-instance/{id} | Delete
*ProcessInstanceApi* | [**delete_process_instance_variable**](docs/ProcessInstanceApi.md#delete_process_instance_variable) | **DELETE** /process-instance/{id}/variables/{varName} | Delete Process Variable
*ProcessInstanceApi* | [**delete_process_instances_async_operation**](docs/ProcessInstanceApi.md#delete_process_instances_async_operation) | **POST** /process-instance/delete | Delete Async (POST)
*ProcessInstanceApi* | [**get_activity_instance_tree**](docs/ProcessInstanceApi.md#get_activity_instance_tree) | **GET** /process-instance/{id}/activity-instances | Get Activity Instance
*ProcessInstanceApi* | [**get_process_instance**](docs/ProcessInstanceApi.md#get_process_instance) | **GET** /process-instance/{id} | Get Process Instance
*ProcessInstanceApi* | [**get_process_instance_variable**](docs/ProcessInstanceApi.md#get_process_instance_variable) | **GET** /process-instance/{id}/variables/{varName} | Get Process Variable
*ProcessInstanceApi* | [**get_process_instance_variable_binary**](docs/ProcessInstanceApi.md#get_process_instance_variable_binary) | **GET** /process-instance/{id}/variables/{varName}/data | Get Process Variable (Binary)
*ProcessInstanceApi* | [**get_process_instance_variables**](docs/ProcessInstanceApi.md#get_process_instance_variables) | **GET** /process-instance/{id}/variables | Get Process Variables
*ProcessInstanceApi* | [**get_process_instances**](docs/ProcessInstanceApi.md#get_process_instances) | **GET** /process-instance | Get List
*ProcessInstanceApi* | [**get_process_instances_count**](docs/ProcessInstanceApi.md#get_process_instances_count) | **GET** /process-instance/count | Get List Count
*ProcessInstanceApi* | [**modify_process_instance**](docs/ProcessInstanceApi.md#modify_process_instance) | **POST** /process-instance/{id}/modification | Modify Process Instance Execution State
*ProcessInstanceApi* | [**modify_process_instance_async_operation**](docs/ProcessInstanceApi.md#modify_process_instance_async_operation) | **POST** /process-instance/{id}/modification-async | Modify Process Instance Execution State Async
*ProcessInstanceApi* | [**modify_process_instance_variables**](docs/ProcessInstanceApi.md#modify_process_instance_variables) | **POST** /process-instance/{id}/variables | Update/Delete Process Variables
*ProcessInstanceApi* | [**query_process_instances**](docs/ProcessInstanceApi.md#query_process_instances) | **POST** /process-instance | Get List (POST)
*ProcessInstanceApi* | [**query_process_instances_count**](docs/ProcessInstanceApi.md#query_process_instances_count) | **POST** /process-instance/count | Get List Count (POST)
*ProcessInstanceApi* | [**set_process_instance_variable**](docs/ProcessInstanceApi.md#set_process_instance_variable) | **PUT** /process-instance/{id}/variables/{varName} | Update Process Variable
*ProcessInstanceApi* | [**set_process_instance_variable_binary**](docs/ProcessInstanceApi.md#set_process_instance_variable_binary) | **POST** /process-instance/{id}/variables/{varName}/data | Update Process Variable (Binary)
*ProcessInstanceApi* | [**set_retries_by_process**](docs/ProcessInstanceApi.md#set_retries_by_process) | **POST** /process-instance/job-retries | Set Job Retries Async (POST)
*ProcessInstanceApi* | [**set_retries_by_process_historic_query_based**](docs/ProcessInstanceApi.md#set_retries_by_process_historic_query_based) | **POST** /process-instance/job-retries-historic-query-based | Set Job Retries Async Historic Query Based (POST)
*ProcessInstanceApi* | [**set_variables_async_operation**](docs/ProcessInstanceApi.md#set_variables_async_operation) | **POST** /process-instance/variables-async | Set Variables Async (POST)
*ProcessInstanceApi* | [**update_suspension_state**](docs/ProcessInstanceApi.md#update_suspension_state) | **PUT** /process-instance/suspended | Activate/Suspend In Group
*ProcessInstanceApi* | [**update_suspension_state_async_operation**](docs/ProcessInstanceApi.md#update_suspension_state_async_operation) | **POST** /process-instance/suspended-async | Activate/Suspend In Batch
*ProcessInstanceApi* | [**update_suspension_state_by_id**](docs/ProcessInstanceApi.md#update_suspension_state_by_id) | **PUT** /process-instance/{id}/suspended | Activate/Suspend Process Instance By Id
*SchemaLogApi* | [**get_schema_log**](docs/SchemaLogApi.md#get_schema_log) | **GET** /schema/log | Get List
*SchemaLogApi* | [**query_schema_log**](docs/SchemaLogApi.md#query_schema_log) | **POST** /schema/log | Get List (POST)
*SignalApi* | [**throw_signal**](docs/SignalApi.md#throw_signal) | **POST** /signal | Event
*TaskApi* | [**claim**](docs/TaskApi.md#claim) | **POST** /task/{id}/claim | Claim
*TaskApi* | [**complete**](docs/TaskApi.md#complete) | **POST** /task/{id}/complete | Complete
*TaskApi* | [**create_task**](docs/TaskApi.md#create_task) | **POST** /task/create | Create
*TaskApi* | [**delegate_task**](docs/TaskApi.md#delegate_task) | **POST** /task/{id}/delegate | Delegate
*TaskApi* | [**delete_task**](docs/TaskApi.md#delete_task) | **DELETE** /task/{id} | Delete
*TaskApi* | [**get_deployed_form**](docs/TaskApi.md#get_deployed_form) | **GET** /task/{id}/deployed-form | Get Deployed Form
*TaskApi* | [**get_form**](docs/TaskApi.md#get_form) | **GET** /task/{id}/form | Get Form Key
*TaskApi* | [**get_form_variables**](docs/TaskApi.md#get_form_variables) | **GET** /task/{id}/form-variables | Get Task Form Variables
*TaskApi* | [**get_rendered_form**](docs/TaskApi.md#get_rendered_form) | **GET** /task/{id}/rendered-form | Get Rendered Form
*TaskApi* | [**get_task**](docs/TaskApi.md#get_task) | **GET** /task/{id} | Get
*TaskApi* | [**get_tasks**](docs/TaskApi.md#get_tasks) | **GET** /task | Get List
*TaskApi* | [**get_tasks_count**](docs/TaskApi.md#get_tasks_count) | **GET** /task/count | Get List Count
*TaskApi* | [**handle_bpmn_error**](docs/TaskApi.md#handle_bpmn_error) | **POST** /task/{id}/bpmnError | Handle BPMN Error
*TaskApi* | [**handle_escalation**](docs/TaskApi.md#handle_escalation) | **POST** /task/{id}/bpmnEscalation | Handle BPMN Escalation
*TaskApi* | [**query_tasks**](docs/TaskApi.md#query_tasks) | **POST** /task | Get List (POST)
*TaskApi* | [**query_tasks_count**](docs/TaskApi.md#query_tasks_count) | **POST** /task/count | Get List Count (POST)
*TaskApi* | [**resolve**](docs/TaskApi.md#resolve) | **POST** /task/{id}/resolve | Resolve
*TaskApi* | [**set_assignee**](docs/TaskApi.md#set_assignee) | **POST** /task/{id}/assignee | Set Assignee
*TaskApi* | [**submit**](docs/TaskApi.md#submit) | **POST** /task/{id}/submit-form | Submit Form
*TaskApi* | [**unclaim**](docs/TaskApi.md#unclaim) | **POST** /task/{id}/unclaim | Unclaim
*TaskApi* | [**update_task**](docs/TaskApi.md#update_task) | **PUT** /task/{id} | Update
*TaskAttachmentApi* | [**add_attachment**](docs/TaskAttachmentApi.md#add_attachment) | **POST** /task/{id}/attachment/create | Create
*TaskAttachmentApi* | [**delete_attachment**](docs/TaskAttachmentApi.md#delete_attachment) | **DELETE** /task/{id}/attachment/{attachmentId} | Delete
*TaskAttachmentApi* | [**get_attachment**](docs/TaskAttachmentApi.md#get_attachment) | **GET** /task/{id}/attachment/{attachmentId} | Get
*TaskAttachmentApi* | [**get_attachment_data**](docs/TaskAttachmentApi.md#get_attachment_data) | **GET** /task/{id}/attachment/{attachmentId}/data | Get (Binary)
*TaskAttachmentApi* | [**get_attachments**](docs/TaskAttachmentApi.md#get_attachments) | **GET** /task/{id}/attachment | Get List
*TaskCommentApi* | [**create_comment**](docs/TaskCommentApi.md#create_comment) | **POST** /task/{id}/comment/create | Create
*TaskCommentApi* | [**get_comment**](docs/TaskCommentApi.md#get_comment) | **GET** /task/{id}/comment/{commentId} | Get
*TaskCommentApi* | [**get_comments**](docs/TaskCommentApi.md#get_comments) | **GET** /task/{id}/comment | Get List
*TaskIdentityLinkApi* | [**add_identity_link**](docs/TaskIdentityLinkApi.md#add_identity_link) | **POST** /task/{id}/identity-links | Add
*TaskIdentityLinkApi* | [**delete_identity_link**](docs/TaskIdentityLinkApi.md#delete_identity_link) | **POST** /task/{id}/identity-links/delete | Delete
*TaskIdentityLinkApi* | [**get_identity_links**](docs/TaskIdentityLinkApi.md#get_identity_links) | **GET** /task/{id}/identity-links | Get List
*TaskLocalVariableApi* | [**delete_task_local_variable**](docs/TaskLocalVariableApi.md#delete_task_local_variable) | **DELETE** /task/{id}/localVariables/{varName} | Delete Local Task Variable
*TaskLocalVariableApi* | [**get_task_local_variable**](docs/TaskLocalVariableApi.md#get_task_local_variable) | **GET** /task/{id}/localVariables/{varName} | Get Local Task Variable
*TaskLocalVariableApi* | [**get_task_local_variable_binary**](docs/TaskLocalVariableApi.md#get_task_local_variable_binary) | **GET** /task/{id}/localVariables/{varName}/data | Get Local Task Variable (Binary)
*TaskLocalVariableApi* | [**get_task_local_variables**](docs/TaskLocalVariableApi.md#get_task_local_variables) | **GET** /task/{id}/localVariables | Get Local Task Variables
*TaskLocalVariableApi* | [**modify_task_local_variables**](docs/TaskLocalVariableApi.md#modify_task_local_variables) | **POST** /task/{id}/localVariables | Update/Delete Local Task Variables
*TaskLocalVariableApi* | [**put_task_local_variable**](docs/TaskLocalVariableApi.md#put_task_local_variable) | **PUT** /task/{id}/localVariables/{varName} | Update Local Task Variable
*TaskLocalVariableApi* | [**set_binary_task_local_variable**](docs/TaskLocalVariableApi.md#set_binary_task_local_variable) | **POST** /task/{id}/localVariables/{varName}/data | Update Local Task Variable (Binary)
*TaskVariableApi* | [**delete_task_variable**](docs/TaskVariableApi.md#delete_task_variable) | **DELETE** /task/{id}/variables/{varName} | Delete Task Variable
*TaskVariableApi* | [**get_task_variable**](docs/TaskVariableApi.md#get_task_variable) | **GET** /task/{id}/variables/{varName} | Get Task Variable
*TaskVariableApi* | [**get_task_variable_binary**](docs/TaskVariableApi.md#get_task_variable_binary) | **GET** /task/{id}/variables/{varName}/data | Get Task Variable (Binary)
*TaskVariableApi* | [**get_task_variables**](docs/TaskVariableApi.md#get_task_variables) | **GET** /task/{id}/variables | Get Task Variables
*TaskVariableApi* | [**modify_task_variables**](docs/TaskVariableApi.md#modify_task_variables) | **POST** /task/{id}/variables | Update/Delete Task Variables
*TaskVariableApi* | [**put_task_variable**](docs/TaskVariableApi.md#put_task_variable) | **PUT** /task/{id}/variables/{varName} | Update Task Variable
*TaskVariableApi* | [**set_binary_task_variable**](docs/TaskVariableApi.md#set_binary_task_variable) | **POST** /task/{id}/variables/{varName}/data | Update Task Variable (Binary)
*TelemetryApi* | [**configure_telemetry**](docs/TelemetryApi.md#configure_telemetry) | **POST** /telemetry/configuration | Configure Telemetry
*TelemetryApi* | [**get_telemetry_configuration**](docs/TelemetryApi.md#get_telemetry_configuration) | **GET** /telemetry/configuration | Fetch Telemetry Configuration
*TenantApi* | [**available_tenant_group_members_operations**](docs/TenantApi.md#available_tenant_group_members_operations) | **OPTIONS** /tenant/{id}/group-members | Tenant Group Membership Resource Options
*TenantApi* | [**available_tenant_instance_operations**](docs/TenantApi.md#available_tenant_instance_operations) | **OPTIONS** /tenant/{id} | Tenant Resource Options
*TenantApi* | [**available_tenant_resource_operations**](docs/TenantApi.md#available_tenant_resource_operations) | **OPTIONS** /tenant | Tenant Resource Options
*TenantApi* | [**available_tenant_user_members_operations**](docs/TenantApi.md#available_tenant_user_members_operations) | **OPTIONS** /tenant/{id}/user-members | Tenant User Membership Resource Options
*TenantApi* | [**create_group_membership**](docs/TenantApi.md#create_group_membership) | **PUT** /tenant/{id}/group-members/{groupId} | Create Tenant Group Membership
*TenantApi* | [**create_tenant**](docs/TenantApi.md#create_tenant) | **POST** /tenant/create | Create Tenant
*TenantApi* | [**create_user_membership**](docs/TenantApi.md#create_user_membership) | **PUT** /tenant/{id}/user-members/{userId} | Create Tenant User Membership
*TenantApi* | [**delete_group_membership**](docs/TenantApi.md#delete_group_membership) | **DELETE** /tenant/{id}/group-members/{groupId} | Create Tenant Group Membership
*TenantApi* | [**delete_tenant**](docs/TenantApi.md#delete_tenant) | **DELETE** /tenant/{id} | Delete Tenant
*TenantApi* | [**delete_user_membership**](docs/TenantApi.md#delete_user_membership) | **DELETE** /tenant/{id}/user-members/{userId} | Delete a Tenant User Membership
*TenantApi* | [**get_tenant**](docs/TenantApi.md#get_tenant) | **GET** /tenant/{id} | Get Tenant
*TenantApi* | [**get_tenant_count**](docs/TenantApi.md#get_tenant_count) | **GET** /tenant/count | Get Tenant Count
*TenantApi* | [**query_tenants**](docs/TenantApi.md#query_tenants) | **GET** /tenant | Get Tenants
*TenantApi* | [**update_tenant**](docs/TenantApi.md#update_tenant) | **PUT** /tenant/{id} | Update Tenant
*UserApi* | [**available_operations**](docs/UserApi.md#available_operations) | **OPTIONS** /user | Options
*UserApi* | [**available_user_operations**](docs/UserApi.md#available_user_operations) | **OPTIONS** /user/{id} | Options
*UserApi* | [**create_user**](docs/UserApi.md#create_user) | **POST** /user/create | Create
*UserApi* | [**delete_user**](docs/UserApi.md#delete_user) | **DELETE** /user/{id} | Delete
*UserApi* | [**get_user_count**](docs/UserApi.md#get_user_count) | **GET** /user/count | Get List Count
*UserApi* | [**get_user_profile**](docs/UserApi.md#get_user_profile) | **GET** /user/{id}/profile | Get Profile
*UserApi* | [**get_users**](docs/UserApi.md#get_users) | **GET** /user | Get List
*UserApi* | [**unlock_user**](docs/UserApi.md#unlock_user) | **POST** /user/{id}/unlock | Unlock User
*UserApi* | [**update_credentials**](docs/UserApi.md#update_credentials) | **PUT** /user/{id}/credentials | Update Credentials
*UserApi* | [**update_profile**](docs/UserApi.md#update_profile) | **PUT** /user/{id}/profile | Update User Profile
*VariableInstanceApi* | [**get_variable_instance**](docs/VariableInstanceApi.md#get_variable_instance) | **GET** /variable-instance/{id} | Get Variable Instance
*VariableInstanceApi* | [**get_variable_instance_binary**](docs/VariableInstanceApi.md#get_variable_instance_binary) | **GET** /variable-instance/{id}/data | Get Variable Instance (Binary)
*VariableInstanceApi* | [**get_variable_instances**](docs/VariableInstanceApi.md#get_variable_instances) | **GET** /variable-instance | Get Variable Instances
*VariableInstanceApi* | [**get_variable_instances_count**](docs/VariableInstanceApi.md#get_variable_instances_count) | **GET** /variable-instance/count | Get Variable Instance Count
*VariableInstanceApi* | [**query_variable_instances**](docs/VariableInstanceApi.md#query_variable_instances) | **POST** /variable-instance | Get Variable Instances (POST)
*VariableInstanceApi* | [**query_variable_instances_count**](docs/VariableInstanceApi.md#query_variable_instances_count) | **POST** /variable-instance/count | Get Variable Instance Count (POST)
*VersionApi* | [**get_rest_api_version**](docs/VersionApi.md#get_rest_api_version) | **GET** /version | Get Rest API version


## Documentation For Models

 - [AbstractSetRemovalTimeDto](docs/AbstractSetRemovalTimeDto.md)
 - [ActivityInstanceDto](docs/ActivityInstanceDto.md)
 - [ActivityInstanceIncidentDto](docs/ActivityInstanceIncidentDto.md)
 - [ActivityStatisticsResultDto](docs/ActivityStatisticsResultDto.md)
 - [AnnotationDto](docs/AnnotationDto.md)
 - [AtomLink](docs/AtomLink.md)
 - [AttachmentDto](docs/AttachmentDto.md)
 - [AttachmentDtoAllOf](docs/AttachmentDtoAllOf.md)
 - [AuthenticationResult](docs/AuthenticationResult.md)
 - [AuthorizationCheckResultDto](docs/AuthorizationCheckResultDto.md)
 - [AuthorizationCreateDto](docs/AuthorizationCreateDto.md)
 - [AuthorizationDto](docs/AuthorizationDto.md)
 - [AuthorizationExceptionDto](docs/AuthorizationExceptionDto.md)
 - [AuthorizationExceptionDtoAllOf](docs/AuthorizationExceptionDtoAllOf.md)
 - [AuthorizationUpdateDto](docs/AuthorizationUpdateDto.md)
 - [BasicUserCredentialsDto](docs/BasicUserCredentialsDto.md)
 - [BatchDto](docs/BatchDto.md)
 - [BatchStatisticsDto](docs/BatchStatisticsDto.md)
 - [BatchStatisticsDtoAllOf](docs/BatchStatisticsDtoAllOf.md)
 - [CalledProcessDefinitionDto](docs/CalledProcessDefinitionDto.md)
 - [CalledProcessDefinitionDtoAllOf](docs/CalledProcessDefinitionDtoAllOf.md)
 - [CamundaFormRef](docs/CamundaFormRef.md)
 - [CaseDefinitionDto](docs/CaseDefinitionDto.md)
 - [CheckPasswordPolicyResultDto](docs/CheckPasswordPolicyResultDto.md)
 - [CheckPasswordPolicyResultDtoAllOf](docs/CheckPasswordPolicyResultDtoAllOf.md)
 - [CheckPasswordPolicyRuleDto](docs/CheckPasswordPolicyRuleDto.md)
 - [CheckPasswordPolicyRuleDtoAllOf](docs/CheckPasswordPolicyRuleDtoAllOf.md)
 - [CleanableHistoricBatchReportResultDto](docs/CleanableHistoricBatchReportResultDto.md)
 - [CleanableHistoricDecisionInstanceReportResultDto](docs/CleanableHistoricDecisionInstanceReportResultDto.md)
 - [CleanableHistoricProcessInstanceReportResultDto](docs/CleanableHistoricProcessInstanceReportResultDto.md)
 - [CommentDto](docs/CommentDto.md)
 - [CommentDtoAllOf](docs/CommentDtoAllOf.md)
 - [CompleteExternalTaskDto](docs/CompleteExternalTaskDto.md)
 - [CompleteExternalTaskDtoAllOf](docs/CompleteExternalTaskDtoAllOf.md)
 - [CompleteTaskDto](docs/CompleteTaskDto.md)
 - [ConditionQueryParameterDto](docs/ConditionQueryParameterDto.md)
 - [CorrelationMessageAsyncDto](docs/CorrelationMessageAsyncDto.md)
 - [CorrelationMessageDto](docs/CorrelationMessageDto.md)
 - [CountResultDto](docs/CountResultDto.md)
 - [CreateFilterDto](docs/CreateFilterDto.md)
 - [CreateIncidentDto](docs/CreateIncidentDto.md)
 - [DecisionDefinitionDiagramDto](docs/DecisionDefinitionDiagramDto.md)
 - [DecisionDefinitionDto](docs/DecisionDefinitionDto.md)
 - [DecisionRequirementsDefinitionDto](docs/DecisionRequirementsDefinitionDto.md)
 - [DecisionRequirementsDefinitionXmlDto](docs/DecisionRequirementsDefinitionXmlDto.md)
 - [DeleteHistoricDecisionInstancesDto](docs/DeleteHistoricDecisionInstancesDto.md)
 - [DeleteHistoricProcessInstancesDto](docs/DeleteHistoricProcessInstancesDto.md)
 - [DeleteProcessInstancesDto](docs/DeleteProcessInstancesDto.md)
 - [DeploymentDto](docs/DeploymentDto.md)
 - [DeploymentDtoAllOf](docs/DeploymentDtoAllOf.md)
 - [DeploymentResourceDto](docs/DeploymentResourceDto.md)
 - [DeploymentWithDefinitionsDto](docs/DeploymentWithDefinitionsDto.md)
 - [DeploymentWithDefinitionsDtoAllOf](docs/DeploymentWithDefinitionsDtoAllOf.md)
 - [DurationReportResultDto](docs/DurationReportResultDto.md)
 - [EvaluateDecisionDto](docs/EvaluateDecisionDto.md)
 - [EvaluationConditionDto](docs/EvaluationConditionDto.md)
 - [EventSubscriptionDto](docs/EventSubscriptionDto.md)
 - [EventSubscriptionQueryDto](docs/EventSubscriptionQueryDto.md)
 - [EventSubscriptionQueryDtoSorting](docs/EventSubscriptionQueryDtoSorting.md)
 - [ExceptionDto](docs/ExceptionDto.md)
 - [ExecutionDto](docs/ExecutionDto.md)
 - [ExecutionQueryDto](docs/ExecutionQueryDto.md)
 - [ExecutionQueryDtoSorting](docs/ExecutionQueryDtoSorting.md)
 - [ExecutionTriggerDto](docs/ExecutionTriggerDto.md)
 - [ExtendLockOnExternalTaskDto](docs/ExtendLockOnExternalTaskDto.md)
 - [ExtendLockOnExternalTaskDtoAllOf](docs/ExtendLockOnExternalTaskDtoAllOf.md)
 - [ExternalTaskBpmnError](docs/ExternalTaskBpmnError.md)
 - [ExternalTaskBpmnErrorAllOf](docs/ExternalTaskBpmnErrorAllOf.md)
 - [ExternalTaskDto](docs/ExternalTaskDto.md)
 - [ExternalTaskFailureDto](docs/ExternalTaskFailureDto.md)
 - [ExternalTaskFailureDtoAllOf](docs/ExternalTaskFailureDtoAllOf.md)
 - [ExternalTaskQueryDto](docs/ExternalTaskQueryDto.md)
 - [ExternalTaskQueryDtoSorting](docs/ExternalTaskQueryDtoSorting.md)
 - [FetchExternalTaskTopicDto](docs/FetchExternalTaskTopicDto.md)
 - [FetchExternalTasksDto](docs/FetchExternalTasksDto.md)
 - [FilterDto](docs/FilterDto.md)
 - [FormDto](docs/FormDto.md)
 - [GroupDto](docs/GroupDto.md)
 - [GroupQueryDto](docs/GroupQueryDto.md)
 - [GroupQueryDtoSorting](docs/GroupQueryDtoSorting.md)
 - [HandleExternalTaskDto](docs/HandleExternalTaskDto.md)
 - [HistoricActivityInstanceDto](docs/HistoricActivityInstanceDto.md)
 - [HistoricActivityInstanceQueryDto](docs/HistoricActivityInstanceQueryDto.md)
 - [HistoricActivityInstanceQueryDtoSorting](docs/HistoricActivityInstanceQueryDtoSorting.md)
 - [HistoricActivityStatisticsDto](docs/HistoricActivityStatisticsDto.md)
 - [HistoricBatchDto](docs/HistoricBatchDto.md)
 - [HistoricBatchQueryDto](docs/HistoricBatchQueryDto.md)
 - [HistoricBatchQueryDtoSorting](docs/HistoricBatchQueryDtoSorting.md)
 - [HistoricDecisionInputInstanceDto](docs/HistoricDecisionInputInstanceDto.md)
 - [HistoricDecisionInstanceDto](docs/HistoricDecisionInstanceDto.md)
 - [HistoricDecisionInstanceQueryDto](docs/HistoricDecisionInstanceQueryDto.md)
 - [HistoricDecisionInstanceStatisticsDto](docs/HistoricDecisionInstanceStatisticsDto.md)
 - [HistoricDecisionOutputInstanceDto](docs/HistoricDecisionOutputInstanceDto.md)
 - [HistoricDetailDto](docs/HistoricDetailDto.md)
 - [HistoricDetailQueryDto](docs/HistoricDetailQueryDto.md)
 - [HistoricDetailQueryDtoSorting](docs/HistoricDetailQueryDtoSorting.md)
 - [HistoricExternalTaskLogDto](docs/HistoricExternalTaskLogDto.md)
 - [HistoricExternalTaskLogQueryDto](docs/HistoricExternalTaskLogQueryDto.md)
 - [HistoricExternalTaskLogQueryDtoSorting](docs/HistoricExternalTaskLogQueryDtoSorting.md)
 - [HistoricIdentityLinkLogDto](docs/HistoricIdentityLinkLogDto.md)
 - [HistoricIncidentDto](docs/HistoricIncidentDto.md)
 - [HistoricJobLogDto](docs/HistoricJobLogDto.md)
 - [HistoricJobLogQueryDto](docs/HistoricJobLogQueryDto.md)
 - [HistoricJobLogQueryDtoSorting](docs/HistoricJobLogQueryDtoSorting.md)
 - [HistoricProcessInstanceDto](docs/HistoricProcessInstanceDto.md)
 - [HistoricProcessInstanceQueryDto](docs/HistoricProcessInstanceQueryDto.md)
 - [HistoricProcessInstanceQueryDtoSorting](docs/HistoricProcessInstanceQueryDtoSorting.md)
 - [HistoricTaskInstanceDto](docs/HistoricTaskInstanceDto.md)
 - [HistoricTaskInstanceQueryDto](docs/HistoricTaskInstanceQueryDto.md)
 - [HistoricTaskInstanceQueryDtoSorting](docs/HistoricTaskInstanceQueryDtoSorting.md)
 - [HistoricTaskInstanceReportResultDto](docs/HistoricTaskInstanceReportResultDto.md)
 - [HistoricVariableInstanceDto](docs/HistoricVariableInstanceDto.md)
 - [HistoricVariableInstanceDtoAllOf](docs/HistoricVariableInstanceDtoAllOf.md)
 - [HistoricVariableInstanceQueryDto](docs/HistoricVariableInstanceQueryDto.md)
 - [HistoricVariableInstanceQueryDtoSorting](docs/HistoricVariableInstanceQueryDtoSorting.md)
 - [HistoryCleanupConfigurationDto](docs/HistoryCleanupConfigurationDto.md)
 - [HistoryTimeToLiveDto](docs/HistoryTimeToLiveDto.md)
 - [IdentityLinkDto](docs/IdentityLinkDto.md)
 - [IdentityServiceGroupDto](docs/IdentityServiceGroupDto.md)
 - [IdentityServiceGroupInfoDto](docs/IdentityServiceGroupInfoDto.md)
 - [IdentityServiceUserDto](docs/IdentityServiceUserDto.md)
 - [IncidentDto](docs/IncidentDto.md)
 - [IncidentStatisticsResultDto](docs/IncidentStatisticsResultDto.md)
 - [JobConditionQueryParameterDto](docs/JobConditionQueryParameterDto.md)
 - [JobDefinitionDto](docs/JobDefinitionDto.md)
 - [JobDefinitionPriorityDto](docs/JobDefinitionPriorityDto.md)
 - [JobDefinitionQueryDto](docs/JobDefinitionQueryDto.md)
 - [JobDefinitionQueryDtoSorting](docs/JobDefinitionQueryDtoSorting.md)
 - [JobDefinitionSuspensionStateDto](docs/JobDefinitionSuspensionStateDto.md)
 - [JobDefinitionSuspensionStateDtoAllOf](docs/JobDefinitionSuspensionStateDtoAllOf.md)
 - [JobDefinitionsSuspensionStateDto](docs/JobDefinitionsSuspensionStateDto.md)
 - [JobDefinitionsSuspensionStateDtoAllOf](docs/JobDefinitionsSuspensionStateDtoAllOf.md)
 - [JobDto](docs/JobDto.md)
 - [JobDuedateDto](docs/JobDuedateDto.md)
 - [JobQueryDto](docs/JobQueryDto.md)
 - [JobQueryDtoSorting](docs/JobQueryDtoSorting.md)
 - [JobSuspensionStateDto](docs/JobSuspensionStateDto.md)
 - [JobSuspensionStateDtoAllOf](docs/JobSuspensionStateDtoAllOf.md)
 - [LinkableDto](docs/LinkableDto.md)
 - [LockExternalTaskDto](docs/LockExternalTaskDto.md)
 - [LockExternalTaskDtoAllOf](docs/LockExternalTaskDtoAllOf.md)
 - [LockedExternalTaskDto](docs/LockedExternalTaskDto.md)
 - [MessageCorrelationResultWithVariableDto](docs/MessageCorrelationResultWithVariableDto.md)
 - [MetricsIntervalResultDto](docs/MetricsIntervalResultDto.md)
 - [MetricsResultDto](docs/MetricsResultDto.md)
 - [MigrationExecutionDto](docs/MigrationExecutionDto.md)
 - [MigrationInstructionDto](docs/MigrationInstructionDto.md)
 - [MigrationInstructionValidationReportDto](docs/MigrationInstructionValidationReportDto.md)
 - [MigrationPlanDto](docs/MigrationPlanDto.md)
 - [MigrationPlanGenerationDto](docs/MigrationPlanGenerationDto.md)
 - [MigrationPlanReportDto](docs/MigrationPlanReportDto.md)
 - [MigrationVariableValidationReportDto](docs/MigrationVariableValidationReportDto.md)
 - [MigrationVariableValidationReportDtoAllOf](docs/MigrationVariableValidationReportDtoAllOf.md)
 - [MissingAuthorizationDto](docs/MissingAuthorizationDto.md)
 - [ModificationDto](docs/ModificationDto.md)
 - [MultiFormAttachmentDto](docs/MultiFormAttachmentDto.md)
 - [MultiFormDeploymentDto](docs/MultiFormDeploymentDto.md)
 - [MultiFormVariableBinaryDto](docs/MultiFormVariableBinaryDto.md)
 - [MultipleProcessInstanceModificationInstructionDto](docs/MultipleProcessInstanceModificationInstructionDto.md)
 - [ParseExceptionDto](docs/ParseExceptionDto.md)
 - [ParseExceptionDtoAllOf](docs/ParseExceptionDtoAllOf.md)
 - [PasswordPolicyDto](docs/PasswordPolicyDto.md)
 - [PasswordPolicyRequestDto](docs/PasswordPolicyRequestDto.md)
 - [PasswordPolicyRuleDto](docs/PasswordPolicyRuleDto.md)
 - [PatchVariablesDto](docs/PatchVariablesDto.md)
 - [PriorityDto](docs/PriorityDto.md)
 - [ProblemDto](docs/ProblemDto.md)
 - [ProcessDefinitionDiagramDto](docs/ProcessDefinitionDiagramDto.md)
 - [ProcessDefinitionDto](docs/ProcessDefinitionDto.md)
 - [ProcessDefinitionStatisticsResultDto](docs/ProcessDefinitionStatisticsResultDto.md)
 - [ProcessDefinitionSuspensionStateDto](docs/ProcessDefinitionSuspensionStateDto.md)
 - [ProcessEngineDto](docs/ProcessEngineDto.md)
 - [ProcessInstanceDto](docs/ProcessInstanceDto.md)
 - [ProcessInstanceDtoAllOf](docs/ProcessInstanceDtoAllOf.md)
 - [ProcessInstanceModificationDto](docs/ProcessInstanceModificationDto.md)
 - [ProcessInstanceModificationInstructionDto](docs/ProcessInstanceModificationInstructionDto.md)
 - [ProcessInstanceQueryDto](docs/ProcessInstanceQueryDto.md)
 - [ProcessInstanceQueryDtoSorting](docs/ProcessInstanceQueryDtoSorting.md)
 - [ProcessInstanceSuspensionStateAsyncDto](docs/ProcessInstanceSuspensionStateAsyncDto.md)
 - [ProcessInstanceSuspensionStateAsyncDtoAllOf](docs/ProcessInstanceSuspensionStateAsyncDtoAllOf.md)
 - [ProcessInstanceSuspensionStateDto](docs/ProcessInstanceSuspensionStateDto.md)
 - [ProcessInstanceSuspensionStateDtoAllOf](docs/ProcessInstanceSuspensionStateDtoAllOf.md)
 - [ProcessInstanceWithVariablesDto](docs/ProcessInstanceWithVariablesDto.md)
 - [ProcessInstanceWithVariablesDtoAllOf](docs/ProcessInstanceWithVariablesDtoAllOf.md)
 - [RedeploymentDto](docs/RedeploymentDto.md)
 - [ResourceOptionsDto](docs/ResourceOptionsDto.md)
 - [ResourceReportDto](docs/ResourceReportDto.md)
 - [RestartProcessInstanceDto](docs/RestartProcessInstanceDto.md)
 - [RestartProcessInstanceModificationInstructionDto](docs/RestartProcessInstanceModificationInstructionDto.md)
 - [RetriesDto](docs/RetriesDto.md)
 - [SchemaLogEntryDto](docs/SchemaLogEntryDto.md)
 - [SchemaLogQueryDto](docs/SchemaLogQueryDto.md)
 - [SchemaLogQueryDtoSorting](docs/SchemaLogQueryDtoSorting.md)
 - [SetJobRetriesByProcessDto](docs/SetJobRetriesByProcessDto.md)
 - [SetJobRetriesDto](docs/SetJobRetriesDto.md)
 - [SetRemovalTimeToHistoricBatchesDto](docs/SetRemovalTimeToHistoricBatchesDto.md)
 - [SetRemovalTimeToHistoricBatchesDtoAllOf](docs/SetRemovalTimeToHistoricBatchesDtoAllOf.md)
 - [SetRemovalTimeToHistoricDecisionInstancesDto](docs/SetRemovalTimeToHistoricDecisionInstancesDto.md)
 - [SetRemovalTimeToHistoricDecisionInstancesDtoAllOf](docs/SetRemovalTimeToHistoricDecisionInstancesDtoAllOf.md)
 - [SetRemovalTimeToHistoricProcessInstancesDto](docs/SetRemovalTimeToHistoricProcessInstancesDto.md)
 - [SetRemovalTimeToHistoricProcessInstancesDtoAllOf](docs/SetRemovalTimeToHistoricProcessInstancesDtoAllOf.md)
 - [SetRetriesForExternalTasksDto](docs/SetRetriesForExternalTasksDto.md)
 - [SetVariablesAsyncDto](docs/SetVariablesAsyncDto.md)
 - [SignalDto](docs/SignalDto.md)
 - [SortTaskQueryParametersDto](docs/SortTaskQueryParametersDto.md)
 - [StartProcessInstanceDto](docs/StartProcessInstanceDto.md)
 - [StartProcessInstanceFormDto](docs/StartProcessInstanceFormDto.md)
 - [SuspensionStateDto](docs/SuspensionStateDto.md)
 - [TaskBpmnErrorDto](docs/TaskBpmnErrorDto.md)
 - [TaskDto](docs/TaskDto.md)
 - [TaskEscalationDto](docs/TaskEscalationDto.md)
 - [TaskQueryDto](docs/TaskQueryDto.md)
 - [TaskQueryDtoSorting](docs/TaskQueryDtoSorting.md)
 - [TelemetryConfigurationDto](docs/TelemetryConfigurationDto.md)
 - [TenantDto](docs/TenantDto.md)
 - [TransitionInstanceDto](docs/TransitionInstanceDto.md)
 - [TriggerVariableValueDto](docs/TriggerVariableValueDto.md)
 - [TriggerVariableValueDtoAllOf](docs/TriggerVariableValueDtoAllOf.md)
 - [UserCredentialsDto](docs/UserCredentialsDto.md)
 - [UserDto](docs/UserDto.md)
 - [UserIdDto](docs/UserIdDto.md)
 - [UserOperationLogEntryDto](docs/UserOperationLogEntryDto.md)
 - [UserProfileDto](docs/UserProfileDto.md)
 - [VariableInstanceDto](docs/VariableInstanceDto.md)
 - [VariableInstanceDtoAllOf](docs/VariableInstanceDtoAllOf.md)
 - [VariableInstanceQueryDto](docs/VariableInstanceQueryDto.md)
 - [VariableInstanceQueryDtoSorting](docs/VariableInstanceQueryDtoSorting.md)
 - [VariableQueryParameterDto](docs/VariableQueryParameterDto.md)
 - [VariableQueryParameterDtoAllOf](docs/VariableQueryParameterDtoAllOf.md)
 - [VariableValueDto](docs/VariableValueDto.md)
 - [VersionDto](docs/VersionDto.md)


## Documentation For Authorization

 All endpoints do not require authorization.

## Author




