# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['rdf_fastapi_utils', 'rdf_fastapi_utils.tests']

package_data = \
{'': ['*']}

install_requires = \
['pydantic>=1.10.2,<2.0.0', 'rdflib>=6.2.0,<7.0.0']

setup_kwargs = {
    'name': 'rdf-fastapi-utils',
    'version': '0.1.3',
    'description': 'Utils package for interacting with SPARQL endpoint via FastAPI',
    'long_description': '# RDF-FastAPI-Utils\nThis is a small utils library for providing access to data in a triplestore via a FastAPI Rest endpoint.\nCurrently it contains only those classes used to convert a Json resulting from a SPARQL query into a given pydantic model.\n\nCurrently it contains two classes:\n- `models.FieldConfigurationRDF` to add additional information for processing RDF data to the fields in a pydantic model\n- and `models.RDFUtilsModelBaseClass` as a pydantic base class to inherit from for adding SPARQL Json to a pydantic model.\n\n## Minimal example\n*this is taken from the tests*\n\nmodels.py:\n```python\nfrom pydantic import Field\nfrom rdf_fastapi_utils.models import FieldConfigurationRDF, RDFUtilsModelBaseClass\n\n\nclass TCPaginatedResponse(RDFUtilsModelBaseClass):\n    count: int = Field(..., rdfconfig=FieldConfigurationRDF(path="count"))\n    results: list[Union["TCPersonFull", "TCPlaceFull"]] = Field(\n        ...,\n        rdfconfig=FieldConfigurationRDF(path="results", serialization_class_callback=lambda field, item: TCPersonFull),\n    )\n\n\nclass TCPersonFull(RDFUtilsModelBaseClass):\n    id: str = Field(..., rdfconfig=FieldConfigurationRDF(anchor=True, path="person"))\n    name: str = Field(..., rdfconfig=FieldConfigurationRDF(path="entityLabel"))\n    events: list["TCEventFull"] = None\n\n\nclass TCPlaceFull(RDFUtilsModelBaseClass):\n    id: str = Field(..., rdfconfig=FieldConfigurationRDF(anchor=True, path="person"))\n    name: str = Field(..., rdfconfig=FieldConfigurationRDF(path="entityLabel"))\n    events: list["TCEventFull"] = None\n\n\nclass TCEventFull(RDFUtilsModelBaseClass):\n    id: str = Field(..., rdfconfig=FieldConfigurationRDF(anchor=True, path="event"))\n    label: str = Field(..., rdfconfig=FieldConfigurationRDF(path="eventLabel"))\n\n\nTCPaginatedResponse.update_forward_refs()\nTCPersonFull.update_forward_refs()\nTCEventFull.update_forward_refs()\n\n```\n\ntest_data.json\n```json\n{\n      "page": 1,\n      "count": 1,\n      "pages": 1,\n      "results": [\n            {\n                  "count": 1,\n                  "person": "http://www.intavia.eu/apis/personproxy/27118",\n                  "entityTypeLabel": "person",\n                  "entityLabel": "Tesla, Nikola",\n                  "linkedIds": "https://apis-edits.acdh-dev.oeaw.ac.at/entity/27118/",\n                  "role": "http://www.intavia.eu/apis/deceased_person/27118",\n                  "event": "http://www.intavia.eu/apis/deathevent/27118",\n                  "evPlace": "http://www.intavia.eu/apis/place/25209",\n                  "evPlaceLatLong": "Point ( -74.00597 +40.71427 )",\n                  "evPlaceLabel": "New York City",\n                  "eventLabel": "Death of Nikola Tesla",\n                  "end": "1943-01-07 23:59:59+00:00"\n            },\n            {\n                  "count": 1,\n                  "person": "http://www.intavia.eu/apis/personproxy/27118",\n                  "entityTypeLabel": "person",\n                  "entityLabel": "Tesla, Nikola",\n                  "linkedIds": "https://apis.acdh.oeaw.ac.at/entity/27118",\n                  "role": "http://www.intavia.eu/apis/deceased_person/27118",\n                  "event": "http://www.intavia.eu/apis/deathevent/27118",\n                  "evPlace": "http://www.intavia.eu/apis/place/25209",\n                  "evPlaceLatLong": "Point ( -74.00597 +40.71427 )",\n                  "evPlaceLabel": "New York City",\n                  "eventLabel": "Death of Nikola Tesla",\n                  "end": "1943-01-07 23:59:59+00:00"\n            },\n            {\n                  "count": 1,\n                  "person": "http://www.intavia.eu/apis/personproxy/27118",\n                  "entityTypeLabel": "person",\n                  "entityLabel": "Tesla, Nikola",\n                  "linkedIds": "https://apis-edits.acdh-dev.oeaw.ac.at/entity/27118/",\n                  "role": "http://www.intavia.eu/apis/personplace/eventrole/155790",\n                  "event": "http://www.intavia.eu/apis/event/personplace/155790",\n                  "evPlace": "http://www.intavia.eu/apis/place/129965",\n                  "evPlaceLatLong": "Point ( +15.31806 +44.56389 )",\n                  "evPlaceLabel": "Smiljan",\n                  "roleLabel": "ausgebildet in",\n                  "eventLabel": "Tesla, Nikola ausgebildet in Smiljan",\n                  "start": "1862-01-01 00:00:00+00:00",\n                  "end": "1866-12-31 23:59:59+00:00"\n            },\n            {\n                  "count": 1,\n                  "person": "http://www.intavia.eu/apis/personproxy/27118",\n                  "entityTypeLabel": "person",\n                  "entityLabel": "Tesla, Nikola",\n                  "linkedIds": "https://apis.acdh.oeaw.ac.at/entity/27118",\n                  "role": "http://www.intavia.eu/apis/personplace/eventrole/155790",\n                  "event": "http://www.intavia.eu/apis/event/personplace/155790",\n                  "evPlace": "http://www.intavia.eu/apis/place/129965",\n                  "evPlaceLatLong": "Point ( +15.31806 +44.56389 )",\n                  "evPlaceLabel": "Smiljan",\n                  "roleLabel": "ausgebildet in",\n                  "eventLabel": "Tesla, Nikola ausgebildet in Smiljan",\n                  "start": "1862-01-01 00:00:00+00:00",\n                  "end": "1866-12-31 23:59:59+00:00"\n            }\n      ]\n}\n```\n\nRunning the following with the above files in place will result in a correctly nested python object:\n\n```python\nimport json\nfrom .models import TCPaginatedResponse\n\nwith open("test_data.json") as inp:\n    data = json.load(inp)\n    res = TCPaginatedResponse(**data)\n\nprint(res)\n```',
    'author': 'Matthias Schlögl',
    'author_email': 'matthias.schloegl@oeaw.ac.at',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'python_requires': '>=3.10,<4.0',
}


setup(**setup_kwargs)
