"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ContentfulWebhook = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const path = require("path");
const aws_lambda_1 = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
const cdk_secret_key_1 = require("@cloudcomponents/cdk-secret-key");
class ContentfulWebhook extends core_1.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        const accessToken = typeof props.accessToken === 'string' ? cdk_secret_key_1.SecretKey.fromPlainText(props.accessToken) : props.accessToken;
        const handler = new aws_lambda_1.SingletonFunction(this, 'CustomResourceHandler', {
            uuid: '91f2075f-b950-4743-a66b-ee0f6febf50d',
            runtime: aws_lambda_1.Runtime.NODEJS_12_X,
            code: aws_lambda_1.Code.fromAsset(path.join(__dirname, 'lambdas', 'contentful-webhook')),
            handler: 'index.handler',
            lambdaPurpose: 'Custom::ContentfulWebhook',
            timeout: core_1.Duration.minutes(15),
        });
        if (accessToken.grantRead) {
            accessToken.grantRead(handler);
        }
        new core_1.CustomResource(this, 'CustomResource', {
            serviceToken: handler.functionArn,
            resourceType: 'Custom::ContentfulWebhook',
            pascalCaseProperties: true,
            properties: {
                accessTokenString: accessToken.serialize(),
                spaceId: props.spaceId,
                name: props.name,
                url: props.url,
                topics: props.topics,
                logLevel: props.logLevel,
            },
        });
    }
}
exports.ContentfulWebhook = ContentfulWebhook;
_a = JSII_RTTI_SYMBOL_1;
ContentfulWebhook[_a] = { fqn: "@cloudcomponents/cdk-contentful-webhook.ContentfulWebhook", version: "1.31.0" };
//# sourceMappingURL=data:application/json;base64,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