# python-freshbooks

## Not officaily supported

The goal of this project is to provide a python wrapper for FreshBooks API
for now it only supports get and post


## Usage.

This Library is assuming that we are using a webapplication oauth login flow.

Ie a user will authorize the application using the library through FreshBooks U.I and
then they'll be redirected to your domain with that code.

### Get your first access token and refresh token

```python

from freshbooks.client import Client

# This code has to be obtained after a user authorizes your app through FreshBooks U.I.
code = "<my_user_code>"

# Generated by FreshBooks after registering your integration with them
client_id = "<client_id>"
client_secret = "<client_secret>"
redirect_uri = "<redirectt_uri"

client = Client(
	client_id,
	client_secret,
	redirect_uri
)

client.fetch_access_token(code)

me = client.get('/auth/api/v1/users/me')

# save client.bearer_token and client.refresh_token for future use

```

### Assuming you've already saved a bearer token and refresh token
```python

from freshbooks.client import Client

access_token = 'abcdef'
refresh_token = 'jhijkl'

client_id = "<client_id>"
client_secret = "<client_secret>"

client = Client(
	client_id,
	client_secret,
	bearer_token=access_token,
	refresh_token=refresh_token
)

client.refresh_access_token()
# save client.bearer_token and client.refresh_token for future use

me = client.get('/auth/api/v1/users/me')

```
