# Generated by Django 3.0 on 2022-04-12 20:57

from django.conf import settings
import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion
import loducode_web3.models.land
import loducode_web3.models.nft
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        migrations.swappable_dependency(settings.AUTH_USER_MODEL),
    ]

    operations = [
        migrations.CreateModel(
            name='Nft',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, help_text='date when the object was created', verbose_name='creation date')),
                ('modified_at', models.DateTimeField(auto_now=True, help_text='date when the object was modified', verbose_name='update date')),
                ('cus_id', models.BigIntegerField(default=12, unique=True, verbose_name='Cus id')),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('description', models.CharField(blank=True, max_length=555, null=True, verbose_name='Description')),
                ('image', models.FileField(blank=True, null=True, upload_to=loducode_web3.models.nft.create_path_nft, verbose_name='Image')),
                ('level', models.BigIntegerField(blank=True, default=1, null=True, verbose_name='Level')),
                ('update_level', django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=dict, null=True, verbose_name='Update level')),
                ('attributes', django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=dict, null=True, verbose_name='Attributes')),
                ('cost', models.FloatField(default=0.0, verbose_name='Cost')),
                ('date_publication', models.DateField()),
                ('date_created', models.DateField(auto_now=True)),
                ('created_by', models.ForeignKey(blank=True, help_text='user who created the object', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='nft_created_by', to=settings.AUTH_USER_MODEL, verbose_name='creation user')),
                ('modified_by', models.ForeignKey(blank=True, help_text='user who performed the update', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='nft_modified_by', to=settings.AUTH_USER_MODEL, verbose_name='update user')),
            ],
            options={
                'verbose_name': 'Nft',
                'verbose_name_plural': 'Nfts',
            },
        ),
        migrations.CreateModel(
            name='Land',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, help_text='date when the object was created', verbose_name='creation date')),
                ('modified_at', models.DateTimeField(auto_now=True, help_text='date when the object was modified', verbose_name='update date')),
                ('cus_id', models.BigIntegerField(default=12, unique=True, verbose_name='Cus id')),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('description', models.CharField(blank=True, max_length=555, null=True, verbose_name='Description')),
                ('image', models.FileField(blank=True, null=True, upload_to=loducode_web3.models.land.create_path_land, verbose_name='Image')),
                ('attributes', django.contrib.postgres.fields.jsonb.JSONField(blank=True, default=dict, null=True, verbose_name='Attributes')),
                ('cost', models.FloatField(default=0.0, verbose_name='Cost')),
                ('date_publication', models.DateField()),
                ('date_created', models.DateField(auto_now=True)),
                ('created_by', models.ForeignKey(blank=True, help_text='user who created the object', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='land_created_by', to=settings.AUTH_USER_MODEL, verbose_name='creation user')),
                ('modified_by', models.ForeignKey(blank=True, help_text='user who performed the update', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='land_modified_by', to=settings.AUTH_USER_MODEL, verbose_name='update user')),
            ],
            options={
                'verbose_name': 'Land',
                'verbose_name_plural': 'Lands',
            },
        ),
        migrations.CreateModel(
            name='AttributeNft',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, help_text='date when the object was created', verbose_name='creation date')),
                ('modified_at', models.DateTimeField(auto_now=True, help_text='date when the object was modified', verbose_name='update date')),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('value', models.CharField(blank=True, max_length=555, null=True, verbose_name='Value')),
                ('created_by', models.ForeignKey(blank=True, help_text='user who created the object', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='attributenft_created_by', to=settings.AUTH_USER_MODEL, verbose_name='creation user')),
                ('modified_by', models.ForeignKey(blank=True, help_text='user who performed the update', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='attributenft_modified_by', to=settings.AUTH_USER_MODEL, verbose_name='update user')),
                ('nft', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='loducode_web3.Nft', verbose_name='Nft')),
            ],
            options={
                'verbose_name': 'Attribute Nft',
                'verbose_name_plural': 'Attributes Nft',
            },
        ),
        migrations.CreateModel(
            name='AttributeLand',
            fields=[
                ('id', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('created_at', models.DateTimeField(auto_now_add=True, db_index=True, help_text='date when the object was created', verbose_name='creation date')),
                ('modified_at', models.DateTimeField(auto_now=True, help_text='date when the object was modified', verbose_name='update date')),
                ('name', models.CharField(max_length=255, verbose_name='Name')),
                ('value', models.CharField(blank=True, max_length=555, null=True, verbose_name='Value')),
                ('created_by', models.ForeignKey(blank=True, help_text='user who created the object', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='attributeland_created_by', to=settings.AUTH_USER_MODEL, verbose_name='creation user')),
                ('land', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='loducode_web3.Land', verbose_name='Land')),
                ('modified_by', models.ForeignKey(blank=True, help_text='user who performed the update', null=True, on_delete=django.db.models.deletion.SET_NULL, related_name='attributeland_modified_by', to=settings.AUTH_USER_MODEL, verbose_name='update user')),
            ],
            options={
                'verbose_name': 'Attribute Land',
                'verbose_name_plural': 'Attributes Lands',
            },
        ),
    ]
