# coding: utf-8

"""
    Typewise API

    Typewise server for text completion, autocorrection and emoji searching.  # noqa: E501

    OpenAPI spec version: 0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""

import pprint
import re  # noqa: F401

import six

class CompletionRequest(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """
    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'text': 'str',
        'correct_typo_in_partial_word': 'bool',
        'language': 'AllOfCompletionRequestLanguage',
        'max_number_of_predictions': 'int',
        'return_token_scores': 'bool'
    }

    attribute_map = {
        'text': 'text',
        'correct_typo_in_partial_word': 'correctTypoInPartialWord',
        'language': 'language',
        'max_number_of_predictions': 'maxNumberOfPredictions',
        'return_token_scores': 'returnTokenScores'
    }

    def __init__(self, text=None, correct_typo_in_partial_word=False, language=None, max_number_of_predictions=5, return_token_scores=False):  # noqa: E501
        """CompletionRequest - a model defined in Swagger"""  # noqa: E501
        self._text = None
        self._correct_typo_in_partial_word = None
        self._language = None
        self._max_number_of_predictions = None
        self._return_token_scores = None
        self.discriminator = None
        self.text = text
        if correct_typo_in_partial_word is not None:
            self.correct_typo_in_partial_word = correct_typo_in_partial_word
        if language is not None:
            self.language = language
        if max_number_of_predictions is not None:
            self.max_number_of_predictions = max_number_of_predictions
        if return_token_scores is not None:
            self.return_token_scores = return_token_scores

    @property
    def text(self):
        """Gets the text of this CompletionRequest.  # noqa: E501

        The input text to be autocompleted. If full next word prediction is required, end on a space.  # noqa: E501

        :return: The text of this CompletionRequest.  # noqa: E501
        :rtype: str
        """
        return self._text

    @text.setter
    def text(self, text):
        """Sets the text of this CompletionRequest.

        The input text to be autocompleted. If full next word prediction is required, end on a space.  # noqa: E501

        :param text: The text of this CompletionRequest.  # noqa: E501
        :type: str
        """
        if text is None:
            raise ValueError("Invalid value for `text`, must not be `None`")  # noqa: E501

        self._text = text

    @property
    def correct_typo_in_partial_word(self):
        """Gets the correct_typo_in_partial_word of this CompletionRequest.  # noqa: E501

        If true, don't constrain predictions to already typed characters, e.g. 'cahracte' can predict 'character', regardless of the typo.  # noqa: E501

        :return: The correct_typo_in_partial_word of this CompletionRequest.  # noqa: E501
        :rtype: bool
        """
        return self._correct_typo_in_partial_word

    @correct_typo_in_partial_word.setter
    def correct_typo_in_partial_word(self, correct_typo_in_partial_word):
        """Sets the correct_typo_in_partial_word of this CompletionRequest.

        If true, don't constrain predictions to already typed characters, e.g. 'cahracte' can predict 'character', regardless of the typo.  # noqa: E501

        :param correct_typo_in_partial_word: The correct_typo_in_partial_word of this CompletionRequest.  # noqa: E501
        :type: bool
        """

        self._correct_typo_in_partial_word = correct_typo_in_partial_word

    @property
    def language(self):
        """Gets the language of this CompletionRequest.  # noqa: E501

        The language of the sentence.  # noqa: E501

        :return: The language of this CompletionRequest.  # noqa: E501
        :rtype: AllOfCompletionRequestLanguage
        """
        return self._language

    @language.setter
    def language(self, language):
        """Sets the language of this CompletionRequest.

        The language of the sentence.  # noqa: E501

        :param language: The language of this CompletionRequest.  # noqa: E501
        :type: AllOfCompletionRequestLanguage
        """

        self._language = language

    @property
    def max_number_of_predictions(self):
        """Gets the max_number_of_predictions of this CompletionRequest.  # noqa: E501

        The maximum number of predictions to return. The higher the number the slower the response time. Maximum 20.  # noqa: E501

        :return: The max_number_of_predictions of this CompletionRequest.  # noqa: E501
        :rtype: int
        """
        return self._max_number_of_predictions

    @max_number_of_predictions.setter
    def max_number_of_predictions(self, max_number_of_predictions):
        """Sets the max_number_of_predictions of this CompletionRequest.

        The maximum number of predictions to return. The higher the number the slower the response time. Maximum 20.  # noqa: E501

        :param max_number_of_predictions: The max_number_of_predictions of this CompletionRequest.  # noqa: E501
        :type: int
        """

        self._max_number_of_predictions = max_number_of_predictions

    @property
    def return_token_scores(self):
        """Gets the return_token_scores of this CompletionRequest.  # noqa: E501

        If true, also return the consituent token scores for each prediction.  # noqa: E501

        :return: The return_token_scores of this CompletionRequest.  # noqa: E501
        :rtype: bool
        """
        return self._return_token_scores

    @return_token_scores.setter
    def return_token_scores(self, return_token_scores):
        """Sets the return_token_scores of this CompletionRequest.

        If true, also return the consituent token scores for each prediction.  # noqa: E501

        :param return_token_scores: The return_token_scores of this CompletionRequest.  # noqa: E501
        :type: bool
        """

        self._return_token_scores = return_token_scores

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(CompletionRequest, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, CompletionRequest):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
