# typewiseprediction
Typewise server for text completion, autocorrection and emoji searching.

This Python package is automatically generated by the [Swagger Codegen](https://github.com/swagger-api/swagger-codegen) project:

- API version: 0
- Package version: 1.0.0
- Build package: io.swagger.codegen.v3.generators.python.PythonClientCodegen

## Requirements.

Python 2.7 and 3.4+

## Installation & Usage
### pip install

If the python package is hosted on Github, you can install directly from Github

```sh
pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/GIT_USER_ID/GIT_REPO_ID.git`)

Then import the package:
```python
import typewiseprediction 
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import typewiseprediction
```

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python
from __future__ import print_function
import time
import typewiseprediction
from typewiseprediction.rest import ApiException
from pprint import pprint

# create an instance of the API class
api_instance = typewiseprediction.CompletionApi(typewiseprediction.ApiClient(configuration))
body = typewiseprediction.CompletionRequest() # CompletionRequest | 

try:
    # Complete
    api_response = api_instance.complete_completion_complete_post(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CompletionApi->complete_completion_complete_post: %s\n" % e)

# create an instance of the API class
api_instance = typewiseprediction.CompletionApi(typewiseprediction.ApiClient(configuration))
body = typewiseprediction.CompletionRequest() # CompletionRequest | 

try:
    # Complete
    api_response = api_instance.complete_completion_complete_post_0(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CompletionApi->complete_completion_complete_post_0: %s\n" % e)

# create an instance of the API class
api_instance = typewiseprediction.CompletionApi(typewiseprediction.ApiClient(configuration))
body = typewiseprediction.CompletionRequest() # CompletionRequest | 

try:
    # Complete
    api_response = api_instance.complete_completion_complete_post_1(body)
    pprint(api_response)
except ApiException as e:
    print("Exception when calling CompletionApi->complete_completion_complete_post_1: %s\n" % e)
```

## Documentation for API Endpoints

All URIs are relative to *https://typewiseapi.azurewebsites.net/latest*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*CompletionApi* | [**complete_completion_complete_post**](docs/CompletionApi.md#complete_completion_complete_post) | **POST** /completion/complete | Complete
*CompletionApi* | [**complete_completion_complete_post_0**](docs/CompletionApi.md#complete_completion_complete_post_0) | **POST** /completion/complete | Complete
*CompletionApi* | [**complete_completion_complete_post_1**](docs/CompletionApi.md#complete_completion_complete_post_1) | **POST** /completion/complete | Complete
*CorrectionApi* | [**complete_correction_correction_whole_sentence_post**](docs/CorrectionApi.md#complete_correction_correction_whole_sentence_post) | **POST** /correction/whole_sentence | Complete Correction
*CorrectionApi* | [**complete_correction_correction_whole_sentence_post_0**](docs/CorrectionApi.md#complete_correction_correction_whole_sentence_post_0) | **POST** /correction/whole_sentence | Complete Correction
*CorrectionApi* | [**complete_correction_correction_whole_sentence_post_1**](docs/CorrectionApi.md#complete_correction_correction_whole_sentence_post_1) | **POST** /correction/whole_sentence | Complete Correction
*CorrectionApi* | [**last_word_correction_correction_final_word_post**](docs/CorrectionApi.md#last_word_correction_correction_final_word_post) | **POST** /correction/final_word | Last Word Correction
*CorrectionApi* | [**last_word_correction_correction_final_word_post_0**](docs/CorrectionApi.md#last_word_correction_correction_final_word_post_0) | **POST** /correction/final_word | Last Word Correction
*CorrectionApi* | [**last_word_correction_correction_final_word_post_1**](docs/CorrectionApi.md#last_word_correction_correction_final_word_post_1) | **POST** /correction/final_word | Last Word Correction
*DefaultApi* | [**root_get**](docs/DefaultApi.md#root_get) | **GET** / | Root
*EmojiApi* | [**emoji_search_emoji_search_post**](docs/EmojiApi.md#emoji_search_emoji_search_post) | **POST** /emoji/search | Emoji Search
*EmojiApi* | [**emoji_search_emoji_search_post_0**](docs/EmojiApi.md#emoji_search_emoji_search_post_0) | **POST** /emoji/search | Emoji Search
*EmojiApi* | [**emoji_search_emoji_search_post_1**](docs/EmojiApi.md#emoji_search_emoji_search_post_1) | **POST** /emoji/search | Emoji Search
*LanguageDetectionApi* | [**detect_language_language_detection_detector_post**](docs/LanguageDetectionApi.md#detect_language_language_detection_detector_post) | **POST** /language_detection/detector | Detect Language
*LanguageDetectionApi* | [**detect_language_language_detection_detector_post_0**](docs/LanguageDetectionApi.md#detect_language_language_detection_detector_post_0) | **POST** /language_detection/detector | Detect Language
*LanguageDetectionApi* | [**detect_language_language_detection_detector_post_1**](docs/LanguageDetectionApi.md#detect_language_language_detection_detector_post_1) | **POST** /language_detection/detector | Detect Language

## Documentation For Models

 - [AllOfCompleteCorrectionRequestSentenceKeyboard](docs/AllOfCompleteCorrectionRequestSentenceKeyboard.md)
 - [AllOfCompleteCorrectionRequestSentenceLanguage](docs/AllOfCompleteCorrectionRequestSentenceLanguage.md)
 - [AllOfCompletionRequestLanguage](docs/AllOfCompletionRequestLanguage.md)
 - [AllOfLastWordCorrectionRequestSentenceKeyboard](docs/AllOfLastWordCorrectionRequestSentenceKeyboard.md)
 - [AllOfLastWordCorrectionRequestSentenceLanguage](docs/AllOfLastWordCorrectionRequestSentenceLanguage.md)
 - [CompleteCorrectionReply](docs/CompleteCorrectionReply.md)
 - [CompleteCorrectionRequestSentence](docs/CompleteCorrectionRequestSentence.md)
 - [CompletionReply](docs/CompletionReply.md)
 - [CompletionRequest](docs/CompletionRequest.md)
 - [EmojiSearchReply](docs/EmojiSearchReply.md)
 - [EmojiSearchRequest](docs/EmojiSearchRequest.md)
 - [HTTPValidationError](docs/HTTPValidationError.md)
 - [Keyboard](docs/Keyboard.md)
 - [LanguageDetectionReply](docs/LanguageDetectionReply.md)
 - [LanguageDetectionRequest](docs/LanguageDetectionRequest.md)
 - [LastWordCorrectionReply](docs/LastWordCorrectionReply.md)
 - [LastWordCorrectionRequestSentence](docs/LastWordCorrectionRequestSentence.md)
 - [ServerRoutesCompletionPydanticModelsLanguage](docs/ServerRoutesCompletionPydanticModelsLanguage.md)
 - [ServerRoutesCorrectionPydanticModelsLanguage](docs/ServerRoutesCorrectionPydanticModelsLanguage.md)
 - [ServerRoutesLanguageDetectionPydanticModelsLanguage](docs/ServerRoutesLanguageDetectionPydanticModelsLanguage.md)
 - [SingleCompletion](docs/SingleCompletion.md)
 - [SingleCompletionTokenProbability](docs/SingleCompletionTokenProbability.md)
 - [SingleLanguagePrediction](docs/SingleLanguagePrediction.md)
 - [SinglePointCorrection](docs/SinglePointCorrection.md)
 - [ValidationError](docs/ValidationError.md)

## Documentation For Authorization

 All endpoints do not require authorization.


## Author


