# IBCDFO

Interpolation-Based Composite Derivative-Free Optimization

![GitHub](https://img.shields.io/github/license/poptus/IBCDFO)

This page contains source code for interpolation-based optimization methods for
composite derivative-free optimization.

Relevant references include:

  - J. Larson and M. Menickelly. Structure-aware methods for expensive
  derivative-free nonsmooth composite optimization. *arXiv:2207.08264*. 2022.
  [LINK](https://arxiv.org/abs/2207.08264)

  - J. Larson, M. Menickelly, and B. Zhou. Manifold sampling for optimizing
  nonsmooth nonconvex compositions. *SIAM Journal on Optimization*.
  31(4):2638–2664, 2021
  [DOI](https://doi.org/10.1137/20M1378089)

  - K. A. Khan, J. Larson, and S. M. Wild. Manifold sampling for optimization of
  nonconvex functions that are piecewise linear compositions of smooth
  components. *SIAM Journal on Optimization* 28(4):3001--3024, 2018,
  [DOI](https://doi.org/10.1137/17m114741x)

  - S. M. Wild. POUNDERS in TAO: Solving Derivative-Free Nonlinear
  Least-Squares Problems with POUNDERS. *Advances and Trends in Optimization with
  Engineering Applications*. SIAM. 529--539, 2017.
  [DOI](https://doi.org/10.1137%2F1.9781611974683.ch40)

  - J. Larson, M. Menickelly, and S. M. Wild. Manifold sampling for l1 nonconvex
  optimization. *SIAM Journal on Optimization*. 26(4):2540–2563, 2016.
  [DOI](https://doi.org/10.1137/15M1042097)

## Contributing to IBCDFO

Contributions are welcome in a variety of forms; please see [CONTRIBUTING](CONTRIBUTING.rst).

## License

All code included in IBCDFO is open source, with the particular form of license contained in the top-level
subdirectories.  If such a subdirectory does not contain a LICENSE file, then it is automatically licensed
as described in the otherwise encompassing IBCDFO [LICENSE](/LICENSE).

## Resources

To seek support or report issues, e-mail:

 * ``poptus@mcs.anl.gov``
