# coding: utf-8

"""
    FAX.PLUS REST API

    This is the fax.plus API v1 developed for third party developers and organizations. In order to have a better coding experience with this API, let's quickly go through some points:<br /><br /> - This API assumes **/accounts** as an entry point with the base url of **https://restapi.fax.plus/v1**. <br /><br /> - This API treats all date and times sent to it in requests as **UTC**. Also, all dates and times returned in responses are in **UTC**<br /><br /> - Once you have an access_token, you can easily send a request to the resource server with the base url of **https://restapi.fax.plus/v1** to access your permitted resources. As an example to get the user's profile info you would send a request to **https://restapi.fax.plus/v1/accounts/self** when **Authorization** header is set to \"Bearer YOUR_ACCESS_TOKEN\" and custom header of **x-fax-clientid** is set to YOUR_CLIENT_ID  # noqa: E501

    OpenAPI spec version: 1.1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from faxplus.models.payload_outbox_comment import PayloadOutboxComment  # noqa: F401,E501
from faxplus.models.payload_outbox_options import PayloadOutboxOptions  # noqa: F401,E501


class PayloadOutbox(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'to': 'list[str]',
        'from_number': 'str',
        'files': 'list[str]',
        'options': 'PayloadOutboxOptions',
        'send_time': 'str',
        'comment': 'PayloadOutboxComment'
    }

    attribute_map = {
        'to': 'to',
        'from_number': 'from',
        'files': 'files',
        'options': 'options',
        'send_time': 'send_time',
        'comment': 'comment'
    }

    def __init__(self, to=None, from_number=None, files=None, options=None, send_time=None, comment=None):  # noqa: E501
        """PayloadOutbox - a model defined in Swagger"""  # noqa: E501

        self._to = None
        self._from_number = None
        self._files = None
        self._options = None
        self._send_time = None
        self._comment = None
        self.discriminator = None

        if to is not None:
            self.to = to
        if from_number is not None:
            self.from_number = from_number
        if files is not None:
            self.files = files
        if options is not None:
            self.options = options
        if send_time is not None:
            self.send_time = send_time
        if comment is not None:
            self.comment = comment

    @property
    def to(self):
        """Gets the to of this PayloadOutbox.  # noqa: E501


        :return: The to of this PayloadOutbox.  # noqa: E501
        :rtype: list[str]
        """
        return self._to

    @to.setter
    def to(self, to):
        """Sets the to of this PayloadOutbox.


        :param to: The to of this PayloadOutbox.  # noqa: E501
        :type: list[str]
        """

        self._to = to

    @property
    def from_number(self):
        """Gets the from_number of this PayloadOutbox.  # noqa: E501


        :return: The from_number of this PayloadOutbox.  # noqa: E501
        :rtype: str
        """
        return self._from_number

    @from_number.setter
    def from_number(self, from_number):
        """Sets the from_number of this PayloadOutbox.


        :param from_number: The from_number of this PayloadOutbox.  # noqa: E501
        :type: str
        """

        self._from_number = from_number

    @property
    def files(self):
        """Gets the files of this PayloadOutbox.  # noqa: E501


        :return: The files of this PayloadOutbox.  # noqa: E501
        :rtype: list[str]
        """
        return self._files

    @files.setter
    def files(self, files):
        """Sets the files of this PayloadOutbox.


        :param files: The files of this PayloadOutbox.  # noqa: E501
        :type: list[str]
        """

        self._files = files

    @property
    def options(self):
        """Gets the options of this PayloadOutbox.  # noqa: E501


        :return: The options of this PayloadOutbox.  # noqa: E501
        :rtype: PayloadOutboxOptions
        """
        return self._options

    @options.setter
    def options(self, options):
        """Sets the options of this PayloadOutbox.


        :param options: The options of this PayloadOutbox.  # noqa: E501
        :type: PayloadOutboxOptions
        """

        self._options = options

    @property
    def send_time(self):
        """Gets the send_time of this PayloadOutbox.  # noqa: E501


        :return: The send_time of this PayloadOutbox.  # noqa: E501
        :rtype: str
        """
        return self._send_time

    @send_time.setter
    def send_time(self, send_time):
        """Sets the send_time of this PayloadOutbox.


        :param send_time: The send_time of this PayloadOutbox.  # noqa: E501
        :type: str
        """

        self._send_time = send_time

    @property
    def comment(self):
        """Gets the comment of this PayloadOutbox.  # noqa: E501


        :return: The comment of this PayloadOutbox.  # noqa: E501
        :rtype: PayloadOutboxComment
        """
        return self._comment

    @comment.setter
    def comment(self, comment):
        """Sets the comment of this PayloadOutbox.


        :param comment: The comment of this PayloadOutbox.  # noqa: E501
        :type: PayloadOutboxComment
        """

        self._comment = comment

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PayloadOutbox):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
