# coding: utf-8

"""
    FAX.PLUS REST API

    This is the fax.plus API v1 developed for third party developers and organizations. In order to have a better coding experience with this API, let's quickly go through some points:<br /><br /> - This API assumes **/accounts** as an entry point with the base url of **https://restapi.fax.plus/v1**. <br /><br /> - This API treats all date and times sent to it in requests as **UTC**. Also, all dates and times returned in responses are in **UTC**<br /><br /> - Once you have an access_token, you can easily send a request to the resource server with the base url of **https://restapi.fax.plus/v1** to access your permitted resources. As an example to get the user's profile info you would send a request to **https://restapi.fax.plus/v1/accounts/self** when **Authorization** header is set to \"Bearer YOUR_ACCESS_TOKEN\" and custom header of **x-fax-clientid** is set to YOUR_CLIENT_ID  # noqa: E501

    OpenAPI spec version: 1.1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from faxplus.models.account_settings_send_fax_retry import AccountSettingsSendFaxRetry  # noqa: F401,E501
from faxplus.models.outbox_file_changes import OutboxFileChanges  # noqa: F401,E501
from faxplus.models.outbox_initiated_from import OutboxInitiatedFrom  # noqa: F401,E501
from faxplus.models.outbox_status_changes import OutboxStatusChanges  # noqa: F401,E501
from faxplus.models.payload_outbox_comment import PayloadOutboxComment  # noqa: F401,E501


class Outbox(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'files': 'list[str]',
        'src': 'str',
        'retry': 'AccountSettingsSendFaxRetry',
        'should_enhance': 'bool',
        'uid': 'str',
        'designated_src': 'str',
        'ip': 'str',
        'page_count': 'int',
        'comment': 'PayloadOutboxComment',
        'id': 'str',
        'file_changes': 'list[OutboxFileChanges]',
        'to': 'list[str]',
        'status': 'str',
        'status_changes': 'list[OutboxStatusChanges]',
        'contact_name': 'str',
        'send_time': 'str',
        'initiated_from': 'OutboxInitiatedFrom',
        'submit_time': 'str',
        'last_updated_status_time': 'str',
        'options': 'object',
        'extra_info': 'object'
    }

    attribute_map = {
        'files': 'files',
        'src': 'src',
        'retry': 'retry',
        'should_enhance': 'should_enhance',
        'uid': 'uid',
        'designated_src': 'designated_src',
        'ip': 'ip',
        'page_count': 'page_count',
        'comment': 'comment',
        'id': 'id',
        'file_changes': 'file_changes',
        'to': 'to',
        'status': 'status',
        'status_changes': 'status_changes',
        'contact_name': 'contact_name',
        'send_time': 'send_time',
        'initiated_from': 'initiated_from',
        'submit_time': 'submit_time',
        'last_updated_status_time': 'last_updated_status_time',
        'options': 'options',
        'extra_info': 'extra_info'
    }

    def __init__(self, files=None, src=None, retry=None, should_enhance=None, uid=None, designated_src=None, ip=None, page_count=None, comment=None, id=None, file_changes=None, to=None, status=None, status_changes=None, contact_name=None, send_time=None, initiated_from=None, submit_time=None, last_updated_status_time=None, options=None, extra_info=None):  # noqa: E501
        """Outbox - a model defined in Swagger"""  # noqa: E501

        self._files = None
        self._src = None
        self._retry = None
        self._should_enhance = None
        self._uid = None
        self._designated_src = None
        self._ip = None
        self._page_count = None
        self._comment = None
        self._id = None
        self._file_changes = None
        self._to = None
        self._status = None
        self._status_changes = None
        self._contact_name = None
        self._send_time = None
        self._initiated_from = None
        self._submit_time = None
        self._last_updated_status_time = None
        self._options = None
        self._extra_info = None
        self.discriminator = None

        if files is not None:
            self.files = files
        if src is not None:
            self.src = src
        if retry is not None:
            self.retry = retry
        if should_enhance is not None:
            self.should_enhance = should_enhance
        if uid is not None:
            self.uid = uid
        if designated_src is not None:
            self.designated_src = designated_src
        if ip is not None:
            self.ip = ip
        if page_count is not None:
            self.page_count = page_count
        if comment is not None:
            self.comment = comment
        if id is not None:
            self.id = id
        if file_changes is not None:
            self.file_changes = file_changes
        if to is not None:
            self.to = to
        if status is not None:
            self.status = status
        if status_changes is not None:
            self.status_changes = status_changes
        if contact_name is not None:
            self.contact_name = contact_name
        if send_time is not None:
            self.send_time = send_time
        if initiated_from is not None:
            self.initiated_from = initiated_from
        if submit_time is not None:
            self.submit_time = submit_time
        if last_updated_status_time is not None:
            self.last_updated_status_time = last_updated_status_time
        if options is not None:
            self.options = options
        if extra_info is not None:
            self.extra_info = extra_info

    @property
    def files(self):
        """Gets the files of this Outbox.  # noqa: E501


        :return: The files of this Outbox.  # noqa: E501
        :rtype: list[str]
        """
        return self._files

    @files.setter
    def files(self, files):
        """Sets the files of this Outbox.


        :param files: The files of this Outbox.  # noqa: E501
        :type: list[str]
        """

        self._files = files

    @property
    def src(self):
        """Gets the src of this Outbox.  # noqa: E501


        :return: The src of this Outbox.  # noqa: E501
        :rtype: str
        """
        return self._src

    @src.setter
    def src(self, src):
        """Sets the src of this Outbox.


        :param src: The src of this Outbox.  # noqa: E501
        :type: str
        """

        self._src = src

    @property
    def retry(self):
        """Gets the retry of this Outbox.  # noqa: E501


        :return: The retry of this Outbox.  # noqa: E501
        :rtype: AccountSettingsSendFaxRetry
        """
        return self._retry

    @retry.setter
    def retry(self, retry):
        """Sets the retry of this Outbox.


        :param retry: The retry of this Outbox.  # noqa: E501
        :type: AccountSettingsSendFaxRetry
        """

        self._retry = retry

    @property
    def should_enhance(self):
        """Gets the should_enhance of this Outbox.  # noqa: E501


        :return: The should_enhance of this Outbox.  # noqa: E501
        :rtype: bool
        """
        return self._should_enhance

    @should_enhance.setter
    def should_enhance(self, should_enhance):
        """Sets the should_enhance of this Outbox.


        :param should_enhance: The should_enhance of this Outbox.  # noqa: E501
        :type: bool
        """

        self._should_enhance = should_enhance

    @property
    def uid(self):
        """Gets the uid of this Outbox.  # noqa: E501


        :return: The uid of this Outbox.  # noqa: E501
        :rtype: str
        """
        return self._uid

    @uid.setter
    def uid(self, uid):
        """Sets the uid of this Outbox.


        :param uid: The uid of this Outbox.  # noqa: E501
        :type: str
        """

        self._uid = uid

    @property
    def designated_src(self):
        """Gets the designated_src of this Outbox.  # noqa: E501


        :return: The designated_src of this Outbox.  # noqa: E501
        :rtype: str
        """
        return self._designated_src

    @designated_src.setter
    def designated_src(self, designated_src):
        """Sets the designated_src of this Outbox.


        :param designated_src: The designated_src of this Outbox.  # noqa: E501
        :type: str
        """

        self._designated_src = designated_src

    @property
    def ip(self):
        """Gets the ip of this Outbox.  # noqa: E501


        :return: The ip of this Outbox.  # noqa: E501
        :rtype: str
        """
        return self._ip

    @ip.setter
    def ip(self, ip):
        """Sets the ip of this Outbox.


        :param ip: The ip of this Outbox.  # noqa: E501
        :type: str
        """

        self._ip = ip

    @property
    def page_count(self):
        """Gets the page_count of this Outbox.  # noqa: E501


        :return: The page_count of this Outbox.  # noqa: E501
        :rtype: int
        """
        return self._page_count

    @page_count.setter
    def page_count(self, page_count):
        """Sets the page_count of this Outbox.


        :param page_count: The page_count of this Outbox.  # noqa: E501
        :type: int
        """

        self._page_count = page_count

    @property
    def comment(self):
        """Gets the comment of this Outbox.  # noqa: E501


        :return: The comment of this Outbox.  # noqa: E501
        :rtype: PayloadOutboxComment
        """
        return self._comment

    @comment.setter
    def comment(self, comment):
        """Sets the comment of this Outbox.


        :param comment: The comment of this Outbox.  # noqa: E501
        :type: PayloadOutboxComment
        """

        self._comment = comment

    @property
    def id(self):
        """Gets the id of this Outbox.  # noqa: E501


        :return: The id of this Outbox.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Outbox.


        :param id: The id of this Outbox.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def file_changes(self):
        """Gets the file_changes of this Outbox.  # noqa: E501


        :return: The file_changes of this Outbox.  # noqa: E501
        :rtype: list[OutboxFileChanges]
        """
        return self._file_changes

    @file_changes.setter
    def file_changes(self, file_changes):
        """Sets the file_changes of this Outbox.


        :param file_changes: The file_changes of this Outbox.  # noqa: E501
        :type: list[OutboxFileChanges]
        """

        self._file_changes = file_changes

    @property
    def to(self):
        """Gets the to of this Outbox.  # noqa: E501


        :return: The to of this Outbox.  # noqa: E501
        :rtype: list[str]
        """
        return self._to

    @to.setter
    def to(self, to):
        """Sets the to of this Outbox.


        :param to: The to of this Outbox.  # noqa: E501
        :type: list[str]
        """

        self._to = to

    @property
    def status(self):
        """Gets the status of this Outbox.  # noqa: E501


        :return: The status of this Outbox.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this Outbox.


        :param status: The status of this Outbox.  # noqa: E501
        :type: str
        """

        self._status = status

    @property
    def status_changes(self):
        """Gets the status_changes of this Outbox.  # noqa: E501


        :return: The status_changes of this Outbox.  # noqa: E501
        :rtype: list[OutboxStatusChanges]
        """
        return self._status_changes

    @status_changes.setter
    def status_changes(self, status_changes):
        """Sets the status_changes of this Outbox.


        :param status_changes: The status_changes of this Outbox.  # noqa: E501
        :type: list[OutboxStatusChanges]
        """

        self._status_changes = status_changes

    @property
    def contact_name(self):
        """Gets the contact_name of this Outbox.  # noqa: E501


        :return: The contact_name of this Outbox.  # noqa: E501
        :rtype: str
        """
        return self._contact_name

    @contact_name.setter
    def contact_name(self, contact_name):
        """Sets the contact_name of this Outbox.


        :param contact_name: The contact_name of this Outbox.  # noqa: E501
        :type: str
        """

        self._contact_name = contact_name

    @property
    def send_time(self):
        """Gets the send_time of this Outbox.  # noqa: E501


        :return: The send_time of this Outbox.  # noqa: E501
        :rtype: str
        """
        return self._send_time

    @send_time.setter
    def send_time(self, send_time):
        """Sets the send_time of this Outbox.


        :param send_time: The send_time of this Outbox.  # noqa: E501
        :type: str
        """

        self._send_time = send_time

    @property
    def initiated_from(self):
        """Gets the initiated_from of this Outbox.  # noqa: E501


        :return: The initiated_from of this Outbox.  # noqa: E501
        :rtype: OutboxInitiatedFrom
        """
        return self._initiated_from

    @initiated_from.setter
    def initiated_from(self, initiated_from):
        """Sets the initiated_from of this Outbox.


        :param initiated_from: The initiated_from of this Outbox.  # noqa: E501
        :type: OutboxInitiatedFrom
        """

        self._initiated_from = initiated_from

    @property
    def submit_time(self):
        """Gets the submit_time of this Outbox.  # noqa: E501


        :return: The submit_time of this Outbox.  # noqa: E501
        :rtype: str
        """
        return self._submit_time

    @submit_time.setter
    def submit_time(self, submit_time):
        """Sets the submit_time of this Outbox.


        :param submit_time: The submit_time of this Outbox.  # noqa: E501
        :type: str
        """

        self._submit_time = submit_time

    @property
    def last_updated_status_time(self):
        """Gets the last_updated_status_time of this Outbox.  # noqa: E501


        :return: The last_updated_status_time of this Outbox.  # noqa: E501
        :rtype: str
        """
        return self._last_updated_status_time

    @last_updated_status_time.setter
    def last_updated_status_time(self, last_updated_status_time):
        """Sets the last_updated_status_time of this Outbox.


        :param last_updated_status_time: The last_updated_status_time of this Outbox.  # noqa: E501
        :type: str
        """

        self._last_updated_status_time = last_updated_status_time

    @property
    def options(self):
        """Gets the options of this Outbox.  # noqa: E501


        :return: The options of this Outbox.  # noqa: E501
        :rtype: object
        """
        return self._options

    @options.setter
    def options(self, options):
        """Sets the options of this Outbox.


        :param options: The options of this Outbox.  # noqa: E501
        :type: object
        """

        self._options = options

    @property
    def extra_info(self):
        """Gets the extra_info of this Outbox.  # noqa: E501


        :return: The extra_info of this Outbox.  # noqa: E501
        :rtype: object
        """
        return self._extra_info

    @extra_info.setter
    def extra_info(self, extra_info):
        """Sets the extra_info of this Outbox.


        :param extra_info: The extra_info of this Outbox.  # noqa: E501
        :type: object
        """

        self._extra_info = extra_info

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Outbox):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
