# coding: utf-8

"""
    FAX.PLUS REST API

    This is the fax.plus API v1 developed for third party developers and organizations. In order to have a better coding experience with this API, let's quickly go through some points:<br /><br /> - This API assumes **/accounts** as an entry point with the base url of **https://restapi.fax.plus/v1**. <br /><br /> - This API treats all date and times sent to it in requests as **UTC**. Also, all dates and times returned in responses are in **UTC**<br /><br /> - Once you have an access_token, you can easily send a request to the resource server with the base url of **https://restapi.fax.plus/v1** to access your permitted resources. As an example to get the user's profile info you would send a request to **https://restapi.fax.plus/v1/accounts/self** when **Authorization** header is set to \"Bearer YOUR_ACCESS_TOKEN\" and custom header of **x-fax-clientid** is set to YOUR_CLIENT_ID  # noqa: E501

    OpenAPI spec version: 1.1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class NumberNotifications(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'type': 'str',
        'email': 'bool',
        'push_notification': 'bool'
    }

    attribute_map = {
        'type': 'type',
        'email': 'email',
        'push_notification': 'push_notification'
    }

    def __init__(self, type=None, email=None, push_notification=None):  # noqa: E501
        """NumberNotifications - a model defined in Swagger"""  # noqa: E501

        self._type = None
        self._email = None
        self._push_notification = None
        self.discriminator = None

        if type is not None:
            self.type = type
        if email is not None:
            self.email = email
        if push_notification is not None:
            self.push_notification = push_notification

    @property
    def type(self):
        """Gets the type of this NumberNotifications.  # noqa: E501


        :return: The type of this NumberNotifications.  # noqa: E501
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type):
        """Sets the type of this NumberNotifications.


        :param type: The type of this NumberNotifications.  # noqa: E501
        :type: str
        """

        self._type = type

    @property
    def email(self):
        """Gets the email of this NumberNotifications.  # noqa: E501


        :return: The email of this NumberNotifications.  # noqa: E501
        :rtype: bool
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this NumberNotifications.


        :param email: The email of this NumberNotifications.  # noqa: E501
        :type: bool
        """

        self._email = email

    @property
    def push_notification(self):
        """Gets the push_notification of this NumberNotifications.  # noqa: E501


        :return: The push_notification of this NumberNotifications.  # noqa: E501
        :rtype: bool
        """
        return self._push_notification

    @push_notification.setter
    def push_notification(self, push_notification):
        """Sets the push_notification of this NumberNotifications.


        :param push_notification: The push_notification of this NumberNotifications.  # noqa: E501
        :type: bool
        """

        self._push_notification = push_notification

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, NumberNotifications):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
