# coding: utf-8

"""
    FAX.PLUS REST API

    This is the fax.plus API v1 developed for third party developers and organizations. In order to have a better coding experience with this API, let's quickly go through some points:<br /><br /> - This API assumes **/accounts** as an entry point with the base url of **https://restapi.fax.plus/v1**. <br /><br /> - This API treats all date and times sent to it in requests as **UTC**. Also, all dates and times returned in responses are in **UTC**<br /><br /> - Once you have an access_token, you can easily send a request to the resource server with the base url of **https://restapi.fax.plus/v1** to access your permitted resources. As an example to get the user's profile info you would send a request to **https://restapi.fax.plus/v1/accounts/self** when **Authorization** header is set to \"Bearer YOUR_ACCESS_TOKEN\" and custom header of **x-fax-clientid** is set to YOUR_CLIENT_ID  # noqa: E501

    OpenAPI spec version: 1.1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from faxplus.models.number_notifications import NumberNotifications  # noqa: F401,E501


class Number(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'id': 'str',
        'status': 'str',
        'is_canceled': 'bool',
        'expiration_date': 'str',
        'number': 'str',
        'notifications': 'list[NumberNotifications]',
        'acquired_date': 'str',
        'assigned_to': 'object',
        'owner_id': 'str'
    }

    attribute_map = {
        'id': 'id',
        'status': 'status',
        'is_canceled': 'is_canceled',
        'expiration_date': 'expiration_date',
        'number': 'number',
        'notifications': 'notifications',
        'acquired_date': 'acquired_date',
        'assigned_to': 'assigned_to',
        'owner_id': 'owner_id'
    }

    def __init__(self, id=None, status=None, is_canceled=None, expiration_date=None, number=None, notifications=None, acquired_date=None, assigned_to=None, owner_id=None):  # noqa: E501
        """Number - a model defined in Swagger"""  # noqa: E501

        self._id = None
        self._status = None
        self._is_canceled = None
        self._expiration_date = None
        self._number = None
        self._notifications = None
        self._acquired_date = None
        self._assigned_to = None
        self._owner_id = None
        self.discriminator = None

        if id is not None:
            self.id = id
        if status is not None:
            self.status = status
        if is_canceled is not None:
            self.is_canceled = is_canceled
        if expiration_date is not None:
            self.expiration_date = expiration_date
        if number is not None:
            self.number = number
        if notifications is not None:
            self.notifications = notifications
        if acquired_date is not None:
            self.acquired_date = acquired_date
        if assigned_to is not None:
            self.assigned_to = assigned_to
        if owner_id is not None:
            self.owner_id = owner_id

    @property
    def id(self):
        """Gets the id of this Number.  # noqa: E501


        :return: The id of this Number.  # noqa: E501
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id):
        """Sets the id of this Number.


        :param id: The id of this Number.  # noqa: E501
        :type: str
        """

        self._id = id

    @property
    def status(self):
        """Gets the status of this Number.  # noqa: E501

        Status of your fax phone number e.g. active, inactive.  # noqa: E501

        :return: The status of this Number.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this Number.

        Status of your fax phone number e.g. active, inactive.  # noqa: E501

        :param status: The status of this Number.  # noqa: E501
        :type: str
        """

        self._status = status

    @property
    def is_canceled(self):
        """Gets the is_canceled of this Number.  # noqa: E501


        :return: The is_canceled of this Number.  # noqa: E501
        :rtype: bool
        """
        return self._is_canceled

    @is_canceled.setter
    def is_canceled(self, is_canceled):
        """Sets the is_canceled of this Number.


        :param is_canceled: The is_canceled of this Number.  # noqa: E501
        :type: bool
        """

        self._is_canceled = is_canceled

    @property
    def expiration_date(self):
        """Gets the expiration_date of this Number.  # noqa: E501


        :return: The expiration_date of this Number.  # noqa: E501
        :rtype: str
        """
        return self._expiration_date

    @expiration_date.setter
    def expiration_date(self, expiration_date):
        """Sets the expiration_date of this Number.


        :param expiration_date: The expiration_date of this Number.  # noqa: E501
        :type: str
        """

        self._expiration_date = expiration_date

    @property
    def number(self):
        """Gets the number of this Number.  # noqa: E501


        :return: The number of this Number.  # noqa: E501
        :rtype: str
        """
        return self._number

    @number.setter
    def number(self, number):
        """Sets the number of this Number.


        :param number: The number of this Number.  # noqa: E501
        :type: str
        """

        self._number = number

    @property
    def notifications(self):
        """Gets the notifications of this Number.  # noqa: E501


        :return: The notifications of this Number.  # noqa: E501
        :rtype: list[NumberNotifications]
        """
        return self._notifications

    @notifications.setter
    def notifications(self, notifications):
        """Sets the notifications of this Number.


        :param notifications: The notifications of this Number.  # noqa: E501
        :type: list[NumberNotifications]
        """

        self._notifications = notifications

    @property
    def acquired_date(self):
        """Gets the acquired_date of this Number.  # noqa: E501


        :return: The acquired_date of this Number.  # noqa: E501
        :rtype: str
        """
        return self._acquired_date

    @acquired_date.setter
    def acquired_date(self, acquired_date):
        """Sets the acquired_date of this Number.


        :param acquired_date: The acquired_date of this Number.  # noqa: E501
        :type: str
        """

        self._acquired_date = acquired_date

    @property
    def assigned_to(self):
        """Gets the assigned_to of this Number.  # noqa: E501


        :return: The assigned_to of this Number.  # noqa: E501
        :rtype: object
        """
        return self._assigned_to

    @assigned_to.setter
    def assigned_to(self, assigned_to):
        """Sets the assigned_to of this Number.


        :param assigned_to: The assigned_to of this Number.  # noqa: E501
        :type: object
        """

        self._assigned_to = assigned_to

    @property
    def owner_id(self):
        """Gets the owner_id of this Number.  # noqa: E501


        :return: The owner_id of this Number.  # noqa: E501
        :rtype: str
        """
        return self._owner_id

    @owner_id.setter
    def owner_id(self, owner_id):
        """Sets the owner_id of this Number.


        :param owner_id: The owner_id of this Number.  # noqa: E501
        :type: str
        """

        self._owner_id = owner_id

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Number):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
