# coding: utf-8

"""
    FAX.PLUS REST API

    This is the fax.plus API v1 developed for third party developers and organizations. In order to have a better coding experience with this API, let's quickly go through some points:<br /><br /> - This API assumes **/accounts** as an entry point with the base url of **https://restapi.fax.plus/v1**. <br /><br /> - This API treats all date and times sent to it in requests as **UTC**. Also, all dates and times returned in responses are in **UTC**<br /><br /> - Once you have an access_token, you can easily send a request to the resource server with the base url of **https://restapi.fax.plus/v1** to access your permitted resources. As an example to get the user's profile info you would send a request to **https://restapi.fax.plus/v1/accounts/self** when **Authorization** header is set to \"Bearer YOUR_ACCESS_TOKEN\" and custom header of **x-fax-clientid** is set to YOUR_CLIENT_ID  # noqa: E501

    OpenAPI spec version: 1.1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from faxplus.models.account_settings_send_fax import AccountSettingsSendFax  # noqa: F401,E501


class AccountSettings(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'caller_id_name': 'str',
        'send_fax': 'AccountSettingsSendFax',
        'should_enhance': 'bool',
        'options': 'object'
    }

    attribute_map = {
        'caller_id_name': 'caller_id_name',
        'send_fax': 'send_fax',
        'should_enhance': 'should_enhance',
        'options': 'options'
    }

    def __init__(self, caller_id_name=None, send_fax=None, should_enhance=None, options=None):  # noqa: E501
        """AccountSettings - a model defined in Swagger"""  # noqa: E501

        self._caller_id_name = None
        self._send_fax = None
        self._should_enhance = None
        self._options = None
        self.discriminator = None

        if caller_id_name is not None:
            self.caller_id_name = caller_id_name
        if send_fax is not None:
            self.send_fax = send_fax
        if should_enhance is not None:
            self.should_enhance = should_enhance
        if options is not None:
            self.options = options

    @property
    def caller_id_name(self):
        """Gets the caller_id_name of this AccountSettings.  # noqa: E501

        Account caller id name  # noqa: E501

        :return: The caller_id_name of this AccountSettings.  # noqa: E501
        :rtype: str
        """
        return self._caller_id_name

    @caller_id_name.setter
    def caller_id_name(self, caller_id_name):
        """Sets the caller_id_name of this AccountSettings.

        Account caller id name  # noqa: E501

        :param caller_id_name: The caller_id_name of this AccountSettings.  # noqa: E501
        :type: str
        """

        self._caller_id_name = caller_id_name

    @property
    def send_fax(self):
        """Gets the send_fax of this AccountSettings.  # noqa: E501


        :return: The send_fax of this AccountSettings.  # noqa: E501
        :rtype: AccountSettingsSendFax
        """
        return self._send_fax

    @send_fax.setter
    def send_fax(self, send_fax):
        """Sets the send_fax of this AccountSettings.


        :param send_fax: The send_fax of this AccountSettings.  # noqa: E501
        :type: AccountSettingsSendFax
        """

        self._send_fax = send_fax

    @property
    def should_enhance(self):
        """Gets the should_enhance of this AccountSettings.  # noqa: E501


        :return: The should_enhance of this AccountSettings.  # noqa: E501
        :rtype: bool
        """
        return self._should_enhance

    @should_enhance.setter
    def should_enhance(self, should_enhance):
        """Sets the should_enhance of this AccountSettings.


        :param should_enhance: The should_enhance of this AccountSettings.  # noqa: E501
        :type: bool
        """

        self._should_enhance = should_enhance

    @property
    def options(self):
        """Gets the options of this AccountSettings.  # noqa: E501


        :return: The options of this AccountSettings.  # noqa: E501
        :rtype: object
        """
        return self._options

    @options.setter
    def options(self, options):
        """Sets the options of this AccountSettings.


        :param options: The options of this AccountSettings.  # noqa: E501
        :type: object
        """

        self._options = options

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AccountSettings):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
