# coding: utf-8

"""
    FAX.PLUS REST API

    This is the fax.plus API v1 developed for third party developers and organizations. In order to have a better coding experience with this API, let's quickly go through some points:<br /><br /> - This API assumes **/accounts** as an entry point with the base url of **https://restapi.fax.plus/v1**. <br /><br /> - This API treats all date and times sent to it in requests as **UTC**. Also, all dates and times returned in responses are in **UTC**<br /><br /> - Once you have an access_token, you can easily send a request to the resource server with the base url of **https://restapi.fax.plus/v1** to access your permitted resources. As an example to get the user's profile info you would send a request to **https://restapi.fax.plus/v1/accounts/self** when **Authorization** header is set to \"Bearer YOUR_ACCESS_TOKEN\" and custom header of **x-fax-clientid** is set to YOUR_CLIENT_ID  # noqa: E501

    OpenAPI spec version: 1.1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class AccountAccountData(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'default_file_type': 'str',
        'save_history': 'bool',
        'company_name': 'str'
    }

    attribute_map = {
        'default_file_type': 'default_file_type',
        'save_history': 'save_history',
        'company_name': 'company_name'
    }

    def __init__(self, default_file_type=None, save_history=None, company_name=None):  # noqa: E501
        """AccountAccountData - a model defined in Swagger"""  # noqa: E501

        self._default_file_type = None
        self._save_history = None
        self._company_name = None
        self.discriminator = None

        if default_file_type is not None:
            self.default_file_type = default_file_type
        if save_history is not None:
            self.save_history = save_history
        if company_name is not None:
            self.company_name = company_name

    @property
    def default_file_type(self):
        """Gets the default_file_type of this AccountAccountData.  # noqa: E501

        Default file type that fax server uses to send the fax  # noqa: E501

        :return: The default_file_type of this AccountAccountData.  # noqa: E501
        :rtype: str
        """
        return self._default_file_type

    @default_file_type.setter
    def default_file_type(self, default_file_type):
        """Sets the default_file_type of this AccountAccountData.

        Default file type that fax server uses to send the fax  # noqa: E501

        :param default_file_type: The default_file_type of this AccountAccountData.  # noqa: E501
        :type: str
        """

        self._default_file_type = default_file_type

    @property
    def save_history(self):
        """Gets the save_history of this AccountAccountData.  # noqa: E501

        Save fax CDRs in inbox status  # noqa: E501

        :return: The save_history of this AccountAccountData.  # noqa: E501
        :rtype: bool
        """
        return self._save_history

    @save_history.setter
    def save_history(self, save_history):
        """Sets the save_history of this AccountAccountData.

        Save fax CDRs in inbox status  # noqa: E501

        :param save_history: The save_history of this AccountAccountData.  # noqa: E501
        :type: bool
        """

        self._save_history = save_history

    @property
    def company_name(self):
        """Gets the company_name of this AccountAccountData.  # noqa: E501

        Your company name in case you are corporate admin  # noqa: E501

        :return: The company_name of this AccountAccountData.  # noqa: E501
        :rtype: str
        """
        return self._company_name

    @company_name.setter
    def company_name(self, company_name):
        """Sets the company_name of this AccountAccountData.

        Your company name in case you are corporate admin  # noqa: E501

        :param company_name: The company_name of this AccountAccountData.  # noqa: E501
        :type: str
        """

        self._company_name = company_name

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, AccountAccountData):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
