# coding: utf-8

"""
    FAX.PLUS REST API

    This is the fax.plus API v1 developed for third party developers and organizations. In order to have a better coding experience with this API, let's quickly go through some points:<br /><br /> - This API assumes **/accounts** as an entry point with the base url of **https://restapi.fax.plus/v1**. <br /><br /> - This API treats all date and times sent to it in requests as **UTC**. Also, all dates and times returned in responses are in **UTC**<br /><br /> - Once you have an access_token, you can easily send a request to the resource server with the base url of **https://restapi.fax.plus/v1** to access your permitted resources. As an example to get the user's profile info you would send a request to **https://restapi.fax.plus/v1/accounts/self** when **Authorization** header is set to \"Bearer YOUR_ACCESS_TOKEN\" and custom header of **x-fax-clientid** is set to YOUR_CLIENT_ID  # noqa: E501

    OpenAPI spec version: 1.1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six

from faxplus.models.account_account_data import AccountAccountData  # noqa: F401,E501
from faxplus.models.account_settings import AccountSettings  # noqa: F401,E501


class Account(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'status': 'str',
        'account_type': 'str',
        'lastname': 'str',
        'profile_image': 'str',
        'creation_date': 'str',
        'phone': 'str',
        'last_password_modification_date': 'str',
        'uid': 'str',
        'account_data': 'AccountAccountData',
        'name': 'str',
        'member_of': 'list[str]',
        'settings': 'AccountSettings',
        'email': 'str',
        'notifications': 'object'
    }

    attribute_map = {
        'status': 'status',
        'account_type': 'account_type',
        'lastname': 'lastname',
        'profile_image': 'profile_image',
        'creation_date': 'creation_date',
        'phone': 'phone',
        'last_password_modification_date': 'last_password_modification_date',
        'uid': 'uid',
        'account_data': 'account_data',
        'name': 'name',
        'member_of': 'member_of',
        'settings': 'settings',
        'email': 'email',
        'notifications': 'notifications'
    }

    def __init__(self, status=None, account_type=None, lastname=None, profile_image=None, creation_date=None, phone=None, last_password_modification_date=None, uid=None, account_data=None, name=None, member_of=None, settings=None, email=None, notifications=None):  # noqa: E501
        """Account - a model defined in Swagger"""  # noqa: E501

        self._status = None
        self._account_type = None
        self._lastname = None
        self._profile_image = None
        self._creation_date = None
        self._phone = None
        self._last_password_modification_date = None
        self._uid = None
        self._account_data = None
        self._name = None
        self._member_of = None
        self._settings = None
        self._email = None
        self._notifications = None
        self.discriminator = None

        if status is not None:
            self.status = status
        if account_type is not None:
            self.account_type = account_type
        if lastname is not None:
            self.lastname = lastname
        if profile_image is not None:
            self.profile_image = profile_image
        if creation_date is not None:
            self.creation_date = creation_date
        if phone is not None:
            self.phone = phone
        if last_password_modification_date is not None:
            self.last_password_modification_date = last_password_modification_date
        if uid is not None:
            self.uid = uid
        if account_data is not None:
            self.account_data = account_data
        if name is not None:
            self.name = name
        if member_of is not None:
            self.member_of = member_of
        if settings is not None:
            self.settings = settings
        if email is not None:
            self.email = email
        if notifications is not None:
            self.notifications = notifications

    @property
    def status(self):
        """Gets the status of this Account.  # noqa: E501

        Your account status which could be active, inactive etc  # noqa: E501

        :return: The status of this Account.  # noqa: E501
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status):
        """Sets the status of this Account.

        Your account status which could be active, inactive etc  # noqa: E501

        :param status: The status of this Account.  # noqa: E501
        :type: str
        """

        self._status = status

    @property
    def account_type(self):
        """Gets the account_type of this Account.  # noqa: E501

        Account type which could be corporate_admin, individual, etc  # noqa: E501

        :return: The account_type of this Account.  # noqa: E501
        :rtype: str
        """
        return self._account_type

    @account_type.setter
    def account_type(self, account_type):
        """Sets the account_type of this Account.

        Account type which could be corporate_admin, individual, etc  # noqa: E501

        :param account_type: The account_type of this Account.  # noqa: E501
        :type: str
        """

        self._account_type = account_type

    @property
    def lastname(self):
        """Gets the lastname of this Account.  # noqa: E501

        Your last name  # noqa: E501

        :return: The lastname of this Account.  # noqa: E501
        :rtype: str
        """
        return self._lastname

    @lastname.setter
    def lastname(self, lastname):
        """Sets the lastname of this Account.

        Your last name  # noqa: E501

        :param lastname: The lastname of this Account.  # noqa: E501
        :type: str
        """

        self._lastname = lastname

    @property
    def profile_image(self):
        """Gets the profile_image of this Account.  # noqa: E501

        Profile image path  # noqa: E501

        :return: The profile_image of this Account.  # noqa: E501
        :rtype: str
        """
        return self._profile_image

    @profile_image.setter
    def profile_image(self, profile_image):
        """Sets the profile_image of this Account.

        Profile image path  # noqa: E501

        :param profile_image: The profile_image of this Account.  # noqa: E501
        :type: str
        """

        self._profile_image = profile_image

    @property
    def creation_date(self):
        """Gets the creation_date of this Account.  # noqa: E501

        creation date in UTC in the format of YYYY-MM-DD  # noqa: E501

        :return: The creation_date of this Account.  # noqa: E501
        :rtype: str
        """
        return self._creation_date

    @creation_date.setter
    def creation_date(self, creation_date):
        """Sets the creation_date of this Account.

        creation date in UTC in the format of YYYY-MM-DD  # noqa: E501

        :param creation_date: The creation_date of this Account.  # noqa: E501
        :type: str
        """

        self._creation_date = creation_date

    @property
    def phone(self):
        """Gets the phone of this Account.  # noqa: E501

        Your account phone number  # noqa: E501

        :return: The phone of this Account.  # noqa: E501
        :rtype: str
        """
        return self._phone

    @phone.setter
    def phone(self, phone):
        """Sets the phone of this Account.

        Your account phone number  # noqa: E501

        :param phone: The phone of this Account.  # noqa: E501
        :type: str
        """

        self._phone = phone

    @property
    def last_password_modification_date(self):
        """Gets the last_password_modification_date of this Account.  # noqa: E501

        The date in which you have changed your password  # noqa: E501

        :return: The last_password_modification_date of this Account.  # noqa: E501
        :rtype: str
        """
        return self._last_password_modification_date

    @last_password_modification_date.setter
    def last_password_modification_date(self, last_password_modification_date):
        """Sets the last_password_modification_date of this Account.

        The date in which you have changed your password  # noqa: E501

        :param last_password_modification_date: The last_password_modification_date of this Account.  # noqa: E501
        :type: str
        """

        self._last_password_modification_date = last_password_modification_date

    @property
    def uid(self):
        """Gets the uid of this Account.  # noqa: E501

        user id of current user  # noqa: E501

        :return: The uid of this Account.  # noqa: E501
        :rtype: str
        """
        return self._uid

    @uid.setter
    def uid(self, uid):
        """Sets the uid of this Account.

        user id of current user  # noqa: E501

        :param uid: The uid of this Account.  # noqa: E501
        :type: str
        """

        self._uid = uid

    @property
    def account_data(self):
        """Gets the account_data of this Account.  # noqa: E501


        :return: The account_data of this Account.  # noqa: E501
        :rtype: AccountAccountData
        """
        return self._account_data

    @account_data.setter
    def account_data(self, account_data):
        """Sets the account_data of this Account.


        :param account_data: The account_data of this Account.  # noqa: E501
        :type: AccountAccountData
        """

        self._account_data = account_data

    @property
    def name(self):
        """Gets the name of this Account.  # noqa: E501

        your first name  # noqa: E501

        :return: The name of this Account.  # noqa: E501
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name):
        """Sets the name of this Account.

        your first name  # noqa: E501

        :param name: The name of this Account.  # noqa: E501
        :type: str
        """

        self._name = name

    @property
    def member_of(self):
        """Gets the member_of of this Account.  # noqa: E501

        list of user ids that you are member of.  # noqa: E501

        :return: The member_of of this Account.  # noqa: E501
        :rtype: list[str]
        """
        return self._member_of

    @member_of.setter
    def member_of(self, member_of):
        """Sets the member_of of this Account.

        list of user ids that you are member of.  # noqa: E501

        :param member_of: The member_of of this Account.  # noqa: E501
        :type: list[str]
        """

        self._member_of = member_of

    @property
    def settings(self):
        """Gets the settings of this Account.  # noqa: E501


        :return: The settings of this Account.  # noqa: E501
        :rtype: AccountSettings
        """
        return self._settings

    @settings.setter
    def settings(self, settings):
        """Sets the settings of this Account.


        :param settings: The settings of this Account.  # noqa: E501
        :type: AccountSettings
        """

        self._settings = settings

    @property
    def email(self):
        """Gets the email of this Account.  # noqa: E501

        Account email address  # noqa: E501

        :return: The email of this Account.  # noqa: E501
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email):
        """Sets the email of this Account.

        Account email address  # noqa: E501

        :param email: The email of this Account.  # noqa: E501
        :type: str
        """

        self._email = email

    @property
    def notifications(self):
        """Gets the notifications of this Account.  # noqa: E501


        :return: The notifications of this Account.  # noqa: E501
        :rtype: object
        """
        return self._notifications

    @notifications.setter
    def notifications(self, notifications):
        """Sets the notifications of this Account.


        :param notifications: The notifications of this Account.  # noqa: E501
        :type: object
        """

        self._notifications = notifications

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, Account):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
