# coding: utf-8

"""
    FAX.PLUS REST API

    This is the fax.plus API v1 developed for third party developers and organizations. In order to have a better coding experience with this API, let's quickly go through some points:<br /><br /> - This API assumes **/accounts** as an entry point with the base url of **https://restapi.fax.plus/v1**. <br /><br /> - This API treats all date and times sent to it in requests as **UTC**. Also, all dates and times returned in responses are in **UTC**<br /><br /> - Once you have an access_token, you can easily send a request to the resource server with the base url of **https://restapi.fax.plus/v1** to access your permitted resources. As an example to get the user's profile info you would send a request to **https://restapi.fax.plus/v1/accounts/self** when **Authorization** header is set to \"Bearer YOUR_ACCESS_TOKEN\" and custom header of **x-fax-clientid** is set to YOUR_CLIENT_ID  # noqa: E501

    OpenAPI spec version: 1.1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from faxplus.api_client import ApiClient


class OutboxApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def delete_outbox_fax(self, outbox_fax_id, **kwargs):  # noqa: E501
        """Delete a fax from outbox  # noqa: E501

        Delete a fax that is being sent and is still in your outbox  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_outbox_fax(outbox_fax_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str outbox_fax_id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.delete_outbox_fax_with_http_info(outbox_fax_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_outbox_fax_with_http_info(outbox_fax_id, **kwargs)  # noqa: E501
            return data

    def delete_outbox_fax_with_http_info(self, outbox_fax_id, **kwargs):  # noqa: E501
        """Delete a fax from outbox  # noqa: E501

        Delete a fax that is being sent and is still in your outbox  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.delete_outbox_fax_with_http_info(outbox_fax_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str outbox_fax_id: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['outbox_fax_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbox_fax" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'outbox_fax_id' is set
        if ('outbox_fax_id' not in params or
                params['outbox_fax_id'] is None):
            raise ValueError("Missing the required parameter `outbox_fax_id` when calling `delete_outbox_fax`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'outbox_fax_id' in params:
            path_params['outbox_fax_id'] = params['outbox_fax_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fax_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/accounts/self/outbox/{outbox_fax_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_outbox_fax(self, outbox_fax_id, **kwargs):  # noqa: E501
        """Get an outbox record  # noqa: E501

        Get an outbox fax record information  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_outbox_fax(outbox_fax_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str outbox_fax_id: (required)
        :return: Outbox
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_outbox_fax_with_http_info(outbox_fax_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_outbox_fax_with_http_info(outbox_fax_id, **kwargs)  # noqa: E501
            return data

    def get_outbox_fax_with_http_info(self, outbox_fax_id, **kwargs):  # noqa: E501
        """Get an outbox record  # noqa: E501

        Get an outbox fax record information  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_outbox_fax_with_http_info(outbox_fax_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str outbox_fax_id: (required)
        :return: Outbox
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['outbox_fax_id']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbox_fax" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'outbox_fax_id' is set
        if ('outbox_fax_id' not in params or
                params['outbox_fax_id'] is None):
            raise ValueError("Missing the required parameter `outbox_fax_id` when calling `get_outbox_fax`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'outbox_fax_id' in params:
            path_params['outbox_fax_id'] = params['outbox_fax_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fax_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/accounts/self/outbox/{outbox_fax_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Outbox',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_outbox_faxes(self, **kwargs):  # noqa: E501
        """Get outbox records  # noqa: E501

        Get outbox fax records information  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_outbox_faxes(async=True)
        >>> result = thread.get()

        :param async bool
        :return: ResponseOutboxList
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.list_outbox_faxes_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_outbox_faxes_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_outbox_faxes_with_http_info(self, **kwargs):  # noqa: E501
        """Get outbox records  # noqa: E501

        Get outbox fax records information  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.list_outbox_faxes_with_http_info(async=True)
        >>> result = thread.get()

        :param async bool
        :return: ResponseOutboxList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_outbox_faxes" % key
                )
            params[key] = val
        del params['kwargs']

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fax_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/accounts/self/outbox', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='ResponseOutboxList',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def send_fax(self, payload_outbox, **kwargs):  # noqa: E501
        """Send a fax  # noqa: E501

        With this API call you will be able to send a fax (one or more files) to one or more destinations. If you are a corporate member and you don't have a fax number set your **from** parameter to **NO_NUMBER**  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.send_fax(payload_outbox, async=True)
        >>> result = thread.get()

        :param async bool
        :param PayloadOutbox payload_outbox: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.send_fax_with_http_info(payload_outbox, **kwargs)  # noqa: E501
        else:
            (data) = self.send_fax_with_http_info(payload_outbox, **kwargs)  # noqa: E501
            return data

    def send_fax_with_http_info(self, payload_outbox, **kwargs):  # noqa: E501
        """Send a fax  # noqa: E501

        With this API call you will be able to send a fax (one or more files) to one or more destinations. If you are a corporate member and you don't have a fax number set your **from** parameter to **NO_NUMBER**  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.send_fax_with_http_info(payload_outbox, async=True)
        >>> result = thread.get()

        :param async bool
        :param PayloadOutbox payload_outbox: (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['payload_outbox']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method send_fax" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'payload_outbox' is set
        if ('payload_outbox' not in params or
                params['payload_outbox'] is None):
            raise ValueError("Missing the required parameter `payload_outbox` when calling `send_fax`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'payload_outbox' in params:
            body_params = params['payload_outbox']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fax_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/accounts/self/outbox', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_outbox_fax(self, outbox_fax_id, payload_outbox_modification, **kwargs):  # noqa: E501
        """Modify a fax record in outbox  # noqa: E501

        Modify outbox record's comment  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_outbox_fax(outbox_fax_id, payload_outbox_modification, async=True)
        >>> result = thread.get()

        :param async bool
        :param str outbox_fax_id: (required)
        :param PayloadOutboxModification payload_outbox_modification: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.update_outbox_fax_with_http_info(outbox_fax_id, payload_outbox_modification, **kwargs)  # noqa: E501
        else:
            (data) = self.update_outbox_fax_with_http_info(outbox_fax_id, payload_outbox_modification, **kwargs)  # noqa: E501
            return data

    def update_outbox_fax_with_http_info(self, outbox_fax_id, payload_outbox_modification, **kwargs):  # noqa: E501
        """Modify a fax record in outbox  # noqa: E501

        Modify outbox record's comment  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.update_outbox_fax_with_http_info(outbox_fax_id, payload_outbox_modification, async=True)
        >>> result = thread.get()

        :param async bool
        :param str outbox_fax_id: (required)
        :param PayloadOutboxModification payload_outbox_modification: (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['outbox_fax_id', 'payload_outbox_modification']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_outbox_fax" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'outbox_fax_id' is set
        if ('outbox_fax_id' not in params or
                params['outbox_fax_id'] is None):
            raise ValueError("Missing the required parameter `outbox_fax_id` when calling `update_outbox_fax`")  # noqa: E501
        # verify the required parameter 'payload_outbox_modification' is set
        if ('payload_outbox_modification' not in params or
                params['payload_outbox_modification'] is None):
            raise ValueError("Missing the required parameter `payload_outbox_modification` when calling `update_outbox_fax`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'outbox_fax_id' in params:
            path_params['outbox_fax_id'] = params['outbox_fax_id']  # noqa: E501

        query_params = []

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'payload_outbox_modification' in params:
            body_params = params['payload_outbox_modification']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fax_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/accounts/self/outbox/{outbox_fax_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='object',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
