# coding: utf-8

"""
    FAX.PLUS REST API

    This is the fax.plus API v1 developed for third party developers and organizations. In order to have a better coding experience with this API, let's quickly go through some points:<br /><br /> - This API assumes **/accounts** as an entry point with the base url of **https://restapi.fax.plus/v1**. <br /><br /> - This API treats all date and times sent to it in requests as **UTC**. Also, all dates and times returned in responses are in **UTC**<br /><br /> - Once you have an access_token, you can easily send a request to the resource server with the base url of **https://restapi.fax.plus/v1** to access your permitted resources. As an example to get the user's profile info you would send a request to **https://restapi.fax.plus/v1/accounts/self** when **Authorization** header is set to \"Bearer YOUR_ACCESS_TOKEN\" and custom header of **x-fax-clientid** is set to YOUR_CLIENT_ID  # noqa: E501

    OpenAPI spec version: 1.1.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from faxplus.api_client import ApiClient


class FilesApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_file(self, fax_id, **kwargs):  # noqa: E501
        """get a file  # noqa: E501

        Get your fax archive file using it's id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_file(fax_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str fax_id: (required)
        :param str format: can be 'pdf' or 'tiff'
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.get_file_with_http_info(fax_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_file_with_http_info(fax_id, **kwargs)  # noqa: E501
            return data

    def get_file_with_http_info(self, fax_id, **kwargs):  # noqa: E501
        """get a file  # noqa: E501

        Get your fax archive file using it's id.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.get_file_with_http_info(fax_id, async=True)
        >>> result = thread.get()

        :param async bool
        :param str fax_id: (required)
        :param str format: can be 'pdf' or 'tiff'
        :return: file
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fax_id', 'format']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'fax_id' is set
        if ('fax_id' not in params or
                params['fax_id'] is None):
            raise ValueError("Missing the required parameter `fax_id` when calling `get_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}
        if 'fax_id' in params:
            path_params['fax_id'] = params['fax_id']  # noqa: E501

        query_params = []
        if 'format' in params:
            query_params.append(('format', params['format']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/pdf', 'image/tiff'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fax_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/accounts/self/files/{fax_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='file',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def upload_file(self, fax_file, **kwargs):  # noqa: E501
        """upload a file  # noqa: E501

        Before sending a fax you need to upload your files using this API. In order to upload your fax file, you have to send a `multipart/form-data` request with your file. If the upload was successful you would receive a `file_path` which you can use to send your fax.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.upload_file(fax_file, async=True)
        >>> result = thread.get()

        :param async bool
        :param file fax_file: (required)
        :param str format: can be 'pdf' or 'tiff'
        :return: File
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async'):
            return self.upload_file_with_http_info(fax_file, **kwargs)  # noqa: E501
        else:
            (data) = self.upload_file_with_http_info(fax_file, **kwargs)  # noqa: E501
            return data

    def upload_file_with_http_info(self, fax_file, **kwargs):  # noqa: E501
        """upload a file  # noqa: E501

        Before sending a fax you need to upload your files using this API. In order to upload your fax file, you have to send a `multipart/form-data` request with your file. If the upload was successful you would receive a `file_path` which you can use to send your fax.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async=True
        >>> thread = api.upload_file_with_http_info(fax_file, async=True)
        >>> result = thread.get()

        :param async bool
        :param file fax_file: (required)
        :param str format: can be 'pdf' or 'tiff'
        :return: File
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['fax_file', 'format']  # noqa: E501
        all_params.append('async')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method upload_file" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'fax_file' is set
        if ('fax_file' not in params or
                params['fax_file'] is None):
            raise ValueError("Missing the required parameter `fax_file` when calling `upload_file`")  # noqa: E501

        collection_formats = {}

        path_params = {}

        query_params = []
        if 'format' in params:
            query_params.append(('format', params['format']))  # noqa: E501

        header_params = {}

        form_params = []
        local_var_files = {}
        if 'fax_file' in params:
            local_var_files['fax_file'] = params['fax_file']  # noqa: E501

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['multipart/form-data'])  # noqa: E501

        # Authentication setting
        auth_settings = ['fax_oauth']  # noqa: E501

        return self.api_client.call_api(
            '/accounts/self/files', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='File',  # noqa: E501
            auth_settings=auth_settings,
            async=params.get('async'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
