#######################################################
# 
# ReceiveConnections.py
# Python implementation of the Class ReceiveConnections
# Generated by Enterprise Architect
# Created on:      19-May-2020 6:21:05 PM
# Original author: Natha Paquette
# 
#######################################################
import socket
import time
from logging.handlers import RotatingFileHandler
import logging
from FreeTAKServer.controllers.configuration.LoggingConstants import LoggingConstants
import sys
from FreeTAKServer.controllers.model.RawConnectionInformation import RawConnectionInformation
from FreeTAKServer.controllers.CreateLoggerController import CreateLoggerController
loggingConstants = LoggingConstants()
logger = CreateLoggerController("ReceiveConnections").getLogger()
#TODO: move health check values to constants and create controller for HealthCheck data

class ReceiveConnections:
    def __init__(self):
        pass


    def listen(self, sock, pipe):
        #logger = CreateLoggerController("ReceiveConnections").getLogger()
        #listen for client connections
        sock.listen(1000)
        while True:
            try:
                #establish the socket variables
                client, address = sock.accept()
                #wait to receive client
                data = client.recv(1024)
                logger.info(loggingConstants.RECEIVECONNECTIONSLISTENINFO)
                #establish the socket array containing important information about the client
                m_RawConnectionInformation = RawConnectionInformation()
                m_RawConnectionInformation.ip = address
                m_RawConnectionInformation.socket = client
                m_RawConnectionInformation.xmlString = data.decode('utf-8')
                try:
                    if socket != None:
                        self.retrieveNecessaryInformation(m_RawConnectionInformation, pipe)
                    else:
                        pass
                except Exception as e:
                    logger.error('')
                
            except Exception as e:
                logger.error(loggingConstants.RECEIVECONNECTIONSLISTENERROR+str(e))
                break
            time.sleep(0.01)
        self.listen(sock, pipe)

    def retrieveNecessaryInformation(self, socket, pipe):
        #this adds the important client data to the data pipe allowing it to be received by the orchestrator
        print(str(pipe))
        print(str(socket))
        try:
            pipe.put(socket)
        except Exception as e:
            logger.error('pipe error')
