#######################################################
# 
# ClientReceptionHandler.py
# Python implementation of the Class ClientReceptionHandler
# Generated by Enterprise Architect
# Created on:      19-May-2020 7:17:21 PM
# Original author: Natha Paquette
# 
#######################################################
import time
import socket
from xml.dom.minidom import parseString
import threading
import multiprocessing
from queue import Queue
from logging.handlers import RotatingFileHandler
import logging
import sys
from FreeTAKServer.controllers.configuration.ClientReceptionHandlerConstants import ClientReceptionHandlerConstants
from FreeTAKServer.controllers.CreateLoggerController import CreateLoggerController

logger = CreateLoggerController("ClientReceptionHandler").getLogger()
from FreeTAKServer.controllers.configuration.ClientReceptionLoggingConstants import ClientReceptionLoggingConstants

loggingConstants = ClientReceptionLoggingConstants()


# TODO: add more rigid exception management

class ClientReceptionHandler:
    def __init__(self):
        self.dataPipe = ''
        self.eventPipe = ''
        self.threadDict = {}
        self.dataArray = []
        self.clientInformationArray = []

    def startup(self, dataPipe, eventPipe):
        try:
            self.dataPipe = dataPipe
            self.eventPipe = eventPipe
            eventReturn = multiprocessing.Queue()
            monitorEventProcessData = multiprocessing.Process(target=self.monitorEventPipe, args = (self.clientInformationArray,eventReturn,), daemon=True)
            monitorForDataProcessData = multiprocessing.Process(target=self.monitorForData, args = (dataPipe,), daemon=True)
            logger.propagate = False
            logger.info(loggingConstants.CLIENTRECEPTIONHANDLERSTART)
            logger.propagate = True
            while True:
                if self.eventPipe.poll(timeout=0.1):
                    command = self.eventPipe.recv()
                    self.clientInformationArray = self.monitorEventPipe(command, self.clientInformationArray, eventReturn)
                else:
                    pass
                self.monitorForData(dataPipe)
                if eventReturn.empty() == False:
                    self.clientInformationArray = eventReturn.get()
                    monitorEventProcessData.terminate()
                    time.sleep(1)
                    monitorEventProcessData = multiprocessing.Process(target=self.monitorEventPipe,
                                                                      args=(self.clientInformationArray, eventReturn,),
                                                                      daemon=True)
                    monitorEventProcessData.start()
                else:
                    pass
                time.sleep(0.01)
                '''
                time.sleep(600)
                # temporarily remove due to being unnecessary and excessively flooding logs
                logger.info('the number of threads is ' + str(threading.active_count()) + ' monitor event process alive is ' + str(monitorEventProcess.is_alive()) +
                            ' return data to Orchestrator process alive is ' + str(monitorForData.is_alive()))
                '''
        except Exception as e:
            logger.error(loggingConstants.CLIENTRECEPTIONHANDLERSTARTUPERROR + str(e))

    def monitorEventPipe(self, command, clientInformationArray, returnQueue):
        try:
            if command[0] == loggingConstants.CREATE:
                clientInformationArrayModified = self.createClientMonitor(command[1], clientInformationArray)
            elif command[0] == loggingConstants.DESTROY:
                clientInformationArrayModified = self.destroyClientMonitor(command[1], clientInformationArray)
            return clientInformationArrayModified
        except Exception as e:
            logger.error(loggingConstants.CLIENTRECEPTIONHANDLERMONITOREVENTPIPEERROR + str(e))

    def createClientMonitor(self, clientInformation, clientInformationArray):
        try:
            clientInformationArray.append(clientInformation)
            print(clientInformationArray)
            logger.info(loggingConstants.CLIENTRECEPTIONHANDLERCREATECLIENTMONITORINFO)
            return clientInformationArray
        except Exception as e:
            logger.error(loggingConstants.CLIENTRECEPTIONHANDLERCREATECLIENTMONITORERROR + str(e))

    def destroyClientMonitor(self, clientInformation, clientInformationArray):
        try:
            print('removing socket')
            clientInformation.clientInformation.socket.close()
            logger.info(loggingConstants.CLIENTRECEPTIONHANDLERDESTROYCLIENTMONITORINFO)
            return clientInformationArray
        except Exception as e:
            logger.error(loggingConstants.CLIENTRECEPTIONHANDLERDESTROYCLIENTMONITORERROR + str(e))

    def monitorForData(self, queue):
        '''
        updated receive all
        '''

        for client in self.clientInformationArray:
            sock = client.socket
            try:
                try:
                    BUFF_SIZE = 8087
                    data = b''
                except Exception as e:
                    logger.error(loggingConstants.CLIENTRECEPTIONHANDLERMONITORFORDATAERRORA + str(e))
                    self.returnReceivedData(client, b'', queue)
                    self.clientInformationArray.remove(client)
                try:
                    sock.settimeout(0.001)
                    part = sock.recv(BUFF_SIZE)
                    print(part)
                except socket.timeout as e:
                    continue
                except OSError as e:
                    self.returnReceivedData(client, b'', queue)
                    self.clientInformationArray.remove(client)
                    continue
                    """try:
                        logger.error(loggingConstants.CLIENTRECEPTIONHANDLERMONITORFORDATAERRORB + str(e))
                        self.returnReceivedData(client, b'', queue)
                        time.sleep(5)
                    except:
                        self.returnReceivedData(client, b'', queue)
                        self.clientInformationArray.remove(client)
                        break"""
                try:
                    if part == b'' or part == None:
                        self.returnReceivedData(client, b'', queue)
                        self.clientInformationArray.remove(client)
                    elif len(part) < BUFF_SIZE:
                        # either 0 or end of data
                        data += part
                        self.returnReceivedData(client, data, queue)
                        data = b''
                    else:
                        data += part
                except Exception as e:
                    logger.error(loggingConstants.CLIENTRECEPTIONHANDLERMONITORFORDATAERRORC + str(e))
                    self.returnReceivedData(client, b'', queue)
                    self.clientInformationArray.remove(client)

            except Exception as e:
                logger.error(loggingConstants.CLIENTRECEPTIONHANDLERMONITORFORDATAERRORD + str(e))
                self.returnReceivedData(client, b'', queue)
        return 1
    def returnReceivedData(self, clientInformation, data, queue):
        try:
            print('returnning received data')
            print(data)
            from FreeTAKServer.controllers.model.RawCoT import RawCoT
            RawCoT = RawCoT()
            # print(data)
            RawCoT.clientInformation = clientInformation
            RawCoT.xmlString = data
            self.dataPipe.put(RawCoT)

        except Exception as e:
            logger.error(loggingConstants.CLIENTRECEPTIONHANDLERRETURNRECEIVEDDATAERROR + str(e))
