/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt;

import com.carrotsearch.hppcrt.ByteIndexedContainer;
import java.util.Arrays;

public final class ByteArrays {
    public static final byte[] EMPTY = new byte[0];
    private static final int BLANK_ARRAY_SIZE_IN_BIT_SHIFT = 10;
    private static final int BLANK_ARRAY_SIZE = 1024;
    private static final byte[] BLANKING_OBJECT_ARRAY = new byte[1024];

    private ByteArrays() {
    }

    public static void rotate(byte[] table, int from, int mid, int to) {
        ByteArrays.reverse(table, from, mid);
        ByteArrays.reverse(table, mid, to);
        ByteArrays.reverse(table, from, to);
    }

    public static void rotate(ByteIndexedContainer table, int from, int mid, int to) {
        ByteArrays.reverse(table, from, mid);
        ByteArrays.reverse(table, mid, to);
        ByteArrays.reverse(table, from, to);
    }

    public static void reverse(byte[] table, int from, int to) {
        int halfSize = to - from >>> 1;
        for (int i = 0; i < halfSize; ++i) {
            byte tmpValue = table[i + from];
            table[i + from] = table[to - i - 1];
            table[to - i - 1] = tmpValue;
        }
    }

    public static void reverse(ByteIndexedContainer table, int from, int to) {
        int halfSize = to - from >>> 1;
        for (int i = 0; i < halfSize; ++i) {
            byte tmpValue = table.get(i + from);
            table.set(i + from, table.get(to - i - 1));
            table.set(to - i - 1, tmpValue);
        }
    }

    public static void blankArray(byte[] objectArray, int startIndex, int endIndex) {
        assert (startIndex <= endIndex);
        int size = endIndex - startIndex;
        int nbChunks = size >> 10;
        int rem = size & 0x3FF;
        for (int i = 0; i < nbChunks; ++i) {
            System.arraycopy(BLANKING_OBJECT_ARRAY, 0, objectArray, startIndex + (i << 10), 1024);
        }
        if (rem > 0) {
            Arrays.fill(objectArray, startIndex + (nbChunks << 10), startIndex + (nbChunks << 10) + rem, (byte)0);
        }
    }
}

