/*
 * Decompiled with CFR 0.152.
 */
package com.carrotsearch.hppcrt;

import com.carrotsearch.hppcrt.BufferAllocationException;
import com.carrotsearch.hppcrt.ShortCollection;
import com.carrotsearch.hppcrt.ShortLookupContainer;
import com.carrotsearch.hppcrt.cursors.ShortCursor;
import com.carrotsearch.hppcrt.predicates.ShortPredicate;
import java.util.Arrays;

public abstract class AbstractShortCollection
implements ShortCollection {
    protected ShortLookupContainer testContainer;
    protected ShortPredicate testPredicate;
    protected ShortPredicate containsTestPredicate = new ShortPredicate(){

        public final boolean apply(short k) {
            return AbstractShortCollection.this.testContainer.contains(k);
        }
    };
    protected ShortPredicate containsNegateTestPredicate = new ShortPredicate(){

        public final boolean apply(short k) {
            return !AbstractShortCollection.this.testContainer.contains(k);
        }
    };
    protected ShortPredicate negatePredicate = new ShortPredicate(){

        public final boolean apply(short k) {
            return !AbstractShortCollection.this.testPredicate.apply(k);
        }
    };

    public int removeAll(ShortLookupContainer c) {
        this.testContainer = c;
        return this.removeAll(this.containsTestPredicate);
    }

    public int retainAll(ShortLookupContainer c) {
        this.testContainer = c;
        return this.removeAll(this.containsNegateTestPredicate);
    }

    public int retainAll(ShortPredicate predicate) {
        this.testPredicate = predicate;
        return this.removeAll(this.negatePredicate);
    }

    public short[] toArray(short[] target) {
        assert (target.length >= this.size()) : "Target array must be >= " + this.size();
        int i = 0;
        for (ShortCursor c : this) {
            target[i++] = c.value;
        }
        return target;
    }

    public short[] toArray() {
        try {
            return this.toArray(new short[this.size()]);
        }
        catch (OutOfMemoryError e) {
            throw new BufferAllocationException("Not enough memory to allocate a '%s'.toArray() of  %d elements", (Throwable)e, this.getClass().toString(), this.size());
        }
    }

    public String toString() {
        return Arrays.toString(this.toArray());
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }
}

