/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapi.explanation;

import com.clarkparsia.owlapi.explanation.BlackBoxExplanation;
import com.clarkparsia.owlapi.explanation.ExplanationGenerator;
import com.clarkparsia.owlapi.explanation.HSTExplanationGenerator;
import com.clarkparsia.owlapi.explanation.MultipleExplanationGenerator;
import com.clarkparsia.owlapi.explanation.SatisfiabilityConverter;
import com.clarkparsia.owlapi.explanation.util.ExplanationProgressMonitor;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.reasoner.OWLReasoner;
import org.semanticweb.owlapi.reasoner.OWLReasonerFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class DefaultExplanationGenerator
implements ExplanationGenerator {
    @Nonnull
    private final OWLDataFactory dataFactory;
    @Nonnull
    private final MultipleExplanationGenerator gen;

    public DefaultExplanationGenerator(@Nonnull OWLOntologyManager man, @Nonnull OWLReasonerFactory reasonerFactory, @Nonnull OWLOntology ontology, @Nonnull ExplanationProgressMonitor progressMonitor) {
        this(man, reasonerFactory, ontology, OWLAPIPreconditions.checkNotNull(reasonerFactory, "reasonerFactory cannot be null").createNonBufferingReasoner(ontology), progressMonitor);
    }

    public DefaultExplanationGenerator(@Nonnull OWLOntologyManager man, @Nonnull OWLReasonerFactory reasonerFactory, @Nonnull OWLOntology ontology, @Nonnull OWLReasoner reasoner, @Nullable ExplanationProgressMonitor progressMonitor) {
        this.dataFactory = OWLAPIPreconditions.checkNotNull(man, "man cannot be null").getOWLDataFactory();
        BlackBoxExplanation singleGen = new BlackBoxExplanation(OWLAPIPreconditions.checkNotNull(ontology, "ontology cannot be null"), OWLAPIPreconditions.checkNotNull(reasonerFactory, "reasonerFactory cannot be null"), OWLAPIPreconditions.checkNotNull(reasoner, "reasoner cannot be null"));
        this.gen = new HSTExplanationGenerator(singleGen);
        if (progressMonitor != null) {
            this.gen.setProgressMonitor(progressMonitor);
        }
    }

    @Override
    public Set<OWLAxiom> getExplanation(OWLClassExpression unsatClass) {
        return this.gen.getExplanation(unsatClass);
    }

    @Nonnull
    public Set<OWLAxiom> getExplanation(@Nonnull OWLAxiom axiom) {
        SatisfiabilityConverter converter = new SatisfiabilityConverter(this.dataFactory);
        return this.getExplanation(converter.convert(OWLAPIPreconditions.checkNotNull(axiom, "axiom cannot be null")));
    }

    @Override
    public Set<Set<OWLAxiom>> getExplanations(OWLClassExpression unsatClass) {
        return this.gen.getExplanations(unsatClass);
    }

    @Nonnull
    public Set<Set<OWLAxiom>> getExplanations(@Nonnull OWLAxiom axiom) {
        SatisfiabilityConverter converter = new SatisfiabilityConverter(this.dataFactory);
        return this.getExplanations(converter.convert(OWLAPIPreconditions.checkNotNull(axiom, "axiom cannot be null")));
    }

    @Override
    public Set<Set<OWLAxiom>> getExplanations(OWLClassExpression unsatClass, int maxExplanations) {
        return this.gen.getExplanations(unsatClass, maxExplanations);
    }

    @Nonnull
    public Set<Set<OWLAxiom>> getExplanations(@Nonnull OWLAxiom axiom, int maxExplanations) {
        SatisfiabilityConverter converter = new SatisfiabilityConverter(this.dataFactory);
        return this.getExplanations(converter.convert(OWLAPIPreconditions.checkNotNull(axiom, "axiom cannot be null")), maxExplanations);
    }
}

