/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.division;

import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.parameters.Imports;
import uk.ac.ox.krr.logmap2.division.AbstractDivision;
import uk.ac.ox.krr.logmap2.division.MatchingTask;
import uk.ac.ox.krr.logmap2.division.OntologyAlignmentDivision;
import uk.ac.ox.krr.logmap2.io.LogOutput;
import uk.ac.ox.krr.logmap2.io.ReadFile;
import uk.ac.ox.krr.logmap2.lexicon.LexicalUtilities;
import uk.ac.ox.krr.logmap2.statistics.StatisticsTimeMappings;

public class ConceptEmbeddingDivision
extends AbstractDivision
implements OntologyAlignmentDivision {
    int num_tasks;
    int num_tasks_ouput;
    protected String cluster_file;
    Map<String, Set<Integer>> identifier2cluster = new HashMap<String, Set<Integer>>();

    public ConceptEmbeddingDivision(String cluster_file, int num_tasks) {
        this.num_tasks = num_tasks;
        this.num_tasks_ouput = num_tasks;
        this.cluster_file = cluster_file;
    }

    public void setNumTask2Outout(int tasks_ouput) {
        this.num_tasks_ouput = tasks_ouput;
    }

    @Override
    public List<MatchingTask> createPartitionedMatchingTasks(String sourceIRIStr, String targetIRIStr) throws OWLOntologyCreationException, Exception {
        return this.createPartitionedMatchingTasks(this.loadOWLOntology(sourceIRIStr), this.loadOWLOntology(targetIRIStr));
    }

    @Override
    public List<MatchingTask> createPartitionedMatchingTasks(OWLOntology source, OWLOntology target) throws OWLOntologyCreationException, Exception {
        String uri_onto2;
        String uri_onto1;
        this.size_source_ontology = source.getSignature(Imports.INCLUDED).size();
        this.size_target_ontology = target.getSignature(Imports.INCLUDED).size();
        boolean compute_overlapping_stimation = true;
        if (this.num_tasks == 1) {
            compute_overlapping_stimation = false;
        }
        StatisticsTimeMappings.setInitGlobalTime();
        StatisticsTimeMappings.setCurrentInitTime();
        ArrayList<MatchingTask> tasks = new ArrayList<MatchingTask>();
        this.entities_source.clear();
        this.entities_target.clear();
        LexicalUtilities lexicalUtilities = new LexicalUtilities();
        lexicalUtilities.loadStopWords();
        lexicalUtilities.setStemmer();
        this.source_processing = this.createInvertedFile(source, lexicalUtilities, this.use_full_overlapping, 0);
        this.target_processing = this.createInvertedFile(target, lexicalUtilities, this.use_full_overlapping, this.source_processing.getLastidentifier() + 10);
        this.if_intersection = this.source_processing.getWeakInvertedFile().keySet();
        this.if_intersection.retainAll(this.target_processing.getWeakInvertedFile().keySet());
        this.target_processing.getWeakInvertedFile().keySet().retainAll(this.if_intersection);
        double if_file_time = StatisticsTimeMappings.getRunningTime();
        LogOutput.print("Time computing inverted file for overlapping (s): " + if_file_time);
        LogOutput.print("Number of entries IF: " + this.if_intersection.size());
        if (compute_overlapping_stimation) {
            StatisticsTimeMappings.setCurrentInitTime();
            for (Set str_set : this.if_intersection) {
                for (int ide1 : this.source_processing.getWeakInvertedFile().get(str_set)) {
                    this.entities_source.add(this.source_processing.getClass4identifier(ide1));
                }
                for (int ide2 : this.target_processing.getWeakInvertedFile().get(str_set)) {
                    this.entities_target.add(this.target_processing.getClass4identifier(ide2));
                }
            }
            this.overlapping_source = this.createOverlappingEstimation(source, this.entities_source);
            this.overlapping_target = this.createOverlappingEstimation(target, this.entities_target);
            double overlapping_time = StatisticsTimeMappings.getRunningTime();
            LogOutput.print("Time computing overlapping modules (overstimation) (s): " + overlapping_time);
        }
        StatisticsTimeMappings.setCurrentInitTime();
        try {
            uri_onto1 = source.getOntologyID().getOntologyIRI().toString();
        }
        catch (Exception e) {
            uri_onto1 = "http://logmap-partitioning/ontology1";
        }
        try {
            uri_onto2 = target.getOntologyID().getOntologyIRI().toString();
        }
        catch (Exception e) {
            uri_onto2 = "http://logmap-partitioning/ontology2";
        }
        if (compute_overlapping_stimation) {
            this.setUpModuleExtractors(this.overlapping_source, this.overlapping_target);
        } else {
            this.setUpModuleExtractors(source.getAxioms(), target.getAxioms());
        }
        double modules_setUp__time = StatisticsTimeMappings.getRunningTime();
        LogOutput.print("Time setting up module extractors (s): " + modules_setUp__time);
        this.readClusters();
        StatisticsTimeMappings.setCurrentInitTime();
        for (int n_task = 0; n_task < this.num_tasks_ouput; ++n_task) {
            long init_task = StatisticsTimeMappings.getCurrentTimeInMillis();
            tasks.add(this.createMatchingTask(uri_onto1, uri_onto2, n_task, this.identifier2cluster.get(String.valueOf(n_task))));
            double modules_time_task = StatisticsTimeMappings.getRunningTime(init_task);
            LogOutput.print("Time computing modules for task " + n_task + "  (s): " + modules_time_task);
        }
        double modules_time = StatisticsTimeMappings.getRunningTime();
        LogOutput.print("Time computing modules for tasks (s): " + modules_time);
        this.total_time = StatisticsTimeMappings.getTotalRunningTime();
        LogOutput.print("Total time (s): " + this.total_time);
        return tasks;
    }

    private void readClusters() throws FileNotFoundException {
        ReadFile reader = new ReadFile(this.cluster_file);
        String line = reader.readLine();
        while (line != null) {
            String[] elements = line.split(":");
            String cluster_id = elements[1];
            int concept_id = Integer.valueOf(elements[0].replaceAll("__label__", ""));
            if (!this.identifier2cluster.containsKey(cluster_id)) {
                this.identifier2cluster.put(cluster_id, new HashSet());
            }
            this.identifier2cluster.get(cluster_id).add(concept_id);
            line = reader.readLine();
        }
    }
}

