/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2.bioportal;

import java.util.HashSet;
import java.util.Set;

public class BioPortalMapping {
    String source_onto;
    String target_onto;
    String source_entity;
    String target_entity;
    Set<String> mapping_sources = new HashSet<String>();
    double confidence;
    int dir_mapping;
    int typeMapping;
    public static final int SUB = 0;
    public static final int SUP = -1;
    public static final int EQ = -2;
    public static final int CLASSES = 0;
    public static final int DATAPROPERTIES = 1;
    public static final int OBJECTPROPERTIES = 2;
    public static final int INSTANCES = 3;
    public static final int UNKNOWN = 4;

    public BioPortalMapping(String source_entity, String target_entity, String source_onto, String target_onto, Set<String> sources) {
        this.source_entity = source_entity;
        this.target_entity = target_entity;
        this.source_onto = source_onto;
        this.target_onto = target_onto;
        this.mapping_sources.addAll(sources);
        this.confidence = 1.0;
        this.dir_mapping = -2;
        this.typeMapping = 0;
    }

    public String getSourceEntity() {
        return this.source_entity;
    }

    public String getTargetEntity() {
        return this.target_entity;
    }

    public String getSourceOntology() {
        return this.source_onto;
    }

    public String getTargetOntology() {
        return this.target_onto;
    }

    public int getMappingDirection() {
        return this.dir_mapping;
    }

    public double getConfidence() {
        return this.confidence;
    }

    public int getTypeOfMapping() {
        return this.typeMapping;
    }

    public void setTypeOfMapping(int type) {
        this.typeMapping = type;
    }

    public void setConfidenceMapping(double conf) {
        this.confidence = conf;
    }

    public void setMappingDirection(int dir) {
        this.dir_mapping = dir;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (o == this) {
            return true;
        }
        if (!(o instanceof BioPortalMapping)) {
            return false;
        }
        BioPortalMapping i = (BioPortalMapping)o;
        return this.equals(i);
    }

    public boolean equals(BioPortalMapping m) {
        return this.source_entity.equals(m.getSourceEntity()) && this.target_entity.equals(m.getTargetEntity()) && this.source_onto.equals(m.getSourceOntology()) && this.target_onto.equals(m.getTargetOntology());
    }

    public String toString() {
        return "<" + this.source_onto + ":" + this.source_entity + "==" + this.target_onto + ":" + this.target_entity + ">";
    }

    public int hashCode() {
        int code = 10;
        code = 40 * code + this.source_entity.hashCode();
        code = 50 * code + this.target_entity.hashCode();
        code = 60 * code + this.source_onto.hashCode();
        code = 80 * code + this.target_onto.hashCode();
        return code;
    }
}

