/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.ox.krr.logmap2;

import uk.ac.ox.krr.logmap2.LogMap2_Matcher;
import uk.ac.ox.krr.logmap2.LogMap2_RepairFacility;
import uk.ac.ox.krr.logmap2.OntologyLoader;
import uk.ac.ox.krr.logmap2.oaei.FromRDFAlign2OWL;
import uk.ac.ox.krr.logmap2.oaei.reader.MappingsReaderManager;
import uk.ac.ox.krr.logmap_lite.LogMap_Lite;

public class LogMap2_CommandLine {
    private static String getHelpMessage() {
        return "LogMap 2 can operate as an ontology matching system (MATCHER/EVALUATION) or as a mapping debugging system (DEBUGGER). Additionally it also converts mappings from RDF-OAEI format to OWL.\n\nLogMap 2 MATCHER facility requires 5 parameters:\n\t1. MATCHER. To use the matching functionality.\n\t2. IRI ontology 1. e.g.: http://myonto1.owl  or  file:/C://myonto1.owl  or  file:/usr/local/myonto1.owl\n\t3. IRI ontology 2. e.g.: http://myonto2.owl  or  file:/C://myonto2.owl  or  file:/usr/local/myonto2.owl\n\t4. Full output path for mapping files and overlapping modules/fragments. e.g. /usr/local/output_path/ or (windows) C://output_path/ or /C://output_path/\n\t5. Classify the input ontologies together with the mappings. e.g. true or false\n\n\tFor example: java -jar logmap2_standalone.jar MATCHER file:/home/ontos/cmt.owl file:/home/ontos/ekaw.owl /home/mappings/output/ true\n\n\nLogMap 2 EVALUATION facility requires 6 parameters:\n\t1. EVALUATION. To use the matching + evaluation functionality against reference mappings.\n\t2. IRI ontology 1. e.g.: http://myonto1.owl  or  file:/C://myonto1.owl  or  file:/usr/local/myonto1.owl\n\t3. IRI ontology 2. e.g.: http://myonto2.owl  or  file:/C://myonto2.owl  or  file:/usr/local/myonto2.owl\n\t4. Reference mappings (RDF alignment format). e.g.: /usr/local/reference_mappings.rdf\n\t5. Full output path for mapping files and overlapping modules/fragments. e.g. /usr/local/output_path/ or (windows) C://output_path/ or /C://output_path/\n\t6. Classify the input ontologies together with the mappings. e.g. true or false\n\n\tFor example: java -jar logmap2_standalone.jar EVALUATION file:/home/ontos/cmt.owl file:/home/ontos/ekaw.owl /home/refs/ref-cmt-ekaw.rdf /home/mappings/output/ true\n\n\nLogMap 2 DEBUGGER facility requires 8 parameters:\n\t1. DEBUGGER. To use the debugging facility.\n\t2. IRI ontology 1. e.g.: http://myonto1.owl  or  file:/C://myonto1.owl  or  file:/usr/local/myonto1.owl\n\t3. IRI ontology 2. e.g.: http://myonto2.owl  or  file:/C://myonto2.owl  or  file:/usr/local/myonto2.owl\n\t4. Format mappings e.g.: OWL  or  RDF  or  TXT\n\t5. Full IRI or full Path:\n\t\ta. Full IRI of input mappings if OWL format. e.g.: file:/C://mymappings.owl  or  file:/usr/local/mymappings.owl  or http://mymappings.owl\n\t\tb. or Full path of input mappings if formats RDF or TXT. e.g.: C://mymappings.rdf  or /usr/local/mymappings.txt\n\t6. Full output path for the repaired mappings: e.g. /usr/local/output_path or (windows) C://output_path or /C://output_path/\n\t7. Extract modules for repair?: true or false\n\t8. Check satisfiability after repair using HermiT? true or false\n\n\tFor example: java -jar logmap2_standalone.jar DEBUGGER file:/home/ontos/cmt.owl file:/home/ontos/ekaw.owl RDF /usr/local/mymappings.rdf /home/mappings/output false true\n\n\nLogMap 2 LITE facility requires 4 parameters:\n\t1. MATCHER. To use the matching functionality.\n\t2. IRI ontology 1. e.g.: http://myonto1.owl  or  file:/C://myonto1.owl  or  file:/usr/local/myonto1.owl\n\t3. IRI ontology 2. e.g.: http://myonto2.owl  or  file:/C://myonto2.owl  or  file:/usr/local/myonto2.owl\n\t4. Full output path for mapping files and overlapping modules/fragments. e.g. /usr/local/output_path/ or (windows) C://output_path/ or /C://output_path/\n\tFor example: java -jar logmap2_standalone.jar LITE file:/home/ontos/cmt.owl file:/home/ontos/ekaw.owl /home/mappings/output/ \n\n\nThe RDF2OWL converter facility requires 4 parameters:\n\t1. RDF2OWL. To transform from RDF-OAEI format to OWL. Note that the input ontologies are required to check the type of entity of the mapped IRIs.\n\t2. IRI ontology 1. e.g.: http://myonto1.owl  or  file:/C://myonto1.owl  or  file:/usr/local/myonto1.owl\n\t3. IRI ontology 2. e.g.: http://myonto2.owl  or  file:/C://myonto2.owl  or  file:/usr/local/myonto2.owl\n\t4. Full path RDF mappings to be converted: e.g. C://mymappings.rdf  or  /usr/local/mymappings.rdf\n\n\tFor example: java -jar logmap2_standalone.jar RDF2OWL file:/home/ontos/cmt.owl file:/home/ontos/ekaw.owl /usr/local/mymappings.rdf\n\n";
    }

    public static void main(String[] args) {
        try {
            if (args.length < 1) {
                System.out.println(LogMap2_CommandLine.getHelpMessage());
            } else if (args[0].equals("RDF2OWL")) {
                if (args.length != 4) {
                    System.out.println(LogMap2_CommandLine.getHelpMessage());
                } else {
                    new FromRDFAlign2OWL(args[1], args[2], args[3]);
                }
            } else if (args[0].equals("MATCHER")) {
                if (args.length != 5) {
                    System.out.println(LogMap2_CommandLine.getHelpMessage());
                } else {
                    new LogMap2_Matcher(args[1], args[2], args[3], (boolean)Boolean.valueOf(args[4]));
                }
            } else if (args[0].equals("EVALUATION")) {
                if (args.length != 6) {
                    System.out.println(LogMap2_CommandLine.getHelpMessage());
                } else {
                    new LogMap2_Matcher(args[1], args[2], args[3], args[4], Boolean.valueOf(args[5]));
                }
            } else if (args[0].equals("LITE")) {
                if (args.length != 4) {
                    System.out.println(LogMap2_CommandLine.getHelpMessage());
                } else {
                    new LogMap_Lite(args[1], args[2], args[3]);
                }
            } else if (args[0].equals("DEBUGGER")) {
                if (args.length != 8) {
                    System.out.println(LogMap2_CommandLine.getHelpMessage());
                    return;
                }
                String iri_onto1 = args[1];
                String iri_onto2 = args[2];
                String format_mappings = args[3];
                String input_mappings_path = args[4];
                String output_path = args[5];
                boolean overlapping = Boolean.valueOf(args[6]);
                boolean satisfiability_check = Boolean.valueOf(args[7]);
                System.out.println("Loading ontologies...");
                OntologyLoader loader1 = new OntologyLoader(iri_onto1);
                OntologyLoader loader2 = new OntologyLoader(iri_onto2);
                System.out.println("...Done");
                MappingsReaderManager readermanager = new MappingsReaderManager(input_mappings_path, format_mappings);
                new LogMap2_RepairFacility(loader1.getOWLOntology(), loader2.getOWLOntology(), readermanager.getMappingObjects(), overlapping, true, satisfiability_check, output_path + "/mappings_repaired_with_LogMap");
            } else {
                System.out.println(LogMap2_CommandLine.getHelpMessage());
            }
        }
        catch (Exception e) {
            System.out.println(LogMap2_CommandLine.getHelpMessage());
        }
    }
}

