/*
 * Decompiled with CFR 0.152.
 */
package com.clarkparsia.owlapi.explanation.util;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyChangeListener;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class DefinitionTracker
implements OWLOntologyChangeListener {
    private final Map<OWLEntity, Integer> referenceCounts = new HashMap<OWLEntity, Integer>();
    private final OWLOntology ontology;
    private final Set<OWLAxiom> axioms = new HashSet<OWLAxiom>();
    private static final Integer ONE = 1;

    public DefinitionTracker(@Nonnull OWLOntology ontology) {
        this.ontology = (OWLOntology)OWLAPIPreconditions.checkNotNull((Object)ontology, (String)"ontology cannot be null");
        for (OWLOntology importOnt : ontology.getImportsClosure()) {
            for (OWLAxiom axiom : importOnt.getAxioms()) {
                assert (axiom != null);
                this.addAxiom(axiom);
            }
        }
        ontology.getOWLOntologyManager().addOntologyChangeListener((OWLOntologyChangeListener)this);
    }

    private void addAxiom(@Nonnull OWLAxiom axiom) {
        if (this.axioms.add(axiom)) {
            for (OWLEntity entity : axiom.getSignature()) {
                Integer count = this.referenceCounts.get(entity);
                count = count == null ? ONE : Integer.valueOf(count + 1);
                this.referenceCounts.put(entity, count);
            }
        }
    }

    private void removeAxiom(@Nonnull OWLAxiom axiom) {
        if (this.axioms.remove(axiom)) {
            for (OWLEntity entity : axiom.getSignature()) {
                Integer count = this.referenceCounts.get(entity);
                if (count == 1) {
                    this.referenceCounts.remove(entity);
                    continue;
                }
                this.referenceCounts.put(entity, count - 1);
            }
        }
    }

    public boolean isDefined(@Nonnull OWLEntity entity) {
        return ((OWLEntity)OWLAPIPreconditions.checkNotNull((Object)entity, (String)"entity cannot be null")).isBuiltIn() || this.referenceCounts.containsKey(entity);
    }

    public boolean isDefined(@Nonnull OWLClassExpression classExpression) {
        for (OWLEntity entity : ((OWLClassExpression)OWLAPIPreconditions.checkNotNull((Object)classExpression, (String)"classExpression cannot be null")).getSignature()) {
            assert (entity != null);
            if (this.isDefined(entity)) continue;
            return false;
        }
        return true;
    }

    public void ontologiesChanged(List<? extends OWLOntologyChange> changes) {
        for (OWLOntologyChange oWLOntologyChange : changes) {
            if (!oWLOntologyChange.isAxiomChange() || !this.ontology.getImportsClosure().contains(oWLOntologyChange.getOntology())) continue;
            OWLAxiom axiom = oWLOntologyChange.getAxiom();
            assert (axiom != null);
            if (oWLOntologyChange.isAddAxiom()) {
                this.addAxiom(axiom);
                continue;
            }
            if (oWLOntologyChange.isRemoveAxiom()) {
                this.removeAxiom(axiom);
                continue;
            }
            throw new UnsupportedOperationException("Unrecognized axiom change: " + oWLOntologyChange);
        }
    }
}

