/*
 * Decompiled with CFR 0.152.
 */
package org.obolibrary.obo2owl;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.obolibrary.obo2owl.Obo2OWLConstants;
import org.obolibrary.obo2owl.OwlStringTools;
import org.obolibrary.oboformat.model.Clause;
import org.obolibrary.oboformat.model.Frame;
import org.obolibrary.oboformat.model.OBODoc;
import org.obolibrary.oboformat.model.QualifierValue;
import org.obolibrary.oboformat.model.Xref;
import org.obolibrary.oboformat.parser.OBOFormatConstants;
import org.obolibrary.oboformat.parser.OBOFormatException;
import org.obolibrary.oboformat.parser.OBOFormatParser;
import org.obolibrary.oboformat.parser.OBOFormatParserException;
import org.semanticweb.owlapi.formats.RDFXMLDocumentFormat;
import org.semanticweb.owlapi.io.OWLParserException;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.AddOntologyAnnotation;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedObject;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLProperty;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.SetOntologyID;
import org.semanticweb.owlapi.util.CollectionFactory;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.semanticweb.owlapi.vocab.Namespaces;
import org.semanticweb.owlapi.vocab.OWL2Datatype;
import org.semanticweb.owlapi.vocab.OWLRDFVocabulary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OWLAPIObo2Owl {
    private static final Logger LOG = LoggerFactory.getLogger(OWLAPIObo2Owl.class);
    public static final String IRI_PROP_ISREVERSIBLEPROPERTYCHAIN = "http://purl.obolibrary.org/obo/IAO_isReversiblePropertyChain";
    @Nonnull
    protected String defaultIDSpace = "";
    protected OWLOntologyManager manager;
    protected OWLOntology owlOntology;
    protected OWLDataFactory fac;
    protected OBODoc obodoc;
    @Nonnull
    protected final Map<String, String> idSpaceMap;
    @Nonnull
    public static final Map<String, IRI> ANNOTATIONPROPERTYMAP = OWLAPIObo2Owl.initAnnotationPropertyMap();
    @Nonnull
    protected final Set<OWLAnnotationProperty> apToDeclare;
    @Nonnull
    protected final Map<String, OWLClass> clsToDeclare;
    @Nonnull
    protected final Map<String, OWLAnnotationProperty> typedefToAnnotationProperty;
    private static final Set<String> SKIPPED_QUALIFIERS = Sets.newHashSet((Object[])new String[]{"gci_relation", "gci_filler", "cardinality", "minCardinality", "maxCardinality", "all_some", "all_only"});
    private LoadingCache<String, IRI> idToIRICache = CacheBuilder.newBuilder().maximumSize(1024L).build((CacheLoader)new CacheLoader<String, IRI>(){

        public IRI load(String key) {
            return OWLAPIObo2Owl.this.oboIdToIRI_load(key);
        }
    });

    public OWLAPIObo2Owl(OWLOntologyManager manager) {
        this.idSpaceMap = new HashMap<String, String>();
        this.apToDeclare = new HashSet<OWLAnnotationProperty>();
        this.clsToDeclare = new HashMap<String, OWLClass>();
        this.typedefToAnnotationProperty = new HashMap<String, OWLAnnotationProperty>();
        this.init(manager);
    }

    protected void init(OWLOntologyManager m) {
        this.manager = m;
        this.fac = this.manager.getOWLDataFactory();
        this.idSpaceMap.clear();
        this.apToDeclare.clear();
        this.clsToDeclare.clear();
        this.typedefToAnnotationProperty.clear();
    }

    public static void convertURL(@Nonnull String iri, @Nonnull String outFile, @Nonnull OWLOntologyManager manager) throws IOException, OWLOntologyCreationException, OWLOntologyStorageException {
        OWLAPIObo2Owl bridge = new OWLAPIObo2Owl(manager);
        OBOFormatParser p = new OBOFormatParser();
        OBODoc obodoc = p.parse(new URL(iri));
        OWLOntology ontology = bridge.convert(obodoc);
        IRI outputStream = IRI.create((String)outFile);
        RDFXMLDocumentFormat format = new RDFXMLDocumentFormat();
        LOG.info("saving to {} fmt={}", (Object)outputStream, (Object)format);
        manager.saveOntology(ontology, (OWLDocumentFormat)format, outputStream);
    }

    public static void convertURL(String iri, @Nonnull String outFile, String defaultOnt, @Nonnull OWLOntologyManager manager) throws IOException, OWLOntologyCreationException, OWLOntologyStorageException {
        OWLAPIObo2Owl bridge = new OWLAPIObo2Owl(manager);
        OBOFormatParser p = new OBOFormatParser();
        OBODoc obodoc = p.parse(new URL(iri));
        obodoc.addDefaultOntologyHeader(defaultOnt);
        OWLOntology ontology = bridge.convert(obodoc);
        IRI outputStream = IRI.create((String)outFile);
        RDFXMLDocumentFormat format = new RDFXMLDocumentFormat();
        LOG.info("saving to {} fmt={}", (Object)outputStream, (Object)format);
        manager.saveOntology(ontology, (OWLDocumentFormat)format, outputStream);
    }

    @Nonnull
    protected static Map<String, IRI> initAnnotationPropertyMap() {
        HashMap<String, IRI> map = new HashMap<String, IRI>();
        map.put(OBOFormatConstants.OboFormatTag.TAG_IS_OBSELETE.getTag(), OWLRDFVocabulary.OWL_DEPRECATED.getIRI());
        map.put(OBOFormatConstants.OboFormatTag.TAG_NAME.getTag(), OWLRDFVocabulary.RDFS_LABEL.getIRI());
        map.put(OBOFormatConstants.OboFormatTag.TAG_COMMENT.getTag(), OWLRDFVocabulary.RDFS_COMMENT.getIRI());
        for (Obo2OWLConstants.Obo2OWLVocabulary vac : Obo2OWLConstants.Obo2OWLVocabulary.values()) {
            map.put(vac.getMappedTag(), vac.getIRI());
        }
        return map;
    }

    public OWLOntologyManager getManager() {
        return this.manager;
    }

    public void setManager(OWLOntologyManager manager) {
        this.manager = manager;
    }

    public OBODoc getObodoc() {
        return this.obodoc;
    }

    public void setObodoc(OBODoc obodoc) {
        this.obodoc = obodoc;
    }

    @Nonnull
    protected OWLOntology getOwlOntology() {
        return (OWLOntology)OWLAPIPreconditions.verifyNotNull((Object)this.owlOntology);
    }

    protected void setOwlOntology(@Nonnull OWLOntology owlOntology) {
        this.owlOntology = owlOntology;
    }

    public OWLOntology convert(@Nonnull String oboFile) throws OWLOntologyCreationException {
        try {
            OBOFormatParser p = new OBOFormatParser();
            return this.convert(p.parse(oboFile));
        }
        catch (IOException ex) {
            throw new OWLOntologyCreationException("Error Occured while parsing OBO '" + oboFile + '\'', (Throwable)ex);
        }
        catch (OBOFormatParserException ex) {
            throw new OWLOntologyCreationException("Syntax error occured while parsing OBO '" + oboFile + '\'', (Throwable)((Object)ex));
        }
    }

    @Nonnull
    public OWLOntology convert(OBODoc doc) throws OWLOntologyCreationException {
        this.obodoc = doc;
        this.init(this.manager);
        return this.tr(this.manager.createOntology());
    }

    public OWLOntology convert(OBODoc doc, @Nonnull OWLOntology in) {
        this.obodoc = doc;
        this.init(in.getOWLOntologyManager());
        return this.tr(in);
    }

    @Nonnull
    protected OWLOntology tr(@Nonnull OWLOntology in) {
        this.setOwlOntology(in);
        Frame hf = this.obodoc.getHeaderFrame();
        Clause ontClause = hf.getClause(OBOFormatConstants.OboFormatTag.TAG_ONTOLOGY);
        if (ontClause != null) {
            String ontOboId;
            this.defaultIDSpace = ontOboId = (String)ontClause.getValue();
            IRI ontIRI = ontOboId.contains(":") ? IRI.create((String)ontOboId) : IRI.create((String)("http://purl.obolibrary.org/obo/" + ontOboId + ".owl"));
            Clause dvclause = hf.getClause(OBOFormatConstants.OboFormatTag.TAG_DATA_VERSION);
            if (dvclause != null) {
                String dv = dvclause.getValue().toString();
                IRI vIRI = IRI.create((String)("http://purl.obolibrary.org/obo/" + ontOboId + '/' + dv + '/' + ontOboId + ".owl"));
                OWLOntologyID oid = new OWLOntologyID(Optional.of((Object)ontIRI), Optional.of((Object)vIRI));
                if (!oid.equals((Object)in.getOntologyID())) {
                    this.manager.applyChange((OWLOntologyChange)new SetOntologyID(in, oid));
                }
            } else if (!ontIRI.equals(in.getOntologyID().getOntologyIRI().orNull())) {
                this.manager.applyChange((OWLOntologyChange)new SetOntologyID(in, new OWLOntologyID(Optional.of((Object)ontIRI), Optional.absent())));
            }
        } else {
            this.defaultIDSpace = "TEMP";
            this.manager.applyChange((OWLOntologyChange)new SetOntologyID(in, new OWLOntologyID(Optional.of((Object)IRI.create((String)("http://purl.obolibrary.org/obo/" + this.defaultIDSpace))), Optional.absent())));
        }
        this.trHeaderFrame(hf);
        for (Frame f : this.obodoc.getTypedefFrames()) {
            this.trTypedefToAnnotationProperty(f);
        }
        for (Frame f : this.obodoc.getTypedefFrames()) {
            this.trTypedefFrame(f);
        }
        for (Frame f : this.obodoc.getTermFrames()) {
            this.trTermFrame(f);
        }
        for (Clause cl : hf.getClauses(OBOFormatConstants.OboFormatTag.TAG_IMPORT)) {
            String path = OWLAPIObo2Owl.getURI(cl.getValue().toString());
            IRI importIRI = IRI.create((String)path);
            OWLImportsDeclaration owlImportsDeclaration = this.fac.getOWLImportsDeclaration(importIRI);
            this.manager.makeLoadImportRequest(owlImportsDeclaration, new OWLOntologyLoaderConfiguration());
            AddImport ai = new AddImport(in, owlImportsDeclaration);
            this.manager.applyChange((OWLOntologyChange)ai);
        }
        this.postProcess(in);
        return in;
    }

    protected void postProcess(@Nonnull OWLOntology ontology) {
        IRI pIRI = null;
        for (OWLAnnotation ann : ontology.getAnnotations()) {
            if (!Obo2OWLConstants.Obo2OWLVocabulary.IRI_OIO_LogicalDefinitionViewRelation.sameIRI((OWLEntity)ann.getProperty())) continue;
            OWLAnnotationValue v = ann.getValue();
            if (v instanceof OWLLiteral) {
                String rel = ((OWLLiteral)v).getLiteral();
                pIRI = this.oboIdToIRI(rel);
                break;
            }
            pIRI = (IRI)v;
            break;
        }
        if (pIRI != null) {
            OWLObjectProperty vp = this.fac.getOWLObjectProperty(pIRI);
            HashSet<OWLEquivalentClassesAxiom> rmAxioms = new HashSet<OWLEquivalentClassesAxiom>();
            HashSet<OWLEquivalentClassesAxiom> newAxioms = new HashSet<OWLEquivalentClassesAxiom>();
            for (OWLEquivalentClassesAxiom eca : ontology.getAxioms(AxiomType.EQUIVALENT_CLASSES)) {
                int numNamed = 0;
                HashSet<Object> xs = new HashSet<Object>();
                for (OWLClassExpression x : eca.getClassExpressions()) {
                    assert (x != null);
                    if (x instanceof OWLClass) {
                        xs.add(x);
                        ++numNamed;
                        continue;
                    }
                    xs.add(this.fac.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)vp, x));
                }
                if (numNamed != true) continue;
                rmAxioms.add(eca);
                newAxioms.add(this.fac.getOWLEquivalentClassesAxiom(xs));
            }
            this.manager.removeAxioms(ontology, rmAxioms);
            this.manager.addAxioms(ontology, newAxioms);
        }
    }

    protected static String getURI(@Nonnull String path) {
        if (path.startsWith("http://") || path.startsWith("file:")) {
            return path;
        }
        File f = new File(path);
        return f.toURI().toString();
    }

    public void trHeaderFrame(@Nonnull Frame headerFrame) {
        for (String t : headerFrame.getTags()) {
            Collection<Clause> clauses;
            OWLAnnotationProperty parentAnnotProp;
            OBOFormatConstants.OboFormatTag tag = OBOFormatConstants.getTag(t);
            if (tag == OBOFormatConstants.OboFormatTag.TAG_ONTOLOGY || tag == OBOFormatConstants.OboFormatTag.TAG_IMPORT) continue;
            if (tag == OBOFormatConstants.OboFormatTag.TAG_SUBSETDEF) {
                parentAnnotProp = this.trTagToAnnotationProp(t);
                for (Clause clause : headerFrame.getClauses(t)) {
                    OWLAnnotationProperty childAnnotProp = this.trAnnotationProp(clause.getValue(String.class));
                    Set<OWLAnnotation> annotations = this.trAnnotations(clause);
                    this.add((OWLAxiom)this.fac.getOWLSubAnnotationPropertyOfAxiom(childAnnotProp, parentAnnotProp, annotations));
                    OWLAnnotationProperty ap = this.trTagToAnnotationProp(OBOFormatConstants.OboFormatTag.TAG_COMMENT.getTag());
                    this.add((OWLAxiom)this.fac.getOWLAnnotationAssertionAxiom(ap, (OWLAnnotationSubject)childAnnotProp.getIRI(), this.trLiteral(clause.getValue2())));
                }
                continue;
            }
            if (tag == OBOFormatConstants.OboFormatTag.TAG_SYNONYMTYPEDEF) {
                parentAnnotProp = this.trTagToAnnotationProp(t);
                for (Clause clause : headerFrame.getClauses(t)) {
                    Object[] values = clause.getValues().toArray();
                    OWLAnnotationProperty childAnnotProp = this.trAnnotationProp(values[0].toString());
                    IRI childIRI = childAnnotProp.getIRI();
                    Set<OWLAnnotation> annotations = this.trAnnotations(clause);
                    this.add((OWLAxiom)this.fac.getOWLSubAnnotationPropertyOfAxiom(childAnnotProp, parentAnnotProp, annotations));
                    OWLAnnotationProperty ap = this.trTagToAnnotationProp(OBOFormatConstants.OboFormatTag.TAG_NAME.getTag());
                    this.add((OWLAxiom)this.fac.getOWLAnnotationAssertionAxiom(ap, (OWLAnnotationSubject)childIRI, this.trLiteral(values[1])));
                    if (values.length <= 2 || values[2].toString().isEmpty()) continue;
                    ap = this.trTagToAnnotationProp(OBOFormatConstants.OboFormatTag.TAG_SCOPE.getTag());
                    this.add((OWLAxiom)this.fac.getOWLAnnotationAssertionAxiom(ap, (OWLAnnotationSubject)childIRI, (OWLAnnotationValue)this.trTagToAnnotationProp(values[2].toString()).getIRI()));
                }
                continue;
            }
            if (tag == OBOFormatConstants.OboFormatTag.TAG_DATE) {
                Clause clause = headerFrame.getClause(tag);
                Iterator<Object> value = clause.getValue();
                String dateString = null;
                if (value instanceof Date) {
                    dateString = OBOFormatConstants.headerDateFormat().format((Date)((Object)value));
                } else if (value instanceof String) {
                    dateString = (String)((Object)value);
                }
                if (dateString != null) {
                    this.addOntologyAnnotation(this.trTagToAnnotationProp(t), this.trLiteral(dateString), this.trAnnotations(clause));
                    continue;
                }
                OBOFormatException e = new OBOFormatException("Cannot translate clause \u00ab" + clause + '\u00bb');
                LOG.error("Cannot translate: {}", (Object)clause, (Object)e);
                continue;
            }
            if (tag == OBOFormatConstants.OboFormatTag.TAG_PROPERTY_VALUE) {
                this.addPropertyValueHeaders(headerFrame.getClauses(OBOFormatConstants.OboFormatTag.TAG_PROPERTY_VALUE));
                continue;
            }
            if (tag == OBOFormatConstants.OboFormatTag.TAG_DATA_VERSION) continue;
            if (tag == OBOFormatConstants.OboFormatTag.TAG_REMARK) {
                clauses = headerFrame.getClauses(t);
                for (Clause clause : clauses) {
                    this.addOntologyAnnotation(this.fac.getRDFSComment(), this.trLiteral(clause.getValue()), this.trAnnotations(clause));
                }
                continue;
            }
            if (tag == OBOFormatConstants.OboFormatTag.TAG_IDSPACE) continue;
            if (tag == OBOFormatConstants.OboFormatTag.TAG_OWL_AXIOMS) {
                Collection<String> axiomStrings = headerFrame.getTagValues(tag, String.class);
                try {
                    for (String axiomString : axiomStrings) {
                        Set<OWLAxiom> axioms = OwlStringTools.translate(axiomString, this.manager);
                        if (axioms == null) continue;
                        this.manager.addAxioms(this.getOwlOntology(), axioms);
                    }
                    continue;
                }
                catch (OwlStringTools.OwlStringException e) {
                    throw new RuntimeException(e);
                }
            }
            clauses = headerFrame.getClauses(t);
            for (Clause clause : clauses) {
                this.addOntologyAnnotation(this.trTagToAnnotationProp(t), this.trLiteral(clause.getValue()), this.trAnnotations(clause));
            }
        }
    }

    protected void addPropertyValueHeaders(@Nonnull Collection<Clause> clauses) {
        for (Clause clause : clauses) {
            Set<OWLAnnotation> annotations = this.trAnnotations(clause);
            Collection<Object> values = clause.getValues();
            Object v = clause.getValue();
            Object v2 = clause.getValue2();
            if (v == null) {
                LOG.error("Cannot translate: {}", (Object)clause);
                continue;
            }
            if (values.size() == 2) {
                OWLAnnotationProperty prop = this.trAnnotationProp((String)v);
                IRI value = this.trAnnotationProp(v2.toString()).getIRI();
                OWLAnnotation ontAnn = this.fac.getOWLAnnotation(prop, (OWLAnnotationValue)value, annotations);
                AddOntologyAnnotation addAnn = new AddOntologyAnnotation(this.getOwlOntology(), ontAnn);
                this.apply((OWLOntologyChange)addAnn);
                continue;
            }
            if (values.size() == 3) {
                Iterator<Object> it = clause.getValues().iterator();
                it.next();
                it.next();
                String v3String = (String)it.next();
                IRI valueIRI = v3String.startsWith("xsd:") ? IRI.create((String)(Namespaces.XSD + v3String.substring(4))) : IRI.create((String)v3String);
                OWLLiteral value = this.fac.getOWLLiteral((String)v2, OWL2Datatype.getDatatype((IRI)valueIRI));
                OWLAnnotationProperty prop = this.trAnnotationProp((String)v);
                OWLAnnotation ontAnn = this.fac.getOWLAnnotation(prop, (OWLAnnotationValue)value, annotations);
                AddOntologyAnnotation addAnn = new AddOntologyAnnotation(this.getOwlOntology(), ontAnn);
                this.apply((OWLOntologyChange)addAnn);
                continue;
            }
            LOG.error("Cannot translate: {}", (Object)clause);
        }
    }

    protected void addOntologyAnnotation(@Nonnull OWLAnnotationProperty ap, @Nonnull OWLAnnotationValue v, @Nonnull Set<OWLAnnotation> annotations) {
        OWLAnnotation ontAnn = this.fac.getOWLAnnotation(ap, v, annotations);
        AddOntologyAnnotation addAnn = new AddOntologyAnnotation(this.getOwlOntology(), ontAnn);
        this.apply((OWLOntologyChange)addAnn);
    }

    public OWLClassExpression trTermFrame(@Nonnull Frame termFrame) {
        OWLClass cls = this.trClass(termFrame.getId());
        this.add((OWLAxiom)this.fac.getOWLDeclarationAxiom((OWLEntity)cls));
        for (String t : termFrame.getTags()) {
            Set<OWLAxiom> axioms;
            Collection<Clause> clauses = termFrame.getClauses(t);
            if (OBOFormatConstants.OboFormatTag.TAG_ALT_ID.getTag().equals(t) && !(axioms = this.translateAltIds(clauses, cls.getIRI(), true)).isEmpty()) {
                this.add(axioms);
            }
            if ((axioms = this.trTermFrameClauses(cls, clauses, t)).isEmpty()) continue;
            this.add(axioms);
        }
        return cls;
    }

    @Nonnull
    protected Set<OWLAxiom> translateAltIds(@Nonnull Collection<Clause> clauses, @Nonnull IRI replacedBy, boolean isClass) {
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        for (Clause clause : clauses) {
            OWLClass altIdEntity;
            String altId = clause.getValue(String.class);
            if (altId == null) continue;
            if (isClass) {
                altIdEntity = this.trClass(altId);
            } else {
                IRI altIdIRI = this.oboIdToIRI(altId);
                altIdEntity = this.fac.getOWLObjectProperty(altIdIRI);
            }
            axioms.add((OWLAxiom)this.fac.getOWLDeclarationAxiom((OWLEntity)altIdEntity));
            axioms.add((OWLAxiom)this.fac.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)altIdEntity.getIRI(), this.fac.getOWLAnnotation(this.fac.getOWLDeprecated(), (OWLAnnotationValue)this.fac.getOWLLiteral(true))));
            axioms.add((OWLAxiom)this.fac.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)altIdEntity.getIRI(), this.fac.getOWLAnnotation(this.fac.getOWLAnnotationProperty(Obo2OWLConstants.Obo2OWLVocabulary.IRI_IAO_0100001.iri), (OWLAnnotationValue)replacedBy)));
            axioms.add((OWLAxiom)this.fac.getOWLAnnotationAssertionAxiom((OWLAnnotationSubject)altIdEntity.getIRI(), this.fac.getOWLAnnotation(this.fac.getOWLAnnotationProperty(Obo2OWLConstants.IRI_IAO_0000231), (OWLAnnotationValue)Obo2OWLConstants.IRI_IAO_0000227)));
        }
        return axioms;
    }

    @Nonnull
    public Set<OWLAxiom> trTermFrameClauses(@Nonnull OWLClass cls, @Nonnull Collection<Clause> clauses, String t) {
        OBOFormatConstants.OboFormatTag tag = OBOFormatConstants.getTag(t);
        HashSet<OWLAxiom> axioms = new HashSet<OWLAxiom>();
        if (tag == OBOFormatConstants.OboFormatTag.TAG_INTERSECTION_OF) {
            axioms.add(this.trIntersectionOf(cls, clauses));
        } else if (tag == OBOFormatConstants.OboFormatTag.TAG_UNION_OF) {
            axioms.add(this.trUnionOf(cls, clauses));
        } else {
            for (Clause clause : clauses) {
                assert (clause != null);
                axioms.add(this.trTermClause(cls, t, clause));
            }
        }
        return axioms;
    }

    @Nullable
    protected OWLNamedObject trTypedefToAnnotationProperty(@Nonnull Frame typedefFrame) {
        Object tagValue = typedefFrame.getTagValue(OBOFormatConstants.OboFormatTag.TAG_IS_METADATA_TAG);
        if (Boolean.TRUE.equals(tagValue)) {
            String id = typedefFrame.getId();
            OWLAnnotationProperty p = this.trAnnotationProp(id);
            this.add((OWLAxiom)this.fac.getOWLDeclarationAxiom((OWLEntity)p));
            String xid = this.translateShorthandIdToExpandedId(id);
            if (!id.equals(xid)) {
                OWLAnnotationAssertionAxiom ax = this.fac.getOWLAnnotationAssertionAxiom(this.trTagToAnnotationProp("shorthand"), (OWLAnnotationSubject)p.getIRI(), this.trLiteral(id), new HashSet());
                this.add((OWLAxiom)ax);
            }
            this.typedefToAnnotationProperty.put(p.getIRI().toString(), p);
            for (String tag : typedefFrame.getTags()) {
                OBOFormatConstants.OboFormatTag tagConstant = OBOFormatConstants.getTag(tag);
                if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_IS_A) continue;
                for (Clause clause : typedefFrame.getClauses(tag)) {
                    this.add(this.trGenericClause((OWLNamedObject)p, tag, clause));
                }
            }
            return p;
        }
        return null;
    }

    @Nullable
    public OWLNamedObject trTypedefFrame(@Nonnull Frame typedefFrame) {
        Object tagValue = typedefFrame.getTagValue(OBOFormatConstants.OboFormatTag.TAG_IS_METADATA_TAG);
        if (Boolean.TRUE.equals(tagValue)) {
            return null;
        }
        String id = typedefFrame.getId();
        OWLObjectProperty p = this.trObjectProp(id);
        this.add((OWLAxiom)this.fac.getOWLDeclarationAxiom((OWLEntity)p));
        String xid = this.translateShorthandIdToExpandedId(id);
        if (!xid.equals(id)) {
            OWLAnnotationAssertionAxiom ax = this.fac.getOWLAnnotationAssertionAxiom(this.trTagToAnnotationProp("shorthand"), (OWLAnnotationSubject)p.getIRI(), this.trLiteral(id), new HashSet());
            this.add((OWLAxiom)ax);
        }
        for (String tag : typedefFrame.getTags()) {
            OWLAxiom axiom;
            Collection<Clause> clauses = typedefFrame.getClauses(tag);
            OBOFormatConstants.OboFormatTag tagConstant = OBOFormatConstants.getTag(tag);
            if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_INTERSECTION_OF) {
                axiom = OWLAPIObo2Owl.trRelationIntersectionOf(id, (OWLProperty)p, clauses);
                if (axiom == null) continue;
                this.add(axiom);
                continue;
            }
            if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_UNION_OF) {
                axiom = OWLAPIObo2Owl.trRelationUnionOf(id, (OWLProperty)p, clauses);
                if (axiom == null) continue;
                this.add(axiom);
                continue;
            }
            if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_ALT_ID) {
                this.add(this.translateAltIds(clauses, p.getIRI(), false));
                continue;
            }
            for (Clause clause : clauses) {
                this.add(this.trTypedefClause(p, tag, clause));
            }
        }
        return p;
    }

    @Nullable
    protected static OWLAxiom trRelationUnionOf(String id, OWLProperty p, Collection<Clause> clauses) {
        LOG.error("The relation union_of for {} is currently non-translatable to OWL. Ignoring clauses: {}", (Object)id, clauses);
        return null;
    }

    @Nullable
    protected static OWLAxiom trRelationIntersectionOf(String id, OWLProperty p, Collection<Clause> clauses) {
        LOG.error("The relation intersection_of for {} is currently non-translatable to OWL. Ignoring clauses: {}", (Object)id, clauses);
        return null;
    }

    @Nonnull
    protected OWLAxiom trUnionOf(OWLClass cls, @Nonnull Collection<Clause> clauses) {
        Set<? extends OWLAnnotation> annotations = this.trAnnotations(clauses);
        HashSet<Object> eSet = new HashSet<Object>();
        eSet.add(cls);
        HashSet<OWLClassExpression> iSet = new HashSet<OWLClassExpression>();
        for (Clause clause : clauses) {
            Collection<QualifierValue> qvs = clause.getQualifierValues();
            if (clause.getValues().size() == 1) {
                iSet.add(this.trClass(clause.getValue()));
                continue;
            }
            LOG.error("union_of n-ary slots not is standard - converting anyway");
            iSet.add(this.trRel((String)clause.getValue(), (String)clause.getValue2(), qvs));
        }
        eSet.add(this.fac.getOWLObjectUnionOf(iSet));
        if (annotations.isEmpty()) {
            return this.fac.getOWLEquivalentClassesAxiom(eSet);
        }
        return this.fac.getOWLEquivalentClassesAxiom(eSet, annotations);
    }

    protected OWLAxiom trIntersectionOf(OWLClass cls, @Nonnull Collection<Clause> clauses) {
        Set<? extends OWLAnnotation> annotations = this.trAnnotations(clauses);
        HashSet<Object> eSet = new HashSet<Object>();
        eSet.add(cls);
        HashSet<OWLClassExpression> iSet = new HashSet<OWLClassExpression>();
        for (Clause clause : clauses) {
            Collection<QualifierValue> qvs = clause.getQualifierValues();
            if (clause.getValues().size() == 1) {
                iSet.add(this.trClass(clause.getValue()));
                continue;
            }
            iSet.add(this.trRel((String)clause.getValue(), (String)clause.getValue2(), qvs));
        }
        eSet.add(this.fac.getOWLObjectIntersectionOf(iSet));
        if (annotations.isEmpty()) {
            return this.fac.getOWLEquivalentClassesAxiom(eSet);
        }
        return this.fac.getOWLEquivalentClassesAxiom(eSet, annotations);
    }

    protected void add(@Nullable OWLAxiom axiom) {
        if (axiom == null) {
            LOG.error("no axiom");
            return;
        }
        this.add(Collections.singleton(axiom));
    }

    protected void add(@Nullable Set<OWLAxiom> axioms) {
        if (axioms == null || axioms.isEmpty()) {
            LOG.error("no axiom");
            return;
        }
        this.manager.addAxioms(this.getOwlOntology(), axioms);
    }

    protected void apply(OWLOntologyChange change) {
        this.apply(CollectionFactory.list((Object)change));
    }

    protected void apply(@Nonnull List<OWLOntologyChange> changes) {
        try {
            this.manager.applyChanges(changes);
        }
        catch (Exception e) {
            LOG.error("COULD NOT TRANSLATE AXIOM", (Throwable)e);
        }
    }

    protected OWLAxiom trTermClause(@Nonnull OWLClass cls, String tag, @Nonnull Clause clause) {
        HashSet<OWLClass> cSet;
        Object ax;
        Collection<QualifierValue> qvs = clause.getQualifierValues();
        Set<OWLAnnotation> annotations = this.trAnnotations(clause);
        OBOFormatConstants.OboFormatTag tagConstant = OBOFormatConstants.getTag(tag);
        OWLClass clsx = cls;
        String gciRel = OWLAPIObo2Owl.getQVString("gci_relation", qvs);
        if (gciRel != null && !gciRel.isEmpty()) {
            String gciFiller = OWLAPIObo2Owl.getQVString("gci_filler", qvs);
            OWLClassExpression r = this.trRel(gciRel, gciFiller, new HashSet<QualifierValue>());
            clsx = this.fac.getOWLObjectIntersectionOf(new OWLClassExpression[]{cls, r});
        }
        if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_IS_A) {
            ax = this.fac.getOWLSubClassOfAxiom((OWLClassExpression)clsx, (OWLClassExpression)this.trClass((String)clause.getValue()), annotations);
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_RELATIONSHIP) {
            IRI relId = this.oboIdToIRI((String)clause.getValue());
            OWLAnnotationProperty prop = this.typedefToAnnotationProperty.get(relId.toString());
            ax = prop != null ? this.fac.getOWLAnnotationAssertionAxiom(prop, (OWLAnnotationSubject)cls.getIRI(), (OWLAnnotationValue)this.oboIdToIRI((String)clause.getValue2()), annotations) : this.fac.getOWLSubClassOfAxiom((OWLClassExpression)clsx, this.trRel((String)clause.getValue(), (String)clause.getValue2(), qvs), annotations);
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_DISJOINT_FROM) {
            cSet = new HashSet<OWLClass>();
            cSet.add(clsx);
            cSet.add(this.trClass((String)clause.getValue()));
            ax = this.fac.getOWLDisjointClassesAxiom(cSet, annotations);
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO) {
            cSet = new HashSet();
            cSet.add(clsx);
            cSet.add(this.trClass((String)clause.getValue()));
            ax = this.fac.getOWLEquivalentClassesAxiom(cSet, annotations);
        } else {
            return this.trGenericClause((OWLNamedObject)cls, tag, clause);
        }
        return ax;
    }

    @Nullable
    protected OWLAxiom trTypedefClause(@Nonnull OWLObjectProperty p, String tag, @Nonnull Clause clause) {
        OWLSubObjectPropertyOfAxiom ax = null;
        Object v = clause.getValue();
        Set<OWLAnnotation> annotations = this.trAnnotations(clause);
        OBOFormatConstants.OboFormatTag tagConstant = OBOFormatConstants.getTag(tag);
        if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_IS_A) {
            ax = this.fac.getOWLSubObjectPropertyOfAxiom((OWLObjectPropertyExpression)p, (OWLObjectPropertyExpression)this.trObjectProp((String)v), annotations);
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_RELATIONSHIP) {
            IRI relId = this.oboIdToIRI((String)clause.getValue());
            OWLAnnotationProperty metaProp = this.typedefToAnnotationProperty.get(relId.toString());
            if (metaProp != null) {
                ax = this.fac.getOWLAnnotationAssertionAxiom(metaProp, (OWLAnnotationSubject)p.getIRI(), (OWLAnnotationValue)this.oboIdToIRI((String)clause.getValue2()), annotations);
            }
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_DISJOINT_FROM) {
            HashSet<OWLObjectProperty> cSet = new HashSet<OWLObjectProperty>();
            cSet.add(p);
            cSet.add(this.trObjectProp((String)v));
            ax = this.fac.getOWLDisjointObjectPropertiesAxiom(cSet, annotations);
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_INVERSE_OF) {
            ax = this.fac.getOWLInverseObjectPropertiesAxiom((OWLObjectPropertyExpression)p, (OWLObjectPropertyExpression)this.trObjectProp((String)v), annotations);
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO) {
            HashSet<OWLObjectProperty> cSet = new HashSet<OWLObjectProperty>();
            cSet.add(p);
            cSet.add(this.trObjectProp((String)v));
            ax = this.fac.getOWLEquivalentObjectPropertiesAxiom(cSet, annotations);
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_DOMAIN) {
            ax = this.fac.getOWLObjectPropertyDomainAxiom((OWLObjectPropertyExpression)p, this.trClass(v), annotations);
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_RANGE) {
            ax = this.fac.getOWLObjectPropertyRangeAxiom((OWLObjectPropertyExpression)p, this.trClass(v), annotations);
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_TRANSITIVE_OVER) {
            ArrayList<Object> chain = new ArrayList<Object>(2);
            chain.add(p);
            chain.add(this.trObjectProp(v));
            ax = this.fac.getOWLSubPropertyChainOfAxiom(chain, (OWLObjectPropertyExpression)p, annotations);
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_HOLDS_OVER_CHAIN || tagConstant == OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO_CHAIN) {
            if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_EQUIVALENT_TO_CHAIN) {
                OWLAnnotation ann = this.fac.getOWLAnnotation(this.trAnnotationProp(IRI_PROP_ISREVERSIBLEPROPERTYCHAIN), this.trLiteral("true"));
                annotations.add(ann);
            }
            ArrayList<OWLObjectPropertyExpression> chain = new ArrayList<OWLObjectPropertyExpression>();
            chain.add(this.trObjectProp(v));
            chain.add(this.trObjectProp(clause.getValue2()));
            ax = this.fac.getOWLSubPropertyChainOfAxiom(chain, (OWLObjectPropertyExpression)p, annotations);
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_IS_TRANSITIVE && "true".equals(clause.getValue().toString())) {
            ax = this.fac.getOWLTransitiveObjectPropertyAxiom((OWLObjectPropertyExpression)p, annotations);
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_IS_REFLEXIVE && "true".equals(clause.getValue().toString())) {
            ax = this.fac.getOWLReflexiveObjectPropertyAxiom((OWLObjectPropertyExpression)p, annotations);
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_IS_SYMMETRIC && "true".equals(clause.getValue().toString())) {
            ax = this.fac.getOWLSymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)p, annotations);
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_IS_ASYMMETRIC && "true".equals(clause.getValue().toString())) {
            ax = this.fac.getOWLAsymmetricObjectPropertyAxiom((OWLObjectPropertyExpression)p, annotations);
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_IS_FUNCTIONAL && "true".equals(clause.getValue().toString())) {
            ax = this.fac.getOWLFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)p, annotations);
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_IS_INVERSE_FUNCTIONAL && "true".equals(clause.getValue().toString())) {
            ax = this.fac.getOWLInverseFunctionalObjectPropertyAxiom((OWLObjectPropertyExpression)p, annotations);
        } else {
            return this.trGenericClause((OWLNamedObject)p, tag, clause);
        }
        return ax;
    }

    protected OWLAxiom trGenericClause(@Nonnull OWLNamedObject e, @Nonnull String tag, @Nonnull Clause clause) {
        return this.trGenericClause((OWLAnnotationSubject)e.getIRI(), tag, clause);
    }

    @Nullable
    protected OWLAxiom trGenericClause(@Nonnull OWLAnnotationSubject sub, @Nonnull String tag, @Nonnull Clause clause) {
        Set<OWLAnnotation> annotations = this.trAnnotations(clause);
        if (clause.getValue() == null) {
            LOG.error("Problem: {}", (Object)clause);
        }
        OWLAnnotationAssertionAxiom ax = null;
        OBOFormatConstants.OboFormatTag tagConstant = OBOFormatConstants.getTag(tag);
        if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_NAME) {
            ax = this.fac.getOWLAnnotationAssertionAxiom(this.trTagToAnnotationProp(tag), sub, this.trLiteral(clause.getValue()), annotations);
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_DEF) {
            ax = this.fac.getOWLAnnotationAssertionAxiom(this.trTagToAnnotationProp(tag), sub, this.trLiteral(clause.getValue()), annotations);
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_SUBSET) {
            Object v = clause.getValue();
            if (v == null) {
                LOG.error("Cannot translate: {}", (Object)clause);
            } else {
                ax = this.fac.getOWLAnnotationAssertionAxiom(this.trTagToAnnotationProp(tag), sub, (OWLAnnotationValue)this.trAnnotationProp(v.toString()).getIRI(), annotations);
            }
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_PROPERTY_VALUE) {
            Collection<Object> values = clause.getValues();
            Object v = clause.getValue();
            Object v2 = clause.getValue2();
            if (v == null) {
                LOG.error("Cannot translate: {}", (Object)clause);
            } else if (values.size() == 2) {
                ax = this.fac.getOWLAnnotationAssertionAxiom(this.trAnnotationProp((String)v), sub, (OWLAnnotationValue)this.trAnnotationProp(v2.toString()).getIRI(), annotations);
            } else if (values.size() == 3) {
                Iterator<Object> it = clause.getValues().iterator();
                it.next();
                it.next();
                String v3String = (String)it.next();
                IRI valueIRI = v3String.startsWith("xsd:") ? IRI.create((String)(Namespaces.XSD + v3String.substring(4))) : IRI.create((String)v3String);
                OWLLiteral value = this.fac.getOWLLiteral((String)v2, OWL2Datatype.getDatatype((IRI)valueIRI));
                ax = this.fac.getOWLAnnotationAssertionAxiom(this.trAnnotationProp((String)v), sub, (OWLAnnotationValue)value, annotations);
            } else {
                LOG.error("Cannot translate: {}", (Object)clause);
            }
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_SYNONYM) {
            String synType;
            Object[] values = clause.getValues().toArray();
            if (values.length > 1) {
                synType = values[1].toString();
                if (values.length > 2) {
                    OWLAnnotation ann = this.fac.getOWLAnnotation(this.trTagToAnnotationProp(OBOFormatConstants.OboFormatTag.TAG_HAS_SYNONYM_TYPE.getTag()), (OWLAnnotationValue)this.trAnnotationProp(values[2].toString()).getIRI());
                    annotations.add(ann);
                }
            } else {
                LOG.warn("Assume 'RELATED'for missing scope in synonym clause: {}", (Object)clause);
                synType = OBOFormatConstants.OboFormatTag.TAG_RELATED.getTag();
            }
            ax = this.fac.getOWLAnnotationAssertionAxiom(this.trSynonymType(synType), sub, this.trLiteral(clause.getValue()), annotations);
        } else if (tagConstant == OBOFormatConstants.OboFormatTag.TAG_XREF) {
            Xref xref = (Xref)clause.getValue();
            String xrefAnnotation = xref.getAnnotation();
            if (xrefAnnotation != null) {
                OWLAnnotation owlAnnotation = this.fac.getOWLAnnotation(this.fac.getRDFSLabel(), (OWLAnnotationValue)this.fac.getOWLLiteral(xrefAnnotation));
                annotations.add(owlAnnotation);
            }
            ax = this.fac.getOWLAnnotationAssertionAxiom(this.trTagToAnnotationProp(tag), sub, this.trLiteral(clause.getValue()), annotations);
        } else {
            ax = this.fac.getOWLAnnotationAssertionAxiom(this.trTagToAnnotationProp(tag), sub, this.trLiteral(clause.getValue()), annotations);
        }
        return ax;
    }

    protected OWLAnnotationProperty trSynonymType(@Nonnull String type) {
        if (type.equals(OBOFormatConstants.OboFormatTag.TAG_RELATED.getTag()) || type.equals(OBOFormatConstants.OboFormatTag.TAG_EXACT.getTag()) || type.equals(OBOFormatConstants.OboFormatTag.TAG_NARROW.getTag()) || type.equals(OBOFormatConstants.OboFormatTag.TAG_BROAD.getTag())) {
            return this.trTagToAnnotationProp(type);
        }
        return this.trAnnotationProp(type);
    }

    @Nonnull
    protected Set<OWLAnnotation> trAnnotations(@Nonnull Clause clause) {
        if (clause.hasNoAnnotations()) {
            return CollectionFactory.createSet();
        }
        HashSet<OWLAnnotation> anns = new HashSet<OWLAnnotation>();
        this.trAnnotations(clause, anns);
        return anns;
    }

    protected void trAnnotations(@Nonnull Clause clause, @Nonnull Set<OWLAnnotation> anns) {
        Collection<Xref> xrefs = clause.getXrefs();
        for (Xref x : xrefs) {
            if (x.getIdref() == null || x.getIdref().isEmpty()) continue;
            OWLAnnotationProperty ap = this.trTagToAnnotationProp(OBOFormatConstants.OboFormatTag.TAG_XREF.getTag());
            OWLAnnotation ann = this.fac.getOWLAnnotation(ap, this.trLiteral(x));
            anns.add(ann);
        }
        Collection<QualifierValue> qvs = clause.getQualifierValues();
        for (QualifierValue qv : qvs) {
            String qTag = qv.getQualifier();
            if (SKIPPED_QUALIFIERS.contains(qTag)) continue;
            OWLAnnotationProperty ap = this.trTagToAnnotationProp(qTag);
            OWLAnnotation ann = this.fac.getOWLAnnotation(ap, this.trLiteral(qv.getValue()));
            anns.add(ann);
        }
    }

    @Nullable
    protected Set<? extends OWLAnnotation> trAnnotations(@Nonnull Collection<Clause> clauses) {
        HashSet<OWLAnnotation> anns = new HashSet<OWLAnnotation>();
        for (Clause clause : clauses) {
            assert (clause != null);
            this.trAnnotations(clause, anns);
        }
        return anns;
    }

    public OWLClassExpression trRel(@Nonnull String relId, @Nonnull String classId, @Nonnull Collection<QualifierValue> quals) {
        Object ex;
        Frame relFrame = this.obodoc.getTypedefFrame(relId);
        OWLObjectProperty pe = this.trObjectProp(relId);
        OWLClass ce = this.trClass(classId);
        assert (pe != null);
        assert (ce != null);
        Integer exact = OWLAPIObo2Owl.getQVInt("cardinality", quals);
        Integer min = OWLAPIObo2Owl.getQVInt("minCardinality", quals);
        Integer max = OWLAPIObo2Owl.getQVInt("maxCardinality", quals);
        boolean allSome = OWLAPIObo2Owl.getQVBoolean("all_some", quals);
        boolean allOnly = OWLAPIObo2Owl.getQVBoolean("all_only", quals);
        if (ce instanceof OWLClass) {
            this.add((OWLAxiom)this.fac.getOWLDeclarationAxiom((OWLEntity)ce));
        }
        if (exact != null && exact > 0) {
            ex = this.fac.getOWLObjectExactCardinality(exact.intValue(), (OWLObjectPropertyExpression)pe, (OWLClassExpression)ce);
        } else if (exact != null && exact == 0 || max != null && max == 0) {
            OWLObjectComplementOf ceCompl = this.fac.getOWLObjectComplementOf((OWLClassExpression)ce);
            ex = this.fac.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)pe, (OWLClassExpression)ceCompl);
        } else {
            ex = max != null && min != null ? this.fac.getOWLObjectIntersectionOf(new OWLClassExpression[]{this.fac.getOWLObjectMinCardinality(min.intValue(), (OWLObjectPropertyExpression)pe, (OWLClassExpression)ce), this.fac.getOWLObjectMaxCardinality(max.intValue(), (OWLObjectPropertyExpression)pe, (OWLClassExpression)ce)}) : (min != null ? this.fac.getOWLObjectMinCardinality(min.intValue(), (OWLObjectPropertyExpression)pe, (OWLClassExpression)ce) : (max != null ? this.fac.getOWLObjectMaxCardinality(max.intValue(), (OWLObjectPropertyExpression)pe, (OWLClassExpression)ce) : (allSome && allOnly ? this.fac.getOWLObjectIntersectionOf(new OWLClassExpression[]{this.fac.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)pe, (OWLClassExpression)ce), this.fac.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)pe, (OWLClassExpression)ce)}) : (allOnly ? this.fac.getOWLObjectAllValuesFrom((OWLObjectPropertyExpression)pe, (OWLClassExpression)ce) : (relFrame != null && Boolean.TRUE.equals(relFrame.getTagValue(OBOFormatConstants.OboFormatTag.TAG_IS_CLASS_LEVEL_TAG)) ? this.fac.getOWLObjectHasValue((OWLObjectPropertyExpression)pe, this.trIndividual(classId)) : this.fac.getOWLObjectSomeValuesFrom((OWLObjectPropertyExpression)pe, (OWLClassExpression)ce))))));
        }
        return ex;
    }

    @Nullable
    protected static String getQVString(String q, @Nonnull Collection<QualifierValue> quals) {
        for (QualifierValue qv : quals) {
            if (!qv.getQualifier().equals(q)) continue;
            return qv.getValue();
        }
        return null;
    }

    protected static boolean getQVBoolean(String q, @Nonnull Collection<QualifierValue> quals) {
        for (QualifierValue qv : quals) {
            if (!qv.getQualifier().equals(q)) continue;
            String v = qv.getValue();
            return Boolean.parseBoolean(v);
        }
        return false;
    }

    @Nullable
    protected static Integer getQVInt(String q, @Nonnull Collection<QualifierValue> quals) {
        for (QualifierValue qv : quals) {
            if (!qv.getQualifier().equals(q)) continue;
            String v = qv.getValue();
            return Integer.valueOf(v);
        }
        return null;
    }

    protected OWLClass trClass(@Nonnull String classId) {
        IRI iri = this.oboIdToIRI(classId);
        return this.fac.getOWLClass(iri);
    }

    protected OWLClassExpression trClass(@Nonnull Object v) {
        return this.trClass((String)v);
    }

    @Nonnull
    protected String mapPropId(@Nonnull String id) {
        Frame f = this.obodoc.getTypedefFrame(id);
        if (f != null) {
            Collection<Xref> xrefs = f.getTagValues(OBOFormatConstants.OboFormatTag.TAG_XREF, Xref.class);
            for (Xref x : xrefs) {
                String xid = x.getIdref();
                if (!OBODoc.isTreatXrefsAsEquivalent(OWLAPIObo2Owl.getIdPrefix(xid))) continue;
                return xid;
            }
        }
        return id;
    }

    protected static String getIdPrefix(@Nonnull String x) {
        String[] parts = x.split(":", 2);
        return parts[0];
    }

    @Nonnull
    protected OWLIndividual trIndividual(@Nonnull String instId) {
        IRI iri = this.oboIdToIRI(instId);
        return this.fac.getOWLNamedIndividual(iri);
    }

    @Nonnull
    public static IRI trTagToIRI(String tag) {
        IRI iri = ANNOTATIONPROPERTYMAP.get(tag);
        if (iri == null) {
            iri = IRI.create((String)("http://www.geneontology.org/formats/oboInOwl#" + tag));
        }
        return iri;
    }

    @Nonnull
    protected OWLAnnotationProperty trTagToAnnotationProp(@Nonnull String tag) {
        IRI iri = OWLAPIObo2Owl.trTagToIRI(tag);
        OWLAnnotationProperty ap = this.fac.getOWLAnnotationProperty(iri);
        if (!this.apToDeclare.contains(ap)) {
            this.apToDeclare.add(ap);
            this.add((OWLAxiom)this.fac.getOWLDeclarationAxiom((OWLEntity)ap));
            Obo2OWLConstants.Obo2OWLVocabulary vocab = Obo2OWLConstants.getVocabularyObj(tag);
            if (vocab != null) {
                this.add((OWLAxiom)this.fac.getOWLAnnotationAssertionAxiom(this.fac.getRDFSLabel(), (OWLAnnotationSubject)iri, this.trLiteral(vocab.getLabel())));
            }
        }
        return ap;
    }

    protected void addDeclaredAnnotationProperties(@Nullable Collection<OWLAnnotationProperty> declaredProperties) {
        if (declaredProperties != null) {
            this.apToDeclare.addAll(declaredProperties);
        }
    }

    @Nonnull
    protected OWLAnnotationProperty trAnnotationProp(@Nonnull String relId) {
        IRI iri = this.oboIdToIRI(this.mapPropId(relId));
        return this.fac.getOWLAnnotationProperty(iri);
    }

    @Nonnull
    protected OWLObjectProperty trObjectProp(@Nonnull String relId) {
        IRI iri = this.oboIdToIRI(this.mapPropId(relId));
        return this.fac.getOWLObjectProperty(iri);
    }

    @Nonnull
    protected OWLObjectPropertyExpression trObjectProp(@Nonnull Object v) {
        IRI iri = this.oboIdToIRI(this.mapPropId((String)v));
        return this.fac.getOWLObjectProperty(iri);
    }

    @Nonnull
    protected OWLAnnotationValue trLiteral(@Nonnull Object inputValue) {
        Object value = inputValue;
        if (value instanceof Xref) {
            value = ((Xref)value).getIdref();
        } else {
            if (value instanceof Date) {
                String lexicalValue = Obo2OWLConstants.format((Date)value);
                return this.fac.getOWLLiteral(lexicalValue, OWL2Datatype.XSD_DATE_TIME);
            }
            if (value instanceof Boolean) {
                return this.fac.getOWLLiteral(((Boolean)value).booleanValue());
            }
            if (!(value instanceof String)) {
                value = value.toString();
            }
        }
        String value2 = (String)value;
        assert (value2 != null);
        return this.fac.getOWLLiteral(value2);
    }

    @Nonnull
    public IRI oboIdToIRI(@Nonnull String id) {
        try {
            return (IRI)this.idToIRICache.get((Object)id);
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            if (e.getCause() instanceof OWLParserException) {
                throw (OWLParserException)e.getCause();
            }
            LOG.error("error executing obo id to IRI", e);
            return this.oboIdToIRI_load(id);
        }
    }

    @Nonnull
    public IRI oboIdToIRI_load(@Nonnull String id) {
        String safeId;
        String localId;
        String db;
        String xid;
        if (id.contains(" ")) {
            LOG.error("id contains space: \"{}\"", (Object)id);
            throw new OWLParserException("spaces not allowed: '" + id + '\'');
        }
        if (id.startsWith("http:")) {
            return IRI.create((String)id);
        }
        if (id.startsWith("https:")) {
            return IRI.create((String)id);
        }
        if (id.startsWith("ftp:")) {
            return IRI.create((String)id);
        }
        if (id.startsWith("urn:")) {
            return IRI.create((String)id);
        }
        if (!id.contains(":") && !(xid = this.translateShorthandIdToExpandedId(id)).equals(id)) {
            return this.oboIdToIRI(xid);
        }
        String[] idParts = id.split(":", 2);
        if (idParts.length > 1) {
            db = idParts[0];
            localId = idParts[1];
            db = localId.contains("_") ? db + "#_" : db + "_";
        } else if (idParts.length == 0) {
            db = this.getDefaultIDSpace() + '#';
            localId = id;
        } else {
            db = this.getDefaultIDSpace() + '#';
            localId = idParts[0];
        }
        String uriPrefix = "http://purl.obolibrary.org/obo/" + db;
        if (this.idSpaceMap.containsKey(db)) {
            uriPrefix = this.idSpaceMap.get(db);
        }
        try {
            safeId = URLEncoder.encode(localId, "US-ASCII");
        }
        catch (UnsupportedEncodingException e1) {
            throw new OWLRuntimeException((Throwable)e1);
        }
        if (safeId.contains(" ")) {
            safeId = safeId.replace(" ", "_");
        }
        IRI iri = null;
        try {
            iri = IRI.create((String)(uriPrefix + safeId));
        }
        catch (IllegalArgumentException e) {
            throw new OWLRuntimeException((Throwable)e);
        }
        return iri;
    }

    @Nonnull
    protected String translateShorthandIdToExpandedId(@Nonnull String id) {
        if (id.contains(":")) {
            return id;
        }
        Frame tdf = this.obodoc.getTypedefFrame(id);
        if (tdf == null) {
            return id;
        }
        Collection<Xref> xrefs = tdf.getTagValues(OBOFormatConstants.OboFormatTag.TAG_XREF, Xref.class);
        String matchingExpandedId = null;
        for (Xref xref : xrefs) {
            String xid;
            if (xref == null || (xid = xref.getIdref()).equals(id)) continue;
            if (matchingExpandedId == null) {
                matchingExpandedId = xid;
                continue;
            }
            if (!xid.startsWith("RO") && !xid.startsWith("BFO")) continue;
            matchingExpandedId = xid;
        }
        if (matchingExpandedId == null) {
            return id;
        }
        return matchingExpandedId;
    }

    @Nonnull
    protected String getDefaultIDSpace() {
        return this.defaultIDSpace;
    }
}

