/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.io;

import javax.annotation.Nonnull;
import org.semanticweb.owlapi.io.RDFResource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class RDFResourceIRI
extends RDFResource {
    private static final long serialVersionUID = 40000L;
    @Nonnull
    private final IRI resource;

    public RDFResourceIRI(@Nonnull IRI resource) {
        this.resource = OWLAPIPreconditions.checkNotNull(resource, "resource cannot be null");
    }

    @Override
    public boolean isLiteral() {
        return false;
    }

    @Override
    public IRI getIRI() {
        return this.resource;
    }

    @Override
    public IRI getResource() {
        return this.resource;
    }

    @Override
    public boolean isAnonymous() {
        return false;
    }

    public int hashCode() {
        return this.resource.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RDFResourceIRI)) {
            return false;
        }
        RDFResourceIRI other = (RDFResourceIRI)obj;
        return this.resource.equals(other.resource);
    }

    public String toString() {
        return this.resource.toQuotedString();
    }
}

