from io import StringIO
from Bio import SeqIO
from Bio.Align.Applications import MafftCommandline
from Bio import AlignIO

def fa2hashDF(fa):
	outDict = {"header":[],"pephash":[],"sequeunce":[]}
	for record in SeqIO.parse(fa,"fasta"):
		pephash = seqhash.seqhash(record.seq,dna_type='PROTEIN')
		outDict["header"].append(record.id)
		outDict["pephash"].append(pephash)
		outDict["sequeunce"].append(str(record.seq))
	return pd.DataFrame.from_dict(outDict)

# For now, these will just have sequences hardcoded in them,
# This guarantees that if you have the codebase, you can do the searches.
# What I will also do is use config options to let users define their own input sequences

rule write_CvaB:
	output:
		CvaB_fasta = config["outdir"] + "/00_dbs/CvaB.verified.pep",
		CvaB_pepHash = config["outdir"] + "/00_dbs/CvaB.verified.pephash.csv"
	run:
		verified_CvaB = """>AAL08400.1 MceG [Klebsiella pneumoniae RYC492]
MSNGNVRRMINQLDMRWRRRVPVIHQTETSECGLACLAMICGHFGKNIDLISLRRKFNLS
ARGANLAGINSIAEQLGMVTRALSLELDELGALKTPCILHWDFSHFVVLVSVKRNRYVLH
DPARGRRNVGLEEMTRYFTGVALEVWPGSEFSEETTQNRIQLRSLINSIYGIKSTLAKIF
CLSVVIEAINLVMPVGTQLVMDHAIPAGDRGLLTLISAGLMFFILLRAATGMLRAWSSLV
MGTLINVQWQSGLFNHLLRLPLAYFERRKLGDIQSRFGSLDTLRATFTTSVVGAIMDSIM
VVGVFVMMLLYGGYLTWIVLGFTTVYVLIRLVTYGYYRQISEETLVRGARASSYFMETLY
GIATVKIQGMAERRGTHWLNLKIDAINSGIKLTKMDLFFGGINTFVAACDQVAILWLGTS
LVIDNQMTIGMFVAFGSFRGQFSDRVASLTNFLLQLRMMSLHNERIADIALHEKEEKKPE
LDIVADMTPVSLETTDLSYRYDSQSAPVFSGLYLSVTPGESVAITGTSGAGKTTLMKVLC
GLFEPDSGKVLVNGTDIRQLGINNYHRMIACVMQDDRLFSGSIRENICGFSEEMDEAWMI
ECARASYIHDVIMKMPMGYETLIGELGEGLSGGQKQRIFIARALYRRPGILFMDEATSSL
DTESERFVNVAIRNMNITRVIIAHRETTLRTVDRTISI
>CAJ44959.1 MchF protein [Escherichia coli]
MTNGSFRQIINQLDMRWRRRVPVIHQTETAECGLACLAMICGHFGKNIDLISLRRKFNLS
ARGANLAGINGIAEQLGMVTRALSLELDELGALKMPCILHWDFSHFVVLVSVKRNRYVLH
DPARGRRYLGREEMSRYFTGIALEVWPGSEFLAETQQIRISLRSLINSIYGIKRTLAKIF
CLSVVIEAINLVMPVGTQLVMDHAIPAGDRGLLTLISAGLMFFILLRAAVSMLRAWSSLV
MSTLINIQWQSGLFNHLLRLPLAFFERRKLGDIQSRFGSLDTLRATFTTCVVGAIMDSIM
VVGVFVMMLLYGGYLTWIVLGFTMVYVLIRLVTYGYYRQISEETLVRGARASSYFMESLY
GIATVKIQGMAGIRGTHWLNLKIDAINSGIKLTKMDLLFGGINTFVAACDQVAILWLGAS
LVIDNQMTIGMFVAFGSFRGQFSDRVASLTSFLLQLRIMSLHNERIADIALHEKEEKKPE
IEIVADMSPVSLETTDLSYRYDSQSAQVFSGLNLSVAPGESVAITGASGAGKTTLMKVLC
GLFEPDSGKVLVNGTDIRQLGINNYHRMIACVMQDDRLFSGSIRENICGFAEETDDEWMT
ECARASHIHDVIMKMPMGYETLIGELGEGLSGGQKQRIFIARALYRKPGILFMDEATSSL
DTESERFVNAAIKKMNITRVIIAHRETTLRTVDRIISI
>AAP03990.1 putative microcin L transport protein [Escherichia coli]
MTNGNFRQIINQLDMRWRRRVPVIHQTETAECGLACLAMICGHFGKNIDLISLRRKFNLS
ARGANLAGINGIAEQLGMVTRALSLELDELGALKMPCILHWDFSHFVVLVSVKRNRYVLH
DPARGRRYLGREEMSRYFTGIALEVWPGSEFQAETQQTRISLRSLINSIYGIKRTLAKIF
CLSVVIEAINLVMPVGTQLVMDHAIPAGDRGLLTLISAGLMFFILLRAAVSMLRAWSSLV
MSTLINVQWQSGLFDHLLRLPLAFFERRKLGDIQSRFDSLDTLRATFTTSVIGLIMDSIM
VVGVFVMMLLYGGYLTWIVLCFTTIYIFIRLVTYGNYRQISEECLVREARAASYFMETLY
GIATVKIQGMVGIRGAYWLNMKIDAINSGIKLTRMDLLFGGINTFVTACDQVVILWLGAG
LVIDNQMTIGMFVAFSSFRGQFSERVTSLTSFLLQLKIMSLHNERIADIALHEKEEKKHE
IEIVAHMGPISLETNDLSYRYDSQSAPIFSALSLSVAPGESVAITGASGAGKTTLMKVLC
GLFEPDSGRVLINGIDIRQMGINNYHRMIACVMQDDRLFSGSIRENICGFAEEMDEEWMV
ECARASHIHDVIMNMPMGYETLIGELGEGLSGGQKQRIFIARALYRKPGILFMDEATSAL
DSESEHFVNVAIKNMNITRVIIAHRETTLKTVDRVISI
>ACP43452.1 McnB [Escherichia coli]
MNNNATSPLNTLLNKLEIGLRRRIPVVHQTESSECGLACLSMICGHYGRHIDLSTLRRQF
NLSALGTTLAGITEIGSQLGMETRAFSLDLNELSVLKLPCILHWEFSHFVVLVSVRKNHF
VLHDPARGRRTVGLAEMSQCFTGVALEVWPGTEFVQETMKNRVVLRTLFRSIYGLRSTLT
KIFCFSLVIEAVGLVIPVGTQLVMDHAIPAGDRGLLSLICVGLMFFILLRTAVSMIRSWS
SLVMETLINVQWQSGLHRHLLQLPLAYFERRKMGDIQSRFSSLDTLRTTFTTSVVGAIMD
SIMVSGVLAMLVLYGGWLTTIVLGFTIIYVLIRLLTYNYYRQLSEESLIREARASSYFME
TLYGIATIKMQGMGERRGRHWLNLKIDAINTGIRLARMDMLFSGINTFVAACDQVVILWL
GTSLVIDNQMTIGMFVAFGVFRGQFSDRVGSLTNFLLQLRMMSLHNERIADIAMNEREAR
KPDTAMKADMYPVALETQDLSFRYDSQSAPVFSNLNISIKPGESVAITGASGSGKTTLMK
VLCGLLVPESGRVMIDGTDIRSLGVNNYHKIISCVMQDDRLFSGSIRENICGFTENIDEA
WMVECARASFIHDVIIKMPMGYDTLIGELGEGLSGGQKQRIFIARALYRRPGILFMDEAT
SALDTESEYYVNQAIKQLNITRIIIAHRETTVKSADRIILLEAPARI
>AFN88378.1 hlyB-like ABC transporter-like protein (plasmid) [Escherichia coli]
MESINWKVRKQLPVIRQTESAECGLACLAMIACWHGLKTDLSTLRERFNIGIQGMTLQRL
IECAASIHLSSRAVRLEPEDLRCLNLPSILHWDMNHFVVLHKVRGNRLYIHDPDRGKITI
SLLDAGKHFTGVALELTPASDFTPRNERKKIHLRQLTGKTPGLLASMTKIIIFALALEIL
ALGGPLLNQLVIDEVLVAADRSLLYVIIVALLLLSLIQLLLSLARQWATISLSVNFNMQW
TARVFHHLVRLPLAWFDARSKGSINARFEAVDIIQQALTTQVLEGILDMLLIVTALCMML
LYSPGMTLIAVIAAIIYGALRALWYPALRQSVEDVWDAGTKESGHFLETLNGIQSLRING
VTIHREAAWLNLNVTRRNTQLRQNRLQMSYELTHTLTESVVSAIILWQGAVEVLDGTFTV
GMLVAYLSYQMRFSSSISNLTDNFFSWRMLDVYNERLADIVLTPQEGHQNQHHWANHNET
ISASQYREHKYDNTHPPLLIEKITFSHKGADKPILDNASLMLFPGEILAITGKSGCGKST
LVKLILGIHTPSEGRINAFGIPHTHSDYFQVRQRIGTVLQDDYLFKGSIADNIMFFSEIR
DHEHMRKCASLALIDSDIMAMPMGYQTLLGETGGGLSGGQKQRILLARALYKKPGLLLLD
EATSHLDVESEIEISQTLRQLGIPVLLIAHRPETIASADRVLYLRDGHFSEITYRPARTH
NINNHPNRR
>AFH37355.1 ABC transporter (plasmid) [Escherichia coli]
MDTLKWTGRKQLPLIRQTESAECGLACLVMMACWHGLQTDLPTLRERFSISTQGMTLQRL
IECAAGIRLSSRAVRLEPEDLKSLSLPCILHWNMNHFVVLYKVRGSRLVIHDPDKGKITL
SLQDAGKHFTGVALELTPASDFTARDERKKIRLRQLTGRTPGLLAAMSRIIIFALALEIL
TLSSPLLNQLVIDEVLVAADRSLLTVIIIALLLLSMTQMLLSLARQWASITLSVNFNMQW
TARVFHHLVRLPLGWFDARSKGSINARFEAVDTIQEALTTQVLEGILDVLLVITALCMML
LYSPEMTLIAVLAAIIYGVLRALWYPSLRQSAEDAWDAGARESGHFLETLNGILSLRING
VTAHREAAWLNLNIVRRNTQLRQSRQLMCYDIAHTLTGSVVSAIILWKGAGEVLNGTFTV
GMLVAYLSYQMRFSSSISSLTDKYFSWRMLDIYNERLADIVLTPTEDYQQQPAQEDNDTS
VFPSVFRGDVADGARVPLSLEHITFSHKGGNKPILRGVSLTLHPGEVMAITGQSGCGKST
LVKLILGIHIPDEGTIRAFGIPHTHPDYFQVRQRIGTVLQDDHLFRGSIADNIIFFSGDR
NHERMIQCARLALIDSDIMSMPMGYQTLIGETGGGLSGGQKQRILLARALYKKPGFLLLD
EATSHLDVESEIQISQTLRQLGLPVLLIAHRPETIASADRVLYLADGCFMELRHKRTIDD
GLNKN
>P22520.1 RecName: Full=Colicin V secretion/processing ATP-binding protein CvaB
MTNRNFRQIINLLDLRWQRRVPVIHQTETAECGLACLAMICGHFGKNIDLIYLRRKFNLS
ARGATLAGINGIAEQLGMATRALSLELDELRVLKTPCILHWDFSHFVVLVSVKRNRYVLH
DPARGIRYISREEMSRYFTGVALEVWPGSEFQSETLQTRISLRSLINSIYGIKRTLAKIF
CLSVVIEAINLLMPVGTQLVMDHAIPAGDRGLLTLISAALMFFILLKAATSTLRAWSSLV
MSTLINVQWQSGLFDHLLRLPLAFFERRKLGDIQSRFDSLDTLRATFTTSVIGFIMDSIM
VVGVCVMMLLYGGYLTWIVLCFTTIYIFIRLVTYGNYRQISEECLVREARAASYFMETLY
GIATVKIQGMVGIRGAHWLNMKIDAINSGIKLTRMDLLFGGINTFVTACDQIVILWLGAG
LVIDNQMTIGMFVAFSSFRGQFSERVASLTSFLLQLRIMSLHNERIADIALHEKEEKKPE
IEIVADMGPISLETNGLSYRYDSQSAPIFSALSLSVAPGESVAITGASGAGKTTLMKVLC
GLFEPDSGRVLINGIDIRQIGINNYHRMIACVMQDDRLFSGSIRENICGFAEEMDEEWMV
ECARASHIHDVIMNMPMGYETLIGELGEGLSGGQKQRIFIARALYRKPGILFMDEATSAL
DSESEHFVNVAIKNMNITRVIIAHRETTLRTVDRVISI
"""

		verified_CvaB_SeqIO = SeqIO.parse(StringIO(verified_CvaB), "fasta")

		verified_CvaB_pepHashDF = fa2hashDF(StringIO(verified_CvaB))
		verified_CvaB_pepHashDF.to_csv(output.CvaB_pepHash)
		with open(output.CvaB_fasta,"w") as seq_out:
			SeqIO.write(verified_CvaB_SeqIO, seq_out,"fasta")

rule write_microcins:
	output:
		microcin_fasta = config["outdir"] + "/00_dbs/microcins.verified.pep",
		microcin_pepHash = config["outdir"] + "/00_dbs/microcins.verified.pephash.csv"
	run:
		verified_microcins =""">E492_sp_Q9Z4N4_MCEA_KLEPN Microcin E492 OS=Klebsiella pneumoniae OX=573 GN=mceA PE=1 SV=2
MREISQKDLNLAFGAGETDPNTQLLNDLGNNMAWGAALGAPGGLGSAALGAAGGALQTVG
QGLIDHGPVNVPIPVLIGPSWNGSGSGYNSATSSSGSGS
>H47_sp_P62530_MCHB_ECOLX Microcin H47 OS=Escherichia coli OX=562 GN=mchB PE=1 SV=1
MREITESQLRYISGAGGAPATSANAAGAAAIVGALAGIPGGPLGVVVGAVSAGLTTAIGS
TVGSGSASSSAGGGS
>I47_tr_Q712Q0_Q712Q0_ECOLX MchS2 protein OS=Escherichia coli OX=562 GN=mchS2 PE=4 SV=1
MREISDNMLDSVKGGMNLNGLPASTNVIDLRGKDMGTYIDANGACWAPDTPSIIMYPGGS
GPSYSMSSSTSSANSGS
>M_tr_Q83TS1_Q83TS1_ECOLX Colicin-V (Microcin-V bacteriocin) OS=Escherichia coli OX=562 GN=mcmA PE=4 SV=1
MRKLSENEIKQISGGDGNDGQAELIAIGSLAGTFISPGFGSIAGAYIGDKVHSWATTATV
SPSMSPSGIGLSSQFGSGRGTSSASSSAGSGS
>G492_tr_B4DCT5_B4DCT5_KLEPN MceL OS=Klebsiella pneumoniae OX=573 PE=4 SV=1
MRALTENDFFAVSGADRGDAAVAGAVAGGTAGAAAGGWAGAQMGATVGSLAGPVGTVVGF
VAGAAAGRYGGAFIYDSFSSPSNSSSSGS
>V_sp_P22522_CEAV_ECOLX Colicin-V OS=Escherichia coli OX=562 GN=cvaC PE=1 SV=1
MRTLTLNELDSVSGGASGRDIAMAIGTLSGQFVAGGIGAAAGGVAGGAIYDYASTHKPNP
AMSPSGLGGTIKQKPEGIPSEAWNYAAGRLCNWSPNNLSDVCL
>L_tr_Q841V4_Q841V4_ECOLX Microcin L OS=Escherichia coli OX=562 GN=mclC PE=4 SV=1
MREITLNEMNNVSGAGDVNWVDVGKTVATNGAGVIGGAFGAGLCGPVCAGAFAVGSSAAV
AALYDAAGNSNSAKQKPEGLPPEAWNYAEGRMCNWSPNNLSDVCL
>N_tr_C3VUZ5_C3VUZ5_ECOLX McnN OS=Escherichia coli OX=562 PE=4 SV=1
MRELDREELNCVGGAGDPLADPNSQIVRQIMSNAAWGAAFGARGGLGGMAVGAAGGVTQT
VLQGAAAHMPVNVPIPKVPMGPSWNGSKG
>PDI_tr_I6ZU90_I6ZU90_ECOLX McpM OS=Escherichia coli OX=562 GN=mcpM PE=4 SV=1
MANIRELTLDEITLVSGGNANSNFEGGPRNDRSSGARNSLGRNAPTHIYSDPSTVKCANA
VFSGMIGGAIKGGPIGMARGTIGGAVVGQCLSDHGSGNGSGNRGSSSSCSGNNVGGTCNR
>S_tr_H9ZMG7_H9ZMG7_ECOLX Microcin S OS=Escherichia coli OX=562 GN=mcsS PE=4 SV=1
MSNIRELSFDEIALVSGGNANSNYEGGGSRSRNTGARNSLGRNAPTHIYSDPSTVKCANA
VFSGMVGGAIKGGPVGMTRGTIGGAVIGQCLSGGGNGNGGGNRAGSSNCSGSNVGGTCSR
"""

		verified_microcins_SeqIO = SeqIO.parse(StringIO(verified_microcins), "fasta")
		verified_microcins_pepHashDF = fa2hashDF(StringIO(verified_microcins))
		verified_microcins_pepHashDF.to_csv(output.microcin_pepHash)
		with open(output.microcin_fasta,"w") as seq_out:
			SeqIO.write(verified_microcins_SeqIO, seq_out,"fasta")

rule write_immunity_proteins:
	output:
		immunity_protein_fasta = config["outdir"] + "/00_dbs/immunity_proteins.verified.pep",
		immunity_protein_pepHash = config["outdir"] + "/00_dbs/immunity_proteins.verified.pephash.csv"
	run:
		verified_immunity_proteins = """>classIIb_IP:M_mcmI_tr|Q83TS3|Q83TS3_ECOLX Microcin M imunity protein McmI OS=Escherichia coli OX=562 GN=mcmI PE=4 SV=1
MGEVKKDIKITVIAFVINYLFFYIPVSLYLSYYYGYNFFNLYMFFLSLVVTFLSLWLNVN
FYFFTNLIAKVLK
>classIIb_IP:I47_mchS3_tr|Q712P9|Q712P9_ECOLX MchS3 protein OS=Escherichia coli OX=562 GN=mchS3 PE=4 SV=1
MYLTKKIIISMMFILPSAAFSSDPPPLQQSLEKTTYFSIGMNGFIGYQSEGEKLYTHILT
LDNPEEIFKNIIKNRKSTKESKIYAACGLYYLNVENIESLFNENDKQEYVSVLRGDILTK
IKLNDILNSVIINGCNTKLISEHK
>classIIb_IP:H47_mchI_sp|O86200|MCHI_ECOLX Microcin H47 immunity protein MchI OS=Escherichia coli OX=562 GN=mchI PE=1 SV=1
MSYKKLYQLTAIFSLPLTILLVSLSSLRIVGEGNSYVDVFLSFIIFLGFIELIHGIRKIL
VWSGWKNGS
>classIIb_IP:E492_mceB_sp|Q9ZHG0|IM92_KLEPN Microcin E492 immunity protein OS=Klebsiella pneumoniae OX=573 GN=mceB PE=1 SV=1
MTLLSFGFSPVFFSVMAFCIISRSKFYPQRTRNKVIVLILLTFFICFLYPLTKVYLVGSY
GIFDKFYLFCFISTLIAIAINVVILTINGAKNERN
>classIIb_IP:G492_mceM_tr|B4DCT4|B4DCT4_KLEPN MceM OS=Klebsiella pneumoniae OX=573 GN=SAMEA4364603_01604 PE=4 SV=1
MIFLYLDKIPLFILGIGLLTSFALPGSSALDSPKFLCIYSSTILAGISFIYQVFRHGTNT
EFFLAMLITVSFVVMLPVIKMHFAY
>classIIa_IP:V_cvi
MDRKRTKLELLFAFIINATAIYIALAIYDCVFRGKDFLSMHTFCFSALMSAICYFVGDNYYSISDKIKRRSYENSDSK
>classIIa_IP:L_mclI
MKTWQVFFIILPISIIISLIVKQLNSSNLVQSVVSGIAIALMISIFFNRGK
>classIIa_IP:N_mcnI
MKRNKLTRMSFLNFAFSPVFFSIMACYFIVWRNKRNEFVCNRLLSIIIISFLICFIYPWLNYKIEVKYYIFEQFYLFCFLSSLVAVVINLIVYFILYRRCI
>classIIa_IP:PDI_mcpI
MEGATMFIKLLSFICGLLLGFALLSGSSVIDLYWFSLPSEFSKIVVMLITLFSTARFMDYIIEKIRTISAK
>classIIa_IP:S_mcsI
MDERSSQFRYSKYSAIIFLAVVIISTIVTLSPTFTLRYVGLDIAFFIVFITEILISTLVYLFYLKEFPECRIKIRTDSATVKFSALSFLIIILIQLAVYCYRDYLYHYEPSQINWITVLVMTLVVPYYEEIVYRACAFGFLRSIFKENIIIPCVITSLFFSLMHFQYYNVLDQSVLFVVSMLLLGVRIKSRSLFYPMLIHSGMNTFVILLNIQNIL
"""

		verified_immunity_proteins_SeqIO = SeqIO.parse(StringIO(verified_immunity_proteins), "fasta")
		verified_immunity_proteins_pepHashDF = fa2hashDF(StringIO(verified_immunity_proteins))
		verified_immunity_proteins_pepHashDF.to_csv(output.immunity_protein_pepHash)
		with open(output.immunity_protein_fasta,"w") as seq_out:
  			SeqIO.write(verified_immunity_proteins_SeqIO, seq_out,"fasta")

rule microcin_signal:
	output:
		config["outdir"] + "/00_dbs/verified_SP.aln"
	run:
		verified_SP = """>V_ECOLX_classIIa
MRTLTLNELDSVSGG
>L_ECOLX_classIIa
MREITLNEMNNVSGA
>N_ECOLX_classIIa
MRELDREELNCVGGA
>PDI_ECOLX_classIIa
IRELTLDEITLVSGG
>S_ECOLX_classIIa
IRELSFDEIALVSGG
>E492_KLEPN_classIIb
MREISQKDLNLAFGA
>H47_ECOLX_classIIb
MREITESQLRYISGA
>I47_ECOLX_classIIb
MREISDNMLDSVKGG
>M_ECOLX_classIIb
MRKLSENEIKQISGG
>G492_KLEPN_classIIb
MRALTENDFFAVSGA
>ER14_PAGGL_novel
MRELNSEEIRNVAGA
>ER18_MGAVI_novel
MRMLINNDIKLVTGA
>ER31_PALLI_novel
LRELTDSEINIVSGG
>VC1_VIBCH_novel
MKELSIEQISLVTGG
>lactacin-F_GP_classIIb
FNYLSHKDLAVVVGG
>amylovorin-L_GP_classIIb
MKQLNSEQLQNIIGG
>sakacin-P_GP_classIIa
FIELSLKEVTAITGG
>piscicolin-126_GP_classIIa
VKELSVKEMQLTTGG
>mesentericin-Y105_GP_classIIa
YQQLDNQNLKKVVGG
>sakacin-A_GP_classIIa
VKELSMTELQTITGG
>pediocin_PA-1_GP_classIIa
IEKLTEKEMANIIGG
>ubericin-A_GP_classIIa
FENIKLFSLKKIIGG
>EntA_GP_classIIa
LKILSIKETQLIYGG
>leucocin-A_GP_classIIa
YEQLDNSALEQVVGG
>Enterocin-HF_GP_classIIa
MEKLTVKEMSQVVGG
>carnobacteriocin-B2_GP_classIIa
VKELNVKEMKQLHGG
>carnobacteriocin-BM1_GP_classIIa
VKELNKKEMQQINGG
>leucocin-B_GP_classIIa
YQQLDNNALEQVVGG
>curvacin-A_GP_classIIa
VKELSMTELQTITGG
"""
		verified_SP_msa = AlignIO.read(StringIO(verified_SP), "fasta")
		with open(output[0],"w") as alignment_out:
  			AlignIO.write(verified_SP_msa,alignment_out,"fasta")

