# multiplex-imaging-pipeline
A pipeline for multiplex imaging analysis

## Installation

#### From conda .env file

```bash
conda create -f .env
```

## Usage

#### Create ome.tiff

###### Create from a folder of stitched .tif files (old CODEX)

Takes as input a directory containing stitched .tif images and creates and HTAN consortium compatible ome.tiff

```bash
mip make-ome --tif-directory </path/to/directory/with/tiffs/*.tif> --output-filepath </path/to/output.ome.tiff>
```

###### Create from a .qptiff file (new CODEX)

```bash
mip make-ome --input-tif </path/to/directory/with/qptiff/*.qptiff> --output-filepath </path/to/output.ome.tiff>
```

#### Create cell feature table

Takes a label image and ome.tiff as input, and outputs spatial features.

label image - .tif containing cell segmentation information. is a tiff where all background pixels have the value 0, and the pixels representing the location of a cell are given an integer label unique to that cell. This image can be generated by QiTissue.

```bash
mip generate-spatial-features --label-image </path/to/label/image.tif> --ome-tiff </path/to/*.ome.tiff> --output-prefix </path/to/output/directory>
```
