/**
 * Quantitative, Fast Grid-Based Fields Calculations in 2D and 3D - Residence
 * Time Distributions, Velocity Grids, Eulerian Cell Projections etc.
 * 
 * If you used this codebase or any software making use of it in a scientific
 * publication, you are kindly asked to cite the following papers:
 * 
 *      <TODO: KonigCell Paper After Publication>
 *
 *      Powell D, Abel T. An exact general remeshing scheme applied to
 *      physically conservative voxelization. Journal of Computational
 *      Physics. 2015 Sep 15;297:340-56.
 *
 *
 * MIT License
 * 
 * Copyright (c) 2021 Andrei Leonard Nicusan
 * 
 * Permission is hereby granted, free of charge, to any person obtaining a copy
 * of this software and associated documentation files (the "Software"), to deal
 * in the Software without restriction, including without limitation the rights
 * to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
 * copies of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be included in all
 * copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 */


#ifndef KONIGCELL3D_GENERATED_H
#define KONIGCELL3D_GENERATED_H


#include "konigcell3d.h"


/**
 * Vertices approximating the spherical cylinder. See dev/spherical_cylinder_approx.jl
 * Shape KC3D_SC_NUM_VERTSx3
 */
#define KC3D_SC_NUM_VERTS 192
static const kc3d_real KC3D_SC_VERTS[] = {
    -0.945817,0.3247,0.0,
    -0.947808,0.078538,-0.309017,
    -1.0,-0.0,0.0,
    -0.921954,-0.233471,-0.309017,
    -0.945817,-0.3247,0.0,
    -0.796193,-0.520179,-0.309017,
    -0.789141,-0.614213,0.0,
    -0.584151,-0.750517,-0.309017,
    -0.546948,-0.837166,-0.0,
    -0.308807,-0.899526,-0.309017,
    -0.245485,-0.9694,-0.0,
    0.0,-0.951056,-0.309017,
    0.082579,-0.996584,-0.0,
    0.308807,-0.899526,-0.309017,
    0.401695,-0.915773,-0.0,
    0.584151,-0.750517,-0.309017,
    0.677282,-0.735724,-0.0,
    0.796193,-0.520179,-0.309017,
    0.879474,-0.475947,0.0,
    0.921954,-0.233471,-0.309017,
    0.986361,-0.164595,0.0,
    0.947808,0.078538,-0.309017,
    0.986361,0.164595,0.0,
    0.870952,0.382035,-0.309017,
    0.879474,0.475947,0.0,
    0.699715,0.644133,-0.309017,
    0.677282,0.735724,0.0,
    0.452653,0.836429,-0.309017,
    0.401695,0.915773,0.0,
    0.156539,0.938085,-0.309017,
    0.082579,0.996584,0.0,
    -0.156539,0.938085,-0.309017,
    -0.245485,0.9694,0.0,
    -0.452653,0.836429,-0.309017,
    -0.546948,0.837166,0.0,
    -0.699715,0.644133,-0.309017,
    -0.789141,0.614213,0.0,
    -0.870952,0.382035,-0.309017,
    0.0,-0.309017,-0.951056,
    0.0,0.0,-1.0,
    0.100338,-0.292274,-0.951056,
    0.189802,-0.243858,-0.951056,
    0.258699,-0.169016,-0.951056,
    0.299561,-0.075859,-0.951056,
    0.307961,0.025518,-0.951056,
    0.282989,0.124131,-0.951056,
    0.227351,0.209292,-0.951056,
    0.147076,0.271772,-0.951056,
    0.050863,0.304802,-0.951056,
    -0.050863,0.304802,-0.951056,
    -0.147076,0.271772,-0.951056,
    -0.227351,0.209292,-0.951056,
    -0.282989,0.124131,-0.951056,
    -0.307961,0.025518,-0.951056,
    -0.299561,-0.075859,-0.951056,
    -0.258699,-0.169016,-0.951056,
    -0.189802,-0.243858,-0.951056,
    -0.100338,-0.292274,-0.951056,
    0.0,-0.809017,-0.587785,
    0.262687,-0.765182,-0.587785,
    0.496909,-0.638428,-0.587785,
    0.677282,-0.44249,-0.587785,
    0.784261,-0.198602,-0.587785,
    0.806254,0.066808,-0.587785,
    0.740876,0.324978,-0.587785,
    0.595213,0.547932,-0.587785,
    0.38505,0.711509,-0.587785,
    0.13316,0.797983,-0.587785,
    -0.13316,0.797983,-0.587785,
    -0.38505,0.711509,-0.587785,
    -0.595213,0.547932,-0.587785,
    -0.740876,0.324978,-0.587785,
    -0.806254,0.066808,-0.587785,
    -0.784261,-0.198602,-0.587785,
    -0.677282,-0.44249,-0.587785,
    -0.496909,-0.638428,-0.587785,
    -0.262687,-0.765182,-0.587785,
    0.0,-0.587785,-0.809017,
    0.190854,-0.555937,-0.809017,
    0.361025,-0.463845,-0.809017,
    0.492074,-0.321488,-0.809017,
    0.569799,-0.144293,-0.809017,
    0.585778,0.048539,-0.809017,
    0.538278,0.236111,-0.809017,
    0.432448,0.398096,-0.809017,
    0.279755,0.516942,-0.809017,
    0.096746,0.579769,-0.809017,
    -0.096746,0.579769,-0.809017,
    -0.279755,0.516942,-0.809017,
    -0.432448,0.398096,-0.809017,
    -0.538278,0.236111,-0.809017,
    -0.585778,0.048539,-0.809017,
    -0.569799,-0.144293,-0.809017,
    -0.492074,-0.321488,-0.809017,
    -0.361025,-0.463845,-0.809017,
    -0.190854,-0.555937,-0.809017,
    -1.0,-0.0,-0.0,
    -0.945817,0.3247,-0.0,
    -0.789141,0.614213,-0.0,
    -0.546948,0.837166,-0.0,
    -0.245485,0.9694,-0.0,
    0.082579,0.996584,-0.0,
    0.401695,0.915773,-0.0,
    0.677282,0.735724,-0.0,
    0.879474,0.475947,-0.0,
    0.986361,0.164595,-0.0,
    0.986361,-0.164595,-0.0,
    0.879474,-0.475947,-0.0,
    0.677282,-0.735724,-0.0,
    0.401695,-0.915773,-0.0,
    0.082579,-0.996584,-0.0,
    -0.245485,-0.9694,-0.0,
    -0.546948,-0.837166,-0.0,
    -0.789141,-0.614213,-0.0,
    -0.945817,-0.3247,-0.0,
    -0.921954,-0.233471,-0.3090170000000001,
    -0.947808,0.078538,-0.3090170000000001,
    -0.870952,0.382035,-0.3090170000000001,
    -0.699715,0.644133,-0.3090170000000001,
    -0.452653,0.836429,-0.3090170000000001,
    -0.156539,0.938085,-0.3090170000000001,
    0.156539,0.938085,-0.3090170000000001,
    0.452653,0.836429,-0.3090170000000001,
    0.699715,0.644133,-0.3090170000000001,
    0.870952,0.382035,-0.3090170000000001,
    0.947808,0.078538,-0.3090170000000001,
    0.921954,-0.233471,-0.3090170000000001,
    0.796193,-0.520179,-0.3090170000000001,
    0.584151,-0.750517,-0.3090170000000001,
    0.308807,-0.899526,-0.3090170000000001,
    -0.0,-0.951056,-0.3090170000000001,
    -0.308807,-0.899526,-0.3090170000000001,
    -0.584151,-0.750517,-0.3090170000000001,
    -0.796193,-0.520179,-0.3090170000000001,
    -0.0,-0.309017,-0.951057,
    -0.0,-0.0,-1.0,
    -0.100338,-0.292274,-0.951057,
    -0.189802,-0.243858,-0.951057,
    -0.258699,-0.169016,-0.951057,
    -0.299561,-0.075859,-0.951057,
    -0.307961,0.025518,-0.951057,
    -0.282989,0.124131,-0.951057,
    -0.227351,0.209292,-0.951057,
    -0.147076,0.271772,-0.951057,
    -0.050863,0.304802,-0.951057,
    0.050863,0.304802,-0.951057,
    0.147076,0.271772,-0.951057,
    0.227351,0.209292,-0.951057,
    0.282989,0.124131,-0.951057,
    0.307961,0.025518,-0.951057,
    0.299561,-0.075859,-0.951057,
    0.258699,-0.169016,-0.951057,
    0.189802,-0.243858,-0.951057,
    0.100338,-0.292274,-0.951057,
    -0.0,-0.809017,-0.587785,
    -0.262687,-0.765182,-0.587785,
    -0.496909,-0.638428,-0.587785,
    -0.677282,-0.44249,-0.587785,
    -0.784261,-0.198602,-0.587785,
    -0.806254,0.066808,-0.587785,
    -0.740876,0.324978,-0.587785,
    -0.595213,0.547932,-0.587785,
    -0.38505,0.711509,-0.587785,
    -0.13316,0.797983,-0.587785,
    0.13316,0.797983,-0.587785,
    0.38505,0.711509,-0.587785,
    0.595213,0.547932,-0.587785,
    0.740876,0.324978,-0.587785,
    0.806254,0.066808,-0.587785,
    0.784261,-0.198602,-0.587785,
    0.677282,-0.44249,-0.587785,
    0.496909,-0.638428,-0.587785,
    0.262687,-0.765182,-0.587785,
    -0.0,-0.587785,-0.8090170000000001,
    -0.190854,-0.555937,-0.8090170000000001,
    -0.361025,-0.463845,-0.8090170000000001,
    -0.492074,-0.321488,-0.8090170000000001,
    -0.569799,-0.144293,-0.8090170000000001,
    -0.585778,0.048539,-0.8090170000000001,
    -0.538278,0.236111,-0.8090170000000001,
    -0.432448,0.398096,-0.8090170000000001,
    -0.279755,0.516942,-0.8090170000000001,
    -0.096746,0.579769,-0.8090170000000001,
    0.096746,0.579769,-0.8090170000000001,
    0.279755,0.516942,-0.8090170000000001,
    0.432448,0.398096,-0.8090170000000001,
    0.538278,0.236111,-0.8090170000000001,
    0.585778,0.048539,-0.8090170000000001,
    0.569799,-0.144293,-0.8090170000000001,
    0.492074,-0.321488,-0.8090170000000001,
    0.361025,-0.463845,-0.8090170000000001,
    0.190854,-0.555937,-0.8090170000000001
};


/**
 * Neighbour indices approximating the spherical cylinder. See dev/spherical_cylinder_approx.jl
 * Shape KC3D_SC_NUM_FACESx3
 */
#define KC3D_SC_NUM_FACES 380
static const kc3d_int KC3D_SC_FACES[] = {
    0,1,2,
    2,1,3,
    2,3,4,
    4,3,5,
    4,5,6,
    6,5,7,
    6,7,8,
    8,7,9,
    8,9,10,
    10,9,11,
    10,11,12,
    12,11,13,
    12,13,14,
    14,13,15,
    14,15,16,
    16,15,17,
    16,17,18,
    18,17,19,
    18,19,20,
    20,19,21,
    20,21,22,
    22,21,23,
    22,23,24,
    24,23,25,
    24,25,26,
    26,25,27,
    26,27,28,
    28,27,29,
    28,29,30,
    30,29,31,
    30,31,32,
    32,31,33,
    32,33,34,
    34,33,35,
    34,35,36,
    36,35,37,
    36,37,0,
    0,37,1,
    38,39,40,
    40,39,41,
    41,39,42,
    42,39,43,
    43,39,44,
    44,39,45,
    46,39,47,
    47,39,48,
    48,39,49,
    49,39,50,
    50,39,51,
    52,39,53,
    53,39,54,
    54,39,55,
    55,39,56,
    56,39,57,
    57,39,38,
    11,58,13,
    13,58,59,
    13,59,15,
    15,59,60,
    15,60,17,
    17,60,61,
    17,61,19,
    19,61,62,
    19,62,21,
    21,62,63,
    21,63,23,
    23,63,64,
    23,64,25,
    25,64,65,
    25,65,27,
    27,65,66,
    27,66,29,
    29,66,67,
    29,67,31,
    31,67,68,
    31,68,33,
    33,68,69,
    33,69,35,
    35,69,70,
    35,70,37,
    37,70,71,
    37,71,1,
    1,71,72,
    1,72,3,
    3,72,73,
    3,73,5,
    5,73,74,
    5,74,7,
    7,74,75,
    7,75,9,
    9,75,76,
    9,76,11,
    11,76,58,
    58,77,59,
    59,77,78,
    59,78,60,
    60,78,79,
    60,79,61,
    61,79,80,
    61,80,62,
    62,80,81,
    62,81,63,
    63,81,82,
    63,82,64,
    64,82,83,
    64,83,65,
    65,83,84,
    65,84,66,
    66,84,85,
    66,85,67,
    67,85,86,
    67,86,68,
    68,86,87,
    68,87,69,
    69,87,88,
    69,88,70,
    70,88,89,
    70,89,71,
    71,89,90,
    71,90,72,
    72,90,91,
    72,91,73,
    73,91,92,
    73,92,74,
    74,92,93,
    74,93,75,
    75,93,94,
    75,94,76,
    76,94,95,
    76,95,58,
    58,95,77,
    77,38,78,
    78,38,40,
    78,40,79,
    79,40,41,
    79,41,80,
    80,41,42,
    80,42,81,
    81,42,43,
    81,43,82,
    82,43,44,
    82,44,83,
    83,44,45,
    83,45,84,
    84,45,46,
    84,46,85,
    85,46,47,
    85,47,86,
    86,47,48,
    86,48,87,
    87,48,49,
    87,49,88,
    88,49,50,
    88,50,89,
    89,50,51,
    89,51,90,
    90,51,52,
    90,52,91,
    91,52,53,
    91,53,92,
    92,53,54,
    92,54,93,
    93,54,55,
    93,55,94,
    94,55,56,
    94,56,95,
    95,56,57,
    95,57,77,
    77,57,38,
    45,39,46,
    51,39,52,
    4,96,2,
    2,96,97,
    2,97,0,
    0,97,98,
    0,98,36,
    36,98,99,
    36,99,34,
    34,99,100,
    34,100,32,
    32,100,101,
    32,101,30,
    30,101,102,
    30,102,28,
    28,102,103,
    28,103,26,
    26,103,104,
    26,104,24,
    24,104,105,
    24,105,22,
    22,105,106,
    22,106,20,
    20,106,107,
    20,107,18,
    18,107,108,
    18,108,16,
    16,108,109,
    16,109,14,
    14,109,110,
    14,110,12,
    12,110,111,
    12,111,10,
    10,111,112,
    10,112,8,
    8,112,113,
    8,113,6,
    6,113,114,
    6,114,4,
    4,114,96,
    114,115,96,
    96,115,116,
    96,116,97,
    97,116,117,
    97,117,98,
    98,117,118,
    98,118,99,
    99,118,119,
    99,119,100,
    100,119,120,
    100,120,101,
    101,120,121,
    101,121,102,
    102,121,122,
    102,122,103,
    103,122,123,
    103,123,104,
    104,123,124,
    104,124,105,
    105,124,125,
    105,125,106,
    106,125,126,
    106,126,107,
    107,126,127,
    107,127,108,
    108,127,128,
    108,128,109,
    109,128,129,
    109,129,110,
    110,129,130,
    110,130,111,
    111,130,131,
    111,131,112,
    112,131,132,
    112,132,113,
    113,132,133,
    113,133,114,
    114,133,115,
    134,135,136,
    136,135,137,
    137,135,138,
    138,135,139,
    139,135,140,
    140,135,141,
    141,135,142,
    143,135,144,
    144,135,145,
    145,135,146,
    146,135,147,
    147,135,148,
    149,135,150,
    150,135,151,
    151,135,152,
    152,135,153,
    153,135,134,
    130,154,131,
    131,154,155,
    131,155,132,
    132,155,156,
    132,156,133,
    133,156,157,
    133,157,115,
    115,157,158,
    115,158,116,
    116,158,159,
    116,159,117,
    117,159,160,
    117,160,118,
    118,160,161,
    118,161,119,
    119,161,162,
    119,162,120,
    120,162,163,
    120,163,121,
    121,163,164,
    121,164,122,
    122,164,165,
    122,165,123,
    123,165,166,
    123,166,124,
    124,166,167,
    124,167,125,
    125,167,168,
    125,168,126,
    126,168,169,
    126,169,127,
    127,169,170,
    127,170,128,
    128,170,171,
    128,171,129,
    129,171,172,
    129,172,130,
    130,172,154,
    154,173,155,
    155,173,174,
    155,174,156,
    156,174,175,
    156,175,157,
    157,175,176,
    157,176,158,
    158,176,177,
    158,177,159,
    159,177,178,
    159,178,160,
    160,178,179,
    160,179,161,
    161,179,180,
    161,180,162,
    162,180,181,
    162,181,163,
    163,181,182,
    163,182,164,
    164,182,183,
    164,183,165,
    165,183,184,
    165,184,166,
    166,184,185,
    166,185,167,
    167,185,186,
    167,186,168,
    168,186,187,
    168,187,169,
    169,187,188,
    169,188,170,
    170,188,189,
    170,189,171,
    171,189,190,
    171,190,172,
    172,190,191,
    172,191,154,
    154,191,173,
    173,134,174,
    174,134,136,
    174,136,175,
    175,136,137,
    175,137,176,
    176,137,138,
    176,138,177,
    177,138,139,
    177,139,178,
    178,139,140,
    178,140,179,
    179,140,141,
    179,141,180,
    180,141,142,
    180,142,181,
    181,142,143,
    181,143,182,
    182,143,144,
    182,144,183,
    183,144,145,
    183,145,184,
    184,145,146,
    184,146,185,
    185,146,147,
    185,147,186,
    186,147,148,
    186,148,187,
    187,148,149,
    187,149,188,
    188,149,150,
    188,150,189,
    189,150,151,
    189,151,190,
    190,151,152,
    190,152,191,
    191,152,153,
    191,153,173,
    173,153,134,
    135,149,148,
    135,143,142
};


#endif
