#!/usr/bin/env python
import sys
import pmagpy.command_line_extractor as extractor
from pmagpy import convert_2_magic as convert

def main():
    """
    NAME
        sufar4-asc_magic.py

    DESCRIPTION
        converts ascii files generated by SUFAR ver.4.0 to MagIC formated
        files for use with PmagPy plotting software

    SYNTAX
        sufar4-asc_magic.py -h [command line options]

    OPTIONS
        -h: prints the help message and quits
        -f FILE: specify .asc input file name
        -fsp SINFILE: specify er_specimens input file with location, sample, site, etc. information
        -F MFILE: specify measurements output file
        -Fa AFILE: specify rmag_anisotropy output file # MagIC 2 only
        -Fsi SFILE: specify specimens output file
        -usr USER: specify who made the measurements
        -loc LOC: specify location name for study
        -ins INST: specify instrument used
        -spc SPEC: specify number of characters to specify specimen from sample
        -ncn NCON:  specify naming convention: default is #2 below
        -k15 : specify static 15 position mode - default is spinning
        -new : replace all existing magic files
        -or_con : specify orientation convention (default is AGICO defaults)

    DEFAULTS
        AFILE: rmag_anisotropy.txt  # MagIC 2 only
        SFILE: default is to create new specimen file
        USER: ""
        LOC: "unknown"
        INST: ""
        SPEC: 0  sample name is same as site (if SPEC is 1, sample is all but last character)
        appends to  specimen/sample/site files
       Sample naming convention:
            [1] XXXXY: where XXXX is an arbitrary length site designation and Y
                is the single character sample designation.  e.g., TG001a is the
                first sample from site TG001.    [default]
            [2] XXXX-YY: YY sample from site XXXX (XXX, YY of arbitary length)
            [3] XXXX.YY: YY sample from site XXXX (XXX, YY of arbitary length)
            [4-Z] XXXX[YYY]:  YYY is sample designation with Z characters from site XXX
            [5] site name same as sample
            [6] site name entered in site_name column in the orient.txt format input file  -- NOT CURRENTLY SUPPORTED
            [7-Z] [XXXX]YYY:  XXXX is site designation with Z characters with sample name XXXXYYYY
            NB: all others you will have to customize your self
                 or e-mail ltauxe@ucsd.edu for help.
            [8] This is a synthetic
            [9] ODP naming convention

    orientation conventions:
        [1] Standard Pomeroy convention of azimuth and hade (degrees from vertical down)
             of the drill direction (field arrow).  lab arrow azimuth= sample_azimuth = mag_azimuth;
             lab arrow dip = sample_dip =-field_dip. i.e. the lab arrow dip is minus the hade.
        [2] Field arrow is the strike  of the plane orthogonal to the drill direction,
             Field dip is the hade of the drill direction.  Lab arrow azimuth = mag_azimuth-90
             Lab arrow dip = -field_dip
        [3] Lab arrow is the same as the drill direction;
             hade was measured in the field.
             Lab arrow azimuth = mag_azimuth; Lab arrow dip = 90-field_dip
        [4] lab azimuth and dip are same as mag_azimuth, field_dip : use this for unoriented samples too
        [5] Same as AZDIP convention explained below -
            azimuth and inclination of the drill direction are mag_azimuth and field_dip;
            lab arrow is as in [1] above.
            lab azimuth is same as mag_azimuth,lab arrow dip=field_dip-90
        [6] Lab arrow azimuth = mag_azimuth-90; Lab arrow dip = 90-field_dip
        [7] see http://earthref.org/PmagPy/cookbook/#field_info for more information.  You can customize other format yourself, or email ltauxe@ucsd.edu for help.
        [8] Lab arrow azimuth = mag_azimuth-180; Lab arrow dip = 90-field_dip


    """

    args = sys.argv
    if '-h' in args:
        print(main.__doc__)
        sys.exit()

    dataframe = extractor.command_line_dataframe([ ['WD', False, '.'], ['ID', False, ''],
                                                   ['usr', False, ''], ['ncn', False, '1'],
                                                   ['k15', False, False], ['ins', False, ''],
                                                   ['f', True, ''], ['F', False, 'measurements.txt'],
                                                   ['Fa', False, 'rmag_anisotropy.txt'],
                                                   ['Fsi', False, 'specimens.txt'],
                                                   ['loc', False, 'unknown'], ['spc', False, 0],
                                                   ['fsi', False, None], ['DM', False, 3], 
                                                   ['or_con', False, None] ])
    #'WD', 'ID', 'usr', 'ncn', 'k15', 'ins', 'f', 'F', 'Fa', 'Fsi', 'loc', 'spc',
    checked_args = extractor.extract_and_check_args(args, dataframe)
    output_dir_path, input_dir_path, user, sample_naming_con, static_15_position_mode, instrument, ascfile, meas_output, aniso_output, spec_outfile, locname, specnum, spec_infile, data_model_num,or_con = extractor.get_vars(['WD', 'ID', 'usr', 'ncn', 'k15', 'ins', 'f', 'F', 'Fa', 'Fsi', 'loc', 'spc', 'fsi', 'DM','or_con'], checked_args)

    convert.sufar4(ascfile, meas_output, aniso_output, spec_infile,
                   spec_outfile, specnum=specnum, sample_naming_con=sample_naming_con,
                   user=user, locname=locname, instrument=instrument,
                   static_15_position_mode=static_15_position_mode, dir_path=output_dir_path,
                   input_dir_path=input_dir_path, data_model_num=data_model_num,or_con=or_con)

    # do we need -new flag??
if __name__ == "__main__":
    main()
