# Pyzfn

A micromagnetic post processing library for the data generated by [amumax](https://github.com/MathieuMoalic/amumax), a fork of mumax3.

Wrapper around `zarr.hierarchy.Group` from [zarr](https://zarr.readthedocs.io/en/stable/) to implement convenience functions that work with the ouput of a modified mumax3.

## Installation

It's not on PyPi, you have to install it from github.

```
pip install git+https://github.com/mathieumoalic/pyzfn
```

## Usage

90 % of the functionnalities are provided by [zarr](https://zarr.readthedocs.io/en/stable/), please refer to that documentation extensively.

```python
from pyzfn import Pyzfn

job = Pyzfn("path/to/job.zarr")

# Use this extensively
job.pp # pretty print the data tree with a widget
job.p # not pretty print, but does not need a widget

# Getting simulation metadata:
# json file located at path/to/job.zarr/.attrs
# You can acces it like a python dict:
dt = job.attrs["dt"]
# or as a class attribute (given that you have no dataset named similarly):
dt = job.dt

# Get data you saved in amumax:
# Ex: the x component of the magnetization for all cells for 10 <= t < 20
#             t  ,z,y,x,c
mag = job.m[10:20,:,:,:,0] # mag is a number array

# This will not load the data
mag_dst = job.m
# You need to slice it to obtain the numpy array
arr = mag_dst[:]

# Some very useful info
mag_dst.info

# Reminder that the `help` and `dir` functions in python exist:
help(mag_dst)

# The following is not from zarr, they are convenient (somewhat optimized) post processing functions
job.calc_disp()
job.calc_modes()

# Data visualization:
job.snapshot() # visualize data for a specific t
job.ispec() # interactive fft spectra
```
