#!/bin/bash

# this scripts changes the interpreter of the scripts; on the commandline you'll
# have to escape the "/" with "\\", e.g.
#   ./scripts.sh -i \\/usr\\/local\\/bin\\/bash
#
# $Revision: 1.2 $
# FracPete

# prints the usage of this script
function usage()
{
   echo
   echo "usage: ${0##*/} -i <interpreter> -b [-h]"
   echo 
   echo "changes the interpreter of the scripts"
   echo 
   echo " -h   this help"
   echo " -i   the interpreter to use in the script"
   echo "      default: $INTERPRETER"
   echo "      you use: $BASH"
   echo " -b   backup the files"
   echo 
}

# changes the interpreter in the script "FILE" and sets the value to "VALUE"
function changeValue()
{
   cat $FILE | sed s/"^#\!\/.*"/"#\!$VALUE"/g > _$FILE
   rm $FILE
   mv _$FILE $FILE
}

# variables
ROOT=`expr "$0" : '\(.*\)/'`
INTERPRETER=\\/bin\\/bash
BACKUP=no

# interprete parameters
while getopts ":hbi:" flag
do
   case $flag in
      h) usage
         exit 0
         ;;
      i) INTERPRETER=$OPTARG
         ;;
      b) BACKUP=yes
         ;;
      *) usage
         exit 1
         ;;
   esac
done

# change the files
cd $ROOT
for i in *.sh
do
   FILE=$i

   # itself? -> skip
   if [ "${FILE##*/}" = "${0##*/}" ]
   then
      continue
   fi

   # info
   FILENAME=`echo ${FILE##*/} | cut -f1 -d"." | sed s/-stat//g`
   echo " - $FILENAME"
   
   # save original
   if [ "$BACKUP" = "yes" ]
   then
      cp $i $i.original
   fi

   # change values
   VALUE="$INTERPRETER";changeValue
done

