#!/bin/bash
#
# This shell script prepares the data, s.t. Proper can handle it better
#
# use -help to see options
#
# FracPete

# the usage of this script
function usage()
{
   echo
   echo "usage: ${0##*/} -i <input-dir> -o <output-dir> [-h]"
   echo 
   echo "removes the unnecessary lists to reduce the size of flattening"
   echo "(the names are split up in lists)"
   echo
   echo " -h   this help"
   echo " -i   <input-dir>"
   echo "      the directory with the unprocessed file"
   echo "      default: $SRC"
   echo " -o   <output-dir>"
   echo "      where to put the processed file"
   echo "      default: $DEST"
   echo
}

# variables
ROOT=`expr "$0" : '\(.*\)/'`
SRC="$ROOT/original"
DEST="$ROOT"

# interprete parameters
while getopts ":hi:o:" flag
do
   case $flag in
      i) SRC=$OPTARG
         ;;
      o) DEST=$OPTARG
         ;;
      h) usage
         exit 0
         ;;
      *) usage
         exit 1
         ;;
   esac
done

# copy file
cp $SRC/restbase $DEST/restbase

# process file -> clean
cat $SRC/restbase | sed s/"\['"[^\[]*"']"//g | sed s/", , "/", "/g | sed s/", )"/")"/g | sed s/", _, _, _"//g | sed s/", \['cabrillo', 'hwy', '\[route', '1]']"//g > $DEST/restbase.clean

