#!/bin/bash

# This scripts greps the jobs from the ant XML files and writes them in a
# text file
#
# -h
#    to display help
#
#
# $Revision: 1.3 $
# FracPete

# the usage of this script
function usage()
{
   echo
   echo "usage: ${0##*/} -d <dataset> -o <output-file> -H <host> -P <port> [-h]"
   echo
   echo "greps the jobs from ANT XML files and writes them to a file"
   echo 
   echo " -h to display this help"
   echo " -d <dataset>"
   echo "    the dataset(s) to get the jobs from (comma separated list)"
   echo "    default: $DATASET"
   echo " -o <output-file>"
   echo "    the file to store the jobs in"
   echo "    default: $OUTPUT"
   echo " -H <hostname>"
   echo "    the hostname of the jdbc url for the database server"
   echo "    default: $HOST"
   echo " -P <port>"
   echo "    the port of the jdbc url for the database server"
   echo "    default: $PORT"
   echo
}

# interprete the parameters
ANT=ant
ROOT=`expr "$0" : '\(.*\)/'`
DIR="$ROOT/.."
XMLDIR=""
DATASET="$ROOT/../xml"
OUTPUT="$DIR/tmp/jobs"
HOST="localhost"
PORT="3306"

while getopts ":ho:d:H:P:h" flag
do
   case $flag in
      d) DATASET=$OPTARG
         ;;
      o) OUTPUT=$OPTARG
         ;;
      H) HOST=$OPTARG
         ;;
      P) PORT=$OPTARG
         ;;
      h) usage
         exit 0
         ;;
      *) echo "Parameter '$flag' is not recognized!"
         usage
         exit 1
   esac
done

# grep the jobs
COMMAND="$ANT -f $XMLDIR/remote.xml jobs -Djobs.dataset=$DATASET -Dserver.jobs=$OUTPUT -Djobs.url=jdbc:mysql://$HOST:$PORT/"
$COMMAND

