/*
 * Decompiled with CFR 0.152.
 */
package proper.relaggs;

import java.sql.Date;
import java.util.GregorianCalendar;

public class RelaggsDate {
    public static final int TYPE_YMD = 1;
    public static final int TYPE_YM = 2;
    public static final int TYPE_Y = 3;
    private int day;
    private int month;
    private int year;
    private int type;
    private String hashKey;

    public RelaggsDate(Date date) {
        this(date, 1);
    }

    public RelaggsDate(Date date, int type) {
        this.type = type;
        GregorianCalendar gc = new GregorianCalendar();
        gc.setTime(date);
        this.day = gc.get(5);
        this.month = gc.get(2) + 1;
        this.year = gc.get(1);
        switch (this.type) {
            case 1: {
                this.hashKey = "[" + this.type + "]" + this.year + "-" + this.month + "-" + this.day;
                break;
            }
            case 2: {
                this.hashKey = "[" + this.type + "]" + this.year + "-" + this.month;
                break;
            }
            case 3: {
                this.hashKey = "[" + this.type + "]" + this.year;
                break;
            }
            default: {
                this.hashKey = "[" + this.type + "]";
            }
        }
    }

    public RelaggsDate(String hash_key) {
        this.type = new Integer("" + hash_key.charAt(1));
        this.hashKey = hash_key;
        switch (this.type) {
            case 1: {
                int pos1 = hash_key.indexOf(45);
                int pos2 = hash_key.indexOf(45, pos1 + 1);
                this.year = new Integer(hash_key.substring(hash_key.indexOf(93) + 1, hash_key.indexOf(93) + 5));
                this.month = new Integer(hash_key.substring(pos1 + 1, pos2));
                this.day = new Integer(hash_key.substring(pos2 + 1));
                break;
            }
            case 2: {
                this.year = new Integer(hash_key.substring(hash_key.indexOf(93) + 1, hash_key.indexOf(93) + 5));
                this.month = new Integer(hash_key.substring(hash_key.indexOf(45) + 1));
                this.day = 0;
                break;
            }
            case 3: {
                this.year = new Integer(hash_key.substring(hash_key.indexOf(93) + 1, hash_key.indexOf(93) + 5));
                this.month = 0;
                this.day = 0;
                break;
            }
            default: {
                System.out.println("HASHKEY: " + hash_key);
            }
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof RelaggsDate) {
            RelaggsDate rd_obj = (RelaggsDate)obj;
            if (rd_obj.getType() == this.type) {
                switch (this.type) {
                    case 1: {
                        return this.year == rd_obj.getYear() && this.month == rd_obj.getMonth() && this.day == rd_obj.getDay();
                    }
                    case 2: {
                        return this.year == rd_obj.getYear() && this.month == rd_obj.getMonth();
                    }
                    case 3: {
                        return this.year == rd_obj.getYear();
                    }
                }
                return false;
            }
            return false;
        }
        return false;
    }

    public int getType() {
        return this.type;
    }

    public int getDay() {
        return this.day;
    }

    public int getMonth() {
        return this.month;
    }

    public int getYear() {
        return this.year;
    }

    public String getHashKey() {
        return this.hashKey;
    }

    public String getColumnString() {
        switch (this.type) {
            case 1: {
                return String.valueOf(this.year) + "_" + this.month + "_" + this.day;
            }
            case 2: {
                return String.valueOf(this.year) + "_" + this.month;
            }
            case 3: {
                return "" + this.year;
            }
        }
        return "unknown";
    }

    public String toString() {
        return String.valueOf(this.year) + "-" + this.month + "-" + this.day + " [" + this.type + "]";
    }
}

